DAB['routes'] = function(route) {
	var context = DAB.context();
	var routeDef = {
		'login': DAB.app.login,
		'workorder': DAB.app.workOrder,
		'commissions': DAB.app.commissions,
		'search': DAB.app.search,
		'users': DAB.app.users,
		'summary': DAB.app.clientSummary,
		'addclient': DAB.app.addClient,
		'invoice': DAB.app.invoice,
		'pdf': DAB.app.pdf
	}
	context['app']['dispatchRoute'](route);
	if(context['route'][2] === 'edit') {
		return DAB.app.getClientInformation(context['route'][1])
	}
	if(routeDef.hasOwnProperty(route)) {
		return routeDef[route]();
	} else {
		window.location.href = '#/login/';
	}
}

DAB['init'] =  function() {
	var model = this.model;
	var app = this.app;
	var context = DAB.context();
	//todo rewrite;
	app['liveOrTest'] = 'test';
	context['model']['baseDate'] = new Date(context['app']['rightNow']());
	context['model']['today'] = new Date(context['app']['rightNow']());
	var test = {
		'url': 'ws://10.1.10.184:81',
		// 'repoId': 'DAB_Prod',
		'repoId': 'DAB_Prod_2017',
		'backup': 'dabBackUp',
		'context': DAB
	}
	var prod = {
		'url': 'ws://192.168.55.250:81',
		'repoId': 'DAB_Sandbox',
		'backup': 'dabBackUp',
		'context': DAB
	}
	var websocketInit;
	if(app['liveOrTest'] === 'test') {
		websocketInit = test;
	} else {
		websocketInit = prod;
	}
	Websocket.init(websocketInit).then(function() {
		if(localStorage['userDAB'] === '' || localStorage.length === 0) {
			window.location.href = '#/login';
		} else {
			var user = Utility.storage.getObject('userDAB');			
			context['model']['currentUser'] = user;				
		}
		Router.init({}, DAB);
		if(location.hash === '') {
			window.location.href = '#/login';
		} else {
		}
		window.addEventListener('resize', app['resizeDiv'], true);
		context['app']['fetchQueryResponses']();
	});
}

DAB['uniqueNumber'] = 0;

DAB['dabBackUp'] = function() {
	console.log('backed UP!')
}

DAB['context'] = function() {
	var obj =  {
		'app': DAB.app,
		'model': DAB.model,
		'components': DAB.components,
		'conf': DAB.configuration,
		'route': DAB.currentRoute,
		'previousRoute': DAB.previousRoute,
		'currentModel': DAB.model.currentModel,
		'currentUser': DAB.model.currentUser
	}
	var stateObjects = ['workOrderState'];
	stateObjects.forEach(function(attr) {
		if(DAB['model']['state'] && DAB['model']['state'][attr] !== null) {
			obj[attr] = DAB['model']['state'][attr]
		} else {
			obj[attr] = false;
		}
	})
	if(DAB['model']['state'] && DAB['model']['state']['jobOpen'] !== null && typeof DAB.model.currentModel.currentJobs !== 'undefined') {
		obj['jobOpen'] =  DAB.model.currentModel.currentJobs[DAB['model']['state']['jobOpen']];
	} else {
		obj['jobOpen'] = false;
	}
	return obj;
}

var QueryResponses = {
	'allUsers': {
		'query': 'CommissionDropDown',
		'params': {}
		// 'parseBy': 'commId'
	},
	'checkBoxes': {
		'query': 'WorkOrderCheckBoxes',
		'params': { 'PriceType' : 1 }
		// 'parseBy': 'ItemCode'
	},
	'descCheckBoxes': {
		'query': 'WorkOrderDescCheckBoxes',
		'params': {'Type': 1}
		// 'parseBy': 'U_Code'
	},
	'taxRates': {
		'query': 'TaxRates',
		'params': {},
		'parseBy': 'Code'
	},
	'discountCodes': {
		'query': 'DiscountCodes',
		'params': {},
		'parseBy': { 
			'type': {
				'type': 'arrayByColumn',
				'column': 'code'
			}
		}
	},
	'discountDefinitions': {
		'query': 'DiscountDefinition',
		'params': {}
	},
	'commissions': {
		'query': 'CommissionDefinitions',
		'params': {},
		'parseBy': 'ItemCode'
	}
};

DAB['configuration'] = {
	emailProps: function() {
		var context = DAB.context();
		var props = {
			'SMTP': 'TS_AutoTest',
			'db': 'DAB_Prod_2017'
		}
		var propsDAB = {
			'SMTP': 'TS_AutoTest',
			'db': 'DAB_Sandbox'
		}
		if(context['app']['liveOrTest'] === 'test') {
			props = props;
		} else {
			props = propsDAB;
		}
		return props;
	},
	
	jobTableConf: function() {
		var context = DAB.context();
		var userName = context['model']['currentUser']['name'];
		var nameByType = {
			'rugJob': 'Rug Cleaning',
			'furnJob': 'Upholstery Cleaning',
			'fabJob': 'Fabrication',
			'repairJob': 'Hand Repair',
			'other': 'Other Services',
			'onloFurnJob': 'ONLO Upholstery Cleaning',
			'carpetJob': 'Carpet Cleaning',
			'stoneJob': 'Stone & Tile Cleaning',
			'otherJob': 'Other Services'
		}
		var rowsBase = context['model']['currentModel']['currentJobs'].map(function(rugModel) {
			var takenBy = ''
			if(!QueryResponses['allUsers'].hasOwnProperty('query')) {
				takenBy = context['app']['findInArray'](QueryResponses['allUsers'], 'commId', rugModel['header']['takenBy'])['name'];
			} 
			var row = {
				'Item #': rugModel['header']['title'].replace('Item ' , ''),
				'Taken By': takenBy,
				'Main Service': nameByType[rugModel['header']['type']],
				'Rug Type': rugType(),
				'Item Status': rugModel['header']['status']
			}
			if(context['currentModel']['workOrderHeader']['orderType'] !== 'ONLO') {
				row['Due Date'] = rugModel['header']['dateDue'];
			} else {
				row['Service Date'] = context['currentModel']['workOrderHeader']['scheduledDate'];
			}
			row['Completion Date'] = rugModel['header']['dateComplete']
			if(context['currentModel']['workOrderHeader']['orderType'] === 'SPD') {
				row['Pickup Date'] = rugModel['header']['scheduledPickup'];
				row['Delivery Date'] = rugModel['header']['dateDelivery'];
			}
			
			return row;
			
			function rugType() {
				var title = 'N/A'
				if(['rugJob', 'fabJob', 'repairJob'].indexOf(rugModel['header']['type']) !== -1) {
					var subSelect = rugModel['header']['subSelect'];
					if(subSelect !== '') {
						if(subSelect[0] === 'C') {
							title = context['app']['findInArray'](QueryResponses['descCheckBoxes'], 'U_Code', subSelect)['U_Description'];
						} else {
							var servTitle = context['app']['findInArray'](QueryResponses['checkBoxes'], 'ItemCode', subSelect)['ItemName']; 
							title = servTitle.replace(' Cleaning', ''); 
						}
					}
				}
				return title;
			}
		})
		var jobTableModel = context['app'].createTableModels(rowsBase, 'jsonArray');
		var rows = jobTableModel['objArray'].map(function(cellObj, i) {
			cellObj['num'] = i;
			var initRow = {
				'cells': jobTableModel['rows'][i],
				'fnOnClick': context['app']['selectRow'],
				'baseModel': cellObj
			}
			if(context['model']['state']['jobOpen'] === i) return '';
			return context['components']['tableRow'](initRow);	
		})
		var shown = true;
		if(rows.length === 0) {
			title = 'No Current Jobs';	
			shown = false;
		}
		//Table header shouldn't be shown if only one job exists and this job is open.
		if(rows.length === 1 && context['model']['state']['jobOpen'] === 0) {
			shown = false;
		}
		var jobTable = {
			'columns': jobTableModel['columns'],
			'rows': rows,
			'shown': shown
		}
		return jobTable;
	},
		
	noteForm: function (noteType, noteArray) {
		var context = DAB.context();
		var label;
		var disabled = false;
		var newNoteModel = context['model']['newNote'];
		if(noteType === 'WO') label = 'Work Order Notes';
		if(noteType === 'WO' && (['CL'].indexOf(context['currentModel']['workOrderHeader']['docStatus']) !== -1)) {
			disabled = true;
		}
		if(noteType === 'Client') label = 'Client Notes';
		if(noteType === 'LineItem') {
			label = 'Item Notes';
			newNoteModel = context['model']['newJobNote']
		}
		var noteFormInit = {
			'type': noteType,
			'label': label,
			'className': 'uk-margin-bottom',
			'fnOnChange': context['app']['noteChange'],
			'model': newNoteModel,
			'noteArray': noteArray,
			'disabled': disabled
		}
//			if(context['model']['currentModel']['workOrderHeader']['viewOnly'] === true) noteFormInit['disabled'] = true;
		return noteFormInit;
	},
	
	notePanel: function(model, type) {
		var context = DAB.context();
		var notePanelInit = {
			model: model,
			modelAttr: 'notes',
			type: type,
			fnOnEdit: context['app']['setItemEditing'],
			fnOnDelete: context['app']['setItemInactive']
		}
		
		return notePanelInit;
	},
		
	noteBucket: function(model, type, iconClass, header) {
		var noteBucketInit = {
			'model': model,
			'type': type,
			'iconClass': iconClass,
			'header': header,
			'notes': []
		}
		model['notes'].map(function(note) {
			if(note['type'] === type) {
				noteBucketInit['notes'].push(note);
			}
		});

		return noteBucketInit;
	},
	
	docHeaderConfiguration: function() {
		/** 
			Header configuration utilizes a type selection array for it's button wall,
			It also utilizes an inputs array for the Order-Wide Option fields			
		**/
		var context = DAB.context();
		var workOrderHeader = context['model']['currentModel']['workOrderHeader'];
		headerName = workOrderHeader['documentName'];
		if(workOrderHeader['docStatus'] === 'CL') {
			headerName += ' Cancelled on ' + Utility.formatDate(workOrderHeader['cancelledDate']) + ' by ' +
			context['app']['findInArray'](QueryResponses['allUsers'], 'commId', workOrderHeader['cancelledBy'])['name'];
		}
		var types = [
			[
				'orderType', 
				[
					{'id': 'SCC', 'display': 'Seattle Cash & Carry', 'icon': 'tag'}, 
					{'id': 'BCC', 'display': 'Bellevue Cash & Carry', 'icon': 'tag'}, 
					{'id': 'SPD', 'display': 'Pickup & Delivery', 'icon': 'truck'},
					{'id': 'ONLO', 'display': 'On-Location', 'icon': 'home'}
				]
			],
			[
				'docType',
				[
					{'id': 'SP', 'display': 'Service Proposal'}, 
					{'id': 'WO', 'display': 'Work Order'}, 
					{'id': 'CS', 'display': 'Reservice'}
				]
			],
			[
				'docStatus', 
				[
					{'id': 'IP', 'display': 'In Process'}, 
					{'id': 'H', 'display': 'Hold'}, 
					{'id': 'AP', 'display': 'Auth Pending'}, 
					{'id': 'CP', 'display': 'Complete'}, 
					{'id': 'IC', 'display': 'Invoice Created', 'disabled': true},
					{'id': 'CL', 'display': 'Cancelled', 'disabled': true}
				]
			]
		]
		var buttonClass = 'uk-button ts-button-bold primaryTint';
		var sampleDocHeader = {
			'workOrderName': headerName,
			'model': workOrderHeader
		}
		types.forEach(function(conf) {
			var base = baseConf();
			if(conf[0] === 'orderType') base['fnOnClick'] = context['app']['orderTypeChange'];
			base['modelAttr'] = conf[0];
			base['selections'] = conf[1];
			sampleDocHeader[conf[0]] = base;
		})
		var inputs = [
			['user-plus', 'Placed By', 'placedBy'],
			['tag', 'PO #', 'poNum'],
			['user-plus', 'Sidemark', 'sidemark'],
			['user-plus', 'Referred By', 'refBy']
		]
		sampleDocHeader['inputs'] = inputs.map(function(input) {
			return {
				'icon': input[0],
				'placeholder': input[1],
				'modelAttr': input[2],
				'onchange': context['app']['buttonRadio'],
				'model': workOrderHeader
			}
		})
		if(workOrderHeader['docType'] === 'SP') {
			sampleDocHeader['docStatus']['selections'][4] = {
				'id': 'WC',
				'display': 'Work Order Created',
				'disabled': true
			}
		}
		if(context['model']['currentModel']['workOrderHeader']['viewOnly'] === true) sampleDocHeader['disabled'] = true;
		return sampleDocHeader;
		
		function baseConf() {
			return {
				'buttonClass': buttonClass,
				'model': workOrderHeader, 
				'parentClass': '',
				'fnOnClick': context['app']['buttonRadio']
			}
		}
	},
	
	addressConf: function() {
		var context = DAB.context();
		var addresses = context['model']['currentModel'].addresses.map(function(addr, index) {
			return {
				'model': context['model']['currentModel'].addresses,
				'modelAttr': index,
				'fnOnEdit': context['app'].setPanelEditing,
				'fnOnSave': context['app'].savePanelEditing
			}
		});
		if(context['model']['currentModel']['workOrderHeader']['viewOnly'] === true) addresses['disabled'] = true;
		return addresses;
	},
	
	clientHeader: function() {
		var context = DAB.context();
		var clientHeader = {
			'headerModel': context['model']['currentModel']['headerInfo'],
			'clientModel': context['model']['currentModel']['currentClient'],
			'stickyNotes': context['model']['currentModel']['stickyNotes']
		}

		return clientHeader;
	},
	
	panelInit: function(model) {
		var context = DAB.context();
		var panelInit = {
			model: model,
			fnOnEdit: context['app']['toggleAttribute'],
			fnOnDelete: context['app']['setItemInactive']
		}
		
		return panelInit;		
	},
	
	contactSettings: function() {
		var context = DAB.context();
		var contactSettings = context['model']['currentModel']['contacts'].map(function(contact, i) {
			var newContact = context['app'].objectCopy(contact);
			newContact['options'] = context['model']['currentModel']['contactMethods'][i];
			newContact['model'] = context['model']['currentModel']['workOrderHeader'];
			newContact['fnOnClick'] = context['app']['selectContactWO'];
			return newContact;
		})
		return contactSettings
	},
	
	paymentObj: function() {
		var context = DAB.context();
		var paymentObj = {
			'payment': context['currentModel']['newPayment'],
			'paymentApplied': context['currentModel']['paymentApplied'],
			'historyOn': true
		}
		// if(context['currentModel']['workOrderHeader']['viewOnly'] === true) paymentObj['showOnly'] = true;
		return paymentObj
	},

	searchPageConf: function() {
		var context = DAB.context();
		var searchTypes = [
			{
				'title': 'Search by Client Information',
				'searchTitle': 'Search Client Database',
				'searchElements': [
					['First Name', 0, 'user'],
					['Last Name', 1, 'user'],
					['Email', 2, 'envelope-o'],
					['Phone # (XXX-XXX-XXXX)', 3, 'phone'],
					['Client Code', 4, 'user-plus']
				],
				'type': 'client'
			},
			{
				'title': 'Search by Company Name or Client Full Name',
				'searchTitle': 'Search Client Database',
				'searchElements': [
					['Company / Full Client Name', 0, 'user']
				],
				'type': 'company'
			},
			{
				'title': 'Search by Document',
				'searchTitle': 'Search Document Database',
				'searchElements': [
					['Document Id', 0, 'tag'],
					['PO #', 1, 'tag'],
					['Sidemark', 2, 'user-plus']
				],
				'type': 'document'
			},
			{
				'title': 'Search PDF Document',
				'searchTitle': 'Search PDF Database',
				'searchElements': [
					['Client Code', 0, 'user-plus'],
					['Client Name', 1, 'user']
				],
				'type': 'pdf'
			},
			{
				'title': 'Search Invoices',
				'searchTitle': 'Search Invoice Database',
				'searchElements': [
					['Client Code', 0, 'user-plus'],
					['Company / Full Client Name', 1, 'user'],
					['Search by Document #', 2, 'tag']
				],
				'type': 'invoice'
			}
		]
		context['model']['currentModel'] = {};
		searchTypes.forEach(function(obj) {
			context['model']['currentModel'][obj['type']] = {}; 
		})
		context['model']['currentModel']['currentSearch'] = '';
		context['model']['searchConf'] = searchTypes;
	},
	
	buttonSelConf: function(arr) {
		/**
			
		**/
		var buttons = arr.map(function(b) {
			var conf =  {
				'id': b[0],
				'display': b[1]
			}
			if(typeof b[2] !== 'undefined') conf['icon'] = b[2]
			return conf
		})
		return buttons
	},
	
	setJobContext: function(job) {
		var header = job['header'];
		var context = DAB.context();
		var workOrderHeader = context['currentModel']['workOrderHeader'];
		var woTitles = ['poNum', 'sidemark'];
		var type = header['type']
		woTitles.forEach(function(attr) {
			if(workOrderHeader[attr] !== '') header[attr] = workOrderHeader[attr];
		});
		if(header['type'] === 'furnJob' || header['type'] === 'onloFurnJob') {
			header['unitType'] = '';
		}
		if(header['type'] === 'carpetJob') {
			header['subSelect'] = 'F103';
		}
		if(workOrderHeader['orderType'] === 'SPD') {
			var drivers = {
				'pickupDriver': 'commissionPickup',
				'deliveryDriver': 'commissionDelivery'
			}
			Object.keys(drivers).forEach(function(attr) {
				if(workOrderHeader[attr][0] !== '') {
					console.log(job, drivers[attr]);
					job[drivers[attr]]['base'] = workOrderHeader[attr].slice();
				}
			})
		}
		context['conf']['setRoutingCodes'](header);

	},
	
	setRoutingCodes: function(header) {
		var context = DAB.context();
		var serviceArr = ['receivedLoc', 'serviceLoc', 'returnedLoc'];
		var locationCode = 'OOO';
		var orderType = context['currentModel']['workOrderHeader']['orderType'];
		var serviceCodes = {
			'SCC': {
				'rugJob': 'SSS',
				'furnJob': 'SSS',
				'fabJob': 'SSS',
				'repairJob': 'SSS',
				'otherJob': 'SSS'
			},
			'BCC': {
				'rugJob': 'BSB',
				'furnJob': 'BBB',
				'fabJob': 'BBB',
				'repairJob': 'BBB',
				'otherJob': 'BBB'
			},
			'SPD': {
				'rugJob': 'PSD',
				'furnJob': 'PSD',
				'fabJob': 'PSD',
				'repairJob': 'PSD', 
				'otherJob': 'PSD'
			}
		}
		if(serviceCodes.hasOwnProperty(orderType)) {
			locationCode = serviceCodes[orderType][header['type']];
		}
		serviceArr.forEach(function(loc, i) {
			header[loc] = locationCode[i];
		})
	},
	//--------------------------------------------------------------------------------------------|
	//-------------------------------Job Configuration functions----------------------------------|
	//--------------------------------------------------------------------------------------------|

	baseJobConf: function(obj) {
		var context = DAB.context();
		var formRow = context['components']['formRow'];
		var conf = {
			'pricing': [
				
			],
			'header': [
				formRow('Location Status', context['conf']['locationRow'](obj['header'])),
				formRow('PO # / Sidemark', context['conf']['sidemarkRow'](obj['header'])),
				formRow('Pricing Options', context['conf']['pricingRow'](obj['header'])),
				formRow('Custom Discount', context['conf']['customDiscount'](obj)),
				formRow('Status', context['conf']['statusRow'](obj['header'])),
				formRow('Employee Details', context['conf']['employeeDetailRow'](obj))
			],
			'detail': [
				formRow('Service Dates', context['conf']['dateRow'](obj['header'])),
				formRow('Type of Rug', context['conf']['mainSelectionRow'](obj['header'])),
				formRow('Rug Sub Type', context['conf']['serviceRow'](obj)),
				formRow('Oriental Rug Type', context['conf']['orientalRow'](obj)),
				formRow('Rug Size', context['conf']['sizeRow'](obj)),
				formRow('Rug Shape', context['conf']['shapeRow'](obj)),
				formRow('Rug Color', context['conf']['colorPickerConf'](obj))
			],
			'attachments': [
				formRow('Attached Photos', context['conf']['attachment']('photo', obj)),
				formRow('Attached Files', context['conf']['attachment']('file', obj))
			],
			'conditions': [
				context['conf']['conditions'](obj)
			],
			'additional': [
				context['conf']['additionalButtons'](obj),
				context['conf']['additionalSelection'](obj),
				context['conf']['lineItemContainer'](obj, 'additionalServices', 'Additional Service Detail'),
				context['conf']['delivery'](obj)
			],
			'notes': [
				
			]
		}
		if(obj['header']['type'] === 'furnJob' || obj['header']['type'] === 'onloFurnJob') {
			var secondTitle = 'Upholstery Type';
			conf['detail'] = [conf['detail'][0]];
			conf['detail'].push(formRow('Material Type', context['conf']['mainSelectionRow'](obj['header'])));
			if(obj['header']['mainSelect'] === 'UM102') {
				secondTitle = 'Leather Type';
				conf['detail'].push(context['conf']['furnitureSelect'](obj));
				conf['detail'].push(formRow(secondTitle, context['conf']['serviceRow'](obj)));
			} else {
				conf['detail'].push(formRow(secondTitle, context['conf']['serviceRow'](obj)));
				conf['detail'].push(context['conf']['furnitureSelect'](obj));
			}
			conf['detail'].push(context['conf']['furnitureMaterial'](obj))
			conf['detail'].push(formRow('Service Detail', context['conf']['sizeRow'](obj)));
			conf['detail'].push(formRow('Furniture Color', context['conf']['colorPickerConf'](obj)));
			conf['detail'].push(formRow('Furniture Pattern', context['conf']['shapeRow'](obj)));
		}
		if(obj['header']['type'] === 'fabJob') {
			conf['conditions'] = [
				conf['conditions'][0],
				context['conf']['lineItemContainer'](obj, 'mainServices', 'Service Detail'),
				context['conf']['fabrication'](obj)
			]
		}
		if(obj['header']['type'] === 'repairJob') {
			conf['conditions'] = [
				conf['conditions'][0],
				context['conf']['lineItemContainer'](obj, 'mainServices', 'Service Detail'),
				context['conf']['handRepair'](obj)
			]
		}
		if(obj['header']['type'] === 'otherJob') {
			conf['header'].push(formRow('Service Dates', context['conf']['dateRow'](obj['header'])))
			conf['detail'] = [
				context['conf']['carpetSale'](obj),
				context['conf']['spotOff'](obj),
				context['conf']['carpetPads'](obj),
				context['conf']['lineItemContainer'](obj, 'mainServices', 'Service Detail')
			]
			conf['conditions'] = [];
			conf['additional'] = [];
		}
		if(obj['header']['type'] === 'carpetJob') {
			conf['detail'] = [
				formRow('Service Dates', context['conf']['dateRow'](obj['header'])),
				context['conf']['descButtonRow'](obj['header'], 'F1-01', 'Furniture Moving', 'subSelect', 'buttonRadio'),
				context['conf']['descButtonRow'](obj['header'], 'L1-01', 'Location Type', 'mainSelect', 'buttonRadio')
			], 
			conf['attachments'] = [];
			if(obj['header']['mainSelect'] !== '') {
				conf['attachments'] = [
					context['conf']['carpetAreaSelect'](obj),
					context['conf']['carpetAreaContainer'](obj)
				];				
			}
			conf['conditions'] = [
				formRow('Attached Photos', context['conf']['attachment']('photo', obj)),
				formRow('Attached Files', context['conf']['attachment']('file', obj))
			]
		}
		if(obj['header']['type'] === 'stoneJob') {
			conf['detail'] = [
				formRow('Service Dates', context['conf']['dateRow'](obj['header'])),
				context['conf']['descButtonRow'](obj, 'ST-01', 'Surface', 'subSelect', 'addStoneSurface'),
				context['conf']['carpetAreaContainer'](obj)
			]
			conf['conditions'] = [];
			conf['additional'] = [];
		}
		if(['SPD'].indexOf(context['currentModel']['workOrderHeader']['orderType']) !== -1) {
			conf['detail'].splice(0,0, context['components']['scheduleOptions'](obj['header'], obj['state']))
		}
		return conf;
	},
	
	priceDisplay: function(obj) {
		var priceLabels = {
			'prices': ['subTotal', 'savings', 'additionalSubTotal', 'mainSubTotal'],
			'labels': ['Subtotal: $', 'Savings: $', 'Additional Svc: $', 'Service: $']
		}
		if(obj['header']['type'] === 'carpetJob') {
			priceLabels['prices'].push('unitTotal');
			priceLabels['labels'].push('Total SqFt: ')
		}
		var prices = priceLabels['prices'].map(function(price, i) {
			return m('div', {'className': 'uk-form-controls'},
				m('ul', {'className': 'uk-float-right'},
					m('h2', [
						priceLabels['labels'][i],
						m('span', {'className': ''}, obj['header'][price].toFixed(2))
					])
				)
			);
		});
		return prices;
	},
	
	locationRow: function(obj) {
		var context = DAB.context();
		if(context['currentModel']['workOrderHeader']['docType'] === 'SP' ||
		context['currentModel']['workOrderHeader']['orderType'] === 'ONLO') return '';
		var buttons = [['pickedUp', 'Picked Up']];
		if(context['currentModel']['workOrderHeader']['orderType'] === 'SPD') {
			buttons.push(['delivered', 'Delivered'])
		}
		return selections = buttons.map(function(sel) {
			var className = 'uk-button ts-button-bold uk-margin-small-bottom';
			if(obj[sel[0]] === 'Y') className += ' uk-active';
			return m('button', {
					'className': className,
					'onclick': function(e) {
						e.stopPropagation();
						obj[sel[0]] = obj[sel[0]] === 'Y' ? 'N' : 'Y'
						console.log(obj[sel[0]]);
						context['app']['reDraw']();
					}
				},
				[m('i', {'className': 'uk-icon-check'}), sel[1]]
			)
		})
	},
	
	sidemarkRow: function(baseModel) {
		var context = DAB.context();
		var types = ['receivedLoc', 'serviceLoc', 'returnedLoc'];
		var options = ['', 'S', 'B', 'P', 'O', 'D'];
		var inputs = [
			['tag', 'PO #', 'poNum'],
			['user-plus', 'Sidemark', 'sidemark']
		];
		var location = types.map(function(attr) {
			return context['components']['selection']({
				'selections': options,
				'modelAttr': attr,
				'model': baseModel,
				'parentClass': 'uk-form uk-form-tiny'
			})
		})
		if(context['currentModel']['workOrderHeader']['orderType'] === 'ONLO') {
			location = [];
		}
		inputs.forEach(function(input) {
			location.push(context['components']['inputIcon'](
				 {
					'icon': input[0],
					'placeholder': input[1],
					'modelAttr': input[2],
					'onchange': context['app']['buttonRadio'],
					'model': baseModel,
					'inputClass': 'uk-form-width-small'
				}
			))
		})
		return location;
	},
	
	pricingRow: function(obj) {
		var context = DAB.context();
		var currentUser = context['model']['currentUser'];
		if(context['currentModel']['workOrderHeader']['docType'] === 'SP') return '';
		var buttons = [
			['NONE', 'No Savings', 'times'],
			['STANDARD', 'Standard Pricing', 'check']
		]
		if(currentUser['isAdmin'] === 'Y' || currentUser['isManager'] === 'Y') {
			buttons.splice(1, 0, ['CUSTOM', 'Custom Savings', 'check'])
		}
		var selections = buttons.map(function(b) {
			return {
				'id': b[0],
				'display': b[1],
				'icon': b[2]
			}
		})
		var bWall = context['components']['buttonWall']({
			'model': obj,
			'modelAttr': 'discountType',
			'parentClass': '',
			'selections': selections,
			'fnOnClick': context['app']['buttonRadio']
		});
		return bWall;
	},
	
	customDiscount: function(obj) {
		var context = DAB.context();
		if(obj['header']['discountType'] !== 'CUSTOM') return '';
		var val = obj['header']['customDiscount']
		if(val === 0) val = '';
		return m('input', {
			'onkeydown': context['app']['validateInteger'],
			'placeholder': '0%',
			'value': val,
			'onkeyup': function(e) {
				e.stopPropagation()
				if(this.value === '') {
					value = 0
				} else {
					var value = parseInt(this.value);
					if(value > 100) value = 100; 					
				}
				obj['header']['customDiscount'] = value;
				context['app']['setCustomDiscount'](obj, value)
				context['app']['setJobPrice']();
				context['app']['reDraw']();
			}
		})
	},
	
	statusRow: function(obj) {
		var context = DAB.context();
		if(context['currentModel']['workOrderHeader']['docType'] === 'SP') return '';
		var buttons = [
			['IP', 'In Process', 'circle'],
			['COMP', 'Complete', 'check-circle']
		]
		if(context['currentModel']['workOrderHeader']['orderType'] !== 'ONLO') {
			buttons.splice(1, 0, ['AP', 'Auth Pending', 'exclamation-circle']);
			buttons.splice(1, 0, ['H', 'Hold', 'circle-o']);
		}
		var selections = context['conf']['buttonSelConf'](buttons);
		return context['components']['buttonWall']({
			'model': obj,
			'modelAttr': 'status',
			'parentClass': '',
			'selections': selections,
			'fnOnClick': context['app']['changeJobStatus']
		})
	},
	
	employeeDetailRow: function(obj) {
		var context = DAB.context();
		if(context['currentModel']['workOrderHeader']['docType'] === 'SP') return '';
		var takenBy = context['components']['selectionAndExtra']({
			'model': obj['header']
		}, 'takenBy', 'active');
		var typeByJob = {
			'rugJob': 'Cleaning Technicians',
			'furnJob': 'In-Plant Upholstery Technicians',
			'onloFurnJob': 'Cleaning Technicians',
			'carpetJob': 'Cleaning Technicians',
			'stoneJob': 'Cleaning Technicians'
		}
		var details = [context['components']['miniPanel']('Taken By:', takenBy)]
		if(typeByJob.hasOwnProperty(obj['header']['type'])) {
			var type = typeByJob[obj['header']['type']];
			var workBy = context['components']['selectionAndExtra']({
				'model': obj['commissionWork']
			}, 'workBy', type)			
			details.push(context['components']['miniPanel']('Completed By:', workBy))
		}
		details.push(context['components']['miniPanel']('Picked Up By:',
				context['components']['selectionAndExtra']({
					'model': obj['commissionPickup']
				}, 'base', 'Driver')	
			)
		)
		return details;
	},
			
	dateRow: function(obj) {
		var context = DAB.context();
		if(context['currentModel']['workOrderHeader']['docType'] === 'SP') return '';
		var dates = ['dateReceived', 'dateDue', 'dateComplete'];
		var title = ['Received Date:', 'Due Date:', 'Completion Date:'];
		if(context['currentModel']['workOrderHeader']['orderType'] === 'ONLO') {
			title[0] = 'Received Date:'
			// title[1] = 'Service Date:'
			dates.splice(1,1);
			title.splice(1,1);
		} 
		if(context['currentModel']['workOrderHeader']['orderType'] === 'SPD') {
			title[0] = 'Received Date:'
			// dates.splice(1,0, 'datePickup');
			// title.splice(1,0, 'Pickup Date:');
			// dates.splice(2,0, 'dateDelivery');
			// title.splice(2,0, 'Delivery Date:');
		}
		var datePickers = dates.map(function(date, i) {
			var conf = {
				'modelAttr': date,
				'dateOption': date + 'Sub',
				'model': obj						
			}
			if(date === 'dateDue') {
				conf['fnOnChange'] = context['app']['setDateOverWritten'];
			}
			return context['components']['miniPanel'](title[i],
				context['components']['datePicker'](conf)
			)
		})
		return datePickers;
	},
	
	shapeRow: function(obj) {
		var context = DAB.context();
		var cat = 'S1-01';
		if(obj['header']['type'] === 'furnJob' || obj['header']['type'] === 'onloFurnJob') cat = 'U3-01';
		var bWall = context['components']['buttonWall']({
			'model': obj['header'],	
			'modelAttr': 'shapeCode',
			'selections': context['model']['descriptiveCat'][cat],
			'fnOnClick': context['app']['buttonRadio'],
			'parentClass': 'quickSpacer'
		})
		return bWall;
	},
	
	mainSelectionRow: function(obj) {
		var context = DAB.context();
		var cat = 'T1-01';
		if(obj['type'] === 'furnJob' || obj['type'] === 'onloFurnJob') cat = 'UM-01';
		var selections = context['model']['descriptiveCat'][cat].slice();
		//remove other option
		if(['repairJob', 'fabJob'].indexOf(obj['type']) !== -1) selections.pop();
		var bWall = context['components']['buttonWall']({
			'model': obj,
			'modelAttr': 'mainSelect',
			'selections': selections,
			'fnOnClick': context['app']['selectFurnitureType'],
			'parentClass': 'quickSpacer'
		})
		return bWall;
	},
	
	serviceRow: function(obj) {
		var context = DAB.context();
		var mainSelect = obj['header']['mainSelect']; 
		if(mainSelect === ''|| obj['header']['type'] === 'carpetJob') return '';
		var dictionary = {
			'T101': '01-01',
			'T102': '01-02',
			'T103': '01-03',
			'T104': '01-05',
			'T105': '01-06'
		}
		var fnOnClick = context['app']['addNewMainService'];
		var selections = context['model']['servicesCat'][dictionary[mainSelect]];
		if(obj['header']['type'] !== 'rugJob') {
			if(['repairJob', 'fabJob'].indexOf(obj['header']['type']) !== -1) {
				dictionary = {
					'T101': 'RD-01',
					'T102': 'RD-02',
					'T103': 'RD-03',
					'T104': 'RD-04'
				} 
			}
			if(obj['header']['type'] === 'furnJob' || obj['header']['type'] === 'onloFurnJob') {
				dictionary = {
					'UM101': 'U1-01',
					'UM102': 'U2-04'
				}
			} 
			selections = context['model']['descriptiveCat'][dictionary[mainSelect]]
			fnOnClick = context['app']['buttonRadio'];
		}
		var bWall = context['components']['buttonWall']({
			'model': obj['header'],
			'modelAttr': 'subSelect',
			'selections': selections,
			'fnOnClick': fnOnClick,
			'parentClass': 'quickSpacer'
		})
		return bWall;
	},
	
	orientalRow: function(obj) {
		var context = DAB.context();
		var subSelect = obj['header']['subSelect'];
		if(subSelect === '') return '';
		if(['141', 'C117'].indexOf(subSelect) === -1) return '';
		return context['components']['buttonWall']({
			'model': obj['header'],
			'modelAttr': 'mainCode',
			'selections': context['model']['descriptiveCat']['OR-01'],
			'fnOnClick': context['app']['buttonRadio'],
			'parentClass': 'spaceAdjust6 uk-grid uk-grid-width-1-6 uk-grid-width-xlarge-1-6 uk-grid-width-medium-1-3 ts-checkboxwall'
		})
	},
	
	furnitureSelect: function(obj) {
		var context = DAB.context();
		var dictionary = {
			'P101': [['03-03', 'Chair']],
			'P102': [['03-06', 'Cushions']],
			'P103': [['03-05', 'Dining / Desk Chair']],
			'P104': [['03-13', 'Luggage']],
			'P105': [['03-14', 'Mattress / Futon']],
			'P106': [['03-07', 'Ottoman / Foot Stool']],
			'P107': [['03-01', 'Sofa / Loveseat'], ['03-02', 'Chaise Lounge']],
			'P108': [['03-12', 'Cornice / Head Board'], ['03-04', 'Arm Cap / Head Rest'], ['03-15', 'Fabric Covered Wall / Divider Panel'], ['03-17','Specialty Services']]
		}
		var selected = obj['header']['subSelect'];	
		if(obj['header']['type'] === 'onloFurnJob') {
			//set categories for onlo services
			Object.keys(dictionary).forEach(function(attr) {
				dictionary[attr].forEach(function(el) {
					el[0] = '06' + el[0].substr(2);
				})
			})
		}
		if(selected === '' && obj['header']['mainSelect'] !== 'UM102') return '';
		var title = 'Furniture Type';
		if(selected === 'P108') title = 'Other Upholstery Services';
		var iterateThru = dictionary[selected];
		var selectionContainer = context['model']['servicesCat'];
		if(obj['header']['mainSelect'] === 'UM102') {
			var selectionContainer = context['model']['descriptiveCat'];
			iterateThru = [
				['LS-01', 'Sofa / Loveseat / Chaise Lounge'],
				['LS-02', 'Chair'],
				['LS-03', 'Cushions'],
				['LS-04', 'Ottoman / Seating'],
				['LS-05', 'Special Service']
			]
		}
		var content = iterateThru.map(function(bWall) {
			//gotta set services according to A or B types; 
			var selections = selectionContainer[bWall[0]];
			if(obj['header']['mainSelect'] !== 'UM102') {
				var selections = [];
				var selectionType = context['app']['fabricType'](obj['header']['materialSelect']);
				selectionContainer[bWall[0]].forEach(function(button) {
					if(button['id'][3] === selectionType || button['id'].length === 3) {
						selections.push(button);
					} 
				})
			}
			var buttonWall = context['components']['buttonWall']({
				'model': obj['header'],
				'modelAttr': 'serviceSelect',
				'selections': selections,
				'fnOnClick': context['app']['addNewMainService'],
				'parentClass': 'spaceAdjust6 uk-grid uk-grid-width-1-6 uk-grid-width-xlarge-1-6 uk-grid-width-medium-1-3 ts-checkboxwall'
			})
			return context['components']['formRow'](bWall[1], buttonWall);
		})
		return context['components']['rowElementLegend']({
			'content': content,
			'title': title
		});
	},
	
	furnitureMaterial: function(obj) {
		var context = DAB.context();
		var mainSelect = obj['header']['mainSelect']; 
		if(['', 'UM102'].indexOf(mainSelect) !== -1) return '';
		var iterateThru = [
			['U2-01', 'Fabric (A)'],
			['U2-02', 'Fabric (B)']
		]
		var content = iterateThru.map(function(bWall) {
			var buttonWall = context['components']['buttonWall']({
				'model': obj['header'],
				'modelAttr': 'materialSelect',
				'selections': context['model']['descriptiveCat'][bWall[0]],
				'fnOnClick': context['app']['buttonRadio'],
				'parentClass': 'spaceAdjust6 uk-grid uk-grid-width-1-6 uk-grid-width-xlarge-1-6 uk-grid-width-medium-1-3 ts-checkboxwall'
			})
			return context['components']['formRow'](bWall[1], buttonWall);
		})
		return context['components']['rowElementLegend']({
			'content': content,
			'title': 'Fabric Type:'
		});
	},
	
	sizeRow: function(obj) {
		var context = DAB.context();
		var header = obj['header'];
		if(header['unitType'] === '') return '';
		if(header['mainSelect'] === 'UM102' && header['subSelect'] === '') return '';
		var dimensionsByType = {
			'Square Foot': {
				'dimName': ['ftWidth', 'inWidth', 'ftHeight', 'inHeight', 'unitTotal'],
				'placeholder': ['Feet', 'Inches', 'Feet', 'Inches', 'Total'],
				'splice': [[0,0,'Width: '],[3,0,'Length: '],[6,0, 'Total: ']]
			},
			'Leneal Foot': {
				'dimName': ['ftWidth', 'inWidth'],
				'placeholder': ['Feet', 'Inches'],
				'splice': [[0,0,'Length: ']]
			},
			'Each': {
				'dimName': ['quantity'],
				'placeholder': ['Units'],
				'splice': [[0,0,'Quantity: ']]
			},
			'Est': {
				'dimName': ['quantity'],
				'placeholder': ['$'],
				'splice': [[0,0,'Custom Cost: ']]
			}
		}
		var dimensions = ['ftWidth', 'inWidth', 'ftHeight', 'inHeight', 'unitTotal'];
		var placeholder = ['Feet', 'Inches', 'Feet', 'Inches', 'Total'];
		var dimensionsToUse = dimensionsByType[header['unitType']];
		var dimensionRow = dimensionsToUse['dimName'].map(function(attr, i) {
			var max = 10000;
			var min = 0;
			var disabled = false;
			var value = header[attr];
			if(attr === 'unitTotal' && header['unitType'] === 'Square Foot') {
				disabled = true;
				value = header[attr].toFixed(2);
			}
			var validate = context['app']['validateInteger'];
			if(header['unitType'] === 'Est') validate = context['app']['validateFloat'];
			if(placeholder[i] === 'Inches') max = 11;
			if(value === 0) value = '';
			return m('input', {
				'placeholder': dimensionsToUse['placeholder'][i],
				'onkeyup': function(e) {
					inputAction(this.value);
				},
				'onchange': function(e) {
					inputAction(this.value);
				},
				'value': value,
				'type': 'number',
				'max': max,
				'min': min,
				'className': 'uk-form-width-small',
				'onkeydown': validate,
				'disabled': disabled
			})				
			function inputAction(value) {
				if(parseInt(value) > max) value = max;
				if(value === '') value = 0;
				header[attr] = value
				context['app']['setDimension'](header);
				if(['rugJob', 'furnJob', 'onloFurnJob'].indexOf(header['type']) !== -1) {
					obj['mainServices'].forEach(function(serv) {
						context['app']['inheritDimObj'](header, serv)
					})
					if(header['type'] === 'rugJob') {
						var hasAdd = false;
						for(var i = 0; i < obj['additionalServices'].length; i++) {
							if(obj['additionalServices'][i]['id'][0] === '1') {
								hasAdd = true;
								break;
							}
						}				
						if(hasAdd) context['workOrderState']['inheritChild'] = 'Y';
					}
				}
				context['app']['setJobPrice']();
				context['app']['reDraw']();
			}
		})
		dimensionsToUse['splice'].forEach(function(arr) {
			dimensionRow.splice(arr[0], arr[1], arr[2]);
		})
		if(context['workOrderState']['inheritChild'] === 'Y') {
			dimensionRow.push(
				m('button', {
					'className': 'uk-button',
					'onclick': function(e) {
						e.stopPropagation();
						context['workOrderState']['inheritChild'] = 'N';
						obj['additionalServices'].forEach(function(serv) {
							if(serv['id'][0] === '1') {
								context['app']['inheritDimObj'](header, serv)
							}
						});
						context['app']['setJobPrice']();
						context['app']['reDraw']();
					}
				}, 'Set Additional Servives Dimensions')
			)
		}
		
		
		return dimensionRow;
	},
	
	attachment: function(attach, obj) {
		var context = DAB.context();
		return [
			context['components']['attachmentForm']({
				'label': 'Attach '+ attach +'s:',
				'modelAttr': attach,
				'model': obj['attachments'],
				'fnOnChange': context['app']['attachmentAdd']
			}),
			context['components']['attachment' + capitalizeFirstLetter(attach)]({
				'modelAttr': attach,
				'model': obj['attachments'],
				// 'title': obj['header']['title']
			})								
		]
		
		function capitalizeFirstLetter(string) {
			return string.charAt(0).toUpperCase() + string.slice(1);
		}
	},
	
	conditions: function(obj) {
		var context = DAB.context();
		var conditions = [
			['Soil and Stains', 'D1-01'],
			['Manufacturing', 'D2-01'],
			['Use / Wear', 'D3-01'],
			['Time & Environment', 'D4-01'],
			['Color Issues', 'D5-01']
		]
		var title =  'Rug Conditions:';
		if(obj['header']['type'] === 'furnJob' || obj['header']['type'] === 'onloFurnJob') {
			var preffix = 'U';
			title = 'Upholstery Conditions: ';
			if(obj['header']['mainSelect'] === 'UM102') {
				preffix = 'L';
				title = 'Leather Upholstery Conditions: ';
			}
			conditions = conditions.map(function(el, i) {
				el[1] = preffix + (i + 4) + '-01';
				return el;
			})
		}
		var conditionState = obj['state']['conditionFilter'];
		var maxCondition = 4;
		var content = conditions.map(function(cat, i) {
			return conditionCreate(cat, i)
		})
		var initObj = {
			'model': obj['state'],
			'modelAttr': 'conditionFilter',
			'content': content,
			'title': title
		}
		var conditionContainer = context['components']['filterElement'](initObj);
		function conditionCreate(condition, i) {
			var inner = [];
			var buttonWall = context['components']['buttonWall']({
				'model': obj,
				'modelAttr': 'descriptive',
				'selections': context['model']['descriptiveCat'][condition[1]],
				'fnOnClick': context['app']['buttonToggle'],
				'filterBy': conditionState,
				'parentClass': 'spaceAdjust6 uk-grid uk-grid-width-1-6 uk-grid-width-xlarge-1-6 uk-grid-width-medium-1-3 ts-checkboxwall'
			})
			inner.push(buttonWall);
			var subSelection = condition[1].substring(0,3) + '02'
			if(context['model']['descriptiveCat'].hasOwnProperty(subSelection)) {
				var selected = obj['state'][subSelection] === true
				var buttonClass ='uk-button ts-button-bold uk-margin-small-bottom';
				var otherOW = checkOther();
				if(otherOW) selected = true;
				if(selected) buttonClass += ' uk-active';
				buttonWall['children'].push(
					m('div', {'className': 'checkboxwallcontainer '},
						m('button', {
						'className': buttonClass,
						'onclick': function(e) {
							if(otherOW) return;
							var setTo = obj['state'][subSelection] ? false : true;
							obj['state'][subSelection] = setTo;
							context['app']['reDraw']();
						}
						}, 'Other')
					)
				);
				if(typeof obj['state'][subSelection] === 'undefined') obj['state'][subSelection] = false;
				if(selected || otherOW) {
					inner.push(context['components']['buttonWall']({
						'model': obj,
						'modelAttr': 'descriptive',
						'selections': context['model']['descriptiveCat'][subSelection],
						'fnOnClick': context['app']['buttonToggle'],
						'filterBy': conditionState,
						'parentClass': 'spaceAdjust6 uk-grid uk-grid-width-1-6 uk-grid-width-xlarge-1-6 uk-grid-width-medium-1-3 ts-checkboxwall'
					}))
				}
			}
			return context['components']['formRow'](condition[0], inner, ' color-' + i);
			
			function checkOther() {
				var other = false;
				obj['descriptive'].forEach(function(code) {
					if(context['app']['findInArray'](context['model']['descriptiveCat'][subSelection], 'id', code)) {
						other = true
					}
				})
				return other;
			}
		}
		return conditionContainer
	},
	
	additionalButtons: function(obj) {
		var context = DAB.context();
		var buttons = [
			['Add Additional Services', 'additionalRug', 'plus'],
			['Add Rug Pads', 'carpetPads', 'plus'],
			['Add Hand Repair', 'handRepair', 'plus'],
			['Add Fabrication', 'fabrication', 'plus']
		]
		if(obj['header']['type'] === 'furnJob' || obj['header']['type'] === 'onloFurnJob') {
			buttons = [
				['Add Additional Services', 'additionalFurn', 'plus']
			]
		}
		if(['repairJob', 'fabJob'].indexOf(obj['header']['type']) !== -1) {
			buttons = [buttons[0], buttons[1]];
		}
		if(obj['header']['type'] === 'carpetJob') {
			buttons = [['Add Additional Service', 'additionalCarpet', 'plus']];
		}
		if(['SCC', 'BCC', 'ONLO'].indexOf(context['currentModel']['workOrderHeader']['orderType']) === -1) {
			buttons.push(['Delivery Options', 'deliveryOptions', 'truck'])
		}
		var buttonChange = buttons.map(function(b) {
			return {
				'display': b[0],
				'id': b[1],
				'icon': b[2],
				'buttonClass': 'uk-button uk-button-large ts-button-bold'
			}
		})
		return  context['components']['buttonWall']({
			'model': obj['state'],
			'modelAttr': 'additionalSelection',
			'selections': buttonChange,
			'parentClass': 'uk-form-row uk-margin-bottom',
			'fnOnClick': context['app']['buttonRadio']
		})
	},
	
	additionalSelection: function(obj) {
		var context = DAB.context();
		var addSel = obj['state']['additionalSelection']; 
		if(addSel === '') return '';
		return context['conf'][addSel](obj);
	},
	
	additionalConf: function(obj, cat, selections, type) {
		var context = DAB.context();
		var state = obj['state']['additionalFilter'];
		var inner = {
			'model': obj,
			'modelAttr': 'additionalSelected',
			'selections': context['model']['servicesCat'][cat],
			'fnOnClick': context['app']['addNewLineItem'],
			'filterBy': state,
			'activeDisabled': true,
			'parentClass': 'spaceAdjust6 uk-grid uk-grid-width-1-6 uk-grid-width-xlarge-1-6 uk-grid-width-medium-1-3 ts-checkboxwall'
		}
		if(selections) inner['selections'] = selections;
		if(type === 'main') {
			inner['modelAttr'] = 'mainSelected';
			inner['filterBy'] =  obj['state']['mainFilter'];
			inner['fnOnClick'] = context['app']['addNewMainService'];
		}
		return inner
	},
	
	additionalFilterConf: function(obj,content, title, type) {
		var initObj = {
			'model': obj['state'],
			'modelAttr': 'additionalFilter',
			'content': content,
			'title': title
		}
		if(type && type === 'main') initObj['modelAttr'] = 'mainFilter';
		return initObj
	},
	
	additionalRug: function(obj) {
		var context = DAB.context();
		var inner = context['components']['buttonWall'](context['conf']['additionalConf'](obj, '01-09'))
		// var content = context['components']['formRow']('Additional Services:', inner);
		var initObj = context['conf']['additionalFilterConf'](obj, inner, 'Rug Cleaning Additional Services:');
		return context['components']['filterElement'](initObj)
	},
	
	additionalFurn: function(obj) {
		var context = DAB.context();
		var base = '03';
		if(obj['header']['type'] === 'onloFurnJob') {
			base = '06';
		}
		var cat = base + '-16';
		if(obj['header']['mainSelect'] === 'UM102') {
			cat = base + '-18';
		}
		var inner = context['components']['buttonWall'](context['conf']['additionalConf'](obj, cat))
		// var content = context['components']['formRow']('Additional Services:', inner);
		var initObj = context['conf']['additionalFilterConf'](obj, inner, 'Upholstery Cleaning Additional Services:');
		return context['components']['filterElement'](initObj)
	},
	
	additionalCarpet: function(obj) {
		var context = DAB.context();
		var inner = context['components']['buttonWall'](context['conf']['additionalConf'](obj, '05-05'))
		var initObj = context['conf']['additionalFilterConf'](obj, inner, 'Rug Cleaning Additional Services:');
		return context['components']['filterElement'](initObj)
	},
	
	carpetPads: function(obj) {
		var context = DAB.context();
		var carpetTypes = [
			['DuraHold Rug Pad', '07-01-02'],
			['Wunder Grip Rug Pad', '07-01'],
			['No Muv Rug Pad', '07-02-02'],
			['Wunder Lock Rug Pad', '07-02'],
			['Seaming & Special Cutting', '07-05']
		]
		var type = '';
		if(obj['header']['type'] === 'otherJob') type = 'main';
		var content = carpetTypes.map(function(cType) {
			var conf = context['conf']['additionalConf'](obj, cType[1], false, type);
			var inner = context['components']['buttonWall'](conf);
			return context['components']['formRow'](cType[0], inner);
		})
		var initObj = context['conf']['additionalFilterConf'](obj, content, 'Rug Pad Services:', type);
		return context['components']['filterElement'](initObj)
	},
	
	carpetSale: function(obj) {
		var context = DAB.context();	
		var inner = context['components']['buttonWall'](context['conf']['additionalConf'](obj, '07-04', false, 'main'));
		return context['components']['rowElementLegend']({
			'content': context['components']['formRow']('', inner),
			'title': 'Carpet Sale'
		})
	},
	
	spotOff: function(obj) {
		var context = DAB.context();	
		var spot = [
			['Spot-Off', '09-03'],
			['Spot-Off Shipped', '09-04']
		]
		var content = spot.map(function(cType) {
			var inner = context['components']['buttonWall'](context['conf']['additionalConf'](obj, cType[1], false, 'main'));
			return context['components']['formRow'](cType[0], inner);
		})
		return context['components']['rowElementLegend']({
			'content': content,
			'title': 'Spot Off'
		})
	},
	
	handRepair: function(obj) {
		var context = DAB.context();
		var content = [];
		var type = '';
		if(obj['header']['type'] === 'repairJob') type = 'main';
		var generic = context['components']['buttonWall'](context['conf']['additionalConf'](obj, '02-13', false, type));
		content.push(context['components']['formRow']('Custom Services', generic));
		var wpi = [
			['Under 10 Warps Per Inch', 'A'],
			['10-15 Warps Per Inch', 'B'],
			['Over 15 Warps Per Inch', 'C']
		];
		var wpiSelection = wpi.map(function(w) {
			return {
				'id': w[1],
				'display': w[0]
			}
		});
		var bWall = context['components']['buttonWall']({
			'model': obj['header'],
			'modelAttr': 'wpi',
			'selections': wpiSelection,
			'fnOnClick': context['app']['buttonRadio'],
			'parentClass': 'spaceAdjust6 uk-grid uk-grid-width-1-6 uk-grid-width-xlarge-1-6 uk-grid-width-medium-1-3 ts-checkboxwall'
		})
		content.push(context['components']['formRow']('Warps Per Inch', bWall));
		if(obj['header']['wpi'] !== '') {
			content.push(repairOption());
		}
			
		function repairOption() {
			var repair = [
				['Rug End Repair', '02-16'],
				['Rug Side Edge Repair', '02-17'],
				['Special Repair Services', '02-18']
			]
			var repairContent = repair.map(function(cType) {
				var selections = context['model']['servicesRepair'][obj['header']['wpi']][cType[1]];
				var inner = context['components']['buttonWall'](context['conf']['additionalConf'](obj, cType[1], selections, type));
				return context['components']['formRow'](cType[0], inner);
			})
			return repairContent;
		}
		var initObj = context['conf']['additionalFilterConf'](obj, content, 'Repair Options:', type);
		return context['components']['filterElement'](initObj)
	},
	
	fabrication: function(obj) {
		var context = DAB.context();
		var fabTypes = [
			['Custom Services', '02-13'],
			['Carpet Binding', '02-01'],
			['Wide Binding', '02-02'],
			['Carpet Serging', '02-05'],
			['Custom Designed Carpet Fabrication', '02-11'],
			['Carpet Machine Fringing', '02-06'],
			['Custom Carpet Cutting','02-07'],
			['Removal of Existing Edge Treatment / Seaming Tape', '02-08'],
			['Application of Carpet Backings', '02-09'],
			['Carpet Velcro Fabrication', '02-10']
		]
		var type = '';
		if(obj['header']['type'] === 'fabJob') type = 'main';
		var content = fabTypes.map(function(cType) {
			var inner = context['components']['buttonWall'](context['conf']['additionalConf'](obj, cType[1], false, type));
			return context['components']['formRow'](cType[0], inner);
		})
		var initObj = context['conf']['additionalFilterConf'](obj, content, 'Fabrication Services:', type);
		return context['components']['filterElement'](initObj)
	},
	
	delivery: function(obj) {
		var context = DAB.context();
		if(['SPD', 'ONLO'].indexOf(context['currentModel']['workOrderHeader']['orderType']) !== -1) {
			return '';
		} 
		if(obj['header']['isDelivery'] === 'N') {
			var deliveryButton = m('button', {
				'className': 'uk-button',
				'onclick': function(e) {
					e.stopPropagation();
					obj['header']['isDelivery'] = 'Y';
					setDiscounts();
					context['app']['setJobPrice']();
					context['app']['reDraw']();
				}
			}, 'Delivery Options')
			return context['components']['rowElementLegend']({
				'content': context['components']['formRow']('Delivery', deliveryButton),
				'title': 'Delivery Options'
			})
		}
		var inner = [context['components']['addressContainer']('Item Delivery Options', 'item', obj)]
		var fMove = [{'id': 'N', 'display':'No'}, {'id': 'Y', 'display':'Yes'}];
		var fBWall = context['components']['buttonWall']({
			'selections': fMove,
			'model': obj['header'],
			'modelAttr': 'furnitureMoved',
			'fnOnClick': context['app']['buttonRadio'],
			'parentClass': ''
		})
		inner.push(context['components']['formRow']('Is there furniture to move?', fBWall));
		inner.push(context['components']['scheduleOptions'](obj['header'], obj['state']));
		inner.push(context['components']['formRow']('Delivery Date', 
			context['components']['datePicker']({
				'modelAttr': 'dateDelivery',
				'dateOption': 'dateDeliverySub',
				'model': obj['header']						
			})
		))
		inner.push(
			context['components']['formRow']('Delivered By', 
				context['components']['selectionAndExtra']({
					'model': obj['commissionDelivery']
				}, 'base', 'Driver')			
			)
		)
		inner = inner.concat(context['conf']['deliveryOptions'](obj));
		inner.push(context['components']['formRow']('Remove Delivery', 
			m('button', {'className': 'uk-button uk-button-danger',
			'onclick': function(e) {
				e.stopPropagation();
				obj['itemAddrKey'] = '';
				obj['itemAddress'] = {};
				obj['header']['isDelivery'] = 'N';
				setDiscounts();
				context['app']['setJobPrice']();
				context['app']['reDraw']();
			}}, 
			'Remove Delivery'))
		);
		return context['components']['rowElementLegend']({
			'content': inner,
			'title': 'Delivery Options'
		})
		
		function setDiscounts() {
			var orderType = 'SCC';
			var clientType = context['app']['clientType']();
			if(obj['header']['isDelivery'] === 'Y') {
				orderType = 'SPD'
			}
			context['app']['iterateThroughJob'](setDiscount, obj)
			function setDiscount(serv) {
				serv['discountRate'] = context['app']['searchForDiscount'](clientType, orderType, serv['id']);
			}
		}
	},
	
	deliveryOptions: function(obj) {
		var context = DAB.context();
		var delivery = [
			['Wholesale Delivery to 3rd Party', '02-12'],
			['Rug Pad Delivery', '02-14'],
			['Delivery Additional Services:', '02-21']
		]
		var content = delivery.map(function(cType) {
			var inner = context['components']['buttonWall'](context['conf']['additionalConf'](obj, cType[1], false));
			return context['components']['formRow'](cType[0], inner);
		})
		return content;
		// var initObj = context['conf']['additionalFilterConf'](obj, content, 'Delivery Options:');
		// return context['components']['filterElement'](initObj)
	},
	
	techRequested: function(obj) {
		var context = DAB.context();
		var select = context['components']['selectionAndExtra']({
			'model': obj['header']
		}, 'techRequested', 'Cleaning Technicians')			
		return context['components']['formRow']('Techician Requested', select);
	},
	
	descButtonRow: function(obj, category, title, modelAttr, fnType) {
		var context = DAB.context();
		var selections = context['model']['descriptiveCat'][category];
		if(category === 'ST-01') selections = selections.map(function(sel) {
			sel['icon'] = 'plus';
			return sel;
		})
		var inner = context['components']['buttonWall']({
			'model': obj,
			'modelAttr': modelAttr,
			'selections': selections,
			'fnOnClick': context['app'][fnType],
			'parentClass': 'spaceAdjust6 uk-grid uk-grid-width-1-6 uk-grid-width-xlarge-1-6 uk-grid-width-medium-1-3 ts-checkboxwall'
		})
		return context['components']['formRow'](title, inner);
	},
	//carpet stuff
	carpetAreaSelect: function(obj) {
		var context = DAB.context();
		if(obj['header']['mainSelect'] === '') return '';
		var areaCat = 'R1-01';
		if(obj['header']['mainSelect'] === 'L104') areaCat = 'R1-04';
		if(['L105', 'L106'].indexOf(obj['header']['mainSelect']) !== -1) areaCat = 'R1-05';
		return context['conf']['descButtonRow'](obj, areaCat, 'Add Areas', 'roomName', 'addCarpetRoom');
	},
	
	lineItemContainer: function(obj, containerAttr, title) {
		var context = DAB.context();
		var content;
		if(obj[containerAttr].length === 0) {
			content = m('p', {'className': 'uk-text-success'}, 'No Current Items');
		} else {
			var isEmpty = true;
			content = obj[containerAttr].map(function(serv, i) {
				var initObj = {
					'model': obj[containerAttr],
					'modelAttr': i,
					'fnOnChange': context['app']['changeLineItemAttr'],
					'fnOnCancel': context['app']['cancelLineItem']
				}
				var comp = context['components']['lineItem'](initObj);
				if(comp !== '') isEmpty = false;
				return comp
			})			
			if(isEmpty) content = m('p', {'className': 'uk-text-success'}, 'No Current Items');
		}
		return context['components']['rowElementLegend']({
			'content': content,
			'title': title
		})
	},
	
	carpetAreaContainer: function(obj) {
		var context = DAB.context();
		var content;
		var className = 'uk-grid uk-grid-width-1-4 uk-grid-width-xlarge-1-4 uk-grid-width-medium-1-2 uk-margin-small-left carpet-service-area'
		if(obj['mainServices'].length === 0) {
			content = m('p', {'className': 'uk-text-success'}, 'No Current Areas');
		} else if(obj['header']['type'] === 'carpetJob') {
			content = m('div', {'className': className}, obj['mainServices'].map(function(serv) {
					if(serv['active'] === 'N') return '';
					return context['components']['carpetRoom'](serv);
				})
			)
		} else if (obj['header']['type'] === 'stoneJob') {
			var surfaces = obj['surfaces'] 
			if(obj['state']['mainSelection'] !== '')  {
				var currentSelected = context['app']['findInArray'](surfaces, 'uniqueId', obj['state']['mainSelection']);
				return context['components']['stoneAndTile'](currentSelected);
			} else {
				content = m('div', {'className': 'uk-grid'},
					surfaces.map(function(serv) {
						if(serv['active'] === 'N') return '';
						return m('div', {'className': 'uk-width-1-3'},
							m('button', {
								'className': 'uk-button ts-button-bold primaryTint uk-width-1-1',
								'onclick': function(e) {
									e.stopPropagation();
									obj['state']['mainSelection'] = serv['uniqueId'];
									context['app']['reDraw']();
								}
							}, serv['nameOfItem'])	
						)
					})	
				);
			}
		}
		return context['components']['rowElementLegend']({
			'content': content,
			'title': 'Service Areas'
		})
	},
	
	colorPickerConf: function(obj) {
		var context = DAB.context();
		var colorsInit = ['color1', 'color2', 'color3'];
		var labels = ['Edge: ', 'Primary: ', 'Secondary: '] 
		if(obj['header']['type'] === 'furnJob' || obj['header']['type'] === 'onloFurnJob') {
			colorsInit.pop();
			labels = ['Primary: ', 'Secondary: '];
		}
		colorObjs = colorsInit.map(function(colorName,i) {
			return m('div', {'className': 'color_row_container'}, [
				m('span', labels[i]),
				context['components']['colorPicker']({
					'model': obj['header'],
					'modelAttr': colorName,
					'fnOnSelect': context['app']['colorSelect'],
					'uniqueAttr': colorName
				})
			]);
		})
		return colorObjs;
	},
	
	createUserSelections:function(attr) {
		var selections = [];
		QueryResponses['allUsers'].forEach(function(user) {
			if(user[attr] === 'Y') selections.push({
				'id': user['commId'],
				'display': user['name']
			})
		})
		return selections;
	},
	
	bindingOptions: function(obj, cat) {
		var context = DAB.context();
		var def = '';
		var defByCat = {
			'binding': ['02-01', '02-02'],
			'serging': ['02-05'],
			'fringe': ['02-06']
		}
		var spliceByType = {
			'binding': [
				[0,0, 'Sunbrella Binding Color: '],
				[2,0, 'Narrow Cotton Binding Color: '],
				[4,0, 'Wide Binding Color: ']
			],
			'serging': [
				[0,0, 'Serging Color: ']
			],
			'fringe': [
				[0,0, 'Fringe: ']
			]
		}
		var indexesByType = {
			'binding': [
				{
					"alpine" : 'Alpine',
					"aquamarine" : 'Aquamarine',
					"aruba" : 'Aruba',
					"aspen" : 'Aspen',
					"basil" : 'Basil',
					"beige" : 'Beige',
					"black" : 'Black',
					"blackcherry" : 'Black Cherry',
					"burgundy" : 'Burgundy',
					"buttercup" : 'Buttercup',
					"cadetgrey" : 'Cadet Grey',
					"capri" : 'Capri',
					"captainnavy" : 'Captain Navy',
					"charcoalgrey" : 'Charcoal Grey',
					"charcoaltweed" : 'Charcoal Tweed',
					"cocoa" : 'Cocoa',
					"concord" : 'Concord',
					"dubonnettweed" : 'Dubonnet Tweed',
					"eringreen" : 'Erin Green',
					"fern" : 'Fern',
					"forestgreen" : 'Forest Green',
					"ginkgo" : 'Ginkgo',
					"gold" : 'Gold',
					"heatherbeige" : 'Heather Beige',
					"hemlocktweed" : 'Hemlock Tweed',
					"jockeyred" : 'Jockey Red',
					"linen" : 'Linen',
					"linentweed" : 'Linen Tweed',
					"logored" : 'Logo Red',
					"mahogany" : 'Mahogany',
					"marineblue" : 'Marine Blue',
					"mediterraneanblue" : 'Mediterranean Blue',
					"mediterraneantweed" : 'Mediterranean Tweed',
					"mocha" : 'Mocha',
					"natural" : 'Natural',
					"navy" : 'Navy',
					"navy" : 'Navy',
					"nutmeg" : 'Nutmeg',
					"oceanblue" : 'Ocean Blue',
					"orange" : 'Orange',
					"oyster" : 'Oyster',
					"pacificblue" : 'Pacific Blue',
					"parchment" : 'Parchment',
					"persiangreen" : 'Persian Green',
					"pumpkin" : 'Pumpkin',
					"royalblue" : 'Royal Blue',
					"royalblue" : 'Royal Blue',
					"rust" : 'Rust',
					"salmon" : 'Salmon',
					"sapphireblue" : 'Sapphire Blue',
					"seagrassgreen" : 'Sea Grass Green',
					"silver" : 'Silver',
					"skyblue" : 'Sky Blue',
					"slate" : 'Slate',
					"smoke" : 'Smoke',
					"spa" : 'Spa',
					"sprucegreen" : 'Spruce Green',
					"sunfloweryellow" : 'Sunflower Yellow',
					"tan" : 'Tan',
					"taupe" : 'Taupe',
					"terracotta" : 'Terracotta',
					"toast" : 'Toast',
					"truebrown" : 'True Brown',
					"turquoise" : 'Turquoise',
					"tuscan" : 'Tuscan',
					"walnutbrowntweed" : 'Walnut Brown Tweed',
					"wheat" : 'Wheat',
				},
				{
					'471' : '471',
					'100' : '100',
					'111' : '111',
					'121' : '121',
					'131' : '131',
					'141' : '141',
					'151' : '151',
					'161' : '161',
					'166' : '166',
					'171' : '171',
					'181' : '181',
					'191' : '191',
					'196' : '196',
					'204' : '204',
					'208' : '208',
					'211' : '211',
					'221' : '221',
					'223' : '223',
					'231' : '231',
					'241' : '241',
					'271' : '271',
					'277' : '277',
					'279' : '279',
					'281' : '281',
					'291' : '291',
					'293' : '293',
					'305' : '305',
					'307' : '307',
					'311' : '311',
					'316' : '316',
					'318' : '318',
					'319' : '319',
					'324' : '324',
					'325' : '325',
					'326' : '326',
					'330' : '330',
					'341' : '341',
					'351' : '351',
					'361' : '361',
					'371' : '371',
					'391' : '391',
					'411' : '411',
					'421' : '421',
					'431' : '431',
					'441' : '441',
					'461' : '461',
					'183b' : '183B',
					'c166' : 'C166',
					'c201' : 'C201',
					'c245' : 'C245',
					'c265' : 'C265',
					'c270' : 'C270',
					'c290' : 'C290',
					'c304' : 'C304',
					'c321' : 'C321',
					'c337' : 'C337',
					'c356' : 'C356',
					'c515' : 'C515',
					'c559' : 'C559',
					'c566' : 'C566',
					'c568' : 'C568',
					'c590' : 'C590',
					'c593' : 'C593',
					'c595' : 'C595',
					'c597' : 'C597',
					'c598' : 'C598',
					'c610' : 'C610',
					'c638' : 'C638',
					'c640' : 'C640',
					'c662' : 'C662',
					'c690' : 'C690',
					'c875' : 'C875',
					'c902' : 'C902',
					'c910' : 'C910',
					'c922' : 'C922',
					'c927' : 'C927',
					'c975' : 'C975',
					'c979' : 'C979',
					'c990' : 'C990',
					'nat' : 'NAT'
				}, 
				{
					'bark' : 'Bark',
					'beige' : 'Beige',
					'black' : 'Black',
					'cappuccino' : 'Cappuccino',
					'cardinal' : 'Cardinal',
					'cocoa' : 'Cocoa',
					'darktaupe' : 'Dark Taupe',
					'espresso' : 'Espresso',
					'evergreen' : 'Evergreen',
					'fossil' : 'Fossil',
					'maroon' : 'Maroon',
					'mossandgreygreen' : 'Moss and Grey-Green',
					'navy' : 'Navy',
					'oregano' : 'Oregano',
					'poppy' : 'Poppy',
					'sienna' : 'Sienna',
					'slate' : 'Slate',
					'stone' : 'Stone',
					'tan' : 'Tan',
					'toffee' : 'Toffee'
				}
			],
			'serging': [{
				'2' : '2',
				'8' : '8',
				'26' : '26',
				'57' : '57',
				'67' : '67',
				'72' : '72',
				'93' : '93',
				'121' : '121',
				'135' : '135',
				'200' : '200',
				'336' : '336',
				'382' : '382',
				'451' : '451',
				'469' : '469',
				'541' : '541',
				'569' : '569',
				'594' : '594',
				'632' : '632',
				'812' : '812',
				'901' : '901',
				'989' : '989',
				'1036' : '1036',
				'1048' : '1048',
				'1410' : '1410',
				'1732' : '1732',
				'1755' : '1755',
				'1802' : '1802',
				'2005' : '2005',
				'2082' : '2082',
				'2163' : '2163',
				'2486' : '2486',
				'3295' : '3295',
				'3925' : '3925',
				'4287' : '4287',
				'4817' : '4817',
				'5005' : '5005',
				'5495' : '5495',
				'6182' : '6182',
				'7061' : '7061',
				'8065' : '8065',
				'8925' : '8925',
				'8935' : '8935',
				'9412' : '9412',
				'10353' : '10353',
				'10639' : '10639',
				'10775' : '10775',
				'10797' : '10797',
				'10809' : '10809',
				'10814' : '10814',
				'10816' : '10816',
				'11286' : '11286',
				'11791' : '11791',
				'11989' : '11989',
				'13181' : '13181',
				'13195' : '13195',
				'13665' : '13665',
				'14321' : '14321',
				'15000' : '15000',
				'18605' : '18605',
				'19864' : '19864',
				'20117' : '20117',
				'20118' : '20118',
				'20135' : '20135',
				'20136' : '20136',
				'20137' : '20137',
				'20138' : '20138',
				'20142' : '20142',
				'20182' : '20182',
				'20519' : '20519',
				'20591' : '20591',
				'21039' : '21039',
				'22430' : '22430',
				'23339' : '23339',
				'23833' : '23833',
				'24000' : '24000',
				'29021' : '29021',
				'29022' : '29022',
				'29023' : '29023',
				'29024' : '29024',
				'29025' : '29025',
				'29102' : '29102',
				'29245' : '29245',
				'29265' : '29265',
				'29275' : '29275',
				'29302' : '29302',
				'29305' : '29305',
				'29314' : '29314',
				'29315' : '29315',
				'29316' : '29316',
				'29321' : '29321',
				'29328' : '29328',
				'29330' : '29330',
				'29336' : '29336',
				'29338' : '29338',
				'29345' : '29345',
				'29348' : '29348',
				'29559' : '29559',
				'29560' : '29560',
				'29585' : '29585',
				'29590' : '29590',
				'29636' : '29636',
				'29667' : '29667',
				'29668' : '29668',
				'29686' : '29686',
				'29695' : '29695',
				'29702' : '29702',
				'29750' : '29750',
				'29860' : '29860',
				'29899' : '29899',
				'29905' : '29905',
				'29911' : '29911',
				'29950' : '29950',
				'29955' : '29955',
				'29965' : '29965',
				'29977' : '29977',
				'29979' : '29979',
				'29980' : '29980',
				'29992' : '29992',
				'29997' : '29997',
				'30008' : '30008',
				'10639n' : '10639N',
				'b2' : 'B2',
				'black' : 'BLACK',
				'c14' : 'C14',
				'c2' : 'C2',
				'c21' : 'C21',
				'c3' : 'C3',
				'natural' : 'NATURAL',
				'white' : 'WHITE'
			}],
			'fringe': [{
					'ob6-natural' : 'Brush / OB6:Natural',
					'ob6-off-white' : 'Brush / OB6:Off-white',
					'ob6-beige' : 'Brush / OB6:Beige',
					'ob6-coffee' : 'Brush / OB6:Coffee',
					'ob6-karastan' : 'Brush / OB6:Karastan',
					'or5-natural' : 'Small-Knot / OR5:Natural',
					'or5-off-white' : 'Small-Knot / OR5:Off-white',
					'or5-beige' : 'Small-Knot / OR5:Beige',
					'or5-coffee' : 'Small-Knot / OR5:Coffee',
					'or5-karastan' : 'Small-Knot / OR5:Karastan',
					'or4-natural' : 'Large-Knot / OR4:Natural',
					'or4-off-white' : 'Large-Knot / OR4:Off-white',
					'or4-beige' : 'Large-Knot / OR4:Beige',
					'or4-coffee' : 'Large-Knot / OR4:Coffee',
					'or4-karastan' : 'Large-Knot / OR4:Karastan'
				}
			]
		}
		
		Object.keys(defByCat).forEach(function(defName) {
			if(defByCat[defName].indexOf(cat) !== -1) {
				def = defName;
			}
		})
		var mainDiv;
		if(def !== '') {
			mainDiv = m('div', {'className': 'uk-form-row ts-lineitem'});
			var selects = indexesByType[def].map(function(opt, i) {
				var options = Object.keys(opt).map(function(val) {
					return m('option', {
						'value': val
					}, opt[val])
				})
				//cef is special and needs an empty element
				options.splice(0,0, 
					m('option', {
						'value': '',
						'disabled': true
					})
				)
				return m('select', {
					'value': obj['option' + (i + 1)],
					'onchange': function(e) {
						obj['option' + (i + 1)] = this.value;
					}
				}, options)
			})
			spliceByType[def].forEach(function(arr, i) {
				var className = 'uk-text-bold';
				if(i !== 0) className += ' uk-margin-left';
				selects.splice(arr[0], arr[1], m('span', {'className': className}, arr[2]));
			})
			mainDiv['children'] = selects;
		} else {
			mainDiv = '';
		}
		return mainDiv;
	},

	emailTypes: function() {
		var types = {
			'ccworkorderdetails': 'CC Workorder Detail',
			'ccordercomplete': 'CC Workorder Completion',
			'ccremindersevendays': 'CC Workorder Completion Reminder 1',
			'ccreminderthirtydays': 'CC Workorder Completion Reminder 2',
			'onloserviceinfo': 'ONLO Workorder Confirmation',
			'onlocompletion': 'ONLO Workorder Completion',
			'onloappointmentconfirmation': 'ONLO Service Time Confirmation',
			'onloscheduleconfirmation': 'ONLO Workorder Details',
			'pddeliveryconfirmation': 'SPD Delivery Confirmation',
			'pdpickupconfirmation': 'SPD Pickup Confirmation',
			'pdscheduleconfirmation': 'SPD Schedule Confirmation',
			'pdworkorderdetails': 'SPD Workorder Detail',
			'paymentconfirmation': 'Payment Confirmation',
			'serviceproposal': 'Service Proposal',
			'pdserviceinfo': 'SPD Service Info',
			'outstandinginvoice': 'Outstanding Invoice', 
			'paymentconfirmation': 'Payment Confirmation'
		}
		return types;
	},
	
	extraEmailProps: function(type) {
		var propsByType = {
			//done
			'ccworkorderdetails': [
				'dueDate'
			],
			'ccordercomplete': [],
			'ccremindersevendays': [],
			'ccreminderthirtydays': [],
			//done
			'onloappointmentconfirmation': [
				'onloTechName',
				'timeStartService', 
				'timeEndService', 
				'serviceDate'
			],
			'onloserviceinfo': [
				'onloServiceType'
			],
			'onlocompletion': [],
			'onloscheduleconfirmation': [
				'dueDate', 
				'onloServiceType'
			],
			//done
			'pdpickupconfirmation': [
				'datePickup', 
				'timeStartPickup',
				'timeEndPickup'
			],
			//done
			'pddeliveryconfirmation': [
				'dateDelivery',
				'timeStartDelivery',
				'timeEndDelivery'
			],
			'pdscheduleconfirmation': [
				'serviceDate'
			],
			'pdworkorderdetails': [],
			'outstandinginvoice': [
				'invoiceBalance'
			],
			'paymentconfirmation': [],
			'pdserviceinfo': [],
			'serviceproposal': []
		};
		return propsByType[type]
	},
	
	propsReturn: function(arr) {
		var context = DAB.context();
		var header = context['currentModel']['workOrderHeader'];
		var definition = {
			'dueDate': dueDate,
			//onlo
			'timeStartService': timeStartService,
			'timeEndService': timeEndService,
			'onloTechName': onloTech,
			'serviceDate': dueDate,
			'onloServiceType': onloServiceType,
			//SPD
			'timeStartPickup': timeStartPickup,
			'timeEndPickup': timeEndPickup,
			'datePickup': datePickup,
			'timeStartDelivery': timeStartDelivery,
			'timeEndDelivery': timeEndDelivery,
			'dateDelivery': dateDelivery,
			//Payment Applied
			'invoiceBalance': invoiceBalance
		}
				
		return arr.map(function(token) {
			return [token, definition[token]()]
		});
		
		function onloTech() {
			var techRequested = header['techRequested']; 
			var techName = context['app']['findInArray'](QueryResponses['allUsers'], 'commId', techRequested)['name'];
			return techName
		}
		
		function datePickup() {
			return header['pickupDate'];
		}
		
		function dateDelivery() {
			return header['deliveryDate'];
		}
		
		function timeStartPickup() {
			var timeValue = header['pickupTimeStart'];
			return context['app']['timeDisplay'](timeValue);
		}
		
		function timeEndPickup() {
			var timeValue = header['pickupTimeEnd'];
			return context['app']['timeDisplay'](timeValue);
		}
		
		function timeStartDelivery() {
			var timeValue = header['deliveryTimeStart'];
			return context['app']['timeDisplay'](timeValue);
		}
		
		function timeEndDelivery() {
			var timeValue = header['deliveryTimeEnd'];
			return context['app']['timeDisplay'](timeValue);
		}
		
		function timeStartService(){
			var timeValue = header['servTimeStart'];
			return context['app']['timeDisplay'](timeValue);
		}

		function timeEndService(){
			var timeValue = header['servTimeEnd'];
			return context['app']['timeDisplay'](timeValue);
		}
		
		function invoiceBalance() {
			return header['due'].toFixed(2)
		}
		
		function dueDate() {
			var date = context['app']['rightNow']();
			context['currentModel']['currentJobs'].forEach(function(job) {
				var jobDate = job['header']['dateDue'];
				if(jobDate !== '') {
					if(context['app']['compareDates'](new Date(job['header']['dateDue']), new Date(date))) {
						date = job['header']['dateDue']
					}
				}
			})
			return date;
		}
		
		function onloServiceType() {
			var serviceTypes = [];
			var titles = {
				'carpetJob': 'Carpet Cleaning',
				'onloFurnJob': 'Upholstery Cleaning',
				'stoneJob': 'Stone & Tile Cleaning'
			}
			context['currentModel']['currentJobs'].forEach(function(job) {
				if(serviceTypes.indexOf(job['header']['type'] === -1)) {
					serviceTypes.push(job['header']['type']);
				}
			})
			var serviceTitle = '';
			var serviceLength = serviceTypes.length;
			for(var i = 0; i < serviceLength; i++) {
				serviceTitle += titles[serviceTypes[i]];
				if(serviceLength === 3 && i === 0) {
					serviceTitle += ', ';
				}
				if(i === serviceLength - 2) {
					serviceTitle += ' & ';
				}
			}
			return serviceTitle;
		}
	},
	
	//--------------------------------------------------------------------------------------------|
	//-------------------------------Color Config Stuff-------------------------------------------|
	//--------------------------------------------------------------------------------------------|
		
	colorPallete: [
		['#EEEEEE', '#000000', '#333333', '#776E65', '#8A8278', '#808080', '#A9A9A9', '#C0C0C0', '#FFFFFF'],
		['#800080', '#E6E6FA', '#C8C2C8', '#660066', '#4B0082', '#340034'],
		['#2C2CBA', '#99CCFF', '#00CCCC', '#75889F', '#191970', '#000033', '#001A00'], 
		['#008000', '#D2DB93', '#AAD5AA', '#33CC99', '#808000', '#009999', '#008080', '#333300'], 
		['#CC0000', '#FF3300', '#DC143C', '#B7410E', '#8B0000', '#800020', '#660033', '#400000'],
		['#FF8C00', '#FFD700', '#FFC634', '#FF7F50', '#F58D64', '#8B4513'],
		['#663300', '#E8DAC6', '#D2B48C', '#DAA520', '#BC9A8F', '#4D3626'],
		['#FFFF00', '#FFFFE8', '#FFFFCC', '#FFFFB3', '#F5F1DC'],
		['#FFC0CB', '#FFDAB9', '#E78888', '#C10073', '#751717']
	],
	
	colorCodes: function() {
		var context = DAB.context();
		var colorNames = Object.keys(context['conf']['colorNames']);
		var colorModel = context['conf']['colorNames']
		var colorCodes = colorNames.map(function(cName) {
			var colorCode = colorModel[cName];
			if(colorCode.length === 3) {
				var code = (colorCode[0] + colorCode[0] + colorCode[1] + colorCode[1] + colorCode[2] + colorCode[2])
				return '#' + code.toUpperCase();
			} else {
				return '#' + colorCode.toUpperCase();
			}
		})
		return colorCodes;
	},
	
	colorNames: {
		antiquewhite: "faebd7",
		aqua: "0cc",
		aquamarine: "7fffd4",
		azure: "f0ffff",
		beige: "f5f1dc",
		bisque: "ffe4c4",
		black: "000",
		blackcherry: "400000",
		blanchedalmond: "ffebcd",
		blue: "2c2cba",
		bluegray: "75889f",
		bluegreen: "099",
		blueviolet: "8a2be2",
		brick: "751717",
		brown: "630",
		burgundy: "800020",
		burlywood: "deb887",
		burntsienna: "ea7e5d",
		cadetblue: "5f9ea0",
		charcoalgray: "333",
		chartreuse: "7fff00",
		chocolate: "d2691e",
		coffee: "4d3626",
		coral: "ff7f50",
		cornflowerblue: "6495ed",
		cornsilk: "fff8dc",
		cream: "ffc",
		crimson: "dc143c",
		cyan: "0ff",
		darkblue: "00008b",
		darkcyan: "008b8b",
		darkgoldenrod: "b8860b",
		darkgray: "a9a9a9",
		darkgreen: "6400",
		darkgrey: "a9a9a9",
		darkkhaki: "bdb76b",
		darkmagenta: "8b008b",
		darkolive: "330",
		darkolivegreen: "556b2f",
		darkorange: "ff8c00",
		darkorchid: "9932cc",
		darkpurple: "340034",
		darkred: "8b0000",
		darksalmon: "e9967a",
		darkseagreen: "8fbc8f",
		darkslateblue: "483d8b",
		darkslategray: "2f4f4f",
		darkslategrey: "2f4f4f",
		darkturquoise: "00ced1",
		darkviolet: "9400d3",
		deeppink: "ff1493",
		deepskyblue: "00bfff",
		dimgray: "696969",
		dimgrey: "696969",
		dodgerblue: "1e90ff",
		eggplant: "606",
		firebrick: "b22222",
		floralwhite: "fffaf0",
		forest: "001b00 ",
		forestgreen: "228b22",
		fuschia: "c10073",
		gainsboro: "dcdcdc",
		ghostwhite: "f8f8ff",
		gold: "ffd700",
		goldenrod: "daa520",
		gray: "808080",
		graybrown: "776e65",
		green: "008000",
		greenyellow: "adff2f",
		grey: "808080",
		honeydew: "f0fff0",
		hotpink: "ff69b4",
		indianred: "cd5c5c",
		indigo: "4b0082",
		ivory: "fffff0",
		khaki: "f0e68c",
		lavender: "e6e6fa",
		lavenderblush: "fff0f5",
		lawngreen: "7cfc00",
		lemonchiffon: "fffacd",
		lightblue: "9cf",
		lightcoral: "f08080",
		lightcyan: "e0ffff",
		lightgoldenrodyellow: "fafad2",
		lightgray: "d3d3d3",
		lightgreen: "90ee90",
		lightgrey: "d3d3d3",
		lightpink: "ffb6c1",
		lightsalmon: "ffa07a",
		lightseagreen: "20b2aa",
		lightskyblue: "87cefa",
		lightslategray: "789",
		lightslategrey: "789",
		lightsteelblue: "b0c4de",
		lightyellow: "ffffe0",
		lilac: "c8c2c8",
		lime: "0f0",
		limegreen: "32cd32",
		linen: "faf0e6",
		magenta: "f0f",
		maroon: "800000",
		mediumaquamarine: "66cdaa",
		mediumblue: "0000cd",
		mediumorchid: "ba55d3",
		mediumpurple: "9370db",
		mediumseagreen: "3cb371",
		mediumslateblue: "7b68ee",
		mediumspringgreen: "00fa9a",
		mediumturquoise: "48d1cc",
		mediumvioletred: "c71585",
		midnight: "003",
		midnightblue: "191970",
		mint: "3c9",
		mintcream: "f5fffa",
		mistyrose: "ffe4e1",
		moccasin: "ffe4b5",
		natural: "ffffe8",
		navajowhite: "ffdead",
		navy: "191970",
		oldlace: "fdf5e6",
		olive: "808000",
		olivedrab: "6b8e23",
		orange: "ff8c00",
		orangered: "ff4500",
		orchid: "da70d6",
		palegoldenrod: "eee8aa",
		palegreen: "98fb98",
		paleturquoise: "afeeee",
		palevioletred: "db7093",
		paleyellow: "ffffb3",
		papayawhip: "ffefd5",
		none: 'eee', 
		peach: "ffdab9 ",
		peachpuff: "ffdab9",
		peru: "cd853f",
		pink: "ffc0cb",
		plum: "603",
		powderblue: "b0e0e6",
		purple: "800080",
		rebeccapurple: "639",
		red: "c00",
		redorange: "f30",
		rose: "e78888",
		'rose-brown': "bc9a8f",
		rosybrown: "bc8f8f",
		royalblue: "4169e1",
		rust: "b7410e",
		saddle: "8b4513",
		saddlebrown: "8b4513",
		sage: "aad5aa",
		salmon: "fa8072",
		sandybrown: "f4a460",
		seagrass: "d2db93",
		seagreen: "2e8b57",
		seashell: "fff5ee",
		sienna: "a0522d",
		silver: "c0c0c0",
		skyblue: "87ceeb",
		slateblue: "6a5acd",
		slategray: "a9a9a9",
		slategrey: "708090",
		snow: "fffafa",
		springgreen: "00ff7f",
		steelblue: "4682b4",
		tan: "d2b48c",
		taupe: "e8dac6",
		teal: "008080",
		terracotta: "f58d64",
		thistle: "d8bfd8",
		tomato: "ff6347",
		turquoise: "40e0d0",
		violet: "ee82ee",
		'warm-gray': "8a8278",
		wheat: "f5deb3",
		white: "fff",
		zaffre: '001a00',
		whitesmoke: "f5f5f5",
		yellow: "ff0",
		yellowgreen: "9acd32",
		yelloworange: "ffc634"
	}
}

DAB.init();