var DAB = {};

DAB['components'] = {
	permitExpired: function() {
		var context = DAB.context();
		var clientInfo = context['model']['currentClient']['ClientInfo']
		clientInfo['PermitExp'] = Utility.formatDate(clientInfo['PermitExp']); 
		return m('div', {'className': 'uk-form permitExpClass'}, [
			m('h2', 'Current Reseller Permit is Expired'),
			m('span', 'If reseller permit is not updated taxes will be charged to client'),
			context['components']['formRow']('Permit', 
				m('input', {
					'value': clientInfo['ResalePermit'],
					'onkeyup': changePermit,
					'onchange': changePermit
				})
			),
			context['components']['formRow']('Permit Expiration', 
				context['components']['datePicker']({
					'modelAttr': 'PermitExp',
					'dateOption': 'permitExpOw',
					'model': clientInfo		
				})
			),
			context['components']['formRow']('', 
				m('button',
					{'className': 'uk-button uk-button-success',
						'onclick': function(e) {
							var current = new Date(context['app']['rightNow']());
							if(new Date(clientInfo['PermitExp']).getTime() > current.getTime()) {
								context['app']['writeClientInfo'](context['model']['currentClient']);
							} else {
								context['app'].addNotification('Permit expiration must be a future date', 3000);
							}
						}
					}, 
				'Update Reseller Permit')
			)
		])
		
		function changePermit(e) {
			clientInfo['ResalePermit'] = Utility.formatDate(this.value);
		}
	},
	
	clientHeader: function(initObj) {
		/**
			@initObj.headerModel is the model containing the info for the visible header
			@initObj.clientModel is the currentClient model with the loaded client's info
			@initObj.stickyNotes is the notes array for the client, the client type notes are fed to the sticky notes component.				
		**/
		var cons = this;
		var context = DAB.context();
		var headerModel = initObj['headerModel'];
		var clientModel = initObj['clientModel'];
		if(typeof initObj['stickyNotes'] === 'undefined') initObj['stickyNotes'] = [];
		var clientHeadClass = 'clientHeader';
		// if(initObj['disabled'] === true) clientHeadClass += ' clickDisable';
		cons.view = function() {
			return m('div', {'className': clientHeadClass}, [
				m('div', {'className': 'uk-clearfix inlinefloatcontainer'},
					m('h1', {'className': 'inlinefloat uk-text-bold uk-text-primary'}, [
						m('i', {'className': 'uk-icon-user uk-margin-small-right'}),
						m('span', {}, headerModel['Client Name']),
						m('div', {'className': 'inlinefloat uk-badge'}, headerModel['CustomerType'])
					]),
					m('button', {'className': 'inlinefloat uk-button-primary uk-button',
						'onclick': function(e) {
							context['app']['appendRoute']('edit');
						}
					},'Edit Client')
				),
				m('div', {'className': 'uk-panel uk-width-1-1'}, [
					Object.keys(headerModel).map(function(data, i) {
						if(headerModel[data] !== '' && headerModel[data] !== null && data !== 'Client Name' && data !== 'CustomerType') {
							return m('div', {'className': 'ts-headerQuickInfo uk-float-left uk-margin-right'}, [
								m('h4', {'className': 'uk-comment-meta'}, data),
								m('div', {'className': 'uk-comment-title'}, headerModel[data])
							])
						}								
					}),
				]),
				m('div', {'className': 'uk-width-1-1'}, [
					initObj['stickyNotes'].map(function(note) {
						return context['components']['stickyNote'](note);
					})
				]),
				m('hr')
			])
		}
					
		return cons.view();
	},
	
	clientFile: function(initObj) {
		/**
			@initObj.model is the model for the current client
			@intiObj.fnOnSave is the function to run when edits are saved
		**/
		var cons = this;
		var context = DAB.context();
		var client = initObj['model']['ClientInfo'];
		client['CustType'].indexOf('2-') > -1 ? initObj['model']['Resale'] = true : initObj['model']['Resale'] = false;
		console.log(initObj['model']);
		var contactInit = context['conf']['panelInit'](initObj['model']);
		var addressInit = context['conf']['panelInit'](initObj['model']);
		var noteFormInit = context['conf']['noteForm']('Client', initObj['model']['notes']);
		var clientNotesInit = context['conf']['noteBucket'](initObj['model'], 'sticky', 'uk-icon-user', 'Client Notes(s)');
		var internalNotesInit = context['conf']['noteBucket'](initObj['model'], 'internal', 'uk-icon-flag', 'Client Notes(s) (Internal)');

		var addressArray = initObj['model']['Addresses'];
		var billDef = initObj['model']['ClientInfo']['BillToDef'];
		var shipDef = initObj['model']['ClientInfo']['ShipToDef'];

		cons.view = function() {
			return m('div', {'className': 'uk-width-5-6 uk-container-center', 'id': 'clientFile'},
				m('div', {'className': 'uk-form uk-form-horizontal'}, [
					m('div', {'class': 'uk-clearfix inlinefloatcontainer'},
						m('h1', {'class': 'inlinefloat uk-text-bold uk-text-primary'}, [
							m('i', {'class': 'uk-icon-user uk-margin-small-right'}),
							m('span', {}, client['Name']),
							m('div', {'className': 'inlinefloat uk-badge'}, client['CustomerType'])
						]),
						m('button', {'class': 'uk-margin-left uk-button uk-margin-bottom uk-button-small',
							'onclick': function(e) { 
								initObj['fnOnSave'](initObj['model'], 'client');
							}
						}, 'Finished')
					),
					m('div', {'className': 'uk-form-row'}, [
						m('label', {'className': 'uk-form-label'}, 'Client Type'),
						m('div', {'className': 'uk-form-controls'},
							context['components']['setSelect'](client, 'CustType', 'uk-form-width-medium', 
							context['components']['customerTypes']())
						)
					]),
					m('hr'),
					context['components']['resaleInfo'](initObj['model']),
					context['components']['formGroup']('Client Name', client, 'Name'),
					m('hr'),
					context['components']['formGroup']('Client Code', client, 'CustomCode', '', 'code'),
					context['components']['verifyMessage'](initObj['model'], 'VerifyCode', 'A customer with this code already exists. Please provide a unique code.'),
					m('hr'),
					m('div', {'className': 'uk-form-row'}, [
						m('h2', {}, 'Client Information'),
						context['components']['formGroupPhone']('Home Phone Number', client, 'Phone1', true),
						context['components']['formGroupPhone']('Cell Phone Number', client, 'Phone2', true),
						context['components']['formGroupPhone']('Business Phone Number', client, 'Cell', true),
						context['components']['verifyMessage'](initObj['model'], 'VerifyPhone', 'At least one phone number is required'),
						context['components']['formGroup']('Email', client, 'Email', 'example@example.com', 'uk-form-width-large'),
						m('div', {'className': 'uk-form-row'}, [
							m('label', {'className': 'uk-form-label'}, 'Email Preferences'),
							m('div', {'className': 'uk-form-controls'},
								context['components']['setSelect'](client, 'EmailPref', 'uk-form-width-medium', 
								context['components']['emailPrefs']())
							)
						])
					]),
					m('hr'),
					m('h2', {}, 'Contact Person(s)'),
					m('div', {'className': ''}, [
						m('div', {'className': 'panelFlex'},
							initObj['model']['Contacts'].map(function(contact) {
								return context['components']['contactPanel'](contactInit, contact)							
							})
						)
					]),
					context['components']['newContactComponent'](initObj['model']),
					m('hr'),
					m('h2', {}, 'Addresses'),
					m('hr'),
					m('div', {'className': 'uk-form-row'}, [
						m('label', {'className': 'uk-form-label'},
							'Billing Address', 
							m('i', {'className': 'uk-icon-calculator'})
						),
						m('div', {'className': 'uk-form-controls'},[
							m('div', {'className': 'panelFlex'},
								addressArray.map(function(address) {
									if(address['Type'] === 'B' && address['ID'] === billDef) return context['components']['addressPanel'](addressInit, address)
									if(billDef === '') return m('text', {'className': 'uk-text'}, 'No Billing address on file');
								})
							)
						])
					]),
					m('div', {'className': 'uk-form-row'}, [
						m('label', {'className': 'uk-form-label'},
							'Service Address(es)', 
							m('i', {'className': 'uk-icon-envelope'})
						),
						m('div', {'className': 'uk-form-controls'},[
							m('div', {'className': 'panelFlex'},
								addressArray.map(function(address) {
									if(address['Type'] === 'S') return context['components']['addressPanel'](addressInit, address)
									if(shipDef === '') return m('text', {'className': 'uk-text'}, 'No Service address on file');
								})
							)
						])
					]),
					m('hr'),
					context['components']['newAddressComponent'](initObj['model']),
					m('hr'),
					context['components']['noteBucket'](clientNotesInit),
					context['components']['noteBucket'](internalNotesInit),
					context['components']['noteForm'](noteFormInit),
					context['components']['formRow']('Attached Files',
						context['conf']['attachment']('file', initObj['model'])
					),
					m('button', {'className': 'uk-button uk-button-medium uk-button-primary',
						'onclick': function(e) {
							initObj['fnOnSave'](initObj['model'], 'client');
						}
					}, 'Finished'),
					disableClient()
				])
			)			
		};
		var loading = initObj['model']['loading'];
		if(loading === true) {
			return context['components']['loadingContainer'](cons.view())
		} else {
			return cons.view();			
		};
		
		function disableClient() {
			if(context['route'][0] !== 'summary') {
				return '';
			}
			return m('button', {'className': 'uk-button uk-button-medium uk-button-danger',
				'onclick': function(e) {
					context['model']['disableClient'](initObj['model']);
				}
			}, 'Disable Client')
		}
	},
	
	addressPanel: function(initObj, addressToUse) {
		/**
			@initObj.shown is an optional boolean to indicate if they address should be shown (for workorder page)
			@initObj.className is the classname for the address panel
			@initObj.selected is a boolean to indicate a selected address (has special class added)
			@initObj.fnOnClick is an optional function to be run when user clicks on address panel itself
			@initObj.hasControls is an optional boolean to indicate if panel edit/delete controls should show
			@initObj.model is the model for the current client
			@initObj.fnOnEdit is the function to be run when user clicks edit control
			@initObj.fnOnDelete is the function to be run when user clicks delete control
			@addressToUse is the address object for this address panel.
		**/
		var context = DAB.context();
		
		if(addressToUse['U_Active'] === 'N') return;
		if(initObj['hasOwnProperty']('shown') && initObj['shown'] === false) return '';
		var className = 'uk-panel';
		var id = addressToUse['ID'];
		if(initObj['hasOwnProperty']('className')) className = initObj['className'];
		if(initObj['hasOwnProperty']('selected') && initObj['selected'] === true) className += ' chosenLocation';
		var panel = m('div.addressPanel', {'className': className}, 
			m('div', {'className': 'uk-flex uk-flex-middle'}, [
				m('div', {'className': 'uk-flex-item-1 uk-flex-middel uk-panel-box uk-flex'}, [
					m('div', {'className': 'uk-width panelicon'},
						m('i', {'className': 'uk-icon-home'})
					),
					m('div', {'className': 'uk-flex-item-1 billInfo'}, [
						m('h3', {'className': 'uk-panel-title'}, addressToUse['ID']),
						m('div', {}, addressToUse['Street']),
						m('div', {}, addressToUse['Block']),
						m('div', {}, [
							m('span', {}, addressToUse['City']),
							m('span', {}, ', '),
							m('span', {}, addressToUse['State'] + ' '),
							m('span', {}, addressToUse['Zip']),
						])
					])
				]),
				panelControls()
			])
		)
			
		if(initObj['hasOwnProperty']('fnOnClick')) panel['attrs']['onclick'] = function(e) {
			e.stopPropagation();
			initObj['fnOnClick'](id, initObj['model'], initObj['attr']);
		}
		return panel;
		function panelControls() {
			if(initObj.hasOwnProperty('hasControls') && initObj['hasControls'] === false) return '';
			return 	m('div', {'className': 'uk-width panelcontrols'}, [
				m('a', {
					'onclick': function(e) {
						initObj['model']['Address'] = addressToUse;
						initObj['fnOnEdit'](initObj['model'], 'EditAddress');
					}
				}, 
					m('i', {'className': 'uk-icon-pencil', 'title': 'Edit Address'})
				),
				m('a', {
					'onclick': function(e) {
						e.stopPropagation();
						initObj['fnOnDelete'](addressToUse, initObj['model'], 'Address');
					}
				}, 
					m('i', {'className': 'uk-icon-minus', 'title': 'Delete Address'})
				)
			])	
		}
	},
	
	contactPanel: function(initObj, contact) {
		/**
			@initObj.shown is an optional boolean to indicate if the contact panel should be shown (for workorder page)
			@initObj.className is the classname for the panel
			@initObj.selected is a boolean to indicate a selected contact (has special class added)
			@initObj.fnOnClick is an optional function to be run when user clicks on contact panel itself
			@initObj.hasControls is an optional boolean to indicate if panel edit/delete controls should show
			@initObj.model is the model for the current client
			@initObj.fnOnEdit is the function to be run when user clicks edit control
			@initObj.fnOnDelete is the function to be run when user clicks delete control
			@contact is the contact object for this panel.
		**/
		var context = DAB.context();
		if(contact['Active'] === 'N') return;
		var id = contact['ID'];
		if(initObj['hasOwnProperty']('shown') && initObj['shown'] === false) return '';
		var className = 'uk-panel'
		if(initObj['hasOwnProperty']('className')) className = initObj['className'];
		if(initObj['hasOwnProperty']('selected') && initObj['selected'] === true) className += ' chosenLocation';
		var primaryIcon = '';
		contact['U_IsPrimary'] === 'Y' ? primaryIcon = 'uk-icon-star' : primaryIcon = 'uk-icon-star-o';
		var panel = m('div', {'className': className}, 
			m('div', {'className': 'uk-flex uk-flex-middle'}, [
				m('div', {'className': 'uk-flex-item-1 uk-flex-middle uk-panel-box uk-flex'}, 
					m('div', {'className': 'uk-flex-item-1'}, [
						m('h3', {'className': 'uk-panel-title'}, [
							m('i', {'className': 'uk-icon-circle'}),
							contact['ID']
						]),
						setSpan(contact, 'Position', 'uk-icon-user', 'ID: ', false),
						setSpan(contact, 'Phone', 'uk-icon-phone', 'Home: ', true),
						setSpan(contact, 'Cell', 'uk-icon-phone', 'Cell: ', true),
						setSpan(contact, 'Phone2', 'uk-icon-phone', 'Business: ', true),
						setSpan(contact, 'Email', 'uk-icon-envelope-square', 'Email: ', false),
						setSpan(contact, 'Fax', 'uk-icon-fax', 'Fax: ', false),
					])
				),
				panelControls()		
			])
		)
		if(initObj['hasOwnProperty']('fnOnClick')) panel['attrs']['onclick'] = function(e) {
			e.stopPropagation();
			initObj['fnOnClick'](id);
		}
		return panel
		
		function panelControls() {
			if(initObj.hasOwnProperty('hasControls') && initObj['hasControls'] === false) return '';
			return m('div', {'className': 'uk-width panelcontrols'}, [
				m('a', {
					'onclick': function(e) {
						initObj['model']['Contact'] = contact;
						context['app']['setPrimaryContact']();
					}
				},
					m('i', {'className': primaryIcon, 'title': 'Set As Primary Contact'})
				),
				m('a', {
					'onclick': function(e) {
						initObj['model']['Contact'] = contact;
						initObj['fnOnEdit'](initObj['model'], 'EditContact');
					}
				}, 
					m('i', {'className': 'uk-icon-pencil', 'title': 'Edit Contact'})
				),
				m('a', {
					'onclick': function(e) {
						e.stopPropagation();
						initObj['fnOnDelete'](contact, initObj['model'], 'Contact');
					}
				}, 
					m('i', {'className': 'uk-icon-minus', 'title': 'Delete Contact'})
				)
			])				
		}

		function setSpan(model, attr, icon, label, phone) {
			if(model[attr] !== null && model[attr] !== '') {
				if(phone && model['U_' + attr + 'Ext'] !== null && model['U_' + attr + 'Ext'] !== '') {
					return m('div', {'className': 'panelLine'}, [
						m('i', {'className': icon}),
						m('span', {}, label + model[attr]),
						m('span', {}, ' ext. ' + model['U_' + attr + 'Ext'])
					])	 
				} else {
					return m('div', {'className': 'panelLine'}, [
						m('i', {'className': icon}),
						m('span', {}, label + model[attr])
					])				
				}
				
			}
		}

	},
	
	newAddressComponent: function(model) {
		/** @model is the model for the current client **/
		var context = DAB.context();
		var newAddress = false;
		if(model['AddAddress']) newAddress = true;
		
		if(model['AddAddress'] || model['EditAddress']) {
			return	m('div', {'className': 'uk-form-row uk-panel uk-panel-box'}, [
				context['components']['formGroupAddress']('Add or Edit Address', model['Address'], newAddress, 'currentBP'),
				m('button', {
					'className': "uk-button-success uk-button uk-margin-top",
					'onclick': function(e) {
						context['app']['verifyClientInfo'](model, 'Address');
					}
				}, 'Save'),
				m('button', {
					'className': 'uk-button uk-margin-top',
					'onclick': function(e) {
						if(model.hasOwnProperty('fnOnCancel')) return model['fnOnCancel'](model['attr']);
						model['Address'] = context['model']['addressModel']();
						if(model['AddAddress']) context['app']['toggleAttribute'](model, 'AddAddress');
						if(model['EditAddress']) context['app']['toggleAttribute'](model, 'EditAddress');
					}
				}, 'Cancel')			
			])
		} else {
			return m('button', {'className': 'uk-button uk-button-medium uk-button-success',
				'onclick': function(e) {
					context['app']['toggleAttribute'](model, 'AddAddress')
				}
			}, 'New Address')
		}
		
	},
	
	newContactComponent: function(model) {
		/** @model is the model for the current client **/
		var context = DAB.context();
		var newContact = false;
		if(model['AddContact']) {
			newContact = true;
		}
		
		if(model['AddContact'] || model['EditContact']) {
			return m('div', {'className': 'contactForm uk-form-horizontal uk-panel uk-panel-box'}, [
				m('div.uk-margin-bottom', [ 
					context['components']['formGroup']('Contact ID', model['Contact'], 'Position', '', 'uk-form-width-medium'),
					m('div', {'className': 'uk-form-row'}, [
						m('label', {'className': 'uk-form-label'}, 'Contact Name'),
						m('div', {'className': 'uk-form-controls'}, [
							m('div', {'className': 'uk-form-icon'}, [
								m('i', {'className': 'uk-icon-user'}),
								context['components']['setInput']({
									'model': model['Contact'],
									'attribute': 'First',
									'placeHolder': 'First Name',
									'className': 'uk-form-width-medium',
									requiredBool: context['model']['requiresVerification'][attr] 
								})
							]),
							context['components']['setInput']({
								'model': model['Contact'],
								'attribute': 'Last',
								'placeHolder': 'Last Name Name',
								'className': 'uk-form-width-medium',
								requiredBool: context['model']['requiresVerification'][attr] 
							})
						]),
					]),
					context['components']['formGroupPhone']('Home Phone Number', model['Contact'], 'Phone'),
					context['components']['formGroupPhone']('Cell Phone Number', model['Contact'], 'Cell'),
					context['components']['formGroupPhone']('Business Phone Number', model['Contact'], 'Phone2'),
					context['components']['formGroup']('Fax Number', model['Contact'], 'Fax', '', 'uk-form-width-medium', 'uk-icon-fax'),
					context['components']['formGroup']('Email Address', model['Contact'], 'Email', '', 'uk-form-width-medium', 'uk-icon-envelope'),
				]),
				saveContactButton(),
				m('button', 
				{'className': 'uk-button uk-button-medium',
					'onclick': function(e) {
						model['Contact'] = context['model']['contactModel']();
						newContact ? context['app']['toggleAttribute'](model, 'AddContact') : context['app']['toggleAttribute'](model, 'EditContact')
					}
				}, 'Cancel')
			])
		} else {
			var button = m('button', 
			{'className': 'uk-button uk-button-medium uk-button-success',
				'onclick': function(e) {
					context['app']['toggleAttribute'](model, 'AddContact');
				}
			}, 'Add Contact Person')
			return button;
		}
		
		function saveContactButton() {
			//only need this if they are editing the client file, otherwise new contact writes when new client form is saved.
			if(model.hasOwnProperty('ClientInfo')) {
				return m('button', {
					'className': 'uk-button uk-button-success', 
					'onclick': function(e) {
						if(model['Contact']['ID'] === '') {
							model['Contact']['ID'] = model['Contact']['First'] + ' ' + model['Contact']['Last'];
						}
						context['app']['verifyClientInfo'](model, 'Contact');
					}}, 
				'Save')
			}			
		}
	},
	
	setInput: function(config) {
		var context = DAB.context();
		var inputConfig = setInputConfiguration(config);
		var model = inputConfig.model;
		requiresVerificationState(inputConfig.requiredBool)
		var value = model[inputConfig.attribute];
		var input = m('input', {
			'className': inputConfig.className,
			'value': value,
			'onkeyup': function(e) {
				setAttribute(this.value)
				if(e.keyCode === 13) {
					onSubmit();
				}
			},
			'onchange': function(e) {
				setAttribute(this.value)
			},
			'onblur': function(e) {
				context['app']['formatField'](model, inputConfig.attribute, className, this.value);
			},
			'placeholder': inputConfig.placeHolder,
			'maxlength': inputConfig.maxlength,
			'disabled': inputConfig.disabled
		});

		return input;
		
		function requiresVerificationState(required) {
			if(required === true) {
				inputConfig.className += ' uk-form-danger';
				inputConfig.placeHolder += ' - Required';
			}

		}
		
		function setAttribute(value) {
			model[inputConfig.attribute] = value;
		}
		
		function setInputConfiguration(config) {
			var inputConfig = {};
			var attributes = [
				'model', 
				'attribute', 
				'placeHolder',
				'className', 
				'maxLength', 
				'disabled',
				'onSubmit',
				'requiredBool'
			];
			attributes.forEach(function(attr) {
				if(config.hasOwnProperty(attr)) {
					inputConfig[attr] = config[attr];
				} else {
					inputConfig[attr] = null;
				}
			});
			return inputConfig
		}
	},
	
	
	setSelect: function(model, attribute, className, options, disabled) {
		var context = DAB.context();
		if(context['model']['requiresVerification'][attribute] === true) {
			className += ' uk-form-danger';
		}
		var dropdown = m('select', {
			'className': className,
			'value': model[attribute] || '',
			'onchange': function(e) {
				model[attribute] = this.value;
				if(attribute === 'CustType') {
					this.value.indexOf('2-') > -1 ? context['app']['setResale'](model, true) : context['app']['setResale'](model, false);					
				}
			},
			'disabled': disabled
		}, options);
		return dropdown;
	},
	
	formGroup: function(label, model, attr, placeHolder, className, iconClass) {
		var context = DAB.context();
		if(typeof placeHolder === 'undefined') {
			placeHolder = '';
		}
		if(typeof className === 'undefined') {
			className = '';
		}
		var inputConfig = {
			model: model,
			attribute: attr,
			placeHolder: placeHolder,
			className: className,
			requiredBool: context['model']['requiresVerification'][attr] 
		}
		if(iconClass === undefined || iconClass === '') {
			return m('div', {'className': 'uk-form-row'}, [
				m('label', {'className': 'uk-form-label'}, label),
				m('div', {'className': 'uk-form-controls'}, 
					context['components']['setInput'](inputConfig)
				)
			])										
		} else {
			return m('div', {'className': 'uk-form-row'}, [
				m('label', {'className': 'uk-form-label'}, label),
				m('div', {'className': 'uk-form-controls'},
					m('div', {'className': 'uk-form-icon'}, [
						m('i', {'className': iconClass}),
							context['components']['setInput'](inputConfig)
					])
				)
			])	
		}
		
	},
		
	formGroupPhone: function(label, model, attr, useIcons) {
		//a formgroup type with a label and two inputs, one for the main number and one for extension. Also the option to display preference/textable icons
		var context = DAB.context();
		var extAttr = 'U_' + attr + 'Ext';
		return m('div', {'className': 'uk-form-row'},
			m('div', [
				m('label', {'className': 'uk-form-label'}, label),
				m('div.uk-form-controls', [
					m('div', {'className': 'uk-form-icon'}, [
						m('i', {'className': 'uk-icon-phone'}),
						context['components']['setInput']({
							model: model,
							attribute: attr,
							placeHolder: '(xxx)-xxx-xxxx',
							className: 'uk-form-width-medium uk-margin-right phone numbersOnly',
							maxLength: 14,
							requiredBool: context['model']['requiresVerification'][attr] 
						})
					]),
					context['components']['setInput']({
						model:model, 
						attribute: extAttr, 
						placeHolder: 'ext.', 
						className: 'uk-form-width-small numbersOnly',
						maxLength: 6,
						requiredBool: context['model']['requiresVerification'][attr] 
					}),
					displayIcons(model, attr, useIcons)
				]),
			])				
		)
		
		function displayIcons(model, attr, useIcons) {
			if(useIcons) {
				var textPrefClass;
				var primaryClass;
				(model[attr + 'Textable'] === 'Y') ? textPrefClass = 'uk-icon-paper-plane' : textPrefClass = 'uk-icon-paper-plane-o';
				(model[attr] !== '' && model['PrefNum'] === attr) ? primaryClass = 'uk-icon-star' : primaryClass = 'uk-icon-star-o';
				return m('span', {'className': 'primaryText'}, [
                    m('a', {
                        'onclick': function(e) {
				            context['app']['setPhoneIcons']('text', model, attr);
					    }
                    }, 
                        m('i', {'className': textPrefClass, 'title': 'Text Preferred'})
                    ),
                    m('a', {
                        'onclick': function(e) {
				            context['app']['setPhoneIcons']('primary', model, attr);
					    }
                    },
                        m('i', {'className': primaryClass, 'title': 'Preferred Number'})
                    )
				])
			}
		}
	},
		
	formGroupAddress:  function(label, model, newAddress, formOrigin) {
		var context = DAB.context();
		var typeDisabled = false;
		var nameDisabled = false;
		if(!newAddress && model['ID'] !== '') {
			nameDisabled = true;
		}
		if(model['Type'] !== '') {
			typeDisabled = true;
		}
		var baseRequired = context['model']['requiresVerification']
		if(formOrigin === 'newBP' && model['Type'] === 'B') {
			if(!context['model']['requiresVerification'].hasOwnProperty('BillAddress')) {
				context['model']['requiresVerification']['BillAddress'] = {};
			}
			baseRequired = context['model']['requiresVerification']['BillAddress'];
		};
		console.log(baseRequired)
		return m('div', {'className': 'uk-form-row'}, [
			m('label', {'className': 'uk-form-label'}, label),
			m('div', {'className': 'uk-form-controls'}, [
				typeSelection(),
				m('div', {'className': 'uk-form-row'},
					context['components']['setInput']({
						model: model, 
						attribute: 'ID', 
						placeHolder: 'Address Name', 
						className: 'uk-form-width-large addressID', 
						maxLength: '', 
						disabled: nameDisabled,
						requiredBool: baseRequired['ID'] 
					})
				),
				verifyID(),
				m('div', {'className': 'uk-form-row'},
					context['components']['setInput']({
						model:model,
						attribute: 'Street', 
						placeHolder: 'Address Line One',
						className: 'uk-form-width-large',
						requiredBool: baseRequired['Street'] 
					})
				),
				m('div', {'className': 'uk-form-row'},
					context['components']['setInput']({
						model: model, 
						attribute: 'Block',
						placeHolder: 'Address Line Two',
						className: 'uk-form-width-large',
						requiredBool: baseRequired['Block'] 
					})
				),
				m('div', {'className': 'uk-form-row'}, [
					context['components']['setInput']({
						model: model,
						attribute: 'City', 
						placeHolder: 'City',
						className: 'uk-form-width-medium uk-margin-right',
						requiredBool: baseRequired['City'] 
					}),
					context['components']['setSelect'](model, 'State', 'uk-margin-right', context['components']['USStates']()),
					m('input', {'className': 'uk-form-width-small numbersOnly',
						'placeholder': 'Zipcode',
						'maxlength': 5,
						'value': model['Zip'],
						'onkeyup': function(e) {
							checkZip(this.value);
						},
						'onchange': function(e) {
							checkZip(this.value);
						}
					}),								
				]),
				m('text', {'className': 'uk-text uk-text-small uk-text-primary'}, 'Entering a zip code in the greater Seattle area will determine city automatically')
			])
		])
		
		function typeSelection() {
			if(model['hasOwnProperty']('noType') && model['noType'] === true) return '';
			return 	m('div', {'className': 'uk-form-row'}, 
				context['components']['setSelect'](model, 'Type', 'uk-form-width-medium', context['components']['addressTypes'](), typeDisabled)
			)
		}
		
		function verifyID() {
			if(typeof context['model']['currentClient'] !== 'undefined') {
				return context['components']['verifyMessage'](context['model']['currentClient'], 'VerifyID', 'Address name must be unique')
			}
		}
		
		function checkZip(value) {
			model['Zip'] = value;
			if(value.length === 5) {
				context['app']['findCityByZip'](value, model);
			}
			DAB['app']['formatField'](model, 'Zip', 'numbersOnly', value);
		} 
	},
    
	selectionAndExtra: function(initObj, modelAttr, type) {
		var context = DAB.context();
		var options = [];
		QueryResponses['allUsers'].forEach(function(user) {
			if(user[type] === 'Y' && user['active'] === 'Y') {
				options.push([user['commId'], user['name']]);
			}
		});
		if(Array.isArray(initObj['model'][modelAttr])) {
			select = initObj['model'][modelAttr].map(function(select, i) {
				var selections = [context['components']['selection']({
					'selections': options,
					'modelAttr': i,
					'attrName': modelAttr,
					'model': initObj['model'][modelAttr]
				})]
				if(initObj.hasOwnProperty('hasDelete') && initObj['hasDelete'] === true) {
					selections.push(
						m('button', {
							'className': 'uk-button uk-button-danger',
							'onclick': function(e) {
								e.stopPropagation();
								initObj['model'][modelAttr].splice(i, 1);
								context['app']['reDraw']();
							}
						}, 'Remove')
					);
				}
				return selections;  
			});
			select.push(m('button', {
				'className': 'uk-button aosaddfix',
				'onclick': function(e) {
					if(isEmpty()) return context['app']['addNotification']('Cannot add new selection if previous selection is empty', 3500);
					initObj['model'][modelAttr].push('');
					context['app']['reDraw']();
				}
			}, 'Add'));
		} else {
			var select = context['components']['selection']({
				'selections': options,
				'modelAttr': modelAttr,
				'attrName': modelAttr,
				'model': initObj['model']
			});			
		}
		
		function isEmpty() {
			return (initObj['model'][modelAttr].indexOf('') !== -1)
		}
		return select;
	},
	
	confirmModal: function() {
		var context = DAB.context();
		return m('div', {}, [
			m('div', {'className': 'uk-form-row'}, 
					m('text', {'className': 'uk-text'}, context['model']['confirmMessage'])
			),
			m('div', {'className': 'uk-form-row'},
					m('button', {'className': 'uk-button uk-button-primary',
							'onclick': context['model']['confirm']
					}, 'Confirm'),
					m('button', {'className': 'uk-button',
							'onclick': context['model']['cancel']													       
					}, 'Cancel')
			)
		])
	},
	
	verifyMessage: function(model, attr, text) {
		if(model[attr]) return m('text', {'className': 'uk-text-small uk-text-danger'}, text);
	},	
	
	resaleInfo: function(model) {
		var context = DAB.context();
		var clientModel = model;
		if(model.hasOwnProperty('ClientInfo')) {
			clientModel = model['ClientInfo'];
		}
		if(clientModel['PermitExp'] !== '') {
			clientModel['PermitExp'] = Utility.formatDate(clientModel['PermitExp']);
		}
		
		var dateObj = {
			'dateOption': 'permitDate',
			'model': clientModel,
			'modelAttr': 'PermitExp'
		}

		if(model['Resale'])  {
			return m('div', {}, [
				context['components']['formGroup']('Resale Permit Number', clientModel, 'ResalePermit', '', 'uk-form-width-medium'),
				m('div', {'className': 'uk-form-row'}, [
					m('label', {'className': 'uk-form-label'}, 'Permit Expiration Date'),
					m('div', {'className': 'uk-form-controls'}, 
						context['components']['datePicker'](dateObj)
					)
				]),				
				m('hr')
			])
		}
	},
	
	filterElement: function(initObj) {
		/**
			@initObj.model
			@initObj.modelAttr
			@initObj.content
			@initObj.title
		**/
		var context = DAB.context();
		var options = ['All', 'Selected', 'Unselected'];
		var bool = ['', true, false];
		var conditionState = initObj['model'][initObj['modelAttr']];
		var titleContent = m('ul', {'className': 'uk-subnav uk-subnav-line uk-float-right'},[
			options.map(function(opt, i) {
				var className = 'ts-filter';
				if(conditionState === bool[i]) className += ' uk-active'
				return m('li', {
						'className': className,
						'onclick': function(e) {
							initObj['model'][initObj['modelAttr']] = bool[i];
							context['app']['reDraw']();
						}
					},
					m('a',opt)
				);
			})
		])
		initObj['titleContent'] = titleContent;
		var filterContainer = context['components']['rowElementLegend'](initObj);
		return filterContainer
	},
	
	rowElementLegend: function(initObj) {
		/**
			@initObj.content
			@initObj.title
			@initObj.titleContent
		**/
		var container = m('div', {'className': 'uk-form-row uk-margin-bottom'}, [
			m('div', {'className': 'uk-form-horizontal'},
				m('legend', {'className':'uk-clearfix'}, [
					initObj['title'],
					titleContent()
				])
			),
			initObj['content']
		])
		
		function titleContent() {
			if(!initObj.hasOwnProperty('titleContent')) return '';
			return initObj['titleContent'];
		}
		return container;
	},
	
	formRow: function(title, content, additionalClass) {
		if(content === '') return '';
		var className = 'uk-form-row';
		if(additionalClass) className += additionalClass;
		return m('div', {'class': className}, [
			m('label', {'class': 'uk-form-label'}, title),
			m('div', {'class': 'uk-form-controls'},
				content
			)
		])
	},
	
	selection: function(initObj) {
		/**
			@initObj.selections is an array that may include index of string or array,
			if array the first index is the value to be returned, second index is the display name
			@initObj.model is the baseModel to be changed
			@initObj.modelAttr is the attribute name for the selection object;
			@initObj.parentClass is the parent class of the selection
		**/
		var context = DAB.context();
		var fnOnChange = context['app']['selectionChange'];
		var parentClass = '';
		if(initObj.hasOwnProperty('parentClass')) parentClass = initObj['parentClass'];
		var options = initObj.selections.map(function(sel) {
			if(Array.isArray(sel)) {
				return m('option', {'value': sel[0]}, sel[1]);
			} else {
				return m('option', sel);
			}
		})
		var emptyOpt = [m('option', {'disabled': true},'')];
		options = emptyOpt.concat(options);
		var dropDown = m('select', {
			'value': initObj['model'][initObj['modelAttr']],
			'onchange': function(e) {
				fnOnChange(initObj['model'], initObj['modelAttr'], initObj['attrName'], this.value);
			},
			'className': parentClass
		}, options)
		return dropDown;
	},
	
	iconButton: function(fnOnClick, title, buttonClass, icon) {
		return m('button', {
			'className': buttonClass, 
			'onclick': function(e) {
				e.stopPropagation();
				fnOnClick();
			}
		}, [
			m('i', {'className': 'uk-icon-' + icon})
		], title)
	},
	
	iconButtonMod: function(initObj) {
		/**
			@initObj.id
			@initObj.model
			@initObj.fnOnClick
			@initObj.buttonClass
			@initObj.display
			@initObj.icon
			@initObj.modelAttr
		**/
		var buttonClass = '';
		if(initObj.hasOwnProperty('buttonClass')) buttonClass = initObj['buttonClass'];
		return m('button', {
			'className': buttonClass, 
			'onclick': function(e) {
				e.stopPropagation();
				initObj['fnOnClick'](initObj['id'], initObj['display'], initObj['model'], initObj['modelAttr']);
			}
		}, [
			m('i', {'className': 'uk-icon-' + initObj['icon']})
		], initObj['display'])
	},
	
	notify: function(messages) {
		var context = DAB.context();
		return m('div', {'className': 'uk-notify uk-notify-top-center'},
			messages.map(function(msg, index) {
				return m('div', 
					{'className': 'uk-notify-message uk-notify-message-danger',
					'style':'opacity: 1; margin-top: 0px; margin-bottom: 10px;'
				}, [
					m('a', {
						'className': 'uk-close',
						'onclick': function(e) {
							e.stopPropagation();
							context['model']['notifications'].splice(index, 1);
							context['app']['reDraw']();
						}
					}),
					m('div', msg)
				])
			})
		)
	},
	
	miniPanel: function(title, element) {
		return m('div', {'className': 'ts-miniPanel miniPanelAlt1'}, [
			m('span', {'className': 'uk-text-bold'}, title),
			element
		])
	},
	
	lightbox: function() {
		var context = DAB.context();
		var images = context['model']['images'];
		var currentSelected = context['model']['imageSelected']; 
		var activeImg = context['model']['activeImages'];
		var image = images[activeImg[currentSelected]];
		var imageS = 'data:image/;base64,' + image['Data']; 
		var previousDisabled = false;
		var nextDisabled = false;
		var previous = m('div', {
			'className': 'uk-icon-large uk-icon-arrow-circle-left',
			'onclick': function(e) {
				e.stopPropagation();
				context['model']['imageSelected'] += -1;
				context['app']['reDraw']()
			},
			'disabled': previousDisabled
		})
		var next = m('div', {
			'className': 'uk-icon-large uk-icon-arrow-circle-right',
			'onclick': function(e) {
				e.stopPropagation();
				context['model']['imageSelected'] += 1;
				context['app']['reDraw']();
			},
			'disabled': nextDisabled
		})
		var buttonContainer = [];
		if(currentSelected !== activeImg[0]) buttonContainer.push(previous);
		if(currentSelected !== activeImg[activeImg.length -1]) buttonContainer.push(next);
		return m('div', [m('img', {'src': imageS}),
			m('div', buttonContainer)
		])
	},
	
	addressesSelect: function(initObj) {
		/**
			@initObj.model is the array address(es) of the current contact
			@initObj.fnOnClick 
			@initObj.fnOnEdit is the function that runs when address property is edited.
		**/
		
		var cons = this;
		var context = DAB.context();
		var model = initObj['model'];
		var docHeader = context['model']['currentModel']['workOrderHeader'];
		var addressesObj = {
			'billing': {
				'btnClass': 'uk-button uk-button-success uk-margin-bottom',
				'searchButton': 'uk-button uk-button-success uk-margin-bottom',
				'keyName': 'addressBillingKey',
				'title': 'Billing Address'
			},
			'from': {
				'btnClass': 'uk-button uk-button-success uk-margin-bottom',
				'searchButton': 'uk-button uk-button-success uk-margin-bottom',
				'keyName': 'addressFromKey',
				'title': 'Pickup Address'
			},
			'to': {
				'btnClass': 'uk-button uk-button-success uk-margin-top',
				'searchButton': 'uk-button uk-button-success uk-margin-top',
				'keyName': 'addressToKey',
				'title': 'Delivery Address'
			}
		}
		
		var parentClass = 'uk-grid';
		if(initObj['disabled'] === true) parentClass += ' clickDisable';
		cons.view = function() {
			return m('div', {'class': parentClass}, 
				Object.keys(addressesObj).map(function(addrType) {
					if(docHeader['orderType'] !== 'SPD' && ['to', 'from'].indexOf(addrType) !== -1) return; 
					var keyName = addressesObj[addrType]['keyName'];
					if(docHeader[keyName] === '') addressesObj[addrType]['btnClass'] += ' uk-hidden';
					return addressContainer(addressesObj[addrType]);
				})
			)
		}
		
		function addressContainer(addressObj) {
			var addressParent = 'uk-width-1-1';
			if(initObj['disabled'] === true) addressParent += ' clickDisable';
			var searchClass = addressObj['searchButton'].replace('uk-button-success', 'uk-button-danger')
			return m('div', {'class': addressParent}, [
				m('h2', { 'class':"uk-margin-bottom-remove"}, addressObj['title']),
				m('div', { 'class':"uk-flex uk-flex-middle uk-flex-wrap"}, [
					model.map(function(obj, index) {
						return buildPanel(obj, index, addressObj['keyName'], obj['isEditing']);
					})
				]),
				context['components']['iconButton'](addAddress, 'Add Address', searchClass, 'plus'),
				context['components']['iconButton'](searchAddressModal, 'Search Addresses', addressObj['searchButton'], 'search'),
				context['components']['iconButton'](deselectAddress, 'Use Different Address', addressObj['btnClass'], 'map-marker')
			]);
			
			function deselectAddress() {
				initObj['fnOnClick']({'Code': ''}, addressObj['keyName']);
			}
			
			function searchAddressModal() {
				context['model']['modalAttrOption'] = addressObj['keyName'];
				context['app']['openSearchModal']('address');
			}
			
			function addAddress() {
				context['model']['modalAttrOption'] = addressObj['keyName'];
				context['app']['addressCreation']();
			}
		}
		
		function buildPanel(obj, index, keyName, editing) {		
			var addressClass = 'uk-panel rugAddress';
			if(obj['Code'] === docHeader[keyName]) {
				addressClass += ' chosenLocation';
			} else if(docHeader[keyName] !== '') {
				addressClass += ' uk-hidden';
			}				
			return m('div', {'className': addressClass,
				'onclick': function(e) {
					initObj['fnOnClick'](obj, keyName);
				}
			}, [
				m('div', { 'className':"uk-flex uk-flex-middle uk-flex-wrap"}, [
					m('div', { 'className':"uk-flex-middle uk-panel-box uk-flex"}, [
						m('div', { 'className':"panelicon"},
							m('i', { 'className':"uk-icon-home uk-icon-large"})
						),
						m('div', { 'className':"uk-flex-item-1"}, [
							m('div', { 'className':"uk-text-bold"}, obj['AddressName']),
							m('div', obj['Address']),
							m('div', obj['AddressLine2']),
							m('div', [
								m('span', obj['City']),
								', ',
								m('span', obj['State']),
								' ',
								m('span', obj['Zipcode'])
							]),
						])
					])
				])				
			])
		}
		
		function setInput(model, attribute, className) {
			return m('input', {
				'className': className,
				'value': model[attribute],
				'onkeyup': function(e) {
					model[attribute] = this.value;
				},
				'onchange': function(e) {
					model[attribute] = this.value;
				},
				'placeholder': attribute
			})
		}			
		return cons.view();
	},

	invoicePanel: function() {
		var context = DAB.context();
		var paymentObj = context['conf']['paymentObj']();
		paymentObj['showOnly'] = false;
		return m('div', {'className': 'uk-form'}, [
			m('h2', context['currentModel']['workOrderHeader']['documentName']),
			context['components']['paymentPanel'](paymentObj),
			m('button', {
				'onclick': function(e) {
					context['model']['createInvoicePayment']();
				},
				'className': 'uk-button uk-button-large uk-button-primary'
			}, 'Submit Payment')
		])
	},
	
	paymentPanel: function(initObj) {
		/**
			@initObj.disabled
			@initObj.payment
			@initObj.paymentApplied
			@initObj.historyOn
		**/
		var context = DAB.context();
		if(initObj['showOnly'] === true && initObj['paymentApplied'].length === 0) {
			return '';
		}
		var labelByType = {
			'cash': 'Cash',
			'check': 'Check',
			'cc': 'Credit Card'
		}
		var workOrderHeader = context['model']['currentModel']['workOrderHeader'];
		var parentClass = 'uk-form-row uk-margin-bottom uk-margin-top noteworkorder';
		if(initObj['disabled'] === true) parentClass += ' clickDisable';
		return m('div', {'className': parentClass},
			m('div',
				m('article', {'className': 'uk-comment extrajobhide'},
					m('header', {'className': 'uk-comment-header'}, [
						titleOption(),
						m('div', {'className': 'uk-comment-meta jobInnerDescription'}, paymentOptions()),
						m('h4', {'className': 'uk-comment-title uk-text-bold jobDescription'}),
						paymentApplied()
					])
				)
			)
		)
		
		function titleOption() {
			if(initObj['showOnly'] === true) return '';
			return m('h4', {'className': 'uk-comment-title uk-text-bold jobDescription'}, 'Payments')
		}
		
		function paymentOptions() {	
			if(initObj['showOnly'] === true) return '';
			if(context['workOrderState']['paymentChange'] === false) {
				initObj['payment']['amount'] = workOrderHeader['due'];
			}
			var amount = initObj['payment']['amount'];
			if(amount === 0) amount = '';
			var element = [
				m('input', {
					'placeholder': 'Amount',
					'onkeyup': function(e) {
						paymentChange(this.value, 'amount')
					},
					'onchange': function(e) {
						paymentChange(this.value, 'amount')
					},
					'value': amount,
					'onkeydown': context['app']['validateFloat']
				})
			]
			element.push(m('select', {
					'onchange': function(e) {
						paymentChange(this.value, 'type')
					}, 
					'value': initObj['payment']['type']
				}, selections())
			)
			
			var title = 'Check #'
			var max = 20;
			if(initObj['payment']['type'] === 'cc') {
				title = 'Last 4 Digits';
				max = 4;
			}
			if(initObj['payment']['type'] !== 'cash' && initObj['payment']['type'] !== 'gift') {
				element.push(m('input', {
					'placeholder': title,
					'onkeyup': function(e) {
						paymentChange(this.value, 'reference')
					},
					'onchange': function(e) {
						paymentChange(this.value, 'reference')
					},
					'maxlength': max,
					'value': initObj['payment']['reference']
				}));
			}
			if(initObj['payment']['type'] === 'cc') {
				element.push(elInput('MM', 'month', 1, 12))
				element.push(elInput('YY', 'year', 0, 99))
			}
			element.push(m('button', {
				'className': 'uk-button',
				'onclick': context['app']['applyPayment']
			}, 'Add Payment'))
			// element.push(m('button', {'className': 'uk-button'}, 'Toggle History'))
			return element;
			
			function selections() {
				var select = [];
				Object.keys(labelByType).forEach(function(val) {
					if(workOrderHeader['docStatus'] === 'IC' && val === 'gift') return;
					select.push(m('option', {'value': val}, labelByType[val]));
				})
				return select;
			}
			
			function elInput(placeholder, attr, min, max) {
				return m('input', {
					'placeholder': placeholder,
					'onkeyup': function(e) {
						if(parseFloat(this.value) > max) this.value = max;
						paymentChange(this.value, attr)
					},
					'onchange': function(e) {
						if(parseFloat(this.value) > max) this.value = max;
						paymentChange(this.value, attr)
					},
					'value': initObj['payment'][attr],
					'type': 'number',
					'max': max,
					'min': min,
					'onkeydown': context['app']['validateInteger']
				})
			}
		}
		
		function paymentApplied() {
			if(initObj['paymentApplied'].length !== 0 && initObj['historyOn']) {
				var paidToDate = 0;
				var rowReturn = [
					m('h4', {'className': 'uk-comment-title uk-text-bold payment'}, 'Payment History'),
					initObj['paymentApplied'].map(function(pay) {
						var userName = context['app']['findInArray'](QueryResponses['allUsers'], 'commId', pay['userId'])['name']
						var paymentTitle = [
							m('span', {'className': 'payspacing'}, '$' + parseFloat(pay['amount']).toFixed(2)),
							m('span', {'className': 'payspacing'}, 'Payment Type: ' + labelByType[pay['type']]),
							m('span', {'className': 'payspacing'}, 'Payment Date: ' + pay['docDate']),
							m('span', {'className': 'payspacing'}, 'Payment Taken By: ' + userName)
						]
						if(pay['type'] === 'cc') {
							paymentTitle.splice(2, 0, m('span', {'className': 'payspacing'}, 'Exp Date: ' + pay['month'] + '/' + pay['year']));
							paymentTitle.splice(2, 0, m('span', {'className': 'payspacing'}, 'Last 4 Digits: ' + pay['reference']));
						}
						if(pay['type'] === 'check') {
							console.log(pay);
							paymentTitle.splice(2, 0, m('span', {'className': 'payspacing'}, 'Check #: ' + pay['checkNum']));
						}
						return m('div', {'className':'uk-comment-meta'}, 
						[
							paymentTitle, 
							// removeOption(pay)
						]);
					})
				]
				var paidRow = m('div', {'className':'uk-comment-meta'}, 
					[
						m('span', {'className': 'uk-text-success'}, 'Amount Paid: $' + workOrderHeader['paidToDate'].toFixed(2)),
						' | ',
						m('span', {'className': 'uk-text-danger'}, 'Amount Due: $' + (workOrderHeader['due']).toFixed(2))
					]
				); 
				rowReturn.push(paidRow);
				return rowReturn;
				function removeOption(payObj) {
					if(!payObj.hasOwnProperty('docEntry')) {
						return m('button', {
							'onclick': function(e) {
							
							},
							'className': 'uk-button'
						}, [m('i', {'className': 'uk-icon-times'}),'Remove Payment']);
					} else {
						return '';
					}
				}
			} else {
				return m('span', {'className': 'uk-text-danger'}, 'Amount Due: $' + (workOrderHeader['total']).toFixed(2));
			}
		}
		
		function paymentChange(value, attribute) {
			if(attribute === 'amount') {
				context['workOrderState']['paymentChange'] = true;
			}
			context['model']['currentModel']['newPayment'][attribute] = value;
			context['app']['reDraw']();
		}
	},
	
	searchView: function(initObj) {
		/**@initObj.title gives search title name
			@initObj.searchElements is input elements to be written
			@initObj.type is the search type in question
		**/
		var context = DAB.context();
		var model = DAB.model;
		var searchModel = context['model']['currentModel'][initObj['type']]
		return m('div', [
			m('h2', {'className':'uk-margin-top'}, initObj['title']),
			initObj['searchElements'].map(function(el) {
				return searchElement(el);
			}),
			m('button',
				{'className': 'uk-button',
					'onclick': search
				}, initObj['searchTitle']
			),
			m('div', {'id': 'search_component'}),
			m('hr')
		])
		
		function searchElement(element) {
			var disabled = false;
			if(context['model']['currentModel']['currentSearch'] !== '' 
				&& context['model']['currentModel']['currentSearch'] !== initObj['type']) {
				disabled = true;
			}
			var value = '';
			if(searchModel.hasOwnProperty(element[1])) value = searchModel[element[1]]; 
			return m('div', {'className': 'uk-form-icon'},[
				m('i', {'className': 'uk-icon-' + element[2]}),
				m('input', {'className': 'uk-margin-right uk-form-width-medium', 
					'placeholder': element[0], 
					'order': element[1], 
					'onkeyup': modifySearch,
					'onchange': modifySearch,
					'onkeydown': submitOnPress,
					'disabled': disabled,
					'value': value
				})
			])
		}
		
		function submitOnPress(e) {
			if(e.keyCode === 13) {
				search();
			}
		}
		
		function modifySearch(e) {
			context['model']['currentModel']['currentSearch'] = initObj['type'];
			var attribute = this.getAttribute('order');
			var order = parseInt(attribute);
			searchModel[order] = this.value;
			var isEmpty = true;
			Object.keys(searchModel).forEach(function(order) {
				if(searchModel[order] !== '') isEmpty = false;
			})
			if(isEmpty) context['model']['currentModel']['currentSearch'] = '';
			context['app']['reDraw']();
		}
		
		function search() {
			var baseSearch = '/search/' + initObj['type'] + '/';
			var searchModel = context['model']['currentModel'][initObj['type']];
			initObj['searchElements'].forEach(function(o, i) {
				if(searchModel.hasOwnProperty(i) && searchModel[i] !== '') {
					baseSearch += '%' + searchModel[i] + '%/';
					searchModel[i] = '';
				} else {
					baseSearch += '%%/';
				}
			});
			context['model']['currentModel']['currentSearch'] = '';
			window.location.hash = baseSearch;
		}
	},
	
	USStates: function() {
		var cons = this;
		var usStates = [
			{ name: 'ALABAMA', abbreviation: 'AL'},
			{ name: 'ALASKA', abbreviation: 'AK'},
			{ name: 'AMERICAN SAMOA', abbreviation: 'AS'},
			{ name: 'ARIZONA', abbreviation: 'AZ'},
			{ name: 'ARKANSAS', abbreviation: 'AR'},
			{ name: 'CALIFORNIA', abbreviation: 'CA'},
			{ name: 'COLORADO', abbreviation: 'CO'},
			{ name: 'CONNECTICUT', abbreviation: 'CT'},
			{ name: 'DELAWARE', abbreviation: 'DE'},
			{ name: 'DISTRICT OF COLUMBIA', abbreviation: 'DC'},
			{ name: 'FEDERATED STATES OF MICRONESIA', abbreviation: 'FM'},
			{ name: 'FLORIDA', abbreviation: 'FL'},
			{ name: 'GEORGIA', abbreviation: 'GA'},
			{ name: 'GUAM', abbreviation: 'GU'},
			{ name: 'HAWAII', abbreviation: 'HI'},
			{ name: 'IDAHO', abbreviation: 'ID'},
			{ name: 'ILLINOIS', abbreviation: 'IL'},
			{ name: 'INDIANA', abbreviation: 'IN'},
			{ name: 'IOWA', abbreviation: 'IA'},
			{ name: 'KANSAS', abbreviation: 'KS'},
			{ name: 'KENTUCKY', abbreviation: 'KY'},
			{ name: 'LOUISIANA', abbreviation: 'LA'},
			{ name: 'MAINE', abbreviation: 'ME'},
			{ name: 'MARSHALL ISLANDS', abbreviation: 'MH'},
			{ name: 'MARYLAND', abbreviation: 'MD'},
			{ name: 'MASSACHUSETTS', abbreviation: 'MA'},
			{ name: 'MICHIGAN', abbreviation: 'MI'},
			{ name: 'MINNESOTA', abbreviation: 'MN'},
			{ name: 'MISSISSIPPI', abbreviation: 'MS'},
			{ name: 'MISSOURI', abbreviation: 'MO'},
			{ name: 'MONTANA', abbreviation: 'MT'},
			{ name: 'NEBRASKA', abbreviation: 'NE'},
			{ name: 'NEVADA', abbreviation: 'NV'},
			{ name: 'NEW HAMPSHIRE', abbreviation: 'NH'},
			{ name: 'NEW JERSEY', abbreviation: 'NJ'},
			{ name: 'NEW MEXICO', abbreviation: 'NM'},
			{ name: 'NEW YORK', abbreviation: 'NY'},
			{ name: 'NORTH CAROLINA', abbreviation: 'NC'},
			{ name: 'NORTH DAKOTA', abbreviation: 'ND'},
			{ name: 'NORTHERN MARIANA ISLANDS', abbreviation: 'MP'},
			{ name: 'OHIO', abbreviation: 'OH'},
			{ name: 'OKLAHOMA', abbreviation: 'OK'},
			{ name: 'OREGON', abbreviation: 'OR'},
			{ name: 'PALAU', abbreviation: 'PW'},
			{ name: 'PENNSYLVANIA', abbreviation: 'PA'},
			{ name: 'PUERTO RICO', abbreviation: 'PR'},
			{ name: 'RHODE ISLAND', abbreviation: 'RI'},
			{ name: 'SOUTH CAROLINA', abbreviation: 'SC'},
			{ name: 'SOUTH DAKOTA', abbreviation: 'SD'},
			{ name: 'TENNESSEE', abbreviation: 'TN'},
			{ name: 'TEXAS', abbreviation: 'TX'},
			{ name: 'UTAH', abbreviation: 'UT'},
			{ name: 'VERMONT', abbreviation: 'VT'},
			{ name: 'VIRGIN ISLANDS', abbreviation: 'VI'},
			{ name: 'VIRGINIA', abbreviation: 'VA'},
			{ name: 'WASHINGTON', abbreviation: 'WA'},
			{ name: 'WEST VIRGINIA', abbreviation: 'WV'},
			{ name: 'WISCONSIN', abbreviation: 'WI'},
			{ name: 'WYOMING', abbreviation: 'WY' }
		];
		this.view = function() {
			return usStates.map(function(state) {
				if(state['abbreviation'] === 'WA') {
					return m('option', {'value': state['abbreviation'], 'selected': true}, state['abbreviation']);
				} else {
					return m('option', {'value': state['abbreviation']}, state['abbreviation']);						
				}
			})
		}
		
		return cons.view();
	},
	
	customerTypes: function() {
		var typeOpts = [
			{name: 'Select', abbreviation: ''},
			{name: '1-C Commercial', abbreviation: '1-C'},
			{name: '1-E Employee', abbreviation: '1-E'},
			{name: '1-R Residential', abbreviation: '1-R'},
			{name: '1-RA Residential (AL)', abbreviation: '1-RA'},
			{name: '1-RR Residential Rental', abbreviation: '1-RR'},
			{name: '1-W Pending Wholesale', abbreviation: '1-W'},
			{name: '2-A Architect', abbreviation: '2-A'},
			{name: '2-C Contractor', abbreviation: '2-C'},
			{name: '2-CC Carpet Cleaner', abbreviation: '2-CC'},
			{name: '2-CD Carpet Dealer', abbreviation: '2-CD'},
			{name: '2-D Designer', abbreviation: '2-D'},
			{name: '2-DC Dry Cleaner', abbreviation: '2-DC'},
			{name: '2-FD Furniture Dealer', abbreviation: '2-FD'},
			{name: '2-O Other Wholesale', abbreviation: '2-O'},
			{name: 'Vendor', abbreviation: 'Vendor'}
		]
		
		return typeOpts.map(function(type) {
			return m('option', {'value': type['abbreviation']}, type['name'])
		});
	},
	
	emailPrefs: function() {
		var prefs = [
			{name: 'All', abbreviation: 'A'},
			{name: 'Service-related only', abbreviation: 'S'},
			{name: 'Special offer', abbreviation: 'SO'},
			{name: 'Decline all', abbreviation: 'D'},
		]
		
		return prefs.map(function(pref) {
			return m('option', {'value': pref['abbreviation']}, pref['name']);
		});
	},
	
	addressTypes: function() {
		var types = [
			{name: 'Address Type', abbreviation: ''},
			{name: 'Service', abbreviation: 'S'},
			{name: 'Billing', abbreviation: 'B'}
		]
		
		return types.map(function(type) {
			return m('option', {'value': type['abbreviation']}, type['name']);
		});
	},
	
	noteTypes: function(type) {
		var types = [
			{name: 'Note Type', abbreviation: ''},
		]
		if(type === 'Client') {
			types.push(
				{name: 'Internal-Only Note', abbreviation: 'internal'},
				{name: 'Client Note', abbreviation: 'sticky'}
			)			
		}
		if(type === 'WO' || type === 'LineItem') {
			types.push(
				{name: 'Internal-Only Note', abbreviation: 'internal'},
				{name: 'Communication Note', abbreviation: 'communication'},
				{name: 'External Note', abbreviation: 'external'}
			)			
		}
		
		return types.map(function(type) {
			return m('option', {'value': type['abbreviation']}, type['name']);
		});
	},
	
	inputIcon: function(initObj) {
		/**
			@initObj.type
			@initObj.icon
			@initObj.placeholder
			@initObj.inputClass
			@initObj.onchange
			@initObj.model
			@initObj.modelAttr
		**/
		var type = 'text';
		var inputClass = '';
		if(initObj.hasOwnProperty('inputClass')) inputClass = initObj['inputClass'];
		if(initObj['hasOwnProperty']('type')) type = initObj['type'];
		return m('div', {'className': 'uk-form-icon spaceAdjust1'}, [
			m('i', {'className': 'uk-icon-' + initObj['icon']}),
			m('input', {
				'placeholder': initObj['placeholder'],
				'onkeyup': function(e) {
					if(e.keyCode === 13 && initObj.hasOwnProperty('fnOnSubmit')) initObj['fnOnSubmit']();
					if(initObj['hasOwnProperty']('onchange')) {
						initObj['onchange'](this.value, initObj['placeholder'], initObj['model'], initObj['modelAttr']);
					}	
				},
				'onchange': function(e) {
					if(initObj['hasOwnProperty']('onchange')) {
						initObj['onchange'](this.value, initObj['placeholder'], initObj['model'], initObj['modelAttr']);
					}	
				},
				'className': inputClass,
				'type': type,
				'value': initObj['model'][initObj['modelAttr']]
			})
		])
	},
	
	documentHeader: function(initObj) {
		/**
			@initObj requires the workorder name/number, and an object compatible with buttonWall() 
			for each row of buttons to be rendered in the header.
		**/
		var cons = this;
		var context = DAB.context();
		var components = DAB.components;
		var workOrderHeader = context['currentModel']['workOrderHeader'];
		var inputs = createInputs();
		
		function createInputs() {
			var inputs = initObj['inputs'].map(function(input) {
				return context['components']['inputIcon'](input);
			});
			if(workOrderHeader['hasMinimum'] === 'Y') {
				if(context['model']['currentUser']['isAdmin'] === 'Y' || context['model']['currentUser']['isManager'] === 'Y') {
					addServiceMinimumOverwriteButton();
				}
				
				function addServiceMinimumOverwriteButton() {
					var title = 'Overwrite Service Minimum';
					var buttonClass = 'uk-button';
					if(workOrderHeader['minimumWaived'] === 'Y') {
						title = 'Minimum Overwritten'
						buttonClass += ' uk-button-success';
					}
					inputs.push(m('button', 
						{'className': buttonClass,
						'onclick': function(e) {
							e.stopPropagation();
							if(workOrderHeader['minimumWaived'] === 'Y') {
								workOrderHeader['minimumWaived'] = 'N'
							} else {
								workOrderHeader['minimumWaived'] = 'Y'
							}
							context['app']['setJobPrice']();
							context['app']['reDraw']();
						}}, 
					title));
				}
			}
			return inputs;
		}
		
		cons.view = function() {
			var parentClass =  '';
			if(initObj['disabled'] === true) parentClass += ' clickDisable';
			var context = DAB.context();
			var headerClass = '';
			if(workOrderHeader['docStatus'] === 'CL') headerClass = 'uk-text-danger';
			if(initObj['workOrderName'] === '' || initObj['workOrderName'] === undefined) initObj['workOrderName'] = 'New Document';			
			if(context['route'][2] !== 'new') initObj['docType']['disabledType'] = 'disabled';
			return m('div', {'className': parentClass}, [
				m('div', {'class': 'uk-clearfix inlinefloatcontainer woHeadline'}, [
					m('h1', {'class': 'inlinefloat uk-text-bold uk-text-primary'}, [
						m('i', {'class': 'uk-icon-tag'}),
						m('span', {'className': headerClass}, initObj['workOrderName'])
					]),
					context['components']['pricingRow'](initObj),
					m('hr', {}),
					m('div', {}, [
						m('div', {'class': 'uk-form-row uk-form-horizontal uk-margin-bottom'}, [
							formRows('Order Type', components['buttonWall'](initObj['orderType']), true),
							formRows('Document Type', components['buttonWall'](initObj['docType']), true),
							formRows('Document Status', components['buttonWall'](initObj['docStatus']), true),
							servCoord(),
							orderContact(),
							formRows('Order-wide Options', inputs, true),
							onloOptions(),
							context['components']['scheduleOptions'](workOrderHeader, context['workOrderState'], context['app']['inheritAttrToJobs']),
							adminOptions()
						])
					])
				])
			])
			function onloOptions() {
				if(context['currentModel']['workOrderHeader']['orderType'] !== 'ONLO') {
					return '';
				}
				return [
					formRows('Time Requested', timeRequested(), true),
					formRows('Schedule Limitations', scheduleLimit(), true),
					formRows('Tech Requested', techRequested(), true)
				]
				
				function timeRequested() {
					var buttonClass = 'uk-button ts-button-bold primaryTint';
					if(workOrderHeader['timeSpecial'] === 'Y') {
						buttonClass += ' uk-active'
					}
					return m('button', {
						'className': buttonClass,
						'innerHTML': '8:00-8:30am',
						'onclick': function(e) {
							e.stopPropagation();
							if(workOrderHeader['timeSpecial'] === 'Y') {
								workOrderHeader['timeSpecial'] = 'N'
							} else {
								workOrderHeader['timeSpecial'] = 'Y'
							}
							context['app']['reDraw']();
						}
					})
				}
				
				function scheduleLimit() {
					var labels = ['None', 'Morning', 'Afternoon'];
					return m('div',
						labels.map(function(label) {
							var buttonClass = 'uk-button ts-button-bold primaryTint';
							var value = label.toLowerCase();
							if(workOrderHeader['scheduleLimitation'] === value) {
								buttonClass += ' uk-active';
							}
							return m('div', {
								'className': 'checkboxwallcontainer'
							},
								m('button', {
									'className': buttonClass,
									'innerHTML': label,
									'onclick': function(e) {
										workOrderHeader['scheduleLimitation'] = value;
										context['app']['reDraw']();
									}
								}) 
							)
						})					
					)
				}
				
				function techRequested() {
					return context['components']['selectionAndExtra']({
						'model': workOrderHeader
					}, 'techRequested', 'Cleaning Technicians')			
				}
			}
			
			function adminOptions() {
				if(context['model']['currentUser']['isAdmin'] === 'N' && context['model']['currentUser']['isManager'] === 'N') {
					return '';
				} else {
					var taxOptions = [];
					Object.keys(QueryResponses['taxRates']).forEach(function(res) {
						if(res !== 'TEST') {
							taxOptions.push(m('option', res))
						}
					});
					var admin = [
						totalOver(),
						taxOver()
					];
					return context['components']['formRow']('Admin Options', admin, ' uk-form-horizontal')
				}
				
				function totalOver() {
					if(context['workOrderState']['totalOver'] === 'Y') {
						return [
							'Order Total Overwrite: ',
							m('input', {
								'value': context['workOrderState']['totalTemp'],
								'onkeydown': context['app']['validateFloat'],
								'onchange': setTotal,
								'onkeyup': setTotal
							}),
							m('button', {
								'className': 'uk-button uk-button-success',
								'onclick': function(e) {
									workOrderHeader['total'] = context['workOrderState']['totalTemp'];
									workOrderHeader['totalOverwritten'] = 'Y';
									context['workOrderState']['totalOver'] = 'N';
									context['app']['setJobPrice']();
									context['app']['reDraw']();
								}
							}
							, 'Set New Total'),
							m('button', {
								'className': 'uk-button uk-button-danger',
								'onclick': function(e) {
									context['workOrderState']['totalOver'] = 'N';
									context['app']['setJobPrice']();
									context['app']['reDraw']();
								}
							}, 'Cancel')
						]
					} else {
						var totalClass = 'uk-button';
						if(context['currentModel']['workOrderHeader']['totalOverwritten'] === 'Y') {
							totalClass += ' uk-button-danger';
						}
						return m('button', {
							'className': totalClass,
							'onclick': function(e) {
								context['workOrderState']['totalOver'] = 'Y';
								context['workOrderState']['totalTemp'] = workOrderHeader['total'];
								context['app']['reDraw']();
							}
						}, 'Total Overwrite')
					}
					
					function setTotal(e) {
						var value = 0;
						if(!isNaN(this.value)) value = parseFloat(this.value);
						context['workOrderState']['totalTemp'] = value; 
					} 
				}
				
				function taxOver() {
					if(context['workOrderState']['taxOver'] === 'Y') {
						return [
							m('select', {
								'value': context['workOrderState']['taxTemp'],
								'onchange': function(e) {
									context['workOrderState']['taxTemp'] = this.value;
								}
							}, taxOptions),
							m('button', {
								'className': 'uk-button uk-button-success',
								'onclick': function(e) {
									var taxCode = context['workOrderState']['taxTemp'];
									workOrderHeader['taxCode'] = taxCode;
									workOrderHeader['taxOverwritten'] = 'Y';
									context['workOrderState']['taxOver'] = 'N';
									context['app']['iterateThroughServices'](setTaxRate);
									context['app']['setJobPrice']();
									context['app']['reDraw']();
									
									function setTaxRate(serv) {
										serv['taxCode'] = taxCode;
										serv['taxRate'] = QueryResponses['taxRates'][taxCode]['Rate']
									}
								}
							}, 'Set Tax Code'),
							m('button', {
								'className': 'uk-button uk-button-danger',
								'onclick': function(e) {
									context['workOrderState']['taxOver'] = 'N';
									context['app']['reDraw']();
								}
							}, 'Cancel')
						]
					} else {
						return m('button', {
							'className': 'uk-button',
							'onclick': function(e) {
								context['workOrderState']['taxTemp'] = workOrderHeader['taxCode'];
								context['workOrderState']['taxOver'] = 'Y';
								context['app']['reDraw']();
							}
						}, 'Tax Overwrite');
					}
				}
			}
			
			function servCoord() {
				if(workOrderHeader['docType'] !== 'SP') return '';
				var selections = context['conf']['createUserSelections']('Service Coordinators');
				var servSelect = m('select', {
					'value': workOrderHeader['servCoord']
					}, 
					selections.map(function(user) {
						return m('option', {'value': user['id']}, user['display'])
					})
				)
				var datePicker = context['components']['datePicker']({
					'modelAttr': 'spDate',
					'dateOption': 'spDate',
					'model': context['currentModel']['workOrderHeader']						
				})
				var timeOptions = [];
				var timeBase = 7;
				var add;
				var currTime;
				var amPm = 'am';
				for(var i=0; i < 23; i++) {
					if(timeBase === 13) {
						timeBase = 1;
					}
					if(i%2 === 0) {
						if(timeBase === 12) amPm = 'pm'
						add = ':00'
						currTime = timeBase + add + amPm;
					} else {
						add = ':30'
						currTime = timeBase + add + amPm;
						timeBase += 1;
					}
					timeOptions.push(currTime);
				}
				var timeSelect = m('select', {'value': workOrderHeader['spTime']}, 
					timeOptions.map(function(time) {
						return m('option', time)
					})
				)
				var inner = [
					m('span', {'className': 'bolding'}, 'Name: '), 
					servSelect, 
					m('span', {'className': 'bolding'}, ' Date: '), 
					datePicker, 
					m('span', {'className': 'bolding'}, ' Time: '), 
					timeSelect
				];
				return context['components']['formRow']('Coordinator Information', inner, ' uk-form-horizontal');
			}
						
			function orderContact() {
				var disabled = false;
				var title = 'Cancel'
				var contactButton = m('button', {
					'className': 'uk-button',
					'onclick': function(e) {
						e.stopPropagation();
						context['model']['state']['contactSelection'] = true;
						context['app']['reDraw']();
					}
				}, 'Order Contact')
				var shown = contactButton;
				if(context['model']['currentClient']['Contacts'].length ===0) {
					shown = m('span', {'className': 'specialNote'}, [
						m('i', {'className': 'uk-icon-warning'}),
						' No Additional Contacts on File.'
					])
				}
				var removeButton = (m('button', {
					'className': 'uk-button',
					'onclick': function(e) {
						e.stopPropagation();
						context['model']['state']['contactSelection'] = false;
						context['app']['reDraw']();
					}
				}, title))
				if(context['model']['state']['contactSelection'] === true) {
					shown = [
						m('div', {'className': 'panelFlex'},
							context['model']['currentClient']['Contacts'].map(function(contact) {
								var initObj = panelObj();
								if(context['currentModel']['workOrderHeader']['contactSelected'] === contact['ID']) {
									initObj['selected'] = true;
								}
								initObj['fnOnClick'] = context['app']['selectContactWO']
								return context['components']['contactPanel'](initObj, contact)							
							}) 
						),
						removeButton]
				} else if(context['currentModel']['workOrderHeader']['contactSelected'] !== '') {
					var removeButton = (m('button', {
						'className': 'uk-button',
						'onclick': function(e) {
							e.stopPropagation();
							context['currentModel']['workOrderHeader']['contactSelected'] = '';
							context['app']['reDraw']();
						}
					}, 'Remove Contact'))
					shown = [
						m('div', {'className': 'panelFlex'},
							context['model']['currentClient']['Contacts'].map(function(contact) {
								var initObj = panelObj();
								if(context['currentModel']['workOrderHeader']['contactSelected'] === contact['ID']) {
									initObj['selected'] = true;
								} else {
									initObj['shown'] = false;
								}
								return context['components']['contactPanel'](initObj, contact)							
							})
					),
					contactButton, 
						m('button', {
							'className': 'uk-button',
							'onclick': function(e) {
								e.stopPropagation();
								context['currentModel']['workOrderHeader']['contactSelected'] = '';
								context['app']['reDraw']();
							}
						}, 'Remove Contact')
					]
				}
				return formRows('Order Contact', shown, true)
				
				function panelObj() {
					return {
						'className': 'uk-panel contactPanel',
						'hasControls': false
					};
				}
			}
			
			function formRows(title, content, isFormHor) {
				var className = 'uk-form-row';
				if(isFormHor) className += ' uk-form-horizontal';
				return m('div', {'class': className}, [
					m('label', {'class': 'uk-form-label'}, title),
					m('div', {'class': 'uk-form-controls'},
						content
					)
				])
			}
		}
		
		return cons.view();
	},
	
	scheduleOptions: function(model, state, fnOnChange) {
		var context = DAB['context']();
		if(['ONLO', 'SPD', 'SCC'].indexOf(context['currentModel']['workOrderHeader']['orderType']) === -1 ||
		context['currentModel']['workOrderHeader']['docType'] === 'CS') return '';
		if(model.hasOwnProperty('orderType') && model['orderType'] === 'SCC') return '';
		var stateObj = state;
		var inner = [];
		if(context['currentModel']['workOrderHeader']['orderType'] === 'ONLO') {
			inner.push(m('span', {'className': 'bolding'}, ''));
			var dateInit = {
				'modelAttr': 'scheduledDate',
				'dateOption': 'scheduledDate',
				'model': context['currentModel']['workOrderHeader']					
			}
			var scheduledDate = context['components']['datePicker'](dateInit)
			inner.push(scheduledDate);					
			inner.push(m('span', {'className': 'bolding'}, 'Between '))
			inner.push(context['components']['timeSelect'](model, 'servTimeStart', stateObj['servTimeStart']));
			inner.push(m('span', {'className': 'bolding'}, ' And '));
			inner.push(context['components']['timeSelect'](model, 'servTimeEnd', stateObj['servTimeEnd']));
		} else if(['SPD', 'SCC'].indexOf(context['currentModel']['workOrderHeader']['orderType']) !== -1) {
			if(context['currentModel']['workOrderHeader']['orderType'] === 'SPD') {
				inner.push(m('span', {'className': 'bolding'}, 'Pickup Scheduled on: '));
				var scheduledInit = {
					'modelAttr': 'scheduledPickup',
					'dateOption': 'scheduledPickup',
					'model': model					
				}
				if(typeof fnOnChange !== 'undefined') {
					scheduledInit['fnOnDateChange'] = fnOnChange;
				}
				var scheduledPickup = context['components']['datePicker'](scheduledInit)
				inner.push(scheduledPickup);
				inner.push(m('span', {'className': 'bolding'}, ' Between '))
				inner.push(context['components']['timeSelect'](model, 'pickupTimeStart', stateObj['pickupTimeStart'], fnOnChange));
				inner.push(m('span', {'className': 'bolding'}, ' And '));
				inner.push(context['components']['timeSelect'](model, 'pickupTimeEnd', stateObj['pickupTimeEnd'], fnOnChange));
				inner.push(m('br'));
			}
			inner.push(m('span', {'className': 'bolding'}, 'Delivery Scheduled on: '));
			var deliveryInit = {
				'modelAttr': 'scheduledDelivery',
				'dateOption': 'scheduledDelivery',
				'model': model						
			}
			if(typeof fnOnChange !== 'undefined') {
				deliveryInit['fnOnDateChange'] = fnOnChange;
			}
			var scheduledDelivery = context['components']['datePicker'](deliveryInit);
			inner.push(scheduledDelivery);
			inner.push(m('span', {'className': 'bolding'}, ' Between '))
			inner.push(context['components']['timeSelect'](model, 'deliveryTimeStart', stateObj['deliveryTimeStart'], fnOnChange));
			inner.push(m('span', {'className': 'bolding'}, ' And '));
			inner.push(context['components']['timeSelect'](model, 'deliveryTimeStart', stateObj['deliveryTimeStart'], fnOnChange));				
		}
		var formRow = context['components']['formRow']('Arrival Window', inner);
		formRow['attrs']['class'] = 'uk-form-row uk-form-horizontal';
		
		return [formRow];
	},
	
	timeSelect: function(model, modelAttr, currentState, fnOnChange) {
		var context = DAB['context']();
		var currentValue = model[modelAttr];
		if(currentState['isSet'] === false && currentValue !== 0) {
			var definedVal = context['app']['timeFromInt'](currentValue); 
			currentState['hr'] = definedVal[0];
			currentState['min'] = definedVal[1];
			currentState['amPm'] = definedVal[2];
		}
		var hrOption = [m('option', {'disabled': true})];
		var minOption = [
			m('option', {'disabled': true}),
			m('option', {'value': 0}, '00')
		];
		var amPm = [
			m('option', {'disabled': true}),
			m('option', 'am'),
			m('option', 'pm')
		]
		for(var i=1; i< 13; i++) {
			hrOption.push(m('option', i));
		}
		for(var i=1; i<4; i++) {
			minOption.push(m('option',  i * 15));
		}
		return [
			m('select', {
				'value': currentState['hr'],
				'onchange': function(e) {
					currentState['hr'] = parseInt(this.value);
					setNewTimeInt();
				}
			}, hrOption),
			m('select', {
				'value': currentState['min'],
				'onchange': function(e) {
					currentState['min'] = parseInt(this.value);
					setNewTimeInt();
				}
			}, minOption),
			m('select',	{
				'value': currentState['amPm'],
				'onchange': function(e) {
					currentState['amPm'] = this.value;
					setNewTimeInt();
				}
			}, amPm)
		]
		
		function setNewTimeInt() {
			if(currentState['amPm'] !== '') {
				var base = 0;
				if(currentState['amPm'] === 'pm') {
					base += 1200;
				}
				if(currentState['hr'] !== 12) {
					base += currentState['hr'] * 100;
				}
				base += currentState['min']
				if(typeof fnOnChange !== 'undefined') {
					fnOnChange(model, modelAttr, base)
				} else {
					model[modelAttr] = base;					
				}
			}
		}
	},
	
	pricingRow: function(initObj) {
		var header = initObj['model'];
		var prices = ['subTotal', 'taxes', 'total', 'due']
		var priceLabels = ['Subtotal:', 'Taxes:', 'Total:', 'Balance:'];
		var titleClass =  'inlinefloat uk-text-bold uk-text-primary uk-margin-left';
		if(header['hasMinimum'] === 'Y') {
			prices.splice(0, 0, 'minimum');
			priceLabels.splice(0, 0, 'Minimum Diff:')
		}
		return m('div', {'className': 'uk-float-right pricingFloat'}, 
			prices.map(function(price, i) {
				var spanClass = '';
				if(header['totalOverwritten'] === 'Y' && price === 'total') spanClass = ' uk-text-danger'
				return m('h3', {'class': titleClass}, [
					m('span', priceLabels[i]),
					m('span', {'className': spanClass}, ' $' + header[price].toFixed(2))
				])
			})
		)
	},
	
	modal: function(content) {
		var context = DAB.context();
		document.addEventListener('click', oneClick);
		var style = 'display:block;';
		if(context['model']['modalOption'] === 'zipCodeView') style += 'width:800px;';
		var div = m('div', {
			'className': 'uk-modal uk-open',
			'aria-hidden': 'false',
			'style': 'display:block; overflow-y: scroll;'
			},  
			m('div', {
				'className': 'uk-modal-dialog',
				'id': 'modal_mithril',
				'style': style
				}, [
				m('div', {
					'className': 'uk-close',
					'onclick': removeModal
				}),
				content
			])
		);
		
		return div;
		function oneClick (e) {
			var el = document.getElementById('modal_mithril');
			if(e.path.indexOf(el) !== -1) return;
			if(el === null) return
			var isClickInside = el.contains(e.target);
			if(!isClickInside) {
				removeModal();
			}
		}
		
		function removeModal() {
			context['model']['modalOption'] = '';
			if(context['model']['modalOnRemove'] !== null) {
				context['model']['modalOnRemove']();
				context['model']['modalOnRemove'] = null;
			}
			context['app']['reDraw']();
			document.removeEventListener('click', oneClick)
		}
	},
	
	modalOption: function(type) {
		var context = DAB.context();
		return context['components'][type]();
	},
	
	requiredModal: function() {
		var context = DAB.context();
		var timeAttrs = [
			'servTimeStart', 
			'servTimeEnd', 
			'pickupTimeStart', 
			'pickupTimeEnd', 
			'deliveryTimeStart', 
			'deliveryTimeEnd'
		]
		var titles = [
			'Service Time Start: ',
			'Service Time End: ',
			'Pickup Time Start: ',
			'Pickup Time End: ',
			'Delivery Time Start: ',
			'Delivery Time End: '
		]
		var required = context['currentModel']['required'].map(function(attr) {
			var timeIndex = timeAttrs.indexOf(attr)
			if(timeIndex !== -1) {
				var timeSelect = context['components']['timeSelect'](context['currentModel']['workOrderHeader'], attr, context['workOrderState'][attr], context['app']['inheritAttrToJobs']);
				return context['components']['formRow'](titles[timeIndex], timeSelect, ' uk-form-horizontal')
			} else if(attr === 'placedBy') { 
				var input = m('input', {
					'value': context['currentModel']['workOrderHeader']['placedBy'],
					'onkeyup': function(e) {
						if(e.keyCode === 13) context['app']['verifyWorkOrder'](e);
						context['currentModel']['workOrderHeader']['placedBy'] = this.value;
					}
				})
				return context['components']['formRow']('Order Placed By:', input, ' uk-form-horizontal')
			} else {
				return [
					context['components']['addressContainer'](attr[0], attr[1], attr[2])
				]
			}
		})
		var requiredEl = [];
		required.forEach(function(reqEl) {
			requiredEl.push(reqEl);
			requiredEl.push(m('hr'));
		})
		return m('div', {'className': 'uk-form'},
			m('h2', 'The following fields are required'),
			requiredEl,
			m('button', {
				'className': 'uk-button ts-button-full',
				'onclick': context['app']['verifyWorkOrder']
			}, 'Submit')
		);
	},
	
	recommendedModal: function() {
		var context = DAB.context();
		return m('div', {'className': 'uk-form'},
			m('h2', 'The following fields are recommended'),
			context['currentModel']['recommended'][0].map(function(obj) {
				console.log(obj['index']);
				var model = title = context['currentModel']['currentJobs'][obj['index']]['header']
				var title = model['title'] + ' Service Date';
				return [m('h3', title),
					context['components']['datePicker']({
						'modelAttr': obj['field'],
						'dateOption': obj['field'] + obj['index'] + 'Sub',
						'model': model						
					})
				]
			}),
			m('hr'),
			m('button', {
				'className': 'uk-button ts-button-full',
				'onclick': function(e) {
					e.stopPropagation();
					context['model']['modalOption'] = '';
					context['model']['fnPostVerify']();
				}
			}, 'Submit')
		);
	},
	
	emailModal: function() {
		var context = DAB.context();
		var emailTitles = context['conf']['emailTypes']();
		var mainTitle = emailTitles[context['workOrderState']['emailNow']];
		return m('div', {'className': 'uk-form'},
			m('h2', 'Clicking send email will send the following email(s)'),
			mainEmail(),
			context['workOrderState']['emailLater'].map(function(mailLater) {
				var timeDisplay = context['app']['timeDisplay'](mailLater[2])
				var title = [
					m('span.uk-text-success', emailTitles[mailLater[0]]),
					m('span.uk-text-bold', ' on '),
					m('span.uk-text-success', mailLater[1]),
					m('span.uk-text-bold', ' at '),
					m('span.uk-text-success', timeDisplay),
					buttonConfirmed(mailLater[0])
				]
				return [m('hr'), m('h2', title)];
			}),
			m('h2', 'With the following details:'),
			m('div.uk-margin-bottom-small', [
				m('span', 'Recipient Name: '),
				m('input', {
					'value': context['currentModel']['emailName'],
					'onchange': function(e) {
						context['currentModel']['emailName'] = this.value
					},
					'onkeyup': function(e) {
						context['currentModel']['emailName'] = this.value
					}
				})
			]),
			m('br'),
			m('div.uk-margin-bottom-small', [
				m('span', 'Recipient Email on File: '),
				m('input', {
					'value': context['currentModel']['toEmail'],
					'onchange': function(e) {
						context['currentModel']['toEmail'] = this.value
					},
					'onkeyup': function(e) {
						context['currentModel']['toEmail'] = this.value
					}
				})			
			]),
			m('br'),
			m('div.uk-margin-bottom-small', [
				m('span', 'Test Email Receivable: '),
				m('input', {
					'value': context['currentModel']['emailToUse'],
					'disabled': true
				})			
			]),
			m('br'),
			m('button', {
				'className': 'uk-button ts-button-full',
				'onclick': context['app']['saveOrder']
			}, [
				m('i', {'className': 'uk-icon-save'}),
				m('span', 'Save Only'),
				m('span', {
					'className': 'uk-text uk-text-small'
				}, ' - Do not Send Email(s)')
			]),
			m('button', {
				'className': 'uk-button ts-button-full',
				'onclick': function(e) {
					e.stopPropagation();
					context['model']['fnPostSave'] = context['app']['postEmail'];
					context['app']['saveOrder']();
				}
			}, [
				m('i', {'className': 'uk-icon-envelope'}),
				'Save & Send Email(s)'
			])
		);
		
		function buttonConfirmed(attr) {
			var isConfirmed = context['workOrderState']['emailConfirm'].indexOf(attr) !== -1;
			var text = 'Cancelled'
			var iconName = 'ban';
			var buttonClass = 'uk-margin-left uk-button';
			if(isConfirmed) {
				buttonClass += ' uk-button-success';
				iconName = 'check';
				text = 'Confirmed';
			} else {
				buttonClass += ' uk-button-danger';
			}
			var icon = m('i', {'className':' uk-icon-' + iconName});
			return m('button', {
				'className': buttonClass,
				'onclick': function(e) {
					e.stopPropagation();
					if(isConfirmed) {
						context['app']['removeFromArray'](context['workOrderState']['emailConfirm'], attr);
					} else {
						context['workOrderState']['emailConfirm'].push(attr);
					}
					context['app']['reDraw']();
				}
			}, [icon, text])
		}
		
		function mainEmail() {
			if(context['workOrderState']['emailNow'] === null) {
				return '';
			}
			var emailNow = context['workOrderState']['emailNow']
			var mainTitle = emailTitles[emailNow];
			return m('h2', [
				m('span.uk-text-success', mainTitle),
				m('span.uk-text-bold', ' | '),
				m('span.uk-text-success', 'Right Now'), 
				buttonConfirmed(emailNow)
			]);
		}
	},
	
	buttonWall: function(initObj) {
		/** @initObj is an object that requires the following attributes:
			@initObj.model is the object location of the attribute that needs to be changed
			@initObj.modelAttr the attribute of the model that holds the state of this element.
			@initObj.selections is an array with objects that have attributes @display and @id in which @id
			is a unique identifier of the button, and @display is the text that will be displayed on the button.
			@initObj.fnOnClick is the function callback for when the button is pressed.
			@initObj.disabledType this property exists and is set to true then button will have class disabled
			@initObj.parentClass if this is defined it sets the class for the parent contianer of the buttonWall
			@initObj.buttonClass if defined it overwrites the buttonClass
			@initObj.filterBy is a filter boolean, if empty string then it shows everything
			@initObj.activeDisabled if true active buttons are disabled
		**/
		var cons = this;
		var isEmpty = false;
		if(initObj.hasOwnProperty('filterBy') && initObj['filterBy'] !== '') {
			isEmpty = true;
		}
	
		cons.view = function() {
			var parentClass = 'ts_button_wall uk-form-controls';
			if(initObj.hasOwnProperty('parentClass')) parentClass = initObj['parentClass'];
			return m('div', {'className': parentClass},
				initObj['selections'].map(function(sel, i) {
					var disabled = false;
					if(initObj.hasOwnProperty('disabledType')) disabled = initObj['disabledType'];
					var className = 'uk-button ts-button-bold uk-margin-small-bottom';
					if(initObj.hasOwnProperty('buttonClass')) className = initObj['buttonClass'];
					if(initObj['isRed'] === true) className += ' uk-button-primary';
					var isSelected = false;
					if(Array.isArray(initObj['model'][initObj['modelAttr']])) {
						if(initObj['model'][initObj['modelAttr']].indexOf(sel['id']) !== -1 ) isSelected = true;
					} else { 
						if(initObj['model'][initObj['modelAttr']] === sel['id']) isSelected = true;
					}
					if(initObj.hasOwnProperty('filterBy')) {
						var filterBy = initObj['filterBy'];
						if(filterBy !== '' && filterBy !== isSelected) {
							return '';
						} else {
							isEmpty = false;
						}
					}
					if(isSelected) className += ' uk-active'
					if(initObj['activeDisabled'] === true && isSelected) disabled = true; 
					if(sel['disabled'] === true) disabled = true;
					return m('div', {'className': 'checkboxwallcontainer'},
						m('button', {
							'onclick': function(e) {
								if(initObj.hasOwnProperty('fnOnClick')) initObj['fnOnClick'](sel['id'], sel['display'], initObj['model'], initObj['modelAttr']);											
							},
							'ts_id': sel['id'],
							'disabled': disabled,
							'className': className
						}, [
							hasIcon(sel), 
							sel['display']
						])
					)
				})
			)
			
			function hasIcon(sel) {
				if(sel.hasOwnProperty('icon')) {
					return m('i', {'className': 'uk-icon-' + sel['icon']})
				} else {
					return '';
				}
			}
		}
		var view = cons.view();
		if(isEmpty) return m('span', 'No Conditions to show');
		return view;
	},
	
	contactSelect: function() {
		
	},

	lineItem: function(initObj) {
		/**
			@initObj.model is the object location of the attribute that needs to be changed
			@initObj.modelAttr the attribute of the model that holds the state of this element.
			@initObj.fnOnChange is the function to call when an attribute within the model changes
			@initObj.fnOnCancel is the function to call when the lineItem is cancelled
		**/
		var lineItemTypes = {
			'sqft': {
				'labels': ['Width Ft', 'Width In', 'Height Ft', 'Height In', 'Total SqFt'],
				'elements': ['ftWidth', 'inWidth', 'ftHeight', 'inHeight', 'unitTotal']
			}
		};
		var rugEach = ['711', '712', '713', '732', '733', '734', '740', '741'];
		var simplified = ['293', '990', '990A', '990B', '741'];
		var context = DAB.context();
		var currentUser = context['model']['currentUser'];
		var cons = this;
		var model = initObj['model'][initObj['modelAttr']];
		if(model['type'] === 'protectant' || model['type'] === 'minimum') return '';
		this.view = function() {
			var unitSelected = lineItemTypes[model['unitType']]
			var parentClass =  'ts-miniPanel uk-panel';
			var mainForm = 'uk-form-row';
			if(model['cancelled'] === 'Y') {
				mainForm += ' clickDisable';
			}
			if(initObj['disabled'] === true) {
				parentClass += ' clickDisable';
			}
			var cancelRow = 'uk-form-row';
			if(['293', '990', '990A', '990B', '741'].indexOf(model['id']) === -1) cancelRow += ' removeLine'
			// var tableClass = 'display compact stripe hover inProcessTable dataTable no-footer';
			return m('div', {'class': parentClass}, [
				m('div', {'class': mainForm}, [
					m('div', {'class': 'nameOfItem uk-text-bold'}, [model['nameOfItem'], serviceCost()]),
					m('br'),
					m('div', {'class': ''}, 
						createInputs()
					)
				]),
				m('div', {
						'class': 'uk-form-row'
					},
					createOptions(),
					m('div', {'className': mainForm},
						createSelects()
					),
					m('div', {'class': mainForm},
						createDates()
					),
					m('div', {'class': mainForm},
						createNoteInput()
					),
					m('div', {'class': mainForm}, [
						statusButtons()
					]),
					m('div', {'class': cancelRow}, [
						m('div', {'className': 'uk-display-inline-block'}, [
							cancelButton()
						])
					])
				)
			]);
		}
		
		function statusButtons() {
			var status = {
				'IP': 'In Process',
				'COMP': 'Complete'
			}
			var statusKeys = Object.keys(status);
			if(simplified.indexOf(model['id']) !== -1) return '';
			return m('div',{'className': 'uk-display-inline-block ts_button_wall'},
				statusKeys.map(function(stat) {
					var buttonClass = 'uk-button ts-button-bold';
					if(model['status'] === stat) buttonClass += ' uk-active'
					return m('button', {
						'class': buttonClass,
						'onclick': function(e) {
							if(model['status'] === stat) {
								return;
							} else {
								initObj['fnOnChange'](stat, model, 'status')
							}
						}
					}, status[stat])
				})
			)
		}
		
		function createNoteInput() {
			if(model['id'][0] !== '2') return '';
			return ['Notes / Instructions: ',
			m('textarea', {
				'className': 'uk-form-width-large',
				'onkeyup': function(e) {
					model['notes'] = this.value;
				},
				'onchange': function(e) {
					model['notes'] = this.value;
				},
				'value': model['notes']
			})]
		}
		
		function createSelects() {
			if(simplified.indexOf(model['id']) !== -1) return '';
			var select = ['AOS By: ']
			select.push(context['components']['selectionAndExtra']({
				'model': context['jobOpen']['commissionAOS'],
			}, model['uniqueId'], 'active'))
			if(model['id'][0] === '2') {
				select.push(' Completed By: ');
				select.push(context['components']['selectionAndExtra']({
					'model': context['jobOpen']['commissionWork'],
				}, model['uniqueId'], 'Repair Technicians'))
			}
			if(model['id'].indexOf('7') === 0 && rugEach.indexOf(model['id']) === -1) {
				select.push(' Pad Cut By: ');
				select.push(context['components']['selectionAndExtra']({
					'model': context['jobOpen']['commissionWork'],
				}, model['uniqueId'], 'Rug Pad Cleaning Tech'))
			}
			return select;
		}
		
		function createDates() {
			if(simplified.indexOf(model['id']) !== -1) return '';
			if(rugEach.indexOf(model['id']) !== -1) return '';
			var dates = [['Completion Date: ', 'dateComplete']]
			var dateContainer = [];
			if(model['id'][0] !== '1') {
				dates.splice(0, 0, [' Due Date: ', 'dateDue']);
			}
			dates.forEach(function(dateArr) {
				if(model[dateArr[1]] !== '') model[dateArr[1]] = Utility.formatDate(model[dateArr[1]]);
				dateContainer.push(m('span', dateArr[0]))
				dateContainer.push(
					context['components']['datePicker']({
						'dateOption': dateArr[1] + model['nameOfItem'],
						'model': model,
						'modelAttr': dateArr[1]
					})
				)
			})
			return dateContainer;
		}
		
		function createOptions() {
			if(model['id'][0] !== '2') return '';
			var cat = context['app']['findInArray'](QueryResponses['checkBoxes'], 'ItemCode', model['id'])['U_Category'];
			return context['conf']['bindingOptions'](model, cat);
		}
		
		function serviceCost() {
			return m('span', { 'class': 'uk-margin-left uk-float-right' }, [
				'Item Cost: $',
				m('span', {'className': 'uk-text-bold'}, model['subTotal'].toFixed(2))
			])
		}
		
		function cancelButton() {
			// if(model['type'] === 'lineItem')  {
			var label = 'Remove';
			var cancelClass = 'uk-button item-remove uk-margin-left';
			if(model['key'] !== '') {
				label = 'Cancel';
			} else {
				cancelClass += ' uk-button-danger';
			}
			if(model['cancelled'] === 'Y') {
				cancelClass += ' uk-button-danger';
				label = 'Cancelled';
			}
			return m('button', {
				'class': cancelClass,
				'onclick': function(e) {
					if(initObj.hasOwnProperty('fnOnCancel')) initObj['fnOnCancel'](initObj['model'], initObj['modelAttr'])
				}
			}, label)
			// } else {
				// return '';
			// }
		}
		
		function createInputs() {
			if(model['id'] === '293') return '';
			var num = model['unitTotal'];
			if(!Number.isFinite(num)) num = 0;
			var inputContainer = [
				m('span', {'className': 'uk-text-bold'},'Width: '),
				unitInput(model['ftWidth'], 'Feet', 'ftWidth'),
				unitInput(model['inWidth'], 'Inches', 'inWidth'),
				m('span', {'className':'uk-text-bold uk-margin-left'}, 'Length: '),
				unitInput(model['ftHeight'], 'Feet', 'ftHeight'),
				unitInput(model['inHeight'], 'Inches', 'inHeight'),
				m('span', {'className':'uk-text-bold uk-margin-left'}, '='),
				m('span', {'className':'uk-margin-left uk-text-success uk-text-bold'}, num.toFixed(2)),
				m('span', {'className':'uk-text-bold'}, ' SqFt')
			]
			if(model['unitType'] === 'Each') {
				inputContainer = [
					m('span', 'Amount '),
					unitInput(model['quantity'], 'Units', 'quantity')
				]
			}
			if(model['unitType'] === 'Leneal Foot') {
				inputContainer = [
					m('span', 'Lineal Feet: '),
					unitInput(model['ftWidth'], 'Feet', 'ftWidth'),
					unitInput(model['inWidth'], 'Inches', 'inWidth'),
					m('span', {'className':'uk-margin-left'}, '='),
					m('span', {'className':'uk-margin-left uk-text-bold'}, num.toFixed(2)),
					m('span', ' Ft')
				]
			}
			if(model['unitType'] === 'Est') {
				var est = [
					m('span.uk-text-bold', 'Service Cost: $'), unitInput(model['quantity'], '00.00', 'quantity')
				]
				if(model['id'] !== '741') {
					inputContainer = est;				
				} else {
					est[0]['children'][0] = 'Service Cost: $'
					est.push(m('br'));
					inputContainer = est.concat(inputContainer);
				}
			}
			if(model['unitType'] === 'Percent') {
				inputContainer = [];
			}
			return inputContainer;
		}
		
		function unitInput(fieldValue, placeholder, modelAttr) {
			var keyDown = context['app']['validateInteger'];
			if(model['unitType'] === 'Est') keyDown = context['app']['validateFloat'];
			if(fieldValue === 0) fieldValue = '';
			return m('input', {
				'type': 'number',
				'class': 'uk-form-width-tiny',
				'placeholder': placeholder,
				'value': fieldValue,
				'onkeyup': function(e) {
					handleInput(this);
				},
				'onkeydown': keyDown,
				'onchange': function(e) {
					handleInput(this);
				}
			})
			
			function handleInput(element) {
				var keyUpValue = element.value;
				if(keyUpValue === '') keyUpValue = 0;
				initObj['fnOnChange'](keyUpValue, model, modelAttr)
			}
		}
		
		return cons.view();
	},

	carpetRoom: function(initObj) {
		var context = DAB.context();
		var typingTimer;
		if(typeof initObj['isEditing'] === 'undefined') initObj['isEditing'] = false;
		var findProtectant = context['app']['findInArray'](context['jobOpen']['additionalServices'], 'referentialId', initObj['uniqueId']);
		var lineItemClass = 'ts-lineItem_room';
		if(initObj['cancelled'] === 'Y') lineItemClass += ' clickDisable';
		return m('div', {'className': lineItemClass},
			m('div', {'className':'uk-form-row uk-panel-box'}, [
				title(),
				m('hr'),
				m('div', {'className': 'uk-width-1-1 uk-text-right uk-margin-small-bottom'}, [
					m('span', 'Carpet Color:',
						context['components']['colorPicker']({
							'model': initObj,
							'modelAttr': 'color',
							'fnOnSelect': context['app']['colorSelect'],
							'uniqueAttr': initObj['uniqueId']
						})
					)
				]),
				inputs(),
				ratios(),
				serviceCharge(),
				protectantCharge(),
				protectantAOS(),
				buttons()
			])
		)
		
		function title() {
			if(initObj['isEditing'] === false) {
				var titleClass = 'nameOfItem uk-text-bold uk-h2'
				if(initObj['cancelled'] === 'Y') titleClass += ' uk-text-danger';
				return [
					m('div', {
						'className': 'inlinefloat uk-button uk-button-mini',
						'onclick': function(e) { 
							initObj['isEditing'] = true;
							initObj['originalName'] = initObj['nameOfItem'].substr();
							initObj['nameOfItem'] = '';
							context['app']['reDraw']();
						}
					}, 'Edit'),
					m('div', {'className': titleClass}, initObj['nameOfItem'])
				]
			} else {
				return [
					context['components']['inputIcon']({
						'placeholder': 'Area Name',
						'icon': 'pencil',
						'type': 'text',
						'model': initObj,
						'modelAttr': 'nameOfItem',
						'onchange': changeTitle
					}),
					m('button', {
						'className': 'inlinefloat uk-button uk-button-mini uk-button-success',
						'onclick': submitTitle
						},
						m('i', {'className': 'uk-icon-check'})
					),
					m('button', {
						'className': 'inlinefloat uk-button uk-button-mini uk-button-danger',
						'onclick': setOriginal
						},
						m('i', {'className': 'uk-icon-times'})
					)
				]
			}
			
			function changeTitle(value) {
				initObj['nameOfItem'] = value;
				if(findProtectant) findProtectant['nameOfItem'] = value + ' Protectant'; 
			}
			
			function submitTitle() {
				if(initObj['nameOfItem'] === '') return setOriginal();
				initObj['isEditing'] = false;
				context['app']['reDraw']();
			}
			
			function setOriginal() {
				initObj['nameOfItem'] = initObj['originalName'];
				initObj['isEditing'] = false;
				context['app']['reDraw']();
			}
		}
		
		function serviceCharge() {
			return m('div', {'className': 'uk-width-1-1 uk-text-right uk-margin-small-bottom'}, [
				'Service Charge: $',
				m('span', {'className': 'uk-text-bold'}, initObj['subTotal'].toFixed(2))
			])
		}
		
		function inputs() {
			if(initObj['id'] === '580') return '';
			return context['components']['inputType'](initObj, 'carpetRoomAttr');
		}
		
		function ratios() {
			if(initObj['unitType'] === 'Each') return '';
			var buttons = [[.25, 'Limited (25%)'],[.50, '50%'],[.75, '75%'],[1.0, '100%']];
			return m('div', {'className': 'uk-width-1-1 uk-text-right uk-margin-small-bottom sqftinput'}, [
				'% Cleaned:',
				m('span', {'className': 'roomPercentages'},
					buttons.map(function(b) {
						var className = 'uk-button ts-button-bold'; 
						if(initObj['ratio'] === b[0]) className+= ' uk-active';
						return m('button', {
							'className': className,
							'onclick': function(e) {
								context['app']['carpetRoomAttr'](b[0], initObj, 'ratio');
							} 
						}, b[1])
					})
				)
			])
		}
		
		function protectantCharge() {
			if(initObj['hasProtectant'] === 'Y') {
				return m('div', {'className': 'uk-width-1-1 uk-text-right uk-margin-small-bottom'}, [
					'Protectant Charge: $',
					m('span', {'className': 'uk-text-bold'}, findProtectant['subTotal'].toFixed(2))
				])
			}
			return '';
		}
		
		function protectantAOS() {
			if(initObj['hasProtectant'] === 'Y') {
				return m('div', {'className': 'uk-width-1-1 uk-text-right uk-margin-small-bottom'}, [
					'Protectant AOS',
					context['components']['selectionAndExtra']({
						'model': context['jobOpen']['commissionAOS'],
					}, findProtectant['uniqueId'], 'active')
				])
			}
			return '';
		}
		
		function buttons() {
			var className = 'uk-float-right uk-button scotch-toggle uk-margin-right ts-button-bold';
			if(initObj['hasProtectant'] === 'Y') className += ' uk-active';
			var title = 'Remove Area';
			if(initObj['key'] !== '') title = 'Cancel Area';
			var baseClass = 'uk-float-right uk-button room-remove';
			if(initObj['key'] === '' || initObj['cancelled'] === 'Y') baseClass += ' uk-button-danger';
			if(initObj['cancelled'] === 'Y')  {
				baseClass += ' uk-active';
				title = 'Cancelled';
			}
			return m('div', {'className': 'uk-width-1-1'}, [
				m('button', {
					'className': baseClass,
					'onclick': function(e) {
						context['app']['removeRoom'](initObj);
					}
				}, title),
				protectantButton()				
			])
			
			function protectantButton() {
				if(['580', '581'].indexOf(initObj['id']) !== -1) return '';
				return context['components']['iconButtonMod']({
					'fnOnClick': context['app']['protectantToggle'],
					'buttonClass': className,
					'modelAttr': 'protectant',
					'display': 'Protectant',
					'icon': 'check',
					'model': initObj,
					'id': 'hasProtectant'
				})	
			}
		}
	},
	
	inputType: function(initObj, fnOnChange) {
		var context = DAB.context();
		var dimensionsByType = {
			'Square Foot': {
				'dimName': [['ftWidth', 'inWidth'], ['ftHeight', 'inHeight'], ['unitTotal']],
				'placeholder': [['Feet', 'Inches'], ['Feet', 'Inches'], ['Total']],
				'splice': ['Width: ','Length: ','Total sqft: ']
			},
			'Each': {
				'dimName': [['quantity']],
				'placeholder': [['Units']],
				'splice': ['Quantity: ']
			},
			'Est': {
				'dimName': [['ftWidth', 'inWidth'], ['ftHeight', 'inHeight'], ['unitTotal'], ['quantity']],
				'placeholder': [['Feet', 'Inches'], ['Feet', 'Inches'], ['Total'], ['Amount']],
				'splice': ['Width: ','Length: ','Total sqft: ', ['Service Cost: ']]
			},
			'EstStone': {
				'dimName': [['quantity']],
				'placeholder': [['Amount']],
				'splice': ['Service Cost: ']
			}
		}
		var dimensionConf = dimensionsByType[initObj['unitType']]
		var rows = dimensionConf['dimName'].map(function(dimRow, i) {
			var currRow = dimRow.map(function(attr, j) {
				var max = 10000;
				var min = 0;
				var disabled = false;
				var value = initObj[attr];
				if(attr === 'notes') type = 'text';
				var placeholder = dimensionConf['placeholder'][i][j];
				if(attr === 'unitTotal' && (initObj['unitType'] === 'Square Foot' || initObj['unitType'] === 'Est')) {
					disabled = true;
					value = initObj[attr].toFixed(2);
				}
				if(placeholder === 'Inches') max = 11;
				if(value === 0) value = '';
				return m('input', {
					'placeholder': placeholder,
					'onkeyup': function(e) {
						inputAction(this.value);
					},
					'onchange': function(e) {
						inputAction(this.value);
					},
					'value': value,
					'type': 'number',
					'max': max,
					'min': min,
					'className': 'uk-form-width-small',
					'onkeydown': context['app']['validateInteger'],
					'disabled': disabled
				})		
				function inputAction(value) {
					if(parseInt(value) > max) value = max;
					var setValue = value;
					if(value === '') setValue = 0;
					context['app'][fnOnChange](setValue, initObj, attr);
				}
			})			
			currRow.splice(0, 0, dimensionConf['splice'][i])
			return m('div', {'className': 'sqftinput uk-width-1-1 uk-text-right uk-margin-small-bottom'}, currRow);
		})
			
		return rows;
	},
	
	notePanel: function(initObj) {
		/**
			@initObj.model is the base model where notes live
			@initObj.fnOnEdit
			@initObj.fnOnDelete
		**/
		var context = DAB.context();
		var noteModel = initObj['model'][initObj['modelAttr']];
		var parentClass = 'noteContainer uk-flex uk-flex-wrap uk-flex-wrap-space-around uk-grid-width-large-1-2 uk-grid-width-small-1-1 uk-grid-width-xlarge-1-3';
		var panelInnerClass = 'uk-flex-item-1 uk-flex-middle uk-panel-box individualPanel';
		
		return m('div', {'className': parentClass},
			noteModel.map(function(note, i) {
				if(note['type'] !== initObj['type']) return '';
				
				var displayType;
				var iconClass;
				switch(note['type']) {
					case 'sticky':
						displayType = 'Client Note';
						iconClass = 'uk-icon-sticky-note';						
					break;
					case 'internal':
						displayType = 'Internal-Only Note';
						iconClass = 'uk-icon-flag-o';					
					break;
					case 'external': 
						displayType = 'External Note';
						iconClass = 'uk-icon-bookmark';					
					break;
					case 'communication':
						displayType = 'Communication Note';
						iconClass = 'uk-icon-pencil-square-o';					
					break;					
				}

				if(note['active'] === 'N') return;
				var controlsClass = 'uk-width panelcontrols';
				
				if(note['isEditing']) {
						return m('div', {'className': 'uk-form-row'}, [
								m('textarea', {'className': 'uk-form-width-large uk-margin-right',
										'onkeyup': function(e) {
												if(e.keyCode === 13){
														note['isEditing'] = false;
														DAB['app']['reDraw']();
												} else {
														DAB['app']['noteChange'](this.value, 'text', note)										
												}
										},
										'value': note['text']
								}),
								m('button', {'className': 'uk-button uk-button-success',
										'onclick': function(e) {
												if(note['type'] !== '' && note['text'] !== '') {
													note['isEditing'] = false;
													DAB['app']['reDraw']();
												}
										}
								}, [
										m('i', {'className':'uk-icon-plus'}),
										'Submit'
								])
						])
				}
				return m('div', {'className': 'uk-flex uk-flex-middle uk-flex-wrap individualPanel uk-panel notepanel'}, [
					m('div', {'className': 'uk-width panelicon'},
						m('i', {'className': iconClass})
					),
					m('div', {'className': panelInnerClass}, [
						m('div', {'className':'uk-margin-small-bottom'}, note['text']),
						m('div', {'className': 'notedetail'}, [
							m('i', {'className': 'uk-icon-user'}),
							displayType + ' Submitted by: ',
							m('span', note['created_by']),
							' on ',
							m('span', Utility.formatDate(note['created_on'])),
							context['components']['noteEditInfo'](note)
						]),
					]),
					m('div', {'className': controlsClass},
													m('a', {},
							m('i', {'className': 'uk-icon-pencil',
								'onclick': function(e) {
									initObj['fnOnEdit'](note);
								}
							})
						),
						m('a', {},
							m('i', {'className': 'uk-icon-minus',
								'onclick': function(e) {
									e.stopPropagation();
									initObj['fnOnDelete'](note, initObj['model'], initObj['modelAttr'], i);
								}
							})
						)
					)
				])
			})
		)
		
	},
	
	noteEditInfo: function(initObj) {
		/** @initObj contains updated_by and updated_on properties**/
		if(!initObj.hasOwnProperty('updated_by') || initObj['updated_by'] === '') return;
		return m('div.uk-text-italic', [
				'Last edited by: ',
				m('span', initObj['updated_by']),
				' on ',
				m('span', Utility.formatDate(initObj['updated_on']))
		])
	},
    
	stickyNote: function(initObj) {
		/** 
			@initObj.created_on is the date the note was first created
			@initObj.text is the body text of the note
			@initObj.created_by is the name of the user who created the note
		**/
			var context = DAB.context();
			var date = Utility.formatDate(initObj['created_on']);
			return m('div', {'className': 'stickyNoteRow uk-form-row ts-miniPanel catchynote uk-margin-small-top'}, 
					m('div', {'className': 'stickyTitle'}, [
							m('div', {'className': ''}, [
									m('i', {'className': 'uk-icon-sticky-note'}),
									m('span', {}, initObj['text']),
									m('span', {'className': 'stickySubtitle'}, [
											m('i', {'className': 'uk-icon-user'}),
											'Client Note ',
											'Submitted by: ',
											m('span', {}, initObj['created_by'] + ' on '),
											m('span', {}, date),
											context['components']['noteEditInfo'](initObj)
									])
							])
					])
			)
	},

	noteBucket: function(initObj) {
		/**
			The note buckets divide the notes by type.
			@initObj.model is the model for the notes
			@initObj.type is the type of note
			@initObj.notes is an array containing all the notes objects that belong in this bucket
			@initObj.iconClass is the icon class which depends on note type
			@initObj.header is the header label for the bucket that depends on the type
		**/
		var context = DAB.context();
		var notePanelInit = context['conf']['notePanel'](initObj['model'], initObj['type']);
		if(initObj['notes'].length === 0) return '';
		return m('div', {'className': 'uk-form-row'}, [
			m('h4.uk-text-bold', {}, [
				m('i', {'className': initObj['iconClass']}),
				initObj['header']
			]),
			m('div', {'className': ''}, [
				context['components']['notePanel'](notePanelInit)
			])
		])
	},

	noteForm: function(initObj) {
		/** @initObj.label is the label for the form
			@initObj.type is the parent type for the note.
			@initObj.fnOnChange is the function that is called when an element on the form changes
			@initObj.model is the base model for the notes entered on the form
			@initObj.noteArray is the array where notes are added for display **this changed slightly from Woodard Rugs
			@initObj.disabled;
		**/
		var context = DAB.context();
		var cons = this;
		var parentClass = 'uk-form uk-form-row uk-margin-bottom uk-margin-top';
		var selectClass = 'uk-margin-right';
		if(context['model']['requiresVerification']['type']) selectClass += ' uk-form-danger';
		var textClass = 'uk-form-width-large uk-margin-right';
		if(context['model']['requiresVerification']['text']) textClass += ' uk-form-danger';
		var noteArray = initObj['noteArray'];
		if(initObj['disabled'] === true) parentClass += ' clickDisable';
		cons.view = function() {
			return m('div', {'className': parentClass}, [
				m('label', {'className': 'uk-form-label'}, initObj['label']),
				m('div', {'className': 'uk-form-controls'}, [
					m('div', {'className': 'uk-form-row'},
						m('select', {'className': selectClass,
							'value': initObj['model']['type'],
							'onchange': function(e) {
								if(initObj.hasOwnProperty('fnOnChange')) initObj['fnOnChange'](this.value, 'type', initObj['model'])
							}
						}, context['components']['noteTypes'](initObj['type'])),
						m('textarea', {'className': textClass,
							'onkeyup': function(e) {
								if(initObj.hasOwnProperty('fnOnChange')) initObj['fnOnChange'](this.value, 'text', initObj['model'])										
							},
							'value': initObj['model']['text']
						}),
						m('button', {'className': 'uk-button uk-button-success',
							'onclick': function(e) {
								e.preventDefault();
								submitNote();
							}
						}, [
							m('i', {'className':'uk-icon-plus'}),
							'Add Note'
						])
					)
				])
			])
		}
		
		function submitNote() {
			if(initObj.hasOwnProperty('fnOnChange')) {
				var id = noteArray.length
				initObj['fnOnChange'](id, 'id', initObj['model']);
				if(initObj['model']['type'] === '' || initObj['model']['text'] === '') {
					if(initObj['model']['text'] === '') context['model']['requiresVerification']['text'] = true;
					if(initObj['model']['type'] === '') context['model']['requiresVerification']['type'] = true;
					context['app'].addNotification('Note type and note text are required', 3000);
					context['app']['reDraw']();
				} else {
					context['model']['requiresVerification'] = {}
					context['app']['createNotePanel'](noteArray, initObj['model']);
				}
			}
		}
		
		return cons.view();
	},

	tableRow: function(initObj) {
		/** tableRow returns a tr which on click execute a function if it exists
			@initObj.baseModel is the model that is returned on click
			@initObj.fnOnClick is the function that is exectuted on row click
			@initObj.cells are the cells that are used to create the table row.
		**/
		return m('tr', {
			'onclick': function(e) {
				if(initObj.hasOwnProperty('fnOnClick')) {
					initObj['fnOnClick'](initObj['baseModel']);
				}
			}
		}, initObj['cells'].map(function(cell) {
				return m('td', cell)
			})
		)

	},

	standardTable: function(initObj) {
		/** tableRow returns a table, may end up adding a search function in the future
			@initObj.columns is an array that has the name of the columns
			@initObj.rows is an array of components.tableRows
			@initObj.shown is a boolean that defines if table is shown
		**/
		var currentModel = DAB.model.currentModel;
		var className = 'uk-table uk-table-striped uk-table-hover';
		if(initObj['shown'] === false) return '';
		return m('table', {'className': className}, [
			m('thead',
				initObj['columns'].map(function(col, i) {
					return m('th', col)
				})
			),
			m('tbody', initObj.rows)
		])
	},
	
	jobBaseContainer: function(initObj) {
		/**
			@initObj is the model created by newJobModel
			This is an aggreggation template so the initObj is just a set of properties
		**/
		var context = DAB.context();
		var jobType = initObj['header']['type'];
		var noteForm = context['conf']['noteForm']('LineItem', initObj['notes']);
		var internalNotesInit = context['conf']['noteBucket'](initObj, 
		'internal', 'uk-icon-pencil', 'Item Note(s) - Internal');
		var externalNotesInit = context['conf']['noteBucket'](initObj, 
		'external', 'uk-icon-pencil', 'Item Note(s) - External');
		var communicationNotesInit = context['conf']['noteBucket'](initObj, 
		'communication', 'uk-icon-pencil', 'Item Note(s) - Communication');
		var userName = context['model']['currentUser']['name'];
		var mainJobClass = '';
		var viewOnly = context['currentModel']['workOrderHeader']['viewOnly'] === true 
		|| ['CL'].indexOf(initObj['header']['status']) !== -1;
		if(viewOnly) mainJobClass += ' clickDisable';
		var attachments = ['photo', 'file'];
		var conf = context['conf']['baseJobConf'](initObj);
		var jobContainer = m('div', {
				'className': 'magic uk-margin-top mainjob uk-form',
				'id': 'current_job'
			},
			m('div', {'className': 'uk-width-1-1 uk-panel uk-panel-box uk-form-horizontal'}, [
				m('div', {'className': mainJobClass}, [
					m('div', {'className': 'uk-form-row jobpanelheader'}, [
						m('h2', [
							m('i', {'className': 'uk-icon-plus'}),
							m('span', initObj['header']['title'])
						]),
						context['conf']['priceDisplay'](initObj)
					]),
					sections(),
					m('div', {'className': 'uk-form-row bottomInfo'}, 
						context['conf']['priceDisplay'](initObj)
					),
					context['components']['noteBucket'](internalNotesInit),
					context['components']['noteBucket'](externalNotesInit),
					context['components']['noteBucket'](communicationNotesInit),
				]),
				context['components']['noteForm'](noteForm),
				m('div', {'className': 'uk-text-right'}, [
					cancelItemButton(),
					m('button', 
						{
							'className': 'uk-button uk-width-2-3 uk-margin-left ts-button-full',
							'onclick': function(e) {
								context['model']['state']['jobOpen'] = null;
								context['app']['reDraw']();
							}
						}, 
					[
						m('i', {'className': 'uk-icon-plus'}),
						'Collapse Item'
					])
				])
			])
		)
		
		if(initObj['state']['loading'] === true) {
			return context['components']['loadingContainer'](jobContainer);
		}	
		return jobContainer;
		
		
		function sections() {
			var sections = ['header', 'detail', 'attachments', 'conditions', 'additional'];
			var returnArray = [];
			sections.forEach(function(sect) {
				returnArray.push(createSection(sect));
				if(conf[sect].length !== 0) returnArray.push(m('hr'));
			})			
			return returnArray;
		}
		
		function createSection(section) {
			return conf[section].map(function(el) {
				return el;
			})
		}
		
		function cancelItemButton() {
			if(context['currentModel']['workOrderHeader']['viewOnly'] === true) return '';
			var className = 'uk-button cancel-job'
			var title = 'Cancel Item';
			if(initObj['header']['status'] === 'CL') {
				className += ' uk-button-danger'
				title = 'Cancelled Item'
			}
			return m('button', 
				{
					'className': className,
					'onclick': function(e) {
						context['app']['removeJob'](initObj['header']['currentIndex']);
					}
					
				},
			[
				m('i', {'className': 'uk-icon-times'}),
				title
			])
		}
		
		function capitalizeFirstLetter(string) {
			return string.charAt(0).toUpperCase() + string.slice(1);
		}
	},
	
	datesContainer: function(initObj) {
		/**
			@initObj.labels are the labels for date pickers.
			@initObj.dates is the name of each date within the model
			@initObj.model is the model which contains the dates
			@initObj.fnOnChange is the fn to call on change
		**/
		var parentClass = 'uk-form-row'
		if(initObj['disabled'] === true) parentClass += ' clickDisable';
		return m('div', {'className': parentClass}, [
			m('label', {'className': 'uk-form-label'}, 'Service Dates'),
			m('div', {'className': 'uk-form-controls'},
				initObj['dates'].map(function(dateName, i) {
					return m('div', {'className': 'ts-miniPanel miniPanelAlt1'}, [
						m('span', {'className': 'uk-text-bold'}, initObj['labels'][i]),
						m('input', {
							'className': 'uk-form-width-small',
							'data-uk-datepicker': "{format: 'MM-DD-YYYY'}",
							'value': date(initObj['model'], dateName),
							'onchange': function(e) {
								var value = this.value
								initObj['fnOnChange'](value, initObj['labels'][i], initObj['model'], dateName)
							}
						})
					])
				})
			)
		])
		
		function date(model, dateName) {
			if(model[dateName] === '') return ''
			return Utility.formatDate(model[dateName])	
		}
	},
	
	colorPicker: function(initObj) {
		/**
			@initObj.model is the object location of the attribute that needs to be changed
			@initObj.modelAttr the attribute of the model that holds the state of this element.
			@initObj.fnOnEdit is the function to run when the selection button is clicked
			@initObj.fnOnSelect is the function to run when color choice is selected
			@initObj.uniqueAttr
			
		**/
		var context = DAB.context();
		var colorNames = Object.keys(context['conf']['colorNames']);
		var colorCodes = context['conf']['colorCodes']();
		var colorPicked = initObj['model'][initObj['modelAttr']] 
		var colorCode = colorCodes[colorNames.indexOf(colorPicked)];
		var status = initObj['model'][initObj['modelAttr'] + 'Status']
		return m('div', {
				'className': 'colorPicker_container'
			}, [
				m('div', {'onclick': function(e) {
						e.stopPropagation();
						var rec = this.parentNode.getBoundingClientRect();
						context['model']['dateOption'] = '';
						context['model']['formX'] = rec.left;
						context['model']['formY'] = rec.bottom;
						context['model']['colorPicker'] = initObj['uniqueAttr'];
						context['app']['reDraw']();
					}	
				}, [
					m('div', {'className': 'preview'},
						m('div', {'className': 'innerPreview',
							'style': 'background-color: ' + colorCode +';',
							'title': colorPicked
						})
					),
					m('div',
						m('i', {'className': 'uk-icon-plus'})
					)					
				]),
				colorPickEditor(context['conf']['colorPallete'])
		])
		
		function colorPickEditor(colorPalette) {
			if(context['model']['colorPicker'] === initObj['uniqueAttr']) {
				var x = context['model']['formX']
				var y = context['model']['formY']
				return m('div', {'style': 'position: fixed; top:' + (y + 2) + 'px; left:' + x + 'px; z-index: 5;', 
						'id': 'color_picker_mithril',
						'oncreate': drawBindings
					},
					m('div', {'className': 'palette_container', 'color-active': true}, 
						m('div', {'className': 'inner_palette'},
							colorPalette.map(function(colorRow) {
								return m('div', {'color-active': true, 'className': 'palette_row'},
									colorRow.map(function(color) {
										var colorName = colorNames[colorCodes.indexOf(color)]
										return m('div', 
											{
												'onclick': function(e) {
													e.stopPropagation();
													initObj['fnOnSelect'](colorName, initObj['model'], initObj['modelAttr'], initObj['modelState']);
												},
												'title': colorName,
												'color-active': true
											}, 
											m('div', {'className': 'palette_color', 'style': 'background-color:' + color +';', 'color-active': true}, '')
										)
									})
								)
							})
						)
					)
				)
			} else {
				return '';
			}
			
			function drawBindings(el, isInit, elContext) {
				if(context['model']['colorPicker'] === initObj['uniqueAttr']) {
					document.addEventListener('click', oneClick)
					document.getElementById('content').addEventListener('scroll', scrolled);
				}
				
				function scrolled() {
					document.getElementById('content').removeEventListener('scroll', scrolled);
					document.removeEventListener('click', oneClick);
					removeModal();
				}
				
				function oneClick (e) {
					var isClickInside = el['dom'].contains(e.target);
					if(!isClickInside) {
						document.removeEventListener('click', oneClick);
						document.getElementById('content').removeEventListener('scroll', scrolled);
						removeModal();
					}
				}
			}
		
			function removeModal() {
				context['model']['colorPicker'] = '';
				context['app']['reDraw']();
			}
		}
	},

	attachmentForm: function(initObj) {
		/**
			@initObj has the label for the form and what type of attachment it takes (photo or file)
			@initObj.fnOnChange is the function to add a new attachment when one is drug into the panel or selected
			@initObj.model is the model that will get changed
			@initObj.modelAttr is the attribute that will get changed
		**/
		var cons = this;
		cons.view = function() {
			if(initObj['modelAttr'] === 'photo') {
				var dragMsg = 'Drag photo here or '
				var linkMsg = 'select a photo'
			} else {
				var dragMsg = 'Drag file here or '
				var linkMsg = 'select a file'
			}
			return [
				m('div', {
					'id': 'dropzone',
					'class': 'uk-placeholder',
					'oncreate': function(element, isInit) {
						if(!isInit) {
							DAB.app.setDragDrop(initObj['fnOnChange'], initObj['model'], initObj['modelAttr'], element);									
						}
					}
				}, [
					m('i', {'class': 'uk-icon-cloud-upload uk-icon-medium uk-text-muted uk-margin-small-right'}),
					m('span', dragMsg),
					m('a', {'class': 'uk-form-file attachafix'}, linkMsg, [
						m('input', {'type': 'file', 'multiple': 'multiple',
							'onchange': function(e) {
								if(initObj.hasOwnProperty('fnOnChange')) initObj['fnOnChange'](e.target.files, initObj['model'], initObj['modelAttr']);
							}
						})
					])
				])
			]
			
		}
		
		return cons.view();
	},
	
	attachmentPhoto: function(initObj) {
		var context = DAB.context();
		context['model']['activeImages'] = [];
		return m('div', 
			initObj['model'][initObj['modelAttr']].map(function(image, i) {
				if(!image['Active']) return;
				context['model']['activeImages'].push(i);
				var currentIndex = context['model']['activeImages'][context['model']['activeImages'].length -1];
				var imageS = 'data:image/;base64,' + image['Data']; 
				return m('div', {'id':'imgrug'}, [
					m('div', {}, [
						m('div', {'className': 'imgDelete',
							'onclick': function(e) {
								e.stopPropagation();
								context['app']['deleteFileOrImage'](image, i, initObj['model'][initObj['modelAttr']]);
							}
						}, 'X'),
						m('a', {
							'img-name': image['FileName'],
							'onclick': function(e) {
								e.stopPropagation();
								context['model']['images'] = initObj['model'][initObj['modelAttr']];
								context['model']['imageSelected'] = currentIndex;
								context['model']['modalOption'] = 'lightbox';
								context['app']['reDraw']();
							}
						}, 
							m('img', {
								'src': imageS
							})
						)
					])
				])
			})
		)
	},
	
	attachmentFile: function(initObj) {
		var app = DAB.app;
		return m('div', 
			initObj['model'][initObj['modelAttr']].map(function(file, i) {
				if(!file['Active']) return;	
				var blob = Utility.b64ToBlob(file['Data']);
				return m('div', {'id':'attachments'}, [
					m('div', [						
					m('div', {'className': 'imgDelete',
							'onclick': function(e) {
								e.stopPropagation();
								DAB.app['deleteFileOrImage'](file, i, initObj['model'][initObj['modelAttr']]);
							}
						}, 'X'),
						m('i', {'className': 'uk-icon-file'}),
						m('button', {
							'className': 'uk-button',
							'onclick': function(e) {
								saveAs(blob, file['FileName'])
							}
						}, file['FileName'])
					])
				])
			})
		)
	},

	tableComponent: function(initObj) {
		/**
			@initObj.fnOnRowClick is a fn to trigger on single click
			@initObj.fnOnRowDbl is a fn to trigger on double click
			@initObj.clickHide if declared false will hide table after clicking
			@initObj.dblHide if declared false will hide table after dbl click
			@initObj.sortButtons is as object that includes the following:
				@title is a string which is shown as a precursor to sort buttons,
				@index is an integer value which tells what row the button will affect
				@options is an array of arrays, the first index of each array is the value 
				to discriminate against, and the second index is the display name of the button
			@initObj.classForRow;
		**/
		var cons = {
			'rows': [],
			'rowsOrig': [],
			'columns': [],
			'objArray': [],
			'shown': [],
			'currentModel': [],
			'sort': [],
			'sortCol': [],
			'sanitized': []
		};
		
		function createTableModels(data, type) {
			/** This function will eventually utilize an array of object to create the precursors for table views
				Depending of what @type is set, @data has to be set accordingly 
				if @type = 'jsonArray' @data needs to be handed as an array of of objects with column : value pairs.
				if @type = 'tableStructure' @data needs to be handed as an object with the following attributes
				@type.columns must be an array of column titles
				@type.cells has to be an array of arrays that have the same length as columns 
			**/
			if(type === 'jsonArray') {
				cons.rows = data.map(function(obj, i) {
					cons.objArray.push(obj);
					return Object.keys(obj).map(function(col) {
						if(i === 0) {
							cons.columns.push(col);
						}
						return obj[col];
					})
				})
			} else if(type === 'tableStructure') {
				var columnNames;
				if(data.hasOwnProperty('colNames')) {
					cons.columns = data['colNames']
				} else {
					columnNames = data['Columns']
					cons.columns = columnNames.map(function(col) {
						return col['Name'];
					});
				}
				cons.rows = data['Rows'];
				cons.objArray = cons.rows.map(function(row, index) {
					row['indexOrig'] = index;
					cons.shown.push(index);
					var cellObj = {}
					sanitize(index, row);
					row.forEach(function(cell, i) {
						cellObj[data['Columns'][i]['Name']] = cell;
					})
					return cellObj
				})
			}
			
			//copy original rows
			cons.rowsOrig = cons.rows.slice();
			if(data['hasOwnProperty']('hiddenCol')) {
				cons.rows = data.Rows.map(function(row, index) {
					var returnRow = [];
					row.forEach(function(col, i) {
						if(data['hiddenCol'].indexOf(i) === -1) {
							returnRow.push(col);
						}
					})
					//If we have hidden columns then we should only search by shown data
					returnRow['indexOrig'] = index;
					sanitize(index, returnRow);
					return returnRow;
				});
				//if we take raw data then columns need to be hidden
				if(!data.hasOwnProperty('colNames')) {
					var tempColumn = [];
					cons.columns.forEach(function(colName, i) {
						if(data['hiddenCol'].indexOf(i) === -1) {
							tempColumn.push(colName);
						}
					})
					cons.columns = tempColumn;
				}
			} 
			
			cons.shown = cons.rows;
			
			cons.sort = cons.columns.map(function(col , i) {
				return 0;
			})
			cons.currentModel = cons.rows;
			
			function sanitize(index, row) {
				cons.sanitized[index] = [];
				row.forEach(function(cell, i) {
					if(cell === null) cell = '';
					cons.sanitized[index][i] = cell.toString().toLowerCase();
				})
			}
		}
		
		function tableRow(rowObj) {
			/** tableRow returns a tr which on click execute a function if it exists
				@rowObj.baseModel is the model that is returned on click
				@rowObj.fnOnRowClick is the function that is exectuted on row click
				@rowObj.cells are the cells that are used to create the table row.
			**/
			var trClass = '';
			if(initObj.hasOwnProperty('classForRow')) {
				initObj['classForRow'].forEach(function(rule) {
					var condition = true;
					var classAppend = rule['className'];
					rule['conditions'].forEach(function(cond) {
						if(rowObj['baseModel'][cond[0]] !== cond[1]) condition = false;
					})
					if(condition === true) trClass += classAppend;
				})
			}
			return m('tr', 
				{'className': trClass,
				'ondblclick': function(e) {
					
					if(rowObj.hasOwnProperty('fnOnRowDbl')) {
						rowObj['fnOnRowDbl'](rowObj['baseModel']);
						if(rowObj['dblHide'] !== false) {
							unDraw()								
						}
					}
				},
				'onclick': function(e) {
					if(rowObj.hasOwnProperty('fnOnRowClick')) {
						rowObj['fnOnRowClick'](rowObj['baseModel']);
						if(rowObj['clickHide'] !== false) {
							unDraw()								
						}
					}
				}
			}, rowObj['cells'].map(function(cell) {
					return m('td', cell)
				})
			)
		}
		
		function standardTable(tObject) {
			/** tableRow returns a table, may end up adding a search function in the future
				@initObj.columns is an array that has the name of the columns
				@initObj.rows is an array of components.tableRows
				@initObj.shown is a boolean that defines if table is shown
			**/
			var className = 'uk-table uk-table-striped uk-table-hover';
			if(tObject['shown'] === false) return '';
			var currentRows = tObject.rows;
			var typingTimer;
			return [
				m('hr'),
				m('table', {'className': className}, [
					m('thead',
						tObject.columns.map(function(col, i) {
							var icon = 'uk-icon-'
							if(cons.sort[i] === 1) icon += 'chevron-up';
							if(cons.sort[i] === -1) icon += 'chevron-down';
							return m('th',{
								'onclick': function() {
									if(cons.sort[i] === 0) {
										cons.sort[i] = 1;
									}
									else {
										cons.sort[i] *= -1;
									}
									sort(i);
								}
							},[m('i', {'className': icon}), ' ' + col])
						})
					),
					m('tbody', currentRows),
				]),
				m('div', {'className':'uk-margin-top uk-grid'}, [
					m('div', {'className':'uk-width-1-1'}, [
						m('div', {'className':'uk-display-inline-block tablePages', 'ts_table': 'pagination'}, [
								currentButtons()
							]),
						m('div', {'className':'uk-display-inline-block tablePages', 'ts_table': 'pagination'}, 
							sortButtons()
						),
						m('input', {
							'placeholder': 'Filter results',
							'className': 'uk-float-right',
							'onkeyup': function(e) {
								var value = this.value;
								inputAction(value);
							},
							'onchange': function(e) {
								var value = this.value;
								inputAction(value);
							}
							})
						])
					])
			]
			
			function inputAction(value) {
				clearTimeout(typingTimer);
				typingTimer = setTimeout(searchValue, 250);
				function searchValue() {
					search(value);
				}
			}
			
			function sortButtons() {
				if(!initObj.hasOwnProperty('sortButtons')) return '';
				return initObj['sortButtons'].map(function(conf) {
					var sortButton = [m('span', conf['title'])];
					var sortDef = cons['sortCol'][conf['index']];
					var buttons = conf['options'].map(function(opt, i) {
						var buttonClass = 'uk-button ts-button-bold'; 
						if(typeof sortDef !== 'undefined' && opt[0] === sortDef) buttonClass += ' uk-active';
						return m('button', {
							'className': buttonClass,
							'onclick': function(e) {
								sortCol(conf['index'], opt[0])	
							}
						}, opt[1])
					})
					var allClass = 'uk-button ts-button-bold';
					if(typeof sortDef === 'undefined') allClass += ' uk-active'
					buttons.push(m('button', {
						'className': allClass,
						'onclick': function(e) {
							sortCol(conf['index'], undefined)	
						}
					}, 'All'));
					var ret = sortButton.concat(buttons);
					return ret;
				})
			}
			
			function currentButtons() {
				var buttonAmt = cons.shown.length / initObj['pagination'];
				if(cons.rows.length % initObj['pagination'] === 0) buttonAmt--;
				var i = cons.rangeStart / initObj['pagination'] - 1;
				var currentSelected = cons.rangeStart / initObj['pagination'];
				if(i <= -1) i = 0;
				var max = Math.floor(buttonAmt) * initObj['pagination'];
				var belowThree = max / initObj['pagination'] <= 3; 	
				var endEdge = currentSelected === Math.floor(buttonAmt) || currentSelected === (Math.floor(buttonAmt) - 1) 
				if(belowThree)  { 
				} else if(endEdge) {
					i = (max / initObj['pagination']) - 2;
				} else if(i > (Math.floor(buttonAmt) - 3) && i < Math.floor(buttonAmt)) {
					i = (max / initObj['pagination']) - 3;
				} else if(i === (Math.floor(buttonAmt) - 3)) {
					i = (max / initObj['pagination']) - 3;
				}
				var end = i + 3;
				if(belowThree) {
					i = 0;
					end = Math.ceil(buttonAmt);
				}
				var indexes = [];
				for(i; i < end; i++) {
					indexes.push(i);
				}
				var buttons = indexes.map(function(index){
					return stdButton(index)
				})
				if(i <= (Math.floor(buttonAmt)) && !belowThree && !endEdge) {
					buttons.push(m('span', '...'))
					buttons.push(stdButton(Math.floor(buttonAmt)));				
				}
				if(i > 3  && !belowThree) {
					var buttons = [stdButton(0), m('span', '...')].concat(buttons);
				}
				return buttons
				function stdButton(index) {
					var buttonClass = 'uk-button ts-button-bold';
					if(index === currentSelected) buttonClass += ' uk-active';
					return m('button', {
						'onclick': function(e) {
							cons.rangeStart = index * initObj['pagination']
							cons.rangeEnd = (index * initObj['pagination']) + initObj['pagination']
							draw();
						},
						'className': buttonClass
					}, index + 1)
				}
			}
		}
		
		function init() {
			createTableModels(initObj['data'], initObj['dataType']);
			cons.rangeStart = 0;
			cons.rangeEnd = cons.rows.length;
			if(initObj['pagination'] !== 0) cons.rangeEnd = initObj['pagination'];
			draw()
		}
		
		function view() {
			var tRows = [];
			var i = cons.rangeStart;
			var end = cons.rangeEnd
			if(end > cons.currentModel.length) end = cons.currentModel.length
			for (i; i < end; i++) {
				var baseObj = {};
				var options = ['fnOnRowDbl', 'fnOnRowClick', 'dblHide', 'clickHide'];
				options.forEach(function(opt) {
					if(initObj.hasOwnProperty(opt)) baseObj[opt] = initObj[opt];
				})
				var currCell = cons.currentModel[i]
				baseObj['cells'] = currCell;
				baseObj['baseModel'] = cons.objArray[currCell['indexOrig']];
				tRows.push(tableRow(baseObj))
			}
			
			return standardTable({
				'columns': cons.columns,
				'rows': tRows,
				'shown': true
			})
		}
		
		function sortCol(index, opt) {
			//
			cons['sortCol'][index] = opt;
			var newSort = [];
			cons.rowsOrig.forEach(function(row, index) {
				var sort = true;
				cons['sortCol'].forEach(function(r, i) {
					if(typeof r === 'undefined') {
						sort = true;
						return;
					}
					if(row[i] !== r) {
						sort = false;
					}
				});
				if(sort) {
					newSort.push(cons.rows[index]);
				}
			})
			cons.shown = newSort;
			cons.rangeStart = 0;
			cons.rangeEnd = initObj['pagination'];
			cons.currentModel = newSort;
			draw();
		}
		
		function sort(i) {
			var sortType = cons.sort[i];
			cons.shown.sort(function(a, b) {
				if(a[i] === null) a[i] = '';
				if(b[i] === null) b[i] = '';
				var compA = a[i].toUpperCase();
				var compB = b[i].toUpperCase();
				if(compA > compB) {
					return 1 * sortType;
				}
				if(compA < compB) {
					return -1 * sortType;
				}
				return 0;
			})
			cons.currentModel = cons.shown;
			draw()
		}
		
		function search(el) {
			var shownRows = [];
			var el = el.toLowerCase();
			if(el !== '') {
				var i = 0
				for(i; i < cons.rows.length; i++) {
					var isShown = false
					var len = cons.rows[i].length;
					var j = 0;
					do {
						if(cons.sanitized[i][j].indexOf(el) !== -1) { 
							shownRows.push(cons.rows[i])
							isShown = true;
						} else {
							j+= 1
						}
					} while (isShown === false && j < len)
				}	
				cons.shown = shownRows;
				cons.rangeStart = 0;
				cons.rangeEnd = initObj['pagination'];
			} else {
				cons.shown = cons.rows;
			}
			cons.currentModel = cons.shown;
			draw();
		}
		
		function draw() {
			m.render(initObj['mountNode'], view());
		}
		
		function unDraw() {
			m.render(initObj['mountNode'], '');
		}
		
		function objectCopy(obj) {
			return JSON.parse(JSON.stringify(obj));
		}
		
		init();
		
		return {
			'draw': function() {
				return view();
			},
			'search': function(val) {
				search(val);
				return view();
			},
			'unDraw': function() {
				unDraw()
			}
		}
	},
			
	newClientForm: function(initObj) {
		/**
			@initObj.fnOnSave
			@initObj.model is the model for the new client. Includes models for billing/service address and contact person if they are added.
		**/
		var context = DAB.context();
		var notesObj = context['conf']['noteForm']('Client');
		var clientNotesInit = context['conf']['noteBucket'](initObj['model'], 'sticky', 'uk-icon-user', 'Client Notes(s)');
		var internalNotesInit = context['conf']['noteBucket'](initObj['model'], 'internal', 'uk-icon-flag', 'Client Notes(s) (Internal)');
		notesObj['noteArray'] = initObj['model']['notes'];
		
		return m('div.uk-width-5-6 uk-container-center', 
			m('div', {'className': 'uk-panel uk-panel-box uk-margin-top'}, [
				m('div', {'className': 'uk-clearfix uk-margin-top'},
					m('h2', {'className': 'uk-text-bold uk-text-primary'}, [
						m('i', {'className': 'uk-icon-plus'})
					], 'Add New Client')
				),
				m('hr'),
				m('div', {'className': 'uk-form uk-form-horizontal'}, [
					m('div', {'className': 'uk-form-row'}, [
						context['components']['setInput']({
							model: initObj['model'],
							attribute: 'FirstName',
							placeHolder: 'First Name', 
							className: 'uk-form-width-medium uk-margin-right',
							requiredBool: context['model']['requiresVerification']['FirstName'] 
						}),
						context['components']['setInput']({
							model: initObj['model'],
							attribute: 'LastName',
							placeHolder: 'Last Name',
							className: 'uk-form-width-medium uk-margin-right'
						}),
						m('text', {'className': 'uk-text-bold uk-margin-right'}, 'OR'),
						context['components']['setInput']({
							model: initObj['model'],
							attribute: 'Name',
							placeHolder: 'Company Name',
							className: 'uk-form-width-medium',
							requiredBool: context['model']['requiresVerification']['Name'] 
						}),
						context['components']['verifyMessage'](initObj['model'], 'VerifyName', 'Name is required')
					]),
					m('hr'),
					m('div', {'className': 'uk-form-row'}, [
						m('label', {'className': 'uk-form-label'}, 'Client Type'),
						m('div', {'className': 'uk-form-controls'},
							context['components']['setSelect'](initObj['model'], 'CustType', 'type', 
							context['components']['customerTypes']())
						)
					]),
					m('hr'),
					context['components']['resaleInfo'](initObj['model']),
					m('div', {}, [
						m('h4', {}, 'Client Information'),
						context['components']['formGroupPhone']('Home Phone Number', initObj['model'], 'Phone1'),
						context['components']['formGroupPhone']('Cell Phone Number', initObj['model'], 'Phone2'),
						context['components']['formGroupPhone']('Business Phone Number', initObj['model'], 'Cell'),
						context['components']['verifyMessage'](initObj['model'], 'VerifyPhone', 'At least one phone number is required'),
						context['components']['formGroup']('Email Address', initObj['model'], 'Email', 'example@example.com', 'uk-form-width-medium email', 'uk-icon-envelope'),
						context['components']['verifyMessage'](initObj['model'], 'VerifyEmail', 'Must have format example@example.com'),
						m('div', {'className': 'uk-form-row'}, [
							m('label', {'className': 'uk-form-label'}, 'Email Preferences'),
							m('div', {'className': 'uk-form-controls'}, 
								m('div', {'className': 'uk-form-icon'}, [
									m('i', {'className': 'uk-icon-envelope'}),
									context['components']['setSelect'](initObj['model'], 'EmailPref', '', 
									context['components']['emailPrefs']())
								])
							)
						]),						
						m('hr'),
						context['components']['newContactComponent'](initObj['model']),
						context['components']['formGroupAddress']('Bill-To Address', initObj['model']['BillAddress'], true, 'newBP'),
						m('div.uk-form-controls uk-margin-bottom', [
							m('button', {'className': 'uk-button uk-button-medium', 
								'onclick': function(e) {
									Object.keys(initObj['model']['BillAddress']).map(function(line) {
										if(line !== 'Type') initObj['model']['ShipAddress'][line] = initObj['model']['BillAddress'][line]
									});
									context['app']['reDraw']();
								}
							}, [
								m('i.uk-icon-exchange'),
								'Set Billing Address to Service Address'])					
						]),
						context['components']['formGroupAddress']('Service Address', initObj['model']['ShipAddress'], true, 'newBP'),
						m('hr'),
						context['components']['formGroup']('Client Code', initObj['model'], 'Code', 'Client Code', 'uk-form-width-medium code'),
						context['components']['verifyMessage'](initObj['model'], 'VerifyCode', 'A customer with this code already exists. Please provide a unique code.'),
						m('hr'),
						context['components']['noteForm'](notesObj),
						context['components']['noteBucket'](clientNotesInit),
						context['components']['noteBucket'](internalNotesInit),
						m('div', {'className': 'uk-form-row'}, [
							m('button', {'className': 'uk-button uk-button-success uk-margin-right',
								'onclick': function(e) {
									e.preventDefault();
									initObj['fnOnSave'](initObj['model'], 'newClient');
								}
							}, 'Save Client'),
							m('button', {'className': 'uk-button uk-button-danger', 
								'onclick': function(e) {
									context['model']['newClient'] = context['model'].newClientModel();
									context['app']['setRoute'](['search']);
								}
							}, 'Cancel')
						
						]),
					])
				])
			])	
		
		)
	},

	headers: function(initObj) {
		var context = DAB.context();
		return m('header', {
			'className': 'uk-grid uk-grid-collapse'
			},
			m('div', {'className': 'uk-width-1-1'},
				m('nav', {'className': 'uk-navbar'},
					ulMagic()
				)
			)
		)
		
		function ulMagic() {
			var liClass = '';
			if(initObj.hasOwnProperty('mainTitle')) liClass += 'uk-active';
			var baseUL = [
				m('ul', {'className': 'uk-navbar-nav uk-margin-large-left'},
					m('li', {'className': liClass},
						m('a', {'className': 'uk-navbar-nav-subtitle uk-text-center'}, mainTitle())
					)
				)
			]
			
			var routes = initObj['routes'].forEach(function(routeObj) {
				baseUL.push(
					m('ul', {'className': 'uk-navbar-nav uk-margin-large-left'},
						m('li', {'onclick': function(e) {
								e.stopPropagation();
								routeObj['fnOnClick'](routeObj['routeToGo']);
							}
						},
							m('a', {'className': 'uk-navbar-nav-subtitle'},
								[
									m('i', {'className': 'uk-icon-' +  routeObj['icon']}),
									routeObj['msg'],
									m('div', routeObj['subMsg'])
								]
							)
						)
					)
				);
			});
			return baseUL;
			
			function mainTitle() {
				if(!initObj.hasOwnProperty('mainTitle')) return '';
				return [
					m('i', {'className': 'uk-icon-arrow-circle-down'})
					, ' ' + initObj['mainTitle'],
					m('div', initObj['subTitle'])
				]
			}
		}
	},
	
	datePicker: function(initObj) {
		/** @initObj.dateOption is a unique id of the datepicker, there shouldn't be 2 datepickers
			with same id on the view.
			@initObj.model is the location of the attribute that will change
			@initObj.modelAttr is the name of the attribute
			@DAB.model.baseDate is an attribute that is application global, there shouldn't be 2 calendars open
			at any point in time, so we utilize the same attribute across the application.
			@initObj.customElement is an element which replaces the main input
			@initObj.fnOnDateChange is a function that is triggered and returns args model, modelAttr, date
			@initObj.parentWrite
		**/
		var context = DAB['context']();
		if(typeof initObj['parentWrite'] !== 'function') {
			initObj['parentWrite'] = context['app']['reDraw'];
		}
		return [
			triggerElement(),
			datePicker()
		]
		
		function triggerElement() {
			if(typeof initObj['customElement'] !== 'undefined') {
				initObj['customElement']['attrs']['onclick'] = setDatePicker;
				return initObj['customElement'];
			} else {
				return m('input', {
					'className': 'uk-form-width-small',
					'onkeydown': context['app']['validateDate'],
					'onkeyup': function(e) {
						if(e.keyCode === 9 || e.keyCode === 16) return;
						context['model']['dateOption'] = '';
						initObj['model'][initObj['modelAttr']] = this.value;
						if(context['model']['removeBindings'] !== null) context['model']['removeBindings']();
						initObj['parentWrite']();
					},
					'onchange': function(e) {
						context['model']['dateOption'] = '';
						var date = this.value;
						initObj['model'][initObj['modelAttr']] = date;
						if(initObj.hasOwnProperty('fnOnDateChange') && initObj['fnOnDateChange'] !== false) {
							initObj['fnOnDateChange'](initObj['model'], initObj['modelAttr'], date);
							return removeModal();
						}
						if(context['model']['removeBindings'] !== null) context['model']['removeBindings']();
						initObj['parentWrite']();
					},
					'onclick': setDatePicker,
					'onfocus': setDatePicker,
					'value': initObj['model'][initObj['modelAttr']]
				})
			}
		}
		
		function focusEvent(el) {
			if(el['state']['binded'] !== true) {
				context['app']['setDateInput'](el, initObj['model'], initObj['modelAttr']);
				el.addEventListener('focus', focus);
				el['state']['binded'] = true;
			}

			function focus(e) {
				if(context['model']['removeBindings'] !== null) context['model']['removeBindings']();
				setDatePicker(e);
			}
		}

		function setDatePicker(e) {
			e.stopPropagation();
			context['model']['colorPicker'] = '';
			var rec = e.target.getBoundingClientRect();
			context['model']['formX'] = rec.left;
			context['model']['formY'] = rec.bottom;
			context['model']['dateOption'] = initObj['dateOption'];
			if(initObj['model'][initObj['modelAttr']] !== '' && initObj['model'][initObj['modelAttr']] !== null) {
				context['model']['baseDate'] = new Date(initObj['model'][initObj['modelAttr']]);
			} else {
				context['model']['baseDate'] = new Date(context['app']['rightNow']());
			}
			initObj['parentWrite']();
		}

		function datePicker() {
			if(initObj['dateOption'] !== context['model']['dateOption']) return '';
			var days = ['Mon', 'Tue', 'Wed' , 'Thu', 'Fri', 'Sat', 'Sun'];
			var monthNames = ["January", "February", "March", "April", "May", "June",
			  "July", "August", "September", "October", "November", "December"
			];
			var setDates;
			var baseDate = context['model']['baseDate'];
			var firstDay = new Date(baseDate.getFullYear(), baseDate.getMonth(), 1);
			var extraFirst = (firstDay.getDay() + 6) % 7;
			var lastDay = new Date(baseDate.getFullYear(), baseDate.getMonth() + 1, 0);
			var extraEnd = 7 - lastDay.getDay();
			var dates = [];
			var monthAmt = lastDay.getDate();
			var done = true;
			var dateToday = context['model']['today'];
			var currentDate = initObj['model'][initObj['modelAttr']];
			var daySelected;
			var currentDateObj = new Date(currentDate)
			if(currentDate === '') {
				var compareDates = sameDate(baseDate, dateToday)
				if(compareDates[1] === true && compareDates[2] === true) daySelected = dateToday.getDate();
			} else {
				var compareDates = sameDate(baseDate, currentDateObj);
				if(compareDates[1] === true && compareDates[2] === true) daySelected = currentDateObj.getDate();
			}
			for(var counter = extraFirst - 1; counter > -1; counter--) {
				dates.push(counter * -1);
			}
			for(var cnt = 1; cnt < (monthAmt + extraEnd + 1); cnt++) {
				dates.push(cnt);
			}
			var daysTot = monthAmt + extraFirst + extraEnd;
			var nextCount = 0;
			var dateRows = [];
			while(nextCount < daysTot) {
				dateRows.push(dates.slice(nextCount, nextCount + 7));
				nextCount += 7;
			}
			var x = context['model']['formX'];
			var y = context['model']['formY'];
			var top = (y) + 'px';
			if(window.innerHeight - context['model']['formY'] < 317) {
				top = (y - 307) + 'px';
			}
			return m('div', { 'className': 'uk-dropdown uk-datepicker',
				'style':'position:fixed; top:' + top + '; left:' + x + 'px; display: block; ',
				'id': 'date_picker_mithril',
				'oncreate': drawBindings}, [
				m('div', {'className': 'uk-datepicker-nav'}, [
					m('a', {'className': 'uk-datepicker-previous', 'onclick': datePrev}),
					m('a', {'className': 'uk-datepicker-next', 'onclick': dateNext}),
					m('div', {'className': 'uk-datepicker-heading'},
						monthNames[baseDate.getMonth()] + ' ' + baseDate.getFullYear()
					)
				]),
				m('table', {'className': 'uk-datepicker-table'}, [
					m('thead',
						m('tr',
							days.map(function(day) {
								return m('th', day);
							})
						)
					),
					m('tbody',
						dateRows.map(function(row) {
							return m('tr',
								row.map(function(dateNum) {
									return dateDisplay(dateNum, baseDate)
								})
							)
						})
					)
				])
			])

			function drawBindings(el) {
				if(el['state']['hasBindings'] !== true && context['model']['dateOption'] === initObj['dateOption']) {
					document.addEventListener('click', oneClick);
					document.addEventListener('keydown', keyBoardEvent)
					document.getElementById('content').addEventListener('scroll', scrolled);
					context['model']['removeBindings'] = removeBindings;
					el['state']['hasBindings'] = true;
				}
				
				function keyBoardEvent(e) {
					if(e.keyCode === 13 || e.keyCode === 9) {
						removeBindings();
						removeModal();						
					}
				}

				function scrolled() {
					removeBindings();
					removeModal();
				}

				function oneClick (e) {
					var isClickInside = el['dom']['contains'](e.target);
					if(!isClickInside) {
						removeBindings();
						removeModal();
					}
				}

				function removeBindings() {
					document.removeEventListener('click', oneClick);
					document.removeEventListener('onkeydown', keyBoardEvent)
					document.getElementById('content').removeEventListener('scroll', scrolled);
					context['model']['removeBindings'] = null;
				}
			}

			function removeModal() {
				context['model']['dateOption'] = '';
				initObj['parentWrite']();
			}

			function dateNext(e) {
				e.stopPropagation();
				setDate(1);
			}

			function datePrev(e) {
				e.stopPropagation();
				setDate(-1);
			}

			function setDate(monthAmt) {
				var newDate = new Date(baseDate.getFullYear(), baseDate.getMonth() + monthAmt, 1);
				context['model']['baseDate'] = newDate;
				initObj['parentWrite']();
			}

			function sameDate(dateOne, dateTwo) {
				var fn = ['getDate', 'getMonth', 'getFullYear'];
				var equal = true;
				var returnArr = fn.map(function(fnName) {
					var compare = dateOne[fnName]() === dateTwo[fnName]()
					if(compare === false) equal = false;
					return compare
				})
				returnArr.push(equal);
				return returnArr;
			}

			function dateDisplay(dateNum) {
				var display;
				var className = {}
				var onClick = {
					'onclick': function(e) {
						e.stopPropagation();
						var date = new Date(baseDate.getFullYear(), baseDate.getMonth(), dateNum);
						var dateFormatted = Utility.formatDate(date);
						if(initObj.hasOwnProperty('fnOnDateChange') && initObj['fnOnDateChange'] !== false) {
							initObj['fnOnDateChange'](initObj['model'], initObj['modelAttr'], dateFormatted);
							return removeModal();
						}
						initObj['model'][initObj['modelAttr']] = dateFormatted
						return removeModal();
					}
				};
				if(dateNum < 1 || dateNum > monthAmt) {
					var dateObj = new Date(baseDate.getFullYear(), baseDate.getMonth(), dateNum);
					display = dateObj.getDate();
					className['className'] = 'uk-datepicker-table-muted';
					if(currentDate !== '' && typeof  daySelected === 'undefined') {
						if(sameDate(dateObj, currentDateObj)[3]) {
							className['className'] = 'uk-active';
						}
					}
				} else {
					display = dateNum
					if(dateNum === daySelected) {
						className['className'] = 'uk-active';
					}
				}
				var td = m('td', onClick,
					m('a', className, display)
				) 
				return td; 
			}
		}

	},
	
	loadingContainer: function(el) {
		//element must be given to this function if loading, return this container instead
		//of other container;
		if(!el['attrs'].hasOwnProperty('className')) el['attrs']['className'] = '';
		el['attrs']['className'] += 'blockloadcontainer';
		el['children'].splice(0, 0, m('div', {'className': 'blockload'}));
		el['children'].splice(0, 0, m('div', {'className': 'blockloadcover'}));
		return el;
	},
	
	stoneAndTile: function(initObj) {
		var context = DAB.context();
		var view = m('div', {'className': 'uk-form-row uk-panel-box uk-margin-bottom'},
			m('div', {'className': 'uk-width-1-1'}, [
				title(),
				m('hr'),
				size(),
				m('hr'),
				services(),
				currentServices(),
				conditions(),
				m('div', {'className': 'uk-width-1-1'}, collapseButton())
			])
		)
		return view;
		
		function title() {
			var content = [];
			if(initObj['isEditing'] === false) {
				content = [
					m('div', {'className': 'nameOfItem uk-text-bold uk-h2'}, initObj['nameOfItem']),
					m('div', {
						'className': 'inlinefloat uk-button uk-button-mini',
						'onclick': function(e) { 
							initObj['isEditing'] = true;
							initObj['originalName'] = initObj['nameOfItem'].substr();
							context['app']['reDraw']();
						}
					}, 'Edit')
				]
			} else {
				content = [
					context['components']['inputIcon']({
						'placeholder': 'Area Name',
						'icon': 'pencil',
						'type': 'text',
						'model': initObj,
						'modelAttr': 'nameOfItem',
						'onchange': changeTitle
					}),
					m('button', {
						'className': 'inlinefloat uk-button uk-button-mini uk-button-success',
						'onclick': submitTitle
						},
						m('i', {'className': 'uk-icon-check'})
					),
					m('button', {
						'className': 'inlinefloat uk-button uk-button-mini uk-button-danger',
						'onclick': setOriginal
						},
						m('i', {'className': 'uk-icon-times'})
					)
				]
				
				function changeTitle(value) {
					initObj['nameOfItem'] = value;
				}
				
				function submitTitle() {
					if(initObj['nameOfItem'] === '') return setOriginal();
					initObj['header']['nameOfItem'] = initObj['nameOfItem']; 
					initObj['isEditing'] = false;
					context['app']['reDraw']();
				}
				
				function setOriginal() {
					initObj['nameOfItem'] = initObj['originalName'];
					initObj['header']['nameOfItem'] = initObj['originalName']
					initObj['isEditing'] = false;
					context['app']['reDraw']();
				}
			}
			content.push(collapseButton());
			return content;
		}
		
		function collapseButton() {
			return m('div', {
				'className': 'uk-button panel-collapse uk-button-success uk-float-right',
				'onclick': function(e) {
					e.stopPropagation();
					context['jobOpen']['state']['mainSelection'] = '';
					context['app']['reDraw']();
				}
			}, 'Collapse')
		}
		
		function size() {
			return context['components']['formRow']('Size', context['conf']['sizeRow'](initObj))
		}
		
		function services() {
			var definition = [
				['04-01', 'Standard Cleaning: '],
				['04-02', 'Removal and Replacement: '],
				['04-03', 'Filling: '],
				['04-04', 'Sealer: '],
				['04-05', 'Specialty Services: ']
			]
			var inner = definition.map(function(bWall) {
				var buttonWall = context['components']['buttonWall']({
					'model': initObj,
					'modelAttr': 'services',
					'selections': context['model']['servicesCat'][bWall[0]],
					'fnOnClick': context['app']['addStoneService'],
					'parentClass': 'spaceAdjust6 uk-grid uk-grid-width-1-6 uk-grid-width-xlarge-1-6 uk-grid-width-medium-1-3 ts-checkboxwall'
				})
				return context['components']['formRow'](bWall[1], buttonWall);
			});
			return context['components']['rowElementLegend']({
				'content': inner,
				'title': 'Select Services'
			});
		}
		
		function currentServices() {
			var current = initObj['mainServices'];
			var className = 'uk-grid uk-grid-width-1-4 uk-grid-width-xlarge-1-4 uk-grid-width-medium-1-2 uk-margin-small-left carpet-service-area'
			if(current.length === 0) return '';
			inner = m('div', {'className': className},
				current.map(function(serv, i) {
					var serviceInit = {
						'model': current,
						'modelAttr': i,
						'fnOnCancel': context['app']['cancelStoneService'],
						'panel': initObj
					}
					return context['components']['stoneService'](serviceInit);
				})
			)
			return context['components']['rowElementLegend']({
				'content': inner,
				'title': 'Current Services'
			});
		}
		
		function conditions() {
			var def = [
				['ST-02', 'Material'],
				['ST-03', 'Type'],
				['ST-04', 'Grout'],
				['ST-06', 'Manufacturing / Installation'],
				['ST-08', 'Time & Environment'],
				['ST-09', 'Color Issues']
			]
			var inner = def.map(function(bWall, i) {
				var buttonWall = context['components']['buttonWall']({
					'model': initObj,
					'modelAttr': 'descriptive',
					'selections': context['model']['descriptiveCat'][bWall[0]],
					'fnOnClick': context['app']['addStoneDescriptive'],
					'parentClass': 'spaceAdjust6 uk-grid uk-grid-width-1-6 uk-grid-width-xlarge-1-6 uk-grid-width-medium-1-3 ts-checkboxwall'
				})
				return context['components']['formRow'](bWall[1], buttonWall, ' color-' + i);
			});
			return context['components']['rowElementLegend']({
				'content': inner,
				'title': 'Materials & Conditions'
			});
		}
	},
	
	stoneService: function(initObj) {
		var context = DAB.context();
		var status = {
			'IP': 'In Process',
			'COMP': 'Complete'
		}
		var model = initObj['model'][initObj['modelAttr']];
		var statusKeys = Object.keys(status);
		return m('div', {'className': 'stone_panel'}, 
			m('div', {'className': 'uk-panel-box uk-margin-small-bottom'},
				m('div', {'className': 'uk-form-row'}, [
					m('label', {'className': 'uk-float-left'}, model['nameOfItem']),
					m('div', {'className': 'sqftinput uk-width-1-1 uk-text-right uk-margin-small-bottom'}, [
						'Notes: ',
						m('textarea', {
							'className': 'uk-form-width-large',
							'onkeyup': function(e) {
								model['notes'] = this.value;
							},
							'onchange': function(e) {
								model['notes'] = this.value;
							},
							'value': model['notes']
						})
					]),
					m('div', {'className': 'uk-grid uk-grid-width-1-4 uk-grid-width-xlarge-1-4 uk-grid-width-medium-1-2 uk-margin-small-left carpet-service-area ts-checkboxwall'}, [
						context['components']['inputType'](model, 'carpetRoomAttr')
					]),
				]),
				m('div', {'class': 'removeLine uk-form-row'}, [
					m('div',{'className': 'uk-display-inline-block ts_button_wall'},
						statusKeys.map(function(stat) {
							var buttonClass = 'uk-button ts-button-bold';
							if(model['status'] === stat) buttonClass += ' uk-active'
							return m('button', {
								'class': buttonClass,
								'onclick': function(e) {
									if(model['status'] === stat) {
										return;
									} else {
										context['app']['buttonRadio'](stat, status[stat], model, 'status')
									}
								}
							}, status[stat])
						})
					),
					m('div', {'className': 'uk-display-inline-block'}, [
						cancelButton(), 
						// serviceCost()
					])
				])
			)
		)
		
		function cancelButton() {
			// if(model['type'] === 'lineItem')  {
			var label = 'Remove';
			var cancelClass = 'uk-button item-remove uk-margin-left';
			if(model['key'] !== '') {
				label = 'Cancel';
			} else {
				cancelClass += ' uk-button-danger';
			}
			if(model['cancelled'] === 'Y') {
				cancelClass += ' uk-button-danger';
				label = 'Cancelled';
			}
			return m('button', {
				'class': cancelClass,
				'onclick': function(e) {
					if(initObj.hasOwnProperty('fnOnCancel')) initObj['fnOnCancel'](initObj['model'], initObj['modelAttr'], initObj['panel'])
				}
			}, label)
			// } else {
				// return '';
			// }
		}
	},
	
	addressContainer: function(label, attr, model) {
		var context = DAB.context();
		var workOrderHeader = context['currentModel']['workOrderHeader'];
		var addresses = context['model']['currentClient']['Addresses'].map(function(address) {		
			var addressInit = {
				'hasControls': false
			};
			if(context['workOrderState'][attr + 'State'] === 'select') {
				addressInit['shown'] = true;
				addressInit['fnOnClick'] = context['app']['selectAddressWO'];
				addressInit['model'] = model;
				addressInit['attr'] = attr;
			}
			return context['components']['addressPanel'](addressInit, address, 'Other')
		});
		addresses = m('div', {'className': 'panelFlex'}, addresses);
		if(context['model']['currentClient']['Addresses'].length === 0) {
			addresses = m('span', {'className': 'uk-text-success'}, 'No Addresses Currently on File.');
		}
		var options = [
			m('button', {
				'className': 'uk-button uk-button-success existing-address',
				'onclick': function(e) {
					e.stopPropagation();
					context['workOrderState'][attr + 'State'] = 'select';
					context['app']['reDraw']();
				}
				}, [
				m('i', {'className': 'uk-icon-link'}),
				'Choose Existing Location'
			]),
			m('button', {'className': 'uk-button uk-button-success existing-address',
				'onclick': function(e) {
					e.stopPropagation();
					var newAddress = context['model']['addressModel']('Other');
					newAddress['sourceWorkOrder'] = attr;
					newAddress['noType'] = true;
					context['model']['currentModel'][attr + 'AddressNew'] = newAddress;
					context['workOrderState'][attr + 'State'] = 'new';
					context['app']['reDraw']();
				}
				}, [
				m('i', {'className': 'uk-icon-plus'}),
				'Add New Location'
			])
		]
		if(context['workOrderState'][attr + 'State'] === 'select') {
			options.push(
				m('button', {'className': 'uk-button uk-button-danger existing-address',
					'onclick': function(e) {
						e.stopPropagation();
						context['workOrderState'][attr + 'State'] = '';
						context['app']['reDraw']();
					} 
				}, [
					m('i', {'className': 'uk-icon-times'}),
					'Cancel'
				])
			)
		}
		if(['pickup', 'item'].indexOf(attr) !== -1) {
			options.push(context['components']['zipCodeLookup']());
		}
		var ukFormClass = ' uk-form-horizontal'
		if(context['currentModel']['workOrderHeader']['viewOnly'] === true) ukFormClass+= ' clickDisable';
		var view = [context['components']['formRow'](label, options, ukFormClass)];
		var selectionLabel = 'Choose ' + attr.substring(0,1).toUpperCase() + attr.substring(1) + ' Address';
		if(context['workOrderState'][attr + 'State'] === 'select') {
			view.splice(0,0, context['components']['formRow'](selectionLabel, addresses, ukFormClass));					
		} 
		var mainLabel = attr.substring(0,1).toUpperCase() + attr.substring(1) + ' Address';
		if(!context['app']['objIsEmpty'](model[attr + 'Address'])) {
			var addressInit = {
				'hasControls': false,
				'shown': true,
				'selected': true,
				'fnOnClick': function(e) {
					context['workOrderState'][attr + 'State'] = '';
					context['app']['reDraw']();
				}
			};
			var currentAddress = context['components']['addressPanel'](addressInit, model[attr + 'Address'], 'Other')
			view.splice(0,0, context['components']['formRow'](mainLabel, currentAddress, ukFormClass));
		}
		if(context['workOrderState'][attr + 'State'] === 'new') {
			var newAddressModel = {
				'AddAddress': true,
				'Address': context['model']['currentModel'][attr + 'AddressNew'],
				'fnOnCancel': context['app']['cancelNewAddress'],
				'attr': attr,
				'model': model
			}
			var newAddress = context['components']['newAddressComponent'](newAddressModel);
			view.splice(0,0,  newAddress)
		}
		
		return view
	},
	
	zipCodeLookup: function() {
		var context = DAB.context();
		return m('button', {
				'className': 'uk-button uk-float-right',
				'onclick': function(e) {
					e.stopPropagation();
					context['model']['modalOption'] = 'zipCodeView';
					context['app']['reDraw']();
				}			
			}, 'Zip Code Lookup')
	},
	
	zipCodeView: function() {
		return m('div', {'className': 'zip_look_up'}, m('img', {'src': 'img/ServiceDates.png'}))
	},
	//--------------------------------------------------------------------------------------------|
	//-------------------------------Main Templates Functions-------------------------------------|
	//--------------------------------------------------------------------------------------------|
	
	invoicePage: function() {
		var context = DAB.context();
		var paymentObj = context['conf']['paymentObj']();
		paymentObj['showOnly'] = false;
		var invoice = m('div', {'className': 'uk-form'}, [
			m('h2', context['currentModel']['workOrderHeader']['documentName']),
			context['components']['paymentPanel'](paymentObj),
			m('button', {
				'onclick': function(e) {
					context['model']['createInvoicePayment']();
				},
				'className': 'uk-button uk-button-large uk-button-primary'
			}, 'Submit Payment'),
			m('button', {
				'onclick': function(e) {
					context['app']['setRoute'](['workorder', context['route'][4], context['route'][1]]);
				},
				'className': 'uk-button uk-button-large uk-button-primary'
			}, 'View base document'),
			m('button', {
				'onclick': function(e) {
					context['app']['setRoute'](['workorder', context['route'][4], context['route'][1]]);
				},
				'disabled': true,
				'className': 'uk-button uk-button-large uk-button-primary'
			}, 'View PDF')
		]);
		if(context['model']['stateLoaded'] === false) {
			return context['components']['loadingContainer'](invoice);
		}
		return invoice;
	},
	
	commissionsPage: function() {
		var context = DAB.context();
		var dates = ['sDate', 'eDate'];		
		var tableLoading = '';
		if(context['model']['tableLoading'] === true) tableLoading = 'mainTableWrapper loading';
		return m('div', {'className': 'uk-width-5-6 uk-container-center'}, [
			m('br'),
			m('br'),
			m('div', {'className': 'uk-grid'},
				m('div', {'className': 'uk-width-1-1'},
					m('div', {
						'className': 'uk-form uk-form-horizontal',
						'id': 'mainform'
					},
						m('div', {
							'className': 'uk-form-row',
							'id': 'customerSearchDialog'
						}, [
							m('h2', 'Search Current Commissions'),
							'Start Date:' ,
							context['components']['datePicker']({
								'modelAttr': 'sDate',
								'dateOption': 'sDateCommission',
								'model': context['currentModel']['commissionSearch']						
							}),
							'End Date:' ,
							context['components']['datePicker']({
								'modelAttr': 'eDate',
								'dateOption': 'eDateCommission',
								'model': context['currentModel']['commissionSearch']						
							}),
							'Document:', 
							m('input', 
								{'className': 'uk-margin-right uk-form-width-medium', 
									'onkeyup': modifySearch,
									'onchange': modifySearch,
									'value': context['currentModel']['commissionSearch']['document']
								}),
							m('button', 
								{'className':'uk-button',
								'onclick': context['app']['searchCommission']
							}, 'Search Commission Database'),
							m('div', {
								'id': 'commission_search',
								'className': tableLoading
							}),
							selectedCommission()
						])
					)
				)
			)	
		]);
		
		function modifySearch(e) {
			context['currentModel']['commissionSearch']['document'] = this.value;
		}
		
		function selectedCommission() {
			if(context['currentModel']['selectedComm'] === '') return '';
			var titleByAttr = {
				'commAmt': 'New Commission'
			}
			var inputs = Object.keys(titleByAttr).map(function(attr) {
				var input = m('input', {
					'onkeydown': context['app']['validateFloat'],
					'onkeyup': setAttribute,
					'onchange': setAttribute,
					'value': context['currentModel']['selectedComm'][attr]
				})
				return context['components']['formRow'](titleByAttr[attr], input); 
				function setAttribute(e) {
					var value = this.value;
					if(isNaN(value)) value = 0;
					context['currentModel']['selectedComm'][attr] = value;
					context['app']['reDraw']();
				}
			})
			
			inputs.push(m('button', {
				'className': 'uk-button uk-button-success',
				'onclick': context['model']['saveCommission']
			}, 'Overwrite Commission'));
			return inputs;
		}
	},
	
	loginPage: function() {
		var context = DAB.context();
		var currentModel = context['model']['currentModel'];
		return m('div', {'className':"loginPage"},
			m('div', {'className':"uk-vertical-align uk-text-center uk-height-1-1"},
				m('div', {
					'className':"uk-vertical-align-middle",
					'style':"width: 250px;"
				}, [
					m('img', {
						'className':"uk-margin-bottom",
						'width': '240',
						'height': '220',
						'src': 'img/daburnslogo.png'
					}),
					m('form', {'className':"uk-panel uk-panel-box uk-form"}, [
						m('div', {'className':"uk-form-row uk-margin-bottom"},
							m('input', {
								'className':"uk-width-1-1 uk-form-large required",
								'id':"loginUsername",
								'type':'text',
								'placeholder': 'User Name',
								'value': currentModel['username'],
								'onkeyup': function(e) {
									currentModel['username'] = this.value;
								},
								'onchange': function(e) {
									currentModel['username'] = this.value;
								}
							})	
						),
						m('div', {'className':"uk-form-row uk-margin-bottom"},
							m('input', {
								'className':"uk-width-1-1 uk-form-large required",
								'type': 'password',
								'placeholder': 'Password',
								'value': currentModel['password'],
								'onkeyup': function(e) {
									currentModel['password'] = this.value;
								},
								'onchange': function(e) {
									currentModel['password'] = this.value;
								}
							})
						),
						m('div', {'className':"uk-form-row"},
							m('div', {
								'className':"uk-width-1-1 uk-button uk-button-login uk-button-large",
								'onclick': context['app']['loginSubmit']
							}, 'Login')
						)
					])
				])
			)
		)
	},
	
	usersPage: function() {
		var context = DAB.context();
		var tableLoading = ''
		if(context['model']['tableLoading'] === true) tableLoading = 'mainTableWrapper loading';
		var div = m('div', {'className': 'uk-width-5-6 uk-container-center'}, [
			m('br'),
			m('br'),
			m('div', {'className': 'uk-grid'},
				m('div', {'className': 'uk-width-1-1'},
					m('div', {
						'className': 'uk-form uk-form-horizontal',
						'id': 'mainform'
					},
						m('div', {
							'className': 'uk-form-row',
							'id': 'customerSearchDialog'
						}, [
							m('h2', 'Users'),
							m('div', {
								'id': 'table_search',
								'className': tableLoading,
								'oncreate': context['app']['createUserTable']
							}),
							m('button', 
								{
									'className': 'uk-button uk-button-success',
									'onclick': function(e) {
										context['currentModel']['issues'] = [];
										context['currentModel']['userObj'] = context['model']['newUserModel']();
										context['currentModel']['userSelected'] = 'new';
										context['app']['reDraw']();
									}
								}, 
							'Add New User'),
							selectedUser()
						])
					)
				)
			)
		])
		if(context['currentModel']['isLoading'] === true) return context['components']['loadingContainer'](div);
		return div;
		function selectedUser() {
			if(context['currentModel']['userSelected'] === '') return '';
			var inputs = [
				['key', 'User ID'],
				['UserName', 'User Name'], 
				['firstName', 'First Name'],
				['lastName', 'Last Name'], 
				['name', 'Display Name'],
				['password', 'User Password'],
				['password2', 'Retype Password']
				
			];
			var booleans = [
				['sales', 'AOS'],
				['cleanTech', 'ONLO Cleaning Technician'],
				['upholstery', 'In Plant Upholstery Cleaning'],
				['repTech', 'Repair Technician'],
				['rugCutter', 'Pad Cutter'],
				['padComm', 'Rug Pad commission Receivable'],
				['servCoord', 'Service Coordinator'],
				['admin', 'Admin'],
				['manager', 'Manager'],
				['active', 'Active']
			]
			if(context['currentModel']['userSelected'] !== 'new') inputs[5][1] = 'New Password'
			var div = m('div', {'className': 'uk-width-1-3 uk-panel uk-panel-box'})
			var panel = div['children'];
			inputs.forEach(function(arr) {
				var disabled = false;
				var type = 'text';
				var className = '';
				if(context['currentModel']['issues'].indexOf(arr[0]) !== -1) className = 'uk-form-danger'; 
				if(['password', 'password2'].indexOf(arr[0]) !== -1) type = 'password';
				if(['key', 'UserName'].indexOf(arr[0]) !== -1) disabled = true;
				if(context['currentModel']['userSelected'] === 'new' && arr[0] === 'key') return '';
				var input = m('input', {
					'value': context['currentModel']['userObj'][arr[0]],
					'onkeyup': fnOnChange,
					'onchange': fnOnChange,
					'disabled': disabled,
					'type': type,
					'className': className
				})
				panel.push(context['components']['formRow'](arr[1], input)); 
				function fnOnChange(e) {
					context['currentModel']['userObj'][arr[0]] = this.value;
					if(context['currentModel']['userSelected'] === 'new') setUserName();
				}
			})
			if(context['currentModel']['issues'].indexOf('mismatch') !== -1) {
				panel.push(context['components']['formRow']('', m('span', {'className': 'uk-text-danger'}, 'Passwords must match'))); 				
			}
			booleans.forEach(function(arr) {
				var buttons = ['Y', 'N'];
				var buttonSelection = buttons.map(function(attr) {
					var className = 'uk-button ts-button-bold'
					if(context['currentModel']['userObj'][arr[0]] === attr) className += ' uk-active';
					return m('buttons', 
						{
							'className': className,
							'onclick': function(e) {
								e.stopPropagation();
								if(arr[0] === 'manager') {
									context['currentModel']['userObj']['managerSwitch'] = 'Y';
								}
								context['currentModel']['userObj'][arr[0]] = attr;
								context['app']['reDraw']();
							}
						},
					attr)
				})
				panel.push(context['components']['formRow'](arr[1], buttonSelection)); 
			})
			panel.push(m('button', {
				'className': 'uk-button uk-button-success',
				'onclick': function(e) {
					e.stopPropagation();
					submitForm();
					// context['model']['saveUser'](context['currentModel']['userObj']);
				}
			}, 'Save User'));
			if(context['currentModel']['userObj']['manager'] === 'Y' && context['currentModel']['userObj']['managerSwitch'] === 'N') {
				var hasDelete = true; 
				if(context['currentModel']['group'].length === 1) hasDelete = false;
				var takenBy = context['components']['selectionAndExtra']({
					'model': context['currentModel'],
					'hasDelete': hasDelete
				}, 'group', 'active');
				var newDiv = m('div', {'className': 'uk-width-1-3 uk-panel uk-panel-box'}, [
					m('h2', 'Add Employees to Management Group'),
					takenBy,
					m('button', {
						'className': 'uk-button uk-button-success',
						'onclick': function(e) {
							e.stopPropagation();
							context['model']['saveManagerGroup']();
						}
					}, 'Save Management Group')
				])
				if(context['currentModel']['currentGroups'] === 'isLoading') {
					newDiv = [m('span', {
						'className': 'uk-icon-spinner uk-icon-spin uk-text-muted uk-text-center'
					}), m('span', {'className': 'uk-text-muted'}, 'Loading Management Info')];						
				}
				div = [div, newDiv];
			}
			return div;
			
			function setUserName() {
				var userObj = context['currentModel']['userObj'];
				if(userObj['firstName'] === '' && userObj['lastName'] === '') {
					context['currentModel']['userObj']['UserName'] = '';
					return context['app']['reDraw']();
				}
				context['currentModel']['userObj']['UserName'] = userObj['firstName'].toLowerCase().substring(0,1) 
				+ '.' + userObj['lastName'].toLowerCase().replace(/[^\w\s]/gi, '');
				return context['app']['reDraw']();
			}
			
			function submitForm() {
				var notBlank = ['firstName', 'lastName', 'name'];
				var issues = [];
				var userObj = context['currentModel']['userObj'];
				notBlank.forEach(function(attr) {
					if(userObj[attr] === '') issues.push(attr);
				})
				if(context['currentModel']['userSelected'] === 'new') {
					if(userObj['password'] === userObj['password2'] && userObj['password'] !== '') {
						userObj['password'] = TwinBcrypt.hashSync(userObj['password'], '$2y$10$kjm.1j6Rxocp03XeNjMtsO');						
					} else {
						issues.push('password');
						issues.push('password2');
						issues.push('mismatch');
					}
				} else {
					if(userObj['password'] !== '') {
						if(userObj['password'] === userObj['password2']) {
							userObj['password'] = TwinBcrypt.hashSync(userObj['password'], '$2y$10$kjm.1j6Rxocp03XeNjMtsO');				
						} else {
							issues.push('password');
							issues.push('password2');
							issues.push('mismatch');
						}
					} else {
						delete userObj['password'];
					}
				}
				context['currentModel']['issues'] = issues;
				if(issues.length === 0) {
					context['currentModel']['isLoading'] = true;
					context['app']['reDraw']();
					context['model']['saveUser'](context['currentModel']['userObj'])
				} else {
					context['app']['reDraw']();
					context['app']['addNotification']('Please fix missing fields before submitting', 3000);
				}
			}
		}
	},
	
	searchPage: function() {
		var context = DAB.context();
		var title = {
			'document': 'Document Search',
			'client': 'Client Search',
			'pdf': 'PDF Document Search',
			'invoice': 'Invoice Search'
		}
		var tableLoading = '';
		if(context['model']['tableLoading'] === true) tableLoading = 'mainTableWrapper loading';
		return m('div', {'className': 'uk-width-5-6 uk-container-center'}, [
			m('br'),
			m('br'),
			m('div', {'className': 'uk-grid'},
				m('div', {'className': 'uk-width-1-1'},
					m('div', {
						'className': 'uk-form uk-form-horizontal',
						'id': 'mainform'
					},
						m('div', {
							'className': 'uk-form-row',
							'id': 'customerSearchDialog'
						}, [
							tableTitle(),
							m('div', {
								'id': 'table_search',
								'className': tableLoading
							}),
							m('h2', m('a', {'onclick': function(e) {
								context['app']['setRoute'](['addclient']);
							 }}, [m('i', {'className': 'uk-icon-plus uk-margin-right'}), 'Add New Client'])),
							m('hr'),
							context['model']['searchConf'].map(function(conf) {
								return context['components']['searchView'](conf);
							})
						])
					)
				)
			)
		])
		
		function tableTitle() {
			var tableType = context['route'][1];
			if(tableType !== '') {
				return m('h2', title[tableType]);					
			} else {
				return '';
			}
		}
	},
	
	summaryPage: function() {
		var context = DAB.context();
		var dateInit = {
			'dateOption': 'dueDate',
			'model': context['model']['currentModel'],
			'modelAttr': 'dueDate'
		}
		return m('div', {'className': 'uk-width-5-6 uk-container-center'}, [
			m('div', {'className': 'uk-grid'},
				m('div', {'className': 'uk-width-1-1'},
					m('div', {
						'className': 'uk-form uk-form-horizontal',
						'id': 'mainform'
					},
						m('div', {
							'className': 'uk-form-row',
							'id': 'customerSearchDialog'
						}, [
							clientHeader(),            
							addNewDocumentButton(),
							tableOptional(),
							rowTitle(),
							m('div', {'id': 'summary_row'})
						])
					)
				)
			)
		])
		
		function addNewDocumentButton() {
			var clientInactive = false;
			if(typeof context['model']['currentModel']['currentClient'] !== 'undefined') {
				clientInactive = context['model']['currentModel']['currentClient']['Inactive'] === 'Y';
			} 
			return [
				m('button', {
					'className': 'uk-button uk-button-large',
					'onclick': function(e) {
						context['app']['setRoute'](['workorder', context['route'][1], 'new'])
					},
					'disabled': clientInactive
				}, 'Add New Document')
			]
		}
		
		function openDocument() {
			var title = 'Document';
			if(context['currentModel']['hasOwnProperty']('rowSelected')) title = context['currentModel']['rowSelected']['U_DABWONumber'];
			if(context['route'][2] === '') {
				return '';
			}
			return m('div', {'className': 'uk-form-row'}, [
				m('h2', {'className': 'uk-text-success'}, title),
				m('button', {
					'className': 'uk-button uk-button-large',
					'onclick': function(e) {
						context['app']['setRoute'](['workorder', context['route'][1], context['route'][2]])
					}
				}, 'Open Current Document')
			])
		}
		
		function tableOptional() {
			if(context['currentModel']['noResults'] !== true) return m('div', {'id': 'summary_table'});
			return m('h2', {'className': 'uk-text-success'}, 'No Document on File.')
		}
		
		function rowTitle() {
			if(context['route'][2] === '') return '';
			var title = '';
			if(typeof context['model']['currentModel']['U_DABWONumber'] !== 'undefined') {
				title = 'Document # ' + context['model']['currentModel']['U_DABWONumber'] + ' Summary';
			} 
			return [
				m('hr'),
				m('h2', title),
				openDocument()
			];
		}
		function clientHeader() {
			var headerInit = context['conf']['clientHeader']();
			if(typeof headerInit['headerModel'] !== 'undefined') {
				return context['components']['clientHeader'](headerInit)
			}
		}
				
		// return context['components']['datePicker'](dateInit);
	},
	
	newClientPage: function() {
		var context = DAB.context();
		var newClientObj = {
			'fnOnSave': context['app']['verifyClientInfo'],
			'model': context['model']['newClient']
		}
		return context['components']['newClientForm'](newClientObj);
	},
	
	clientEditPage: function() {
		var context = DAB.context();
		var initObj = {
			'fnOnSave': context['app']['verifyClientInfo'],
			'model': context['model']['currentClient']
		}

		return context['components']['clientFile'](initObj);
	},
	
	workOrderPage: function() {
		var context = DAB.context();
		var userName = context['model']['currentUser']['name'];
		var jobTable = context['conf']['jobTableConf']();
		var workOrderHeader = context['currentModel']['workOrderHeader'];
		var title = 'Work Order Summary';
		if(jobTable['rows'].length === 0) {
			title = 'No Current Jobs';
		}
		var noteForm = context['conf']['noteForm']('WO', context['currentModel']['notes']);
		var internalNotesInit = context['conf']['noteBucket'](context['currentModel'], 
		'internal', 'uk-icon-pencil', 'Work Order Note(s) - Internal');
		var externalNotesInit = context['conf']['noteBucket'](context['currentModel'], 
		'external', 'uk-icon-pencil', 'Work Order Note(s) - External');
		var communicationNotesInit = context['conf']['noteBucket'](context['currentModel'], 
		'communication', 'uk-icon-pencil', 'Work Order Note(s) - Communication');
		var sampleDocHeader = context['conf']['docHeaderConfiguration']();		
		var addresses = context['conf']['addressConf'](); 
		var clientHeader = context['conf']['clientHeader']();
		var contactSettings = context['conf']['contactSettings']();
		var paymentObj = context['conf']['paymentObj']();
		var containerClass = 'uk-form-controls uk-flex uk-flex-wrap uk-grid-width-large-1-2 uk-grid-width-small-1-1 uk-grid-width-xlarge-1-3'
		var newJobButton = 'uk-button uk-button-large ts-button-bold ts-toggle';
		if(context['currentModel']['workOrderHeader']['viewOnly'] === true) {
			newJobButton += ' clickDisable';
		}
		var viewClass = 'uk-width-5-6 uk-container-center uk-form';
		if(context['currentModel']['completeClass'] === true) {
			viewClass += ' complete';
		}
		if(context['currentModel']['cancelledClass'] === true) {
			viewClass += ' cancelled';
		}
		var bottomButtons = workOrderButton(); 
		var workOrderArray = [
			context['components']['clientHeader'](clientHeader),
			context['components']['documentHeader'](sampleDocHeader), //1 element
			addressOptions(),
			addressAdditional(),
			m('hr'),
			serviceSelect(),
			m('h2', title),
			context['components']['standardTable'](jobTable),
			jobToOpen(),
			m('hr'),
			timeOptions(),
			drivers(),
			context['components']['noteBucket'](internalNotesInit),
			context['components']['noteBucket'](externalNotesInit),
			context['components']['noteBucket'](communicationNotesInit),
			context['components']['noteForm'](noteForm),
			context['components']['formRow']('', 
				context['components']['pricingRow']({'model': workOrderHeader}),
			' uk-form-horizontal'),
			payments(), //18 element
			m('hr'),
			m('div', {
				'className': 'uk-grid'
			}, bottomButtons)
		]
		if(workOrderHeader['key'] !== '') {
			context['app']['moveInArray'](workOrderArray, 17, 2);
		}
		// console.log(newArray);
		var workOrderPage = m('div', {'className': viewClass}, workOrderArray);
		if(context['model']['stateLoaded'] === false) {
			return context['components']['loadingContainer'](workOrderPage);
		}
		return workOrderPage
			
		function serviceSelect() {
			var bContainerClass = '';
			if(context['currentModel']['workOrderHeader']['viewOnly'] === true) {
				bContainerClass = ' clickDisable';
			}
			var buttons = [
				['Rug Cleaning', 'rugJob'],
				['Upholstery Cleaning', 'furnJob'],
				['Fabrication', 'fabJob'],
				['Hand Repair', 'repairJob'],
				['Other', 'otherJob']
			]
			if(context['currentModel']['workOrderHeader']['orderType'] === 'ONLO') {
				buttons = [
					['Upholstery Cleaning', 'onloFurnJob'],
					['Carpet Cleaning', 'carpetJob'],
					['Stone & Tile Cleaning', 'stoneJob']
				]
			}
			return m('div', {'className': 'uk-form-row deleteme', 'id': 'service_main'}, [
				m('div', {'className': 'uk-form-row deleteme uk-margin-bottom-none'},
					m('h2', 'Services')
				),
				m('div', {'className': 'successTint'}, [
					m('label', {'className': 'uk-form-label spaceAdjust4'}, 'Add Item / Service'),
					m('div', {'className': 'uk-form-controls'},
						m('div', {'className': bContainerClass},
							buttons.map(function(button) {
								var buttonClass = 'uk-button uk-button-large ts-button-bold ts-toggle';
								if(context['jobOpen'] !== false && context['jobOpen']['header']['type'] === button[1]) {
									buttonClass += ' uk-active';
								}
								return m('button', {
									'className': buttonClass,
									'onclick': function(e) {
										context['app']['createNewJob'](button[1])
									}
								}, 
									[
										m('i', {'className': 'uk-icon-plus'}),
										button[0]
									]
								)
							})
						)
					)
				])
			])
		}
		
		function addressOptions() {
			if(['SPD', 'ONLO'].indexOf(workOrderHeader['orderType']) === -1) return '';
			var destination = [{'id': 'GSA', 'display': 'Greater Seattle Area'}, {'id': 'OAZ', 'display': 'Outlying Areas'}];
			var fMove = [{'id': 'N', 'display':'No'}, {'id': 'Y', 'display':'Yes'}];
			var returnArray;
			if(workOrderHeader['orderType'] === 'SPD') {
				returnArray = [
					m('hr'),
					context['components']['formRow']('Destination', bWallConf(destination, 'destinationCode'), ' uk-form-horizontal'),
					context['components']['formRow']('Is there furniture to move?', bWallConf(fMove, 'furnitureMoved'), ' uk-form-horizontal'),
					m('hr'),
					context['components']['addressContainer']('Pickup Address Options', 'pickup', workOrderHeader),
					m('hr'),
					context['components']['addressContainer']('Delivery Address Options', 'delivery', workOrderHeader)
				]
			} else if(workOrderHeader['orderType'] === 'ONLO') {
				returnArray = [
					m('hr'),
					context['components']['addressContainer']('Service Address Options', 'service', workOrderHeader)
				]
			}
			return returnArray;
			
			function bWallConf(selections, attr) {
				return context['components']['buttonWall']({
					'selections': selections,
					'model': workOrderHeader,
					'modelAttr': attr,
					'fnOnClick': context['app']['buttonRadio'],
					'parentClass': ''
				})
			}
		}
		
		function jobToOpen() {
			var currentJob = context['model']['state']['jobOpen'];
			if(currentJob === null) {
				return '';
			}
			return context['components']['jobBaseContainer'](context['currentModel']['currentJobs'][currentJob])
		}
		
		function timeOptions() {
			if(['SPD', 'ONLO'].indexOf(context['currentModel']['workOrderHeader']['orderType']) === -1 ||
			context['currentModel']['workOrderHeader']['docType'] === 'CS') return '';
			inner = [];
			var tTime = newSelect('Minutes', 'servTimeHr');
			var servTimeH = newSelect('Hours', 'servTimeMin');
			var servTimeM = newSelect('Minutes', 'travelTime');
			for(var i=1; i < 61; i++) {
				tTime['children']['push'](m('option', i))
			}
			for(var i=1; i< 11; i++) {
				servTimeH['children']['push'](m('option', i));
			}
			for(var i=1; i<4; i++) {
				servTimeM['children']['push'](m('option',  i * 15));
			}
			var inner = [
				m('span', {'className': 'bolding'}, 'Travel: '),
				tTime,
				m('span', {'className': 'bolding'}, ' Service Length: '),
				servTimeH,
				servTimeM
			]
			var formRow = context['components']['formRow']('Time Options', inner);
			formRow['attrs']['class'] = 'uk-form-row uk-form-horizontal';
			return [formRow, m('hr')];
			
			function newSelect(firstLabel, attr) {
				return m('select', {
					'value': context['currentModel']['workOrderHeader'][attr],
					'onchange': function(e) {
						context['currentModel']['workOrderHeader'][attr] = this.value;
					}
					},[
					m('option', 
						{'disabled': true,
						'value': ''}, 
					firstLabel)
				])
			} 
		}
		
		function drivers() {
			var workOrderHeader = context['currentModel']['workOrderHeader'];
			if(workOrderHeader['orderType'] !== 'SPD') return '';
			var driverSelections = context['conf']['createUserSelections']('Driver');			
			return [
				driverRow('pickup', ' Date: ', 'Pickup'),
				driverRow('delivery', ' Delivered Date: ', 'Delivery'),
				m('hr')
			];
			
			function driverRow(attr, dateLabel, label) {
				var row = [
					m('span', {'className': 'bolding'}, 'By: '),
					context['components']['selectionAndExtra']({
						'model': workOrderHeader,
					}, attr + 'Driver', 'Driver'),		
					m('span', {'className': 'bolding'}, dateLabel),
					context['components']['datePicker']({
						'modelAttr': attr + 'Date',
						'dateOption': 'driver' + attr,
						'model': context['currentModel']['workOrderHeader']						
					})
				]
				var formRow = context['components']['formRow'](label, row);
				formRow['attrs']['class'] = 'uk-form-row uk-form-horizontal';
				return formRow;
			}
		}
		
		function payments() {
			if(workOrderHeader['docType'] === 'SP') return '';
			var paymentInit = context['conf']['paymentObj']();
			return context['components']['paymentPanel'](paymentInit);
		}
		
		function workOrderButton() {
			var docType = context['currentModel']['workOrderHeader']['docType']; 
			var docStatus = context['currentModel']['workOrderHeader']['docStatus'];
			// if(context['currentModel']['workOrderHeader']['viewOnly'] === true) return '';
			var titleName = 'Order';
			if(docType === 'SP') {
				titleName = 'Proposal';
			} 
			var buttons = [
				['Save ' + titleName, 'saveEmail', 'save', false], 
				['Save & View Document', 'saveView', 'file-pdf-o', false]
				// ['Save & Email ' + titleName, 'saveEmail', 'envelope', false]
			]
			if((['SCC', 'BCC'].indexOf(workOrderHeader['orderType']) !== -1 || workOrderHeader['key'] !== '') &&
			workOrderHeader['docType'] !== 'SP') {
				buttons.push(['Save & Create Invoice', 'toInvoice', 'arrow-right', false])
			}
			if(workOrderHeader['docType'] === 'SP') {
				buttons.push(['Save & Create Workorder', 'spToWorkOrder', 'arrow-right', false])
			}
			if(workOrderHeader['key'] !== '') {
				buttons.push(['Cancel ' + titleName, 'cancelOrder', 'ban']);
				buttons.push(['Clone ' + titleName, 'cloneAsWO', 'plus-square', false]);
			}
			if(workOrderHeader['docStatus'] === 'IC') {
				buttons = [
					['View Invoice', 'viewInvoice', 'file-pdf-o', true],
					['Clone as Workorder', 'cloneAsWO', 'plus-square', false],
					['Clone as Reservice', 'cloneAsCS', 'plus-square', false],
					['Save Invoice', 'saveEmail', 'save', false]
				];
			}
			if(workOrderHeader['docStatus'] === 'CL') {
				buttons = [];
			}
			iterate = [buttons];
			if(buttons.length === 6) {
				var iterate = [buttons.slice(0, 3), buttons.slice(3)];
			}
			var buttonClass = 'uk-button uk-width-1-1 uk-button-huge ts-button-full ts-button-final uk-padding-left';
			var buttonDiv = iterate.map(function(buttons) {
				return buttons.map(function(b) {
					return m('div', {
							'className': 'uk-margin-bottom uk-width-1-' + buttons.length,
							'oncreate': function(vnode) {
								if(!vnode['dom']['parentNode']['classList'].contains('uk-form')) {
									vnode['dom']['parentNode']['classList'].add('uk-form');
									vnode['dom']['parentNode']['classList'].add('uk-grid');
								}
							}
						}, 
						m('button', {
							'className': buttonClass,
							'onclick': context['app'][b[1]],
							'disabled': b[3]
						}, [
							m('i', {'className': 'uk-icon-' + b[2]}),
							b[0]
						])
					)
				})
			})
			
			return buttonDiv;
		}
		
		function addressAdditional() {
			if(workOrderHeader['orderType'] !== 'ONLO') return '';
			var elements = {
				'additional' :
				[
					['Building Name', 'bName'],
					['Special Access Instructions', 'spAccess'],
					['Do we have the keys?', 'keysAvail'],
					['Parking Instructions', 'parking'],
					['Water Location', 'wLocation'],
					['Pet Notes', 'pets'],
					['Contact Instructions', 'cntcInst'],
					['Special Carpet Conditions', 'carpetCond']
				],
				'marina': [
					['Marina Name', 'mName'],
					['Vessel Name', 'vName'],
					['Marina Access Instructions', 'mAccess'],
					['Dock Number', 'dockNum'],
					['Slip Number', 'slipNum'],
					['Is there electrical access?', 'electricAccs']
				]
			
			}
			var view = [];
			if(!context['app']['objIsEmpty'](workOrderHeader['serviceAddress'])) {
				var options = Object.keys(elements).map(function(elName) {
					return m('button', {
						'className': 'uk-button uk-button-success',
						'onclick': function(e) {
							context['workOrderState'][elName + 'State'] = true;
							context['app']['reDraw']();
						}
					}, 
					context['app']['capitalizeFirstLetter'](elName) + ' Detail')	
				})
				view.push(context['components']['formRow']('Additional Address Information', options, ' uk-form-horizontal'));
			}
			var sections = Object.keys(elements).map(function(elName) {
				var container = context['currentModel']['workOrderHeader'][elName + 'Addr'];
				if(workOrderHeader[elName + 'Addr'].length !== 0 && context['workOrderState'][elName + 'State'] === '') {
					return m('div', {'className': 'uk-panel uk-panel-box lineheightfix'}, [
						m('h2', context['app']['capitalizeFirstLetter'](elName) + ' Detail'),
						elements[elName].map(function(el) {
							var currentElement = context['app']['findInArray'](container, 'subKey', el[1])
							if(currentElement) {
								return context['components']['formRow'](el[0], currentElement['text'], ' uk-form-horizontal');
							} else {
								return '';
							}
						})
						]
					)
				} 
				if(context['workOrderState'][elName + 'State'] === '') return '';
				return m('div', {'className': 'extra-detail'}, 
					[
						elements[elName].map(function(el) {
							var value = '';
							var container = context['currentModel']['workOrderHeader'][elName + 'Addr'];
							var currentElement = context['app']['findInArray'](container, 'subKey', el[1])
							if(currentElement) value = currentElement['text'];
							return m('div', {'className': 'uk-form-row uk-margin-bottom uk-form-horizontal'}, [
								m('div', {'className': 'uk-form-label'}, el[0]),
								m('div', {'className': 'uk-form-controls'},
									m('div', {'className': 'uk-form-row'},
										m('input', {
											'value': value,
											'onkeyup': function(e) {
												if(!currentElement) {
													var newNote = context['model']['newNoteModel']();
													newNote['subKey'] = el[1]
													newNote['text'] = this.value;
													currentElement = newNote;
													container.push(newNote);
												} else {
													currentElement['text'] = this.value;
												}
											},
											'className': 'uk-form-width-large'
										})
									)
								)
							])
						}),
						m('button', 
							{
								'className':'uk-button uk-button-success',
								'onclick': function(e) {
									context['workOrderState'][elName + 'State'] = '';
									context['app']['reDraw']();
								}
							},
						'Set Details')
					]
				)	
			});
			view = view.concat(sections);
			return view;
		}
	},
	
	pdfPage: function() {
		var context = DAB.context();
		if(context['model']['stateLoaded'] === false) {
			return m('div.mainTableWrapper loading');
		} else {
			var src = 'data:application/pdf;base64,' + context['model']['pdf']['FileData'];
			var iFrame = m('iframe', {
				'src': src,
				'style':'width:100%; height:100%;'
			});
			return iFrame;
		}
	}
}