<div id='sidebar'>
	<div id='sidebar-image'>
		<?php
			/*
				displays the featured image/thumbnail
				if no thumbnail is set, or if the page's parent is the home page, uses the chamber logo

				the home page uses it's child pages' thumbnails for display purposes,
				so the thumbnails are going to be set to images and not logos,
				which we don't want to use in the sidebar
			*/
			if (has_post_thumbnail() && $post->post_parent != 5) {
				the_post_thumbnail();
			} else { ?>
				<img src="<?php echo get_template_directory_uri(); ?>/images/header-logo.png"/>
		<?php } ?>
	</div>

	<hr>

	<!-- displays a page explanation under the logo, set in custom field lp_dec -->
	<p id='sidebar-description' class="uk-text-meta">
		<?php /*echo get_post_meta($post->ID, 'lp_desc', true)*/ ?>
	</p>

	<?php
		// the following variables pull data from advanced custom fields,
		// configured to give the user more control over where the sidebar links go

		// for allowing the user to upload a file to be used with the 'download application' link
		$application_id = get_post_meta($post->ID, 'download-application-file', true);
		// same functionality as above, for the 'download brochure' link
		$brochure_id = get_post_meta($post->ID, 'download-brochure-file', true);
		// the address to direct the 'email question' link to
		$email_recipient = get_post_meta($post->ID, 'email-question-recipient', true);
		// gets the id of the page selected in the 'task force' drop down, used to redirect to page
		$task_force_page_id = get_post_meta($post->ID, 'task-force-page-link', true);

		// array of available sidebar options with images and links
		$sidebar_options = array(
			'become a partner' => array(
				'image' => '/icons/icon-member.png',
				'url' => 'index.php?page_id=185'
			),
			'chamber news' => array(
				'image' => '/icons/icon-news.png',
				'url' => 'index.php?page_id=6792'
			),
			'download application' => array(
				'image' => '/icons/icon-application.png',
				'url' => wp_get_attachment_url( $application_id )
			),
			'download brochure' => array(
				'image' => '/icons/icon-brochure.png',
				'url' => wp_get_attachment_url( $brochure_id )
			),
			'calendar' => array(
				'image' => '/icons/icon-calendar.png',
				'url' => 'index.php?page_id=599'
			),
			'contact' => array(
				'image' => '/icons/icon-contact.png',
				// links to about page, where contact info lives
				'url' => 'index.php?page_id=102'
			),
			'business directory' => array(
				'image' => '/icons/icon-directory.png',
				'url' => 'index.php?page_id=1116'
			),
			'email updates' => array(
				'image' => '/icons/icon-enews.png',
				// links to weekly ebeat page
				'url' => 'index.php?page_id=224'
			),
			/*
				this was in their original list of sidebar options,
				but was not being used anywhere on the site

				if added back in, will need to add 'task force login'
				to list of choices in Sidebar->Icons field group in
				advanced custom fields plugin, and supply a url below

				'task force login' => array(
					'image' => '/icons/icon-login.png',
					'url' => ''
				),
			*/
			'map' => array(
				'image' => '/icons/icon-map.png',
				'url' => 'http://local.townsquarepublications.com/oregon/beaverton/'
			),
			'email question' => array(
				'image' => '/icons/icon-question.png',
				'url' => 'mailto:' . $email_recipient
			),
			/*
				also in their original list, now unneccesary due to
				search being ever present in the header

				'search' => array(
					'image' => '/icons/icon-search.png',
					'url' => ''
				),
			*/
			'task force' => array(
				'image' => '/icons/icon-taskforce.png',
				'url' => 'index.php?page_id=' . $task_force_page_id
			)
		);

		// get selected sidebar checkbox meta data from page
		$sidebar_selected_array = get_post_meta( $post->ID, 'sidebar-icons');
		if (empty($sidebar_selected_array[0])) {
			array_push($sidebar_selected_array, 'become a partner', 'chamber news', 'calendar');

			foreach ( $sidebar_selected_array as $default) {
				foreach ($sidebar_options as $key => $value) {
					if ( $default === $key ) {
						echo "<a href='" . $value['url'] . "'>";
						echo "<img src='" . get_template_directory_uri() . $value['image'] ."'>";
						echo "</a>";
					}
				}
			}
		} else {
		//var_dump($sidebar_selected_array);
		// only run code if this array is not empty, meaning sidebar options are checked
			if (count($sidebar_selected_array) > 0) {
				//var_dump($sidebar_selected_array);
				// loop through selected and compare with options
				foreach ( $sidebar_selected_array[0] as $selected ) {
					foreach ( $sidebar_options as $key => $value ) {
						if ( $selected === $key ) {
							echo "<a href='" . $value['url'] . "'>";
							echo "<img src='" . get_template_directory_uri() . $value['image'] ."'>";
							echo "</a>";
						}
					}
				}
			} else {
				// put three default icons in sidebar if none are selected on page
				array_push($sidebar_selected_array, 'become a partner', 'chamber news', 'calendar');

				foreach ( $sidebar_selected_array as $default) {
					foreach ($sidebar_options as $key => $value) {
						if ( $default === $key ) {
							echo "<a href='" . $value['url'] . "'>";
							echo "<img src='" . get_template_directory_uri() . $value['image'] ."'>";
							echo "</a>";
						}
					}
				}
			}
		}
		
		
	?>
</div>
