<?php
	/*
		The template for displaying search results.
	*/
?>

<?php get_header(); ?>

<div id='search-results'>
	<?php if ( have_posts() ) : ?>
		<h1>Search results for: <?php echo get_search_query(); ?></h1>
		

			<?php
			// ensures the original WP_Query is preserved
			// found here: https://codex.wordpress.org/Creating_a_Search_Page
				global $query_string;

				$query_args = explode("&", $query_string);
				$search_query = array();

				foreach($query_args as $key => $string) {
					$query_split = explode("=", $string);
					$search_query[$query_split[0]] = urldecode($query_split[1]);
				} 
				
				// search parameters
				$search_query['post_type'] = array('page', 'post', 'chamber_events');
				$search_query['posts_per_page'] = 10;
		
				// query with parameters
				$search = new WP_Query($search_query);
				
				while($search->have_posts() ) : $search->the_post();
			?>
			
			<div class='search-result'>
				<h3><a href='<?php the_permalink(); ?>'><?php the_title(); ?></a></h3>
				<?php the_excerpt(); ?>
				<a class='view-page' href='<?php the_permalink(); ?>'>View this page</a>
				<br>
				<hr>
			</div>
			
			<?php endwhile; ?>

		
		
		<?php else: ?>
			<h2>Nothing found</h2>
			<p>Sorry, but nothing matched your search criteria. Please try again with some different keywords.</p>
			<?php get_search_form(); ?>
		<?php endif; ?>
		
		<br>
		<?php previous_posts_link('< Previous Results', 0) ?>
        <div id='more-results'>
			<?php next_posts_link('More Results >', 0); ?>   
		</div>
</div>

<?php get_footer(); ?>