<?php
	/*
		Template Name: Store Page
	 */
?>

<?php get_header(); ?>

<div id='store' class="content-pane">
	<?php
		/*
			This code is being reused from the previous theme for two reasons.
			1: It works.
			2: It interacts with a third party storefront called Sage, and it seems silly
				to try and rebuild this code with no knowledge of Sage.
		 */

        // sort function
        function cmp($a, $b) {
			if ($a->order == $b->order) { return 0; }
			return ($a->order < $b->order) ? -1 : 1;
        }

		$args = array('post_type' => 'ch_store_items', 'posts_per_page'=>-1);
        $loop = new WP_Query($args);

		$shoppingItems = array();
		while($loop->have_posts() ) : $loop->the_post();
			// shopping item object
			$sio = (object) array('title' => '', 'content' => '', 'sage' => '', 'order' => '');
			$sio->title = get_the_title();
			$sio->content = get_the_content();
			$sio->thumbnail = get_the_post_thumbnail();
			$sio->sage = get_post_meta($post->ID, 'sage_link', true);
			$sio->order = get_post_meta($post->ID, 'shopping_item_order', true);

			// add object to shopping items array
			$shoppingItems[] = $sio;
		endwhile;

		// sort
		usort($shoppingItems, 'cmp');

		// template url
		$template_url = get_bloginfo('template_url', 'raw');

		// output
		$l = count($shoppingItems) - 1;
		$c = 0;
		foreach($shoppingItems as $item) {
			if($c == 0) {
				echo('<div class="store-item">');
			}
			elseif($c == $l) {
				echo('<div class="store-item">');
			}
			else {
				echo('<div class="store-item">');
			}
				echo('<div id="store-item-title-wrapper"><h1>'. $item->title. '</h1>');
				echo('<a href="'. $item->sage .'" target="_blank">');
				echo('<img class="purchase" src="'. $template_url .'/images/button-purchase.gif" /> </div>');
				echo('</a>');
				echo $item->thumbnail;
				echo('<div class="store-item-content">' . $item->content . '</div>');
			echo('</div>');

			if($c == 2 || $c == 5 || $c == 8) {
				echo('<div></div>');
			}
			$c++;
		}
      ?>
</div>

<?php get_footer(); ?>
