<?php
	/*
		Template Name: Events Page
	*/
?>

<?php get_header(); ?>

<div id="events-page" class="content-pane">
	<div id="events-blog">
		<h1>Upcoming Events</h1>

		<?php
			// get today's date, formatted to match ACF formatting (YYYYMMDD)
			// UNCOMMENT TO MAKE THIS ACTUALLY WORK
			// $date_today = date('Ymd');
			// DEVELOPMENT VERSION = MORE EVENTS
			$date_today = '20150815';

			// set parameter for paging
			$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

			// query custom post type
			// only grab events that are happening today or in the future
			$events_query = new WP_query(
				array(
					'post_type' => 'chamber_events',
					'posts_per_page' => '4',
					'paged' => $paged,
					'meta_key' => 'date_of_event',
					'orderby' => 'meta_value_num',
					'order' => 'DESC',
					'meta_query' => array(
						'key' => 'date_of_event',
						'value' => $date_today,
						'compare' => '>='
					),
				)
			);

			// loop using above query
			if ( $events_query->have_posts() ) : while ( $events_query->have_posts() ) : $events_query->the_post(); ?>
				<!-- only display content, client uploads title, content and image in the actual post content -->
				<div class="event-post">
					<h2><?php the_title(); ?></h2>
					<?php the_content(); ?>
				</div>
			<?php endwhile; ?>

			<div id='pagination'>
				<?php previous_posts_link( 'Previous Events' ); ?>
				<?php next_posts_link( 'More Events', $events_query->max_num_pages ); ?>
			</div>

			<?php wp_reset_postdata(); ?>
			<?php endif; ?>
	</div>

	<div id="events-list">
		<!-- content from events parent post -->
		<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
			<?php the_content(); ?>

		<?php endwhile; endif; ?>
		<!-- child page loop -->
		<?php
			query_posts(array(
				'post_parent' => $post->ID,
				'post_type' => 'page',
				'posts_per_page' => '25',
				'orderby' => 'title',
				'order' => 'ASC'
			)); while ( have_posts() ) { the_post(); ?>
				<!-- event link -->
				<a class="chamber-event" href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
				<!-- description of event from custom field -->
				<p><?php echo get_post_meta( $post->ID, 'lp_desc', true); ?></p>
		<?php }?>
	</div>
</div>

<?php get_footer(); ?>
