<?php
	/*
		Template Name: Events Page
	*/
?>

<?php get_header(); ?>

<div id="events-page" class="content-pane container">
<div id='post-content'>
	<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
	<h1 id='title'><?php the_title() ?></h1>
	<div id="page_subtitle" class="uk-text-center uk-text-meta"><?php echo get_post_meta($post->ID, 'lp_desc', true) ?></div>
	<?php the_content(); ?>
	<div id="events-list">
		<!-- content from events parent post -->

		<?php endwhile; endif; ?>
		<!-- child page loop -->
		<?php
			query_posts(array(
				'post_parent' => $post->ID,
				'post_type' => 'page',
				'posts_per_page' => '25',
				'orderby' => 'title',
				'order' => 'ASC'
			)); while ( have_posts() ) { the_post(); ?>
				<!-- event link -->
				<div>
					<a class="chamber-event" href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
					<!-- description of event from custom field -->
					<p><?php echo get_post_meta( $post->ID, 'lp_desc', true); ?></p>
				</div>
		<?php }?>
	</div>
<?php get_sidebar(); ?>
</div>
</div>

<?php get_footer(); ?>
