<?php
	/*
		Template Name: Beaverton Page
	*/
?>

<?php get_header(); ?>

<div id="beaverton-page" class="content-pane">

	<!-- the loop -->
	<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
		<div id="beaverton-content">
			<?php the_content(); ?>
		</div>

		<div id="page-right">
			<!-- get and embed video from custom field -->
			<div id="embed-video">
				<?php echo wp_oembed_get( get_post_meta( get_the_ID(), 'chamber_video', true)  ); ?>
			</div>
	<!-- close loop -->
	<?php endwhile; endif; ?>

			<div id="more-info">
				<h1>More Info</h1>

				<!-- child page loop -->
				<?php query_posts(array('post_parent' => $post->ID, 'post_type' => 'page')); while ( have_posts() ) { the_post(); ?>
					<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
				<?php }?>
			</div>
		</div>
</div>

<?php get_footer(); ?>
