<?php
/*
Template Name: Application Form Test
*/
get_header();
?>
<script src='https://www.google.com/recaptcha/api.js'></script>

<div id="application" class="container content-pane">
  <div id="application-header">
    <h1>Company Information</h1> <hr />
    <h1>Contact Information</h1> <hr />
    <h1>Membership Level</h1> <hr />
    <h1>Directory</h1> <hr />
    <h1>Payment and Confirmation</h1>
  </div>

  <form id="form-container">
    <div id="company-information" class="form-pane">
      <h1>Company Information</h1>

      <!-- COMPANY NAME -->
      <div><div>
      <label for='company_name'>Company Name</label>
      <input type="text" name="cr_form_company_name" placeholder="Company Name" /> <br /></div>

      <!-- NUMBER OF EMPLOYEES -->
      <div>
      <label for='employee_count'>Number of Employees</label>
      <input type="text" name="cr_form_employees" placeholder="-" /> <br /></div>

      <!-- REFERRED BY  -->
      <div>
      <label for='referred_by'>Referred By (Sponsor)</label>
      <input type="text" name="cr_form_sponsor" placeholder="-" /> <br /></div>

      <!-- MAIN PHONE NUMBER  -->
      <div>
      <label for='phone_number'>Phone Number</label>
      <input type="tel" name="cr_form_phone_number" placeholder="(xxx) xxx-xxxx" /> <br /></div>

      <!-- TOLL FREE NUMBER  -->
      <div>
      <label for='toll_free_number'>Toll Free Number</label>
      <input type="tel" name="cr_form_toll_free" placeholder="(xxx) xxx-xxxx" /> <br /></div>

      <!-- GENERAL EMAIL -->
      <div>
      <label for='general_email'>General Email</label>
      <input type="email" name="cr_form_gen_email" placeholder="example@email.com" /> <br /></div>

      <!-- PERMISSION TO CONTACT -->
      <div>
      <label for='permission_to_contact'>May We Email and/or Fax?</label><span class="radio-button-group"> <span class="radio-label-group">
      <input type="radio" name="cr_form_perm_email" value="yes" /> Yes</span> <br /><span class="radio-label-group">
      <input type="radio" name="cr_form_perm_email" value="no" /> No</span> <br /> </span> </div>
      </div>

      <hr />

      <!-- MAILING ADDRESS GROUP -->
      <div id="application-address-container">
      <div id="mailing-address-group" class="mail-group">
        <h1>Mailing Address</h1>
        <div>
        <label for='mailing_address'>Street</label>
        <input type="text" name="cr_form_address" placeholder="0000 Street" /> <br /></div>
        <br />
        <div>
        <label for='mailing_city'>City</label>
        <input type="text" name="cr_form_city" placeholder="Beaverton" /> <br /></div>

        <div>
        <label for='mailing_state'>State</label>
        <input type="text" name="cr_form_state" placeholder="OR" /> <br /></div>

        <div>
        <label for='mailing_zip'>Zip</label>
        <input type="text" name="cr_form_zip" placeholder="00000" /> <br /></div>
      </div>

      <!-- PHYSICAL ADDRESS GROUP -->
      <div id="physical-address-group" class="mail-group">
        <h1>Physical Address</h1>
        <div>
        <label for='physical_address'>Street</label>
        <input type="text" name="cr_form_py_address" placeholder="0000 Street" /> <br /></div>

        <div>
        <label for='physical_city'>City</label>
        <input type="text" name="cr_form_py_city" placeholder="Beaverton" /> <br /></div>

        <div>
        <label for='physical_state'>State</label>
        <input type="text" name="cr_form_py_state" placeholder="OR" /> <br /></div>

        <div>
        <label for='physical_zip'>Zip</label>
        <input type="text" name="cr_form_py_address" placeholder="00000" /> <br /></div>
      </div>

      <!-- BILLING ADDRESS GROUP -->
      <div id="billing-address-group" class="mail-group">
        <h1>Billing Address</h1>
        <div>
        <label for='billing_address'>Street</label>
        <input type="text" name="cr_form_bi_address" placeholder="0000 Street" /> <br /></div>

        <div>
        <label for='billing_city'>City</label>
        <input type="text" name="cr_form_bi_city" placeholder="Beaverton" /> <br /></div>

        <div>
        <label for='billing_state'>State</label>
        <input type="text" name="cr_form_bi_state" placeholder="OR" /> <br /></div>

        <div>
        <label for='billing_zip'>Zip</label>
        <input type="text" name="cr_form_bi_address" placeholder="00000" /> <br /></div>
      </div>

      <div id="address-control">
        <button type=
        "button" value="physical"><img class="address-control-image" src="<?php echo get_template_directory_uri();?>/icons/physical-address-active.png" />Physical</button>
        <button type=
        "button" value="mailing"><img class="address-control-image" src="<?php echo get_template_directory_uri();?>/icons/mailing-address-inactive.png" />Mailing</button>
        <button type=
        "button" value="billing"><img class="address-control-image" src="<?php echo get_template_directory_uri();?>/icons/billing-address-inactive.png" />Billing</button>

      </div>
      </div>

      <button class="next" type="button" class="next" type="button">Next</button>
    </div>


    <div id="contact-information" class="form-pane">
      <h1>Primary Contact Information</h1>
      <!-- FIRST NAME -->
      <div>
      <label for='contact_first_name'>First Name</label>
      <input type="text" name="cr_form_mc_fname" placeholder="First Name" /> <br /></div>

      <!-- LAST NAME -->
      <div>
      <label for='contact_last_name'>Last Name</label>
      <input type="text" name="cr_form_mc_lname" placeholder="Last Name" /> <br /></div>

      <!-- CONTACT TITLE -->
      <div>
      <label for='contact_title'>Contact Title</label>
      <input type="text" name="cr_form_mc_title" placeholder="Title" /> <br /></div>

      <!-- CONTACT PHONE -->
      <div>
      <label for='contact_phone'>Contact Phone</label>
      <input type="tel" name="cr_form_mc_phone" placeholder="(xxx) xxx-xxxx" /> <br /></div>

      <!-- CONTACT EMAIL -->
      <div>
      <label for='contact_email'>Contact Email</label>
      <input type="email" name="cr_form_mc_email" placeholder="sample@email.com" /> <br /></div>

      <button class="previous" type="button">Previous</button>
      <button class="next" type="button">Next</button>
    </div>


    <div id="membership-level" class="form-pane">
      <h1>Membership Investment</h1>
      <div id="membership-options">
      <span class="radio-button-group membership-option">
      <!-- COMMUNITY PARTNER -->
        <input
        type="radio"
        name="cr_form_mi"
        value="community" /> Community Partner <br></span>

      <!-- POWER PARTNER -->
      <span class="radio-button-group membership-option">
        <input
        type="radio"
        name="cr_form_mi"
        value="power" /> Power Partner <br></span>

      <!-- PREMIER PARTNER -->
      <span class="radio-button-group membership-option">
        <input
        type="radio"
        name="cr_form_mi"
        value="premier" /> Premier Partner <br></span>

      <!-- VISIONARY PARTNER -->
      <span class="radio-button-group membership-option">
        <input
        type="radio"
        name="cr_form_mi"
        value="visionary" /> Visionary Partner <br></span>
      </div>

      <div class="link-entry-group">
        <h1>Links</h1>
      <!-- WEBSITE URL -->
        <div>
        <label for='website_url'>Website URL</label>
        <input type="text" name="cr_form_website" placeholder="http://www.yoursite.com" /> <br /></div>

      <!-- TWITTER URL -->
        <div>
        <label for='twitter_url'>Twitter URL</label>
        <input type="text" name="cr_form_twitter" placeholder="http://www.yoursite.com" /> <br /></div>

      <!-- FACEBOOK URL -->
        <div>
        <label for='facebook_url'>Facebook URL</label>
        <input type="text" name="cr_form_facebook" placeholder="http://www.yoursite.com" /> <br /></div>

      <!-- LINKEDIN URL -->
        <div>
        <label for='linkedin_url'>LinkedIn URL</label>
        <input type="text" name="cr_form_linkedin" placeholder="http://www.yoursite.com" /> <br /></div>

      <!-- ONE BUSINESS CATEGORY -->
        <div>
        <label for='business_category'>One Business Category</label>
        <input type="text" name="cr_form_category" placeholder="e.g. Hospitality, Construction, etc." /> <br /></div>
        <br />

      <!-- SEARCH KEYWORDS -->
        <div>
        <label for='keywords'>Enter keywords you would like to be included as search keywords, seprated by commas.</label>
        <textarea id="keyword-selection-box" type="text" name="cr_form_keywords" placeholder="Hospitality, Construction, Restaurant" rows="4"></textarea>
        <p id="keyword-limit"></p> </div>

        <hr />

        <span class="radio-button-group">
        <input id='unsure' type="checkbox" name="cr_form_unsure" value="unsure" />
        <label for="unsure">I'm unsure about my business category and/or keywords, please contact me.</label> <br /></span>

      </div>
      <button class="previous" type="button">Previous</button>
      <button class="next" type="button">Next</button>
    </div>


    <div id="directory" class="form-pane">
      <h1>Online &amp; Print Directory Presence</h1>
      <!-- PRINTED DIRECTORY -->
      <div class="directory-address-selection">
        <label>Would you like your address to appear in our PRINTED directory?</label>
        <span class="radio-button-group">
          <input
          type="radio"
          name="cr_form_print"
          value="noadd" /> No Address <br></span>
        <span class="radio-button-group">
          <input
          type="radio"
          name="cr_form_print"
          value="mail" /> Mailing Address <br></span>
        <span class="radio-button-group">
          <input
          type="radio"
          name="cr_form_print"
          value="physical" /> Physical Address <br></span>
        <span class="radio-button-group">
          <input
          type="radio"
          name="cr_form_print"
          value="billing" /> Billing Address <br></span>
        <span class="radio-button-group">
          <input
          type="radio"
          name="cr_form_print"
          value="na" /> Not Applicable <br></span>
      </div>

      <div class="directory-address-selection">
        <label>Would you like your address to appear in our ONLINE directory?</label>
        <span class="radio-button-group">
          <input
          type="radio"
          name="cr_form_online"
          value="noadd" /> No Address <br></span>
        <span class="radio-button-group">
          <input
          type="radio"
          name="cr_form_online"
          value="mail" /> Mailing Address <br></span>
        <span class="radio-button-group">
          <input
          type="radio"
          name="cr_form_online"
          value="physical" /> Physical Address <br></span>
        <span class="radio-button-group">
          <input
          type="radio"
          name="cr_form_online"
          value="billing" /> Billing Address <br></span>
        <span class="radio-button-group">
          <input
          type="radio"
          name="cr_form_online"
          value="na" /> Not Applicable <br></span>
      </div>

      <div>
        <h1>Additional Contacts for Online Directory</h1>
        <div><div>
          <h3>Additional Contact #1</h3>
          <div>
          <label for='additional_contact_one_name'>Full Name</label>
          <input type="text" name="cr_form_ac1_name" placeholder="Full Name" /> <br /></div>

          <div>
          <label for='additional_contact_one_name'>Phone</label>
          <input type="tel" name="cr_form_ac1_phone" placeholder="(xxx) xxx-xxxx" /> <br /></div>

          <div>
          <label for='additional_contact_one_name'>Email</label>
          <input type="email" name="cr_form_ac1_email" placeholder="sample@email.com" /> <br /></div>
        </div>
        <hr />
        <div>
          <h3>Additional Contact #2</h3>
          <div>
          <label for='additional_contact_two_name'>Full Name</label>
          <input type="text" name="cr_form_ac2_name" placeholder="Full Name" /> <br /></div>

          <div>
          <label for='additional_contact_two_name'>Phone</label>
          <input type="tel" name="cr_form_ac2_phone" placeholder="(xxx) xxx-xxxx" /> <br /></div>

          <div>
          <label for='additional_contact_two_name'>Email</label>
          <input type="email" name="cr_form_ac2_email" placeholder="sample@email.com" /> <br /></div>
        </div></div>
      </div>
      <button class="previous" type="button">Previous</button>
      <button class="next" type="button">Next</button>
    </div>


    <div id="confirm" class="form-pane">
      <h1>Connecting with the Beaverton Chamber of Commerce</h1>
      <div>
        <span class="radio-button-group">
          <input
          type="checkbox"
          name="cr_form_email_list"
          value="yes" /> Add me to the email list to recieve eNews from the Beaverton Chamber of Commerce <br></span>
        <span class="radio-button-group">
          <input
          type="checkbox"
          name="cr_form_linkedin_group"
          value="yes" /> Add me to the Beaverton Chamber LinkedIn Group <br></span>
        <span class="radio-button-group">
          <input
          type="checkbox"
          name="cr_form_facebook_group"
          value="yes" /> Add me to the Beaverton Chamber Facebook Group <br></span>
      </div>
      <div>
      <h1>Payment</h1>
        <label>Payment Method</label>
        <span class="radio-button-group">
          <input
          type="radio"
          name="cr_form_payment"
          value="card" />Credit Card<br></span>
        <span class="radio-button-group">
          <input
          type="radio"
          name="cr_form_payment"
          value="check" />Check<br></span>
      </div>
      <div class="g-recaptcha" data-sitekey="6LfzNBMUAAAAAHnt-y1VflCJBSTTWQ7klc3Waq_O"></div>
      <button class="previous" type="button">Previous</button>
      <button class="submit" type="submit" value="Submit">Submit</button>
    </div>
  </form>
</div>

<?php get_footer(); ?>
