jQuery(document).ready(function($) {
	// prevents issue on chrome where height is determined before page is fully loaded
	$(window).load(function(){
		// make sure sidebar exists on page
		// prevents console logging errors on pages without sidebar
		if (!!$('#sidebar').offset()) {

			// store height of header
			var headerHeight = $('header').outerHeight();
			// height of header in the viewport
			var headerDiff = headerHeight - $(window).scrollTop();

			// set sidebar top position on load
			// if scrollbar is at top of viewport, set top to headerHeight
			// else if scrollbar is past header, meaning header is not visible, set top to 0
			// else header partially visable, set top to headerDiff
			if ($(window).scrollTop() === 0) {
				$('#sidebar').css({top: headerHeight });
			} else if ($(window).scrollTop() > headerHeight) {
				$('#sidebar').css({top: 0});
			} else {
				$('#sidebar').css({top: headerDiff });
			}

			// call footerFix after top is set to properly position sidebar if overlap with footer
			footerFix();

			// store top of sidebar in relation to window
			var sidebarTop = $('#sidebar').offset().top;

			// scroll event
			$(window).scroll(function() {
				// store current position of top of window
				var windowTop = $(window).scrollTop();

				// console.log($('footer').offset().top);
				// console.log($(window).scrollTop());

				// for keeping sidebar fixed before windowTop hits zero
				var topDiff = Math.max((headerHeight - windowTop), 0)

				// set top to 0 once window passes sidebar's original position
				if (windowTop <= sidebarTop) {
					$('#sidebar').css({top: topDiff});
				} else {
					$('#sidebar').css('top', '0');
				}

				// for fixing sidebar/footer overlap on scroll
				footerFix();
			});

			$(window).resize(function() {
				// fixes issue if user resizes to extremely wide on an extremely small(vertically) window
				footerFix();
			});
		}
	});

	// fixes issue where sidebar overflows into footer, mimics header behavior on scroll
	var footerFix = function() {
		var sidebarMaxFromTop = $(document).height() - $('footer').outerHeight( true ) - $('#sidebar').height();
		var sidebarFooterFix = $(document).height() - $('footer').outerHeight() - $('#sidebar').outerHeight( true ) - $(window).scrollTop();

		if ($('#sidebar').offset().top >= sidebarMaxFromTop) {
			$('#sidebar').css({top: sidebarFooterFix});
		}
	};
});
