jQuery(document).ready(function($) {
	// hide m-z partners on page load
	$('#partners-mz').hide();
	// declare a variable to store which partner list is showing,
	// so we know which to show on resize
	var showing = 'al';
	
	// show a-l partners
	$('#partners-al-toggle').click(function() {
		$('#partners-al').show();
		$('#partners-mz').hide();
		showing = 'al';
	});
	
	// show m-z partners
	$('#partners-mz-toggle').click(function() {
		$('#partners-al').hide();
		$('#partners-mz').show();
		showing = 'mz';
	});
	
	// hide partner list when risizing to mobile/tablet size
	$(window).resize(function() {
		if ($('#calendar-page').css('flex-direction') === 'column') {
			$('#partners-al').hide();
			$('#partners-mz').hide();
		} else {
			// when resizing to desktop, show last shown list
			if (showing === 'al') {
				$('#partners-al').show();
			} else {
				$('#partners-mz').show();
			}
		}
	});
	
	// partner logo slide show
	function slideShow() {
		$('.partner-logo').hide();
		// generate a random number based on the amount of partner logos
		var rand = Math.floor(Math.random() * $('.partner-logo').length);
		// show the element at the index supplied by random number
		$('.partner-logo').eq(rand).fadeIn(1000);
	}
	slideShow();
	setInterval(slideShow, 10000);
});