// event listener to call initialize on page load
google.maps.event.addDomListener( window, 'load', gmaps_initialize );
	
// initialize function
function gmaps_initialize() {
	// define variables
	var map, marker;

	// instantiate map on map-canvas dom element
	map = new google.maps.Map( document.getElementById( 'map-canvas' ), {
		// zoom level
		zoom: 18,
		// coordinates to center map
		center: new google.maps.LatLng( 45.490888, -122.806284 ),
	});
	
	// add a marker to map
	marker = new google.maps.Marker({
		// place marker at center of map coordinates
		position: map.center,
		// use defined map
		map: map,
	});	
}