function LightenDarkenColor(col, amt) {
		var usePound = false;

		if (col[0] == "#") {
				col = col.slice(1);
				usePound = true;
		}

		var num = parseInt(col,16);
		var r = (num >> 16) + amt;

		if (r > 255) r = 255;
		else if	(r < 0) r = 0;

		var b = ((num >> 8) & 0x00FF) + amt;

		if (b > 255) b = 255;
		else if	(b < 0) b = 0;

		var g = (num & 0x0000FF) + amt;

		if (g > 255) g = 255;
		else if (g < 0) g = 0;

		return (usePound?"#":"") + (g | (b << 8) | (r << 16)).toString(16);
}
function rgb2hex(rgb) {
		rgb = rgb.match(/^rgb\((\d+),\s*(\d+),\s*(\d+)\)$/);
		function hex(x) {
				return ("0" + parseInt(x).toString(16)).slice(-2);
		}
		return "#" + hex(rgb[1]) + hex(rgb[2]) + hex(rgb[3]);
}



jQuery(document).ready(function($) {

	function closeSubMenu() {
		$('li').children('.sub-menu-wrap').slideUp('fast');
		$('.sub-menu-dropdown-arrow').children('img').removeClass('flipped');
	}
	
	function closeSearchMenu() {	
		$('#header-search-form').slideToggle('fast');
		$('.menu-header-menu-container').slideUp('fast');
		$('#hamburger').removeClass('open');
		closeSubMenu();
	}
	
	function placeSubMenu() {
		//closeSubMenu();
		var headerHeight = $(header).height();
		var menuContainer = $('.menu-header-menu-container').height();
		//console.log(headerHeight);
		//var adminToolbarHeight = $('#wpadminbar').height();
		$('.sub-menu-wrap').css('top', menuContainer); //+ adminToolbarHeight);
		$('#header-search-form').css('top', headerHeight);
	}
	// function placeFooter() {
	//	var footerHeight = $(footer).height();
	//
	//	$('#body-container').css('padding-bottom', footerHeight)
	// }
	function elementHighlighter(getColorFrom, elementToColor, cssProperty, factor) {
		var subMenuDisplay = getColorFrom.css('display');
		var mainColor = getColorFrom.css('background-color');

			if (subMenuDisplay == 'block') {
				elementToColor.css(cssProperty, '#D2CCC6');
			} else if (subMenuDisplay == 'none') {
				var hexColor = rgb2hex(mainColor);
				var lighterColor = LightenDarkenColor(hexColor, factor);
				elementToColor.css(cssProperty, lighterColor);
			}
		}

// place dropdown button for li's with sub-menus
//could probably delete this if you can get the walker in functions.php to work properly and only place dropdowns in the first group of li
	if ($('.header-menu > li').hasClass('menu-item-has-children')) {
		$('.menu-item-has-children').children('.sub-menu-dropdown-arrow').css('display', 'inline-flex');
	}

//determines the window height to enable the correct javascript
	var scrollWidth=(window.innerWidth-$(window).width());
	var windowWidth = $(window).innerWidth();
	var totalWidth = windowWidth + scrollWidth;
	var currentLayout = 'desktop';
	if(totalWidth < 768) currentLayout = 'mobile';
	rebind(currentLayout);

	// $( window ).load(function() {
	//	placeFooter();
	// });

	$( window ).resize(function() {
		scrollWidth=(window.innerWidth-$(window).width());
		windowWidth = $(window).innerWidth();
		totalWidth = windowWidth + scrollWidth;
		var newLayout = 'desktop';
		if(totalWidth <= 768) newLayout = 'mobile';
	if(newLayout !== currentLayout) {
			rebind(newLayout);
			currentLayout = newLayout;
		}
	});


	
	

	
	
	
	

function rebind(currentLayout) {
	if (currentLayout === 'desktop') {
	//placeFooter();
	$('#header-search-form').hide();
	// opens submenus when menu item is clicked
	$('#menu-toggle').off('click').on('click', function() {
		$('#header-toggle-menu').slideToggle('fast');
	});


	
	
	// Closes open menues if you click anywhere NOT in the menu header
	$('body').off('click').on('click', function(event){
		//returns false if the target IS the header menu 
		var isMenu = $(event.target).parents('.menu-header-menu-container').length === 0;
		//returns false if the target IS the popout submenu 
		var isSubmenu = $(event.target).parents('#sub-menu-wrap').length === 0;
		//returns flase if the target IS the search button 
		var isSearchButton = $(event.target).parents('#mini-menu').length === 0;
		//returns false if the target IS the popout search bar 
		var isSearch = $(event.target).parents('#header-search-form').length === 0;
		
		if (isMenu) { //if you click outside the submenu, then
			if (isSearchButton) {
				if (isSearch) {
					closeSubMenu();
					$('#header-search-form').slideUp('fast')
				}
			}	
		};
	});

	
	
	
	

	//toggles submenus and spins dropdown arrow
	$('#header-toggle-menu > li').off('click').on('click', function(event){
			// closes all opend sub-menus
			$('li').not($(this)).children('.sub-menu-wrap').slideUp('fast');

			//if the search is open, close that
			$('#header-search-form').slideUp('fast');

			// flips dropdown arrows for any opened submenus
			$('img').not($(this).children('.sub-menu-dropdown-arrow').children('img')).removeClass('flipped');

			elementHighlighter($(this).children('div.sub-menu-wrap'), $('#sub-header'), 'background-color', 50);
			placeSubMenu();

			// toggles sub-menu display property of clicked item
			$(this).children('.sub-menu-wrap').slideToggle('600');
			$(this).children('.sub-menu-wrap').toggleClass('opened');

			// toggles class which rotates arrow image
			$(this).children('.sub-menu-dropdown-arrow').children('img').toggleClass('flipped');

			// disable the submenu header and submenu subheader
			$('.sub-menu > li:first-child').off('click');
		});

	// header search toggle
	$('.search-toggle').off('click').on('click', function() {
			$('#header-search-form').slideToggle('fast');
			elementHighlighter($('#header-search-form'), $('#sub-header'), 'background-color', 20);
			closeSubMenu();
			placeSubMenu();
		});

		// on load, add hidden toggle icon to header nav menu
		$('#large-search-toggle').appendTo('#header-toggle-menu');
		$('.menu-header-menu-container').show();




	} else {	//close desktop javascript

		//placeFooter();

		$('.menu-header-menu-container').hide();
		$('#hamburger').removeClass('open');
		$('#header-search-form').hide();


	//hamburger toggle animation
	$('#hamburger').off('click').on('click', function(){
			$(this).toggleClass('open');
			$('.sub-menu-wrap', '#header-search-form', '#sub-menu-wrap').slideUp('fast');
			$('.menu-header-menu-container').slideToggle('fast');
			$('#header-search-form').slideUp('fast');
		});


	// header search toggle
	$('.search-toggle').off('click').on('click', function() {
			closeSearchMenu();
		});
		
	
	
	
	
	
	
	
	

	
	
	
	
	
	
	
	
	
	$('#header-toggle-menu > li').off('click').on('click', function(){
	// hides all sub-menus except for clicked item
			$('li').not($(this)).children('.sub-menu-wrap').slideUp('fast');
			$('img').not($(this).children('.sub-menu-dropdown-arrow').children('img')).removeClass('flipped');
			$('#header-search-form').slideUp('fast');

			//overwrites lingering css from desktop placeSubMenu() on mobile
			$('.sub-menu-wrap').css('top', 0);

			//function elementHighlighter($(this), $(this).find('.sub-menu :nth-child(2)'), 'border-top', 20);
			// function elementHighlighter(getColorFrom, elementToColor, cssProperty, factor) {
			//	var subMenuDisplay = getColorFrom.css('display');
			//	var mainColor = getColorFrom.css('background-color');
			//
			//		if (subMenuDisplay == 'block') {
			//			elementToColor.css(cssProperty, '#D2CCC6');
			//		} else if (subMenuDisplay == 'none') {
			//			var hexColor = rgb2hex(mainColor);
			//			var lighterColor = LightenDarkenColor(hexColor, factor);
			//			elementToColor.css(cssProperty, lighterColor);
			//		}
			//	}

			//function elementHighlighter($(this).find('.sub-menu-wrap'), elementToColor, cssProperty, factor)
			var submenuIsOpen = $(this).find('.sub-menu-wrap').css('display');

			if (submenuIsOpen == 'block') {
				$('#sub-header').css("background-color", '#D2CCC6');
			} else if (submenuIsOpen == 'none') {
				var activeColor = $(this).css('background-color');
				var hexColor = rgb2hex(activeColor);
				var lighterColor = LightenDarkenColor(hexColor, 20);



			}

			// toggles sub-menu display property of clicked item
			$(this).children('.sub-menu-wrap').slideToggle('fast');

			// toggles class which rotates arrow image
			$(this).children('.sub-menu-dropdown-arrow').children('img').toggleClass('flipped');

			$('.sub-menu > li:first-child').off('click').on('click', false);
		});


	} //close mobile javascript
}










	// // if mobile icon isn't visible (screen > 768px), display icon in nav menu
	// if ($('#mobile-search-toggle').css('display') == 'none') {
	// 	$('#large-search-toggle').css('display', 'inline');
	// }
	//
	// // hide and show nav menu seach icon on window resize
	// $(window).resize(function() {
	// 	if ($('#mobile-search-toggle').css('display') == 'none') {
	// 		$('#large-search-toggle').css('display', 'inline');
	// 	} else {
	// 		$('#large-search-toggle').css('display', 'none');
	// 	}
	// });s
});
