jQuery(document).ready(function ($) {
	var keywordLimit = 4;
	var keywordCount = keywordLimit;


	function updateKeywordCount(count) {
		if (count <= 1) {
			$("#keyword-limit").text(count + " keyword left");
		} else {
			$("#keyword-limit").text( count + " keywords left");
		}
	}


	$('#check-addresses').click(function() {
		$('#physical_address').attr("disabled", $(this).is(":checked"));
		$('#physical_city').attr("disabled", $(this).is(":checked"));
		$('#physical_state').attr("disabled", $(this).is(":checked"));
		$('#physical_zip').attr("disabled", $(this).is(":checked"));

		$('#billing_address').attr("disabled", $(this).is(":checked"));
		$('#billing_city').attr("disabled", $(this).is(":checked"));
		$('#billing_state').attr("disabled", $(this).is(":checked"));
		$('#billing_zip').attr("disabled", $(this).is(":checked"));
	});
//FORM INTERACTION
//SELECTION
	$("#membership-options > span").off('click').on('click', function() {
		//console.log($(this).children("input[type=radio]")); //.prop("checked", true);
		$(this).children("input[type=radio]").prop("checked", true);
		var selection = $(this).children("input[type=radio]").val();
		disableInput(selection);

		//console.log("selection: " + selection);
	});

	$("directory-address-selection > span").off('click').on('click', function() {
		$(this).children("input[type=radio]").prop("checked", true);
	})

//DISABLING
	function disableInput(investmentLevel) {
		switch (investmentLevel) {
			case "community":
				console.log("investmentLevel: " + investmentLevel);
				$(".link-entry-group input").prop("disabled", false);

				$(".link-entry-group input[name=cr_form_twitter]").prop("disabled", true);
				$(".link-entry-group input[name=cr_form_facebook]").prop("disabled", true);
				$(".link-entry-group input[name=cr_form_linkedin]").prop("disabled", true);

				//$(".link-entry-group input[name=cr_form_category]").prop("disabled", true);

				updateKeywordCount(2);
				break;

			case "power":
				console.log("investmentLevel: " + investmentLevel);
				$(".link-entry-group input").prop("disabled", false);

				updateKeywordCount(3);
				break;
			case "premier":
				console.log("investmentLevel: " + investmentLevel);
				$(".link-entry-group input").prop("disabled", false);

				updateKeywordCount(4);
				break;
			case "visionary":
				console.log("investmentLevel: " + investmentLevel);
				$(".link-entry-group input").prop("disabled", false);

				updateKeywordCount(4);
				break;
			default:
				console.log("investmentLevel invalid");
		}
	}
//VALIDATION
//COUNT KEYWORDS
$("#keyword-selection-box").focus( function() {
	$("#keyword-selection-box").on("keypress", function(event) {
		console.log(event.charCode);

		//if comma is pressed
		if (event.charCode == 44) {
			keywordCount--;

			//if the wordcount >= wordlimit
			if (keywordCount == 0) {
				if ((event.charCode == 8) || (event.charCode == 46)) {
					$("#keyword-selection-box").on("keydown", function(event) {
						// event.preventDefault();
						console.log("delete allowed")
					});
				} else {
					$("#keyword-selection-box").on("keydown", function(event) {
						//event.preventDefault();
						console.log("textarea disabled")
					});
				}
			}
			//update the label
				//$("#keyword-count").text(keywordCount);
			}
	});
});

//TWITTER SCROLL



//NAVIGATION
//HEADER
	$("#application-header > h1").off('click').on('click', function() {
		$('#form-container').children().hide();
		var text = $(this).text();

		switch ($(this).text()) {
			case 'Company Information':
				$('#company-information').show();
				break;
			case 'Contact Information':
				$('#contact-information').show();
				break;
			case 'Membership Level':
				$('#membership-level').show();
				break;
			case 'Directory':
				$('#directory').show();
				break;
			case 'Payment and Confirmation':
				$('#confirm').show();
				break;

			default:
				console.log("Error in detecting correct navigation item");
		}
		});
// HANDLE NEXT AND PREVIOUS BUTTONS
	$(".next").off('click').on('click', function() {
				$(this).parent().hide();
				$(this).parent().next().show();
	});
	$(".previous").off('click').on('click', function() {
				$(this).parent().hide();
				$(this).parent().prev().show();
	});

//ADDRESS CONTROL
	$("#address-control button").off('click').on('click', function(e) {
		$(".mail-group").hide();

		//change all active images to inactive
		$(".address-control-image").each(function() {
			var activeStatus = $(this).attr("src").substr(-12);
			if (activeStatus !== "inactive.png") {
				var newSource = $(this).attr("src").replace("-active.png", "-inactive.png");
				$(this).attr("src", newSource);
			}
		});

		//change the clicked image to the active image
		var activeStatus = $(this).children("img").attr("src").substr(-12);
		if (activeStatus == "inactive.png") {
			var activeString = $(this).children("img").attr("src").replace("inactive.png", "active.png");
			$(this).children("img").attr("src", activeString);
		}

		//show the correct address form
		switch ($(this).val()) {
			case "physical":
				$("#physical-address-group").css("display", "flex");
				break;
			case "mailing":
				$("#mailing-address-group").css("display", "flex");
				// matchValueToPhysicalAddress();
				break;
			case "billing":
				$("#billing-address-group").css("display", "flex");
				// matchValueToPhysicalAddress();
				break;
			default:
				break;
		}
	});
	
	$('#search-results').on('click', function() {
		console.log('butts')
	});
	
	$( "table" ).wrap( "<div class='uk-overflow-auto'></div>" );


//HELPER
//MATCH VALUES OF PHYSICAL ADDRESS
// var physicalAddressHasChanged = false;
// $("#physical-address-group input").on("keyup", function() {
// 	physicalAddressHasChanged = true;
// 	console.log("physical address keyup has changed var to: " + physicalAddressHasChanged);
// });
// function matchValueToPhysicalAddress() {
// 	if (physicalAddressHasChanged == true) {
// 	var physicalStreet = $("#physical-address-group input[name=cr_form_py_address]").val();
// 	var physicalCity = $("#physical-address-group input[name=cr_form_py_city]").val();
// 	var physicalState = $("#physical-address-group input[name=cr_form_py_state]").val();
// 	var physicalZip = $("#physical-address-group input[name=cr_form_py_zip]").val();
//
// 	$("#mailing-address-group input[name=cr_form_address]").attr("value", physicalStreet);
// 	$("#mailing-address-group input[name=cr_form_city]").attr("value", physicalCity);
// 	$("#mailing-address-group input[name=cr_form_state]").attr("value", physicalState);
// 	$("#mailing-address-group input[name=cr_form_zip]").attr("value", physicalZip);
//
// 	$("#billing-address-group input[name=cr_form_bi_address]").attr("value", physicalStreet);
// 	$("#billing-address-group input[name=cr_form_bi_city]").attr("value", physicalCity);
// 	$("#billing-address-group input[name=cr_form_bi_state]").attr("value", physicalState);
// 	$("#billing-address-group input[name=cr_form_bi_zip]").attr("value", physicalZip);
//
// 	physicalAddressHasChanged = false
// 	console.log("other addresses have been updated to match physical address")
// 	console.log("matchValueToPhysicalAddress has changed var to: " + physicalAddressHasChanged);
// 	}
// }




});
