<?php
  // allows users to add featured images to posts and pages, which are used throughout the site
	add_theme_support( 'post-thumbnails' );



// link javascript files and css file
	function bcc_tiger_sheep_scripts() {
			wp_enqueue_style( 'uikitcss', get_template_directory_uri() . '/uikit.min.css' );
			wp_enqueue_style( 'main_stylesheet', get_template_directory_uri() . '/style.css' );
			wp_enqueue_script( 'fade_in', get_stylesheet_directory_uri() . '/js/fade-in.js', array( 'jquery' ));
			wp_enqueue_script( 'vertical-carousel', get_stylesheet_directory_uri() . '/js/vertical-carousel.js', array( 'jquery' ));
			wp_enqueue_script( 'header', get_stylesheet_directory_uri() . '/js/header.js', array( 'jquery' ));
			wp_enqueue_script( 'google_maps_api', 'https://maps.googleapis.com/maps/api/js'  );
			wp_enqueue_script( 'maps',  get_stylesheet_directory_uri() . '/js/maps.js' );
	//		wp_enqueue_script( 'live',  get_stylesheet_directory_uri() . '/js/live.js' );
			wp_enqueue_script( 'pagination', get_stylesheet_directory_uri() . '/js/pagination.js', array( 'jquery' ));
			wp_enqueue_script( 'scroll', get_stylesheet_directory_uri() . '/js/jquery.verticalscroll.js', array( 'jquery' ));
			wp_enqueue_script( 'premier-partners', get_stylesheet_directory_uri() . '/js/partners.js', array( 'jquery' ));
			wp_enqueue_script( 'application', get_stylesheet_directory_uri() . '/js/application.js', array( 'jquery' ));
			wp_enqueue_script( 'newsroom-sidebar', get_stylesheet_directory_uri() . '/js/newsroom.js', array( 'jquery' ));
			wp_enqueue_script( 'uikitjs', get_stylesheet_directory_uri() . '/js/uikit.js' );

			//mobile add script is enqued in html.  Enqueing it here does not work, for some reason
			// wp_enqueue_script( 'mobile-ad', get_stylesheet_directory_uri() . '/js/mobile-ad.js', array( 'jquery' ));

			//this is no longer needed.  Replaced by adding a min height to .content-pane
			//wp_enqueue_script( 'footer', get_stylesheet_directory_uri() . '/js/footer.js', array( 'jquery' ));

			//wp_enqueue_script( 'sidebar_js', get_stylesheet_directory_uri() . '/js/sidebar.js', array('jquery') );
	};
	add_action( 'wp_enqueue_scripts', 'bcc_tiger_sheep_scripts');





// register menus
	register_nav_menus(
		array(
			'header_menu' => 'Header Menu',
			'mini_menu' => 'Header Mini Menu',
			'front_page_links' => 'Front Page Links',
			'about_us_links' => 'About Us Links',
		)
	);




//Walkers to transform basic menus into specific HTML elements
	class Submenu_Walker extends Walker_Nav_Menu {
			function start_lvl( &$output, $depth = 0, $args = array() ) {
					$indent = str_repeat("\t", $depth);
					$output .= "\n$indent<div class='sub-menu-wrap'><ul class='sub-menu'>\n";
			}
			function end_lvl( &$output, $depth = 0, $args = array() ) {
					$indent = str_repeat("\t", $depth);
					$output .= "$indent</ul></div>\n";
			}
	}
	class Thumbnail_Walker extends Walker_Nav_Menu {
		function start_el(&$output, $item, $depth = 0, $args = array(), $id = 0) {
			$classes = empty( $item->classes) ? array() : (array) $item->classes;

			$class_names = join(
				'',
				apply_filters(
					'nav_menu_css_class',
					array_filter( $classes ), $item
				)
			);

			! empty( $class_names) and $class_names = ' class="'. esc_attr( $class_names ) . '"';

			$output .= "<li id='menu-item-$item->ID' $class_names>";

			$attributes = '';

			! empty( $item->attr_title ) and $attributes .= ' title"' . esc_attr( $item->attr_title ) . '"';
			! empty( $item->target ) and $attributes .= ' target="' . esc_attr( $item->target ) . '"';
			! empty( $item->xfn ) and $attributes .= ' rel="' . esc_attr( $item-xfn ) . '"';
			! empty( $item->url ) and $attributes .= ' href="' . esc_attr( $item->url ) . '"';

			//insert thumbnail
			$thumbnail = '';
			if( has_post_thumbnail( $item->object_id)) {
				$thumbnail = get_the_post_thumbnail( $item->object_id );
				$thumbnail_url = get_the_post_thumbnail_url( $item->object_id );

			}

			$title = apply_filters( 'the_title', $item->title, $item->ID );

			$item_output = $args->before
				. "<a class='front-page-link' $attributes> <div class='link-container'"
				// . "style=background-image:url(" . $thumbnail_url .
				.  "> <div style='background-image:url($thumbnail_url)'></div> <p>"
				. $args->link_before
				. $title
				. $args->link_after
				. "</p>"
				// . $thumbnail
				. $args->after
				. "</div>"
				. "</a>";

				$output .= apply_filters(
					'walker_nav_menu_start_el',
					$item_output,
					$item,
					$depth,
					$args
					);
		}
	}

	function create_fpl( $theme_location) {
		if(( $theme_location) && ($locations = get_nav_menu_locations()) && isset($locations[$theme_location])) {
			$menu = get_term( $locations[$theme_location], 'nav_menu' );
			$menu_items = wp_get_nav_menu_items($menu->term_id);
			$count = 0;
			$menu_list = '<div id="front-page-links">' . '\n';

			foreach( $menu_items as $menu_item ) {
				$link = $menu_item->url;
				$title = $menu_item->ID;

				$result = has_post_thumbnail($menu_item);
				var_dump($result);
			//
			// 	$menu_list .= '<a class="front-page-link" href="'.$link.'">' . '\n';
			// 	$menu_list .= '<div class="link-container"';
			//
			// 	$menu_list .= '</div> </a>';
			}
			$menu_list .= '</div>';
		}
		echo $menu_list;
	}





// not sure what this does but it's probably important so don't delete it
	function prefix_nav_description( $item_output, $item, $depth, $args ) {
		if ( !empty( $item->description ) ) {
				$item_output = str_replace( $args->link_after . '</a>', '<span class="menu-item-description">' . $item->description . '</span>' . $args->link_after . '</a>', $item_output );
		}

		return $item_output;
}
add_filter( 'walker_nav_menu_start_el', 'prefix_nav_description', 10, 4 );





// create custom post types
add_action( 'init', 'create_post_type' );

	function create_post_type() {
		// to post mission members images at bottom of page
		// cr_mission_members was slug name from previous theme
		// decided to keep because it can already access data uploaded by chamber
		register_post_type( 'cr_mission_members',
			array(
				'labels' => array(
					'name' => __( 'Mission Members' ),
					'singular_name' => __( 'Mission Member' )
				),
				'public' => true,
				'supports' => array( 'title', 'thumbnail', 'custom-fields' )
			)
		);

		/*
			from previous code:
			"chamber_events" is for all Chamber events. This post type allows the users to connect
			individual WordPress events to individual google events. These event posts are also given
			an event type meta value. On event landing pages, these events are displayed and if they
			have an attached Google event, that data is called from Google.

			"Store Items" are displayed on the shopping page and connect to Sage.

			"chamber_diamond_members" is for all Chamber diamond members. These posts allow users to add
			logos and description text. These are then randomly pulled out and displayed one at a time
			on the Google calendar page.
		*/

		register_post_type( 'ts-featured-post',
			array(
				'labels' => array(
					'name' => 'Featured Post',
				),
				'public' => true,
				'has_archive' => true,
				'description' => 'Feature an event or post on the front page.',
				'supports' => array('title', 'editor', 'thumbnail'),
				'menu_icon' => 'dashicons-align-center',
				'menu_position' => 5,
			)
		);
		
		

		register_post_type( 'chamber_events',
			array(
				'labels' => array(
					'name' => 'Events',
					'singular_name' => 'Event'
				),
				'public' => true,
				'has_archive' => true,
				'description' => 'Custom post type for events.',
				'supports' => array('title','editor','author','custom-fields'),
				'taxonomies' => array('category')
			)
		);

		register_post_type( 'ch_store_items',
			array(
				'labels' => array(
					'name' => 'Store Items',
					'singular_name' => 'Store Item'
				),
				'public' => true,
				'has_archive' => true,
				'description' => 'Post type for store items.',
				'supports' => array( 'title', 'editor', 'author', 'custom-fields', 'thumbnail' ),
				'taxonomies' => array('category')
			)
		);

		register_post_type( 'cr_diamond_members',
			array(
				'labels' => array(
					'name' => 'Diamond Members',
					'singular_name' => 'Diamond Member'
				),
				'public' => true,
				'has_archive' => true,
				'description' => 'Post type for Diamond Member\'s Logo. Displayed on Calendar page.',
				'supports' => array('title','editor','author','thumbnail',
				'custom-fields'
			),
				'taxonomies' => array('category')
			)
		);

		register_post_type( 'main-sub-menu-title',
			array(
				'labels' => array(
					'name' => 'Sub-Menu Title',
				),
				'public' 								=> true,
				'exclude_from_search' 	=> true,
				'show_in_menu' 					=> false,
				'has_archive' 					=> false,
				'description' 					=> 'Used to display the title of the submenu contents',
				'supports' => array(
														'title',
														),
				'menu_icon'							=> 'dashicons-admin-network'
			)
		);
};


// for allowing the admin to define the order of the mission members in the footer
// posts will default to menu_order = 0, but can be changed in post create/edit
add_action( 'admin_init', 'posts_order_wpse_91866' );
function posts_order_wpse_91866()
{
	add_post_type_support( 'cr_mission_members', 'page-attributes' );
}




	// fixes error when trying to select post title
	// Wordpress transforms certain characters automatically, including quotes
	remove_filter ('the_title', 'wptexturize');





	// removes p tag wrappers from images
	function filter_ptags_on_images($content){
	   return preg_replace('/<p>\s*(<a .*>)?\s*(<img .* \/>)\s*(<\/a>)?\s*<\/p>/iU', '\1\2\3', $content);
	}
	add_filter('the_content', 'filter_ptags_on_images');
	
	





	// advanced custom fields config
	// this adds advanced custom fields functionality, without displaying it in the plugin's menu
	if(function_exists("register_field_group"))
	{
		register_field_group(array (
			'id' => 'acf_sidebar',
			'title' => 'Sidebar',
			'fields' => array (
				array (
					'key' => 'field_569e88196ac77',
					'label' => 'Icons',
					'name' => 'sidebar-icons',
					'type' => 'checkbox',
					'instructions' => 'Select the icons to be shown in the sidebar for this page. If left empty, \'Become a Partner\', \'Chamber News\' and \'Calendar\' will be shown. Once one item is selected, only checked items will be shown.',
					'choices' => array (
						'become a partner' => 'Become a Partner',
						'chamber news' => 'Chamber News',
						'download application' => 'Download Application (select file below)',
						'download brochure' => 'Download Brochure (select file below)',
						'calendar' => 'Calendar',
						'business directory' => 'Business Directory',
						'email updates' => 'Email Updates',
						'map' => 'Map',
						'email question' => 'Email Question (enter recipient address below)',
						'search' => 'Search',
						'task force' => 'Task Force (select page below)',
						'contact' => 'Contact',
					),
					'default_value' => '',
					'layout' => 'vertical',
				),
				array (
					'key' => 'field_56b388c18bee2',
					'label' => 'Application',
					'name' => 'download-application-file',
					'type' => 'file',
					'instructions' => 'Upload a file here to be used with the \'Download Application\' icon in the sidebar. The \'Download Application\' box will have to be checked in the menu above.',
					'save_format' => 'object',
					'library' => 'all',
				),
				array (
					'key' => 'field_56b3ad8853a7f',
					'label' => 'Brochure',
					'name' => 'download-brochure-file',
					'type' => 'file',
					'instructions' => 'Upload a file here to be used with the \'Download Brochure\' icon in the sidebar. The \'Download Brochure\' box will have to be checked in the menu above.',
					'save_format' => 'object',
					'library' => 'all',
				),
				array (
					'key' => 'field_56b3b6a73ce22',
					'label' => 'Email Recipient ',
					'name' => 'email-question-recipient',
					'type' => 'text',
					'instructions' => 'Enter the email address to be used by the \'Email Question\' icon. When a user clicks the icon they will be prompted to send an email to this address. This requires the \'Email Question\' box to be checked in the menu above.',
					'default_value' => 'michelle@beaverton.org',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'formatting' => 'html',
					'maxlength' => '',
				),
				array (
					'key' => 'field_56b3bbcf63dee',
					'label' => 'Task Force Page',
					'name' => 'task-force-page-link',
					'type' => 'page_link',
					'instructions' => 'Select the page you would like the \'Task Force\' icon to redirect to. This requires the \'Task Force\' box to be selected in the area above.',
					'post_type' => array (
						0 => 'page',
					),
					'allow_null' => 0,
					'multiple' => 0,
				),
			),
			'location' => array (
				array (
					array (
						'param' => 'post_type',
						'operator' => '==',
						'value' => 'page',
						'order_no' => 0,
						'group_no' => 0,
					),
				),
			),
			'options' => array (
				'position' => 'side',
				'layout' => 'default',
				'hide_on_screen' => array (
				),
			),
			'menu_order' => 0,
		));
		register_field_group(array (
			'id' => 'acf_video',
			'title' => 'Video',
			'fields' => array (
				array (
					'key' => 'field_56a1194497af0',
					'label' => 'Video',
					'name' => 'chamber_video',
					'type' => 'text',
					'instructions' => 'Add a video here to be displayed on the Beaverton page.',
					'default_value' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'formatting' => 'html',
					'maxlength' => '',
				),
			),
			'location' => array (
				array (
					array (
						'param' => 'page',
						'operator' => '==',
						'value' => '98',
						'order_no' => 0,
						'group_no' => 0,
					),
				),
			),
			'options' => array (
				'position' => 'normal',
				'layout' => 'no_box',
				'hide_on_screen' => array (
				),
			),
			'menu_order' => 0,
		));
	}





	/*
	 * Short Codes ----------------------------------------------------------------
	 * [bc-left-column-title] - landing page left column title
	 * [bc-left-column] - landing page left column content
	 * [bc-middle-column-title] - landing page middle column title
	 * [bc-middle-column] - landing page middle column content
	 * [bc-right-column] - landing page right column content
	 *
	 * [bc_stamp url=""] - two column logo image
	 * [bc_caption] - two column caption located under stamp
	 * [bc_download_app url=""] - download a PDF file associated with page
	 * [bc_download_broc url=""] - download a PDF file associated with page
	 * [bc_calendar] - links to the Google Calendar
	 * [bc_contact] - links to the contact page
	 * [bc_email addr="" subject=""] - email link and subject line
	 * [bc_email_updates] - links to the eNews page
	 * [bc_taskforce url=""] - links to a password protected page on the site with committee information.
	 * [bc_map url=""] - links to the City & School Map page
	 * [bc_member] - links to the Become a Member page
	 * [bc_news] - links to the Chamber�s blog
	 * [bc_business_dir] - links to the Business Directory page
	 * [bc_search] - links to the Search page on the site
	 * [bc_taskforce_page url=""] - Links to a specific page for the task force for the event the user is viewing.
	 * [] -
	 */

	// // make sure shortcodes are processed
	add_filter('the_content', 'do_shortcode');

	// [bc-left-column-title] shortcode handler
	function bcLeftColumnTitleHandler($atts, $content=null) {
	    // $toReturn = '<div class="grid_8">' .
	    //     '<div class="padding_right column">' .
	    //         "<h1>$content</h1>" .
	    //         '<div class="content_hrule"></div>';
	    // return $toReturn;
	}
	add_shortcode('bc-left-column-title', 'bcLeftColumnTitleHandler');
	//
	//
	// // [bc-left-column] shortcode handler
	function bcLeftColumnHandler($atts, $content=null) {
	    // $toReturn = $content . '</div></div>';
	    // return $toReturn;
	}
	add_shortcode('bc-left-column', 'bcLeftColumnHandler');
	//
	//
	// [bc_stamp url=""] shortcode handler
	function bcStampHandler($atts, $content=null) {
	    // end left column and border divs
	    $toReturn = '';

	    // open new grid column (right)
	    $toReturn = $toReturn . '<!-- right column -->
	        <div class="grid_7 prefix_1">';

	    // get stamp image url
	    extract( shortcode_atts( array(
				'url' => '',
			), $atts ) );

	    // output image
	    $toReturn = $toReturn . '<img src="' . $url . '"></img></div>';

	    return $toReturn;
	}
	add_shortcode('bc_stamp', 'bcStampHandler');
	//
	//
	// [bc-caption] shortcode handler
	function bcCaptionHandler($atts, $content=null) {
	    // $toReturn = '<h2>' . $content . '</h2><br />';
	    // return $toReturn;
	}
	add_shortcode('bc_caption', 'bcCaptionHandler');


	// [bc_download_app url=""] shortcode handler
	function bcDownloadAppHandler($atts, $content=null) {
	  //   // get pdf url
	  //   extract( shortcode_atts( array(
		// 	'url' => '',
		// ), $atts ) );
		//
	  //   // template url
	  //   $template_url = get_bloginfo('template_url', 'raw');
		//
	  //   $toReturn = '<a href="' . $url . '">'.
	  //       '<img src="' . $template_url . '/images/icon-application.png"></img></a>';
		//
	  //   return $toReturn;
	}
	add_shortcode('bc_download_app', 'bcDownloadAppHandler');


	// [bc_download_broc url=""] shortcode handler
	function bcDownloadBrocHandler($atts, $content=null) {
	  //   // get pdf url
	  //   extract( shortcode_atts( array(
		// 	'url' => ''
		// ), $atts ) );
		//
	  //   // template url
	  //   $template_url = get_bloginfo('template_url', 'raw');
		//
	  //   $toReturn = '<a href="' . $url . '">'.
	  //       '<img src="' . $template_url . '/images/icon-brochure.png"></img></a>';
		//
	  //   return $toReturn;
	}
	add_shortcode('bc_download_broc', 'bcDownloadBrocHandler');


	// [bc_calendar] shortcode handler
	function bcCalendarHandler($atts, $content=null) {
	    // // template url
	    // $template_url = get_bloginfo('template_url', 'raw');
	    // $blog_url = get_bloginfo('url');
			//
	    // $toReturn = '<a href="' . $blog_url . '/events/calendar/'.  '">'.
	    //     '<img src="' . $template_url . '/images/icon-calendar.png"></img></a>';
			//
	    // return $toReturn;
	}
	add_shortcode('bc_calendar', 'bcCalendarHandler');


	// [bc_contact] shortcode handler
	function bcContactHandler($atts, $content=null) {
	    // // template url
	    // $template_url = get_bloginfo('template_url', 'raw');
	    // $blog_url = get_bloginfo('url');
			//
	    // $toReturn = '<a href="' . $blog_url . '/about/contact/'.  '">'.
	    //     '<img src="' . $template_url . '/images/icon-contact.png"></img></a>';
			//
	    // return $toReturn;
	}
	add_shortcode('bc_contact', 'bcContactHandler');


	// [bc_email addr="" subject=""] shortcode handler
	function bcEmailHandler($atts, $content=null) {
	  //   // get pdf url
	  //   extract( shortcode_atts( array(
		// 	'addr' => '',
	  //       'subject' => ''
		// ), $atts ) );
		//
	  //   // trim white space from beginning and end
	  //   $subject = trim($subject);
		//
	  //   // replace single spaces with %20 for proper url encoding
	  //   $subject = str_replace(' ', '%20', $subject);
		//
	  //   // create mail link
	  //   $mailUrl = 'mailto:' . $addr . '?Subject=' . $subject;
		//
	  //   // template url
	  //   $template_url = get_bloginfo('template_url', 'raw');
		//
	  //   $toReturn = '<a href="' . $mailUrl . '">'.
	  //       '<img src="' . $template_url . '/images/icon-question.png"></img></a>';
		//
	  //   return $toReturn;
	}
	add_shortcode('bc_email', 'bcEmailHandler');


	// [bc_email_updates] shortcode handler
	function bcEmailUpdatesHandler($atts, $content=null) {
	    // // template url
	    // $template_url = get_bloginfo('template_url', 'raw');
	    // $blog_url = get_bloginfo('url');
			//
	    // $toReturn = '<a href="' . $blog_url . '/about/weekly-ebeat/'.  '">'.
	    //     '<img src="' . $template_url . '/images/icon-enews.png"></img></a>';
			//
	    // return $toReturn;
	}
	add_shortcode('bc_email_updates', 'bcEmailUpdatesHandler');


	// [bc_taskforce url=""] shortcode handler
	function bcTaskforceHandler($atts, $content=null) {
	  //   // template url
	  //   $template_url = get_bloginfo('template_url', 'raw');
		//
	  //   // get url
	  //   extract( shortcode_atts( array(
		// 	'url' => '',
		// ), $atts ) );
		//
	  //   $toReturn = '<a href="' . $url . '">'.
	  //       '<img src="' . $template_url . '/images/icon-login.png"></img></a>';
		//
	  //   return $toReturn;
	}
	add_shortcode('bc_taskforce', 'bcTaskforceHandler');


	// [bc_map url=""] shortcode handler
	function bcMapHandler($atts, $content=null) {
	  //   // template url
	  //   $template_url = get_bloginfo('template_url', 'raw');
		//
	  //   // get url
	  //   extract( shortcode_atts( array(
		// 	'url' => '',
		// ), $atts ) );
		//
	  //   $toReturn = '<a href="' . $url . '">'.
	  //       '<img src="' . $template_url . '/images/icon-map.png"></img></a>';
		//
	  //   return $toReturn;
	}
	add_shortcode('bc_map', 'bcMapHandler');


	// [bc_member] shortcode handler
	function bcMemberHandler($atts, $content=null) {
	    // // template url
	    // $template_url = get_bloginfo('template_url', 'raw');
	    // $blog_url = get_bloginfo('url');
			//
	    // $toReturn = '<a href="' . $blog_url . '/about/become-a-member/'.  '">'.
	    //     '<img src="' . $template_url . '/images/icon-member.png"></img></a>';
			//
	    // return $toReturn;
	}
	add_shortcode('bc_member', 'bcMemberHandler');


	// [bc_news] shortcode handler
	function bcNewsHandler($atts, $content=null) {
	    // // template url
	    // $template_url = get_bloginfo('template_url', 'raw');
	    // $blog_url = get_bloginfo('url');
			//
	    // $toReturn = '<a href="' . $blog_url . '/newsroom/'.  '">'.
	    //     '<img src="' . $template_url . '/images/icon-news.png"></img></a>';
			//
	    // return $toReturn;
	}
	add_shortcode('bc_news', 'bcNewsHandler');


	// [bc_business_dir] shortcode handler
	function bcBusinessDirHandler($atts, $content=null) {
			 // // template url
			 // $template_url = get_bloginfo('template_url', 'raw');
			 // $blog_url = get_bloginfo('url');
				//
			 // $toReturn = '<a href="' . $blog_url . '/business-directory/'.  '">'.
			 //     '<img src="' . $template_url . '/images/icon-directory.png"></img></a>';
				//
			 // return $toReturn;
	}
	add_shortcode('bc_business_dir', 'bcBusinessDirHandler');
	

	// [bc_search] shortcode handler
	function bcSearchHandler($atts, $content=null) {
	    // // template url
	    // $template_url = get_bloginfo('template_url', 'raw');
	    // $blog_url = get_bloginfo('url');
			//
	    // $toReturn = '<a href="' . $blog_url . '/search/'.  '">'.
	    //     '<img src="' . $template_url . '/images/icon-search.png"></img></a>';
			//
	    // return $toReturn;
	}
	add_shortcode('bc_search', 'bcSearchHandler');


	// [bc_taskforce_page url=""] shortcode handler
	function bcTaskforcePageHandler($atts, $content=null) {
	  //   // template url
	  //   $template_url = get_bloginfo('template_url', 'raw');
		//
	  //   // get url
	  //   extract( shortcode_atts( array(
		// 	'url' => '',
		// ), $atts ) );
		//
	  //   $toReturn = '<a href="' . $url . '">'.
	  //       '<img src="' . $template_url . '/images/icon-taskforce.png"></img></a>';
		//
	  //   return $toReturn;
	}
	add_shortcode('bc_taskforce_page', 'bcTaskforcePageHandler');
		


?>
