<?php

//enqueue Flexslider Files
	function wptuts_slider_scripts() {
		wp_enqueue_script('jquery');
		wp_enqueue_style( 'flex-style', get_template_directory_uri() . '/feature-slider/css/flexslider.css' );
		wp_enqueue_script( 'flex-script', get_template_directory_uri() . '/feature-slider/js/jquery.flexslider-min.js', array('jquery'), false, true );
	}
	
	add_action( 'wp_enqueue_scripts', 'wptuts_slider_scripts' );
	
//Initialize Slider
	function wptuts_slider_initialize() { ?>
		<script type='text/javascript' charset='utf-8'>
			jQuery(window).load(function() {
				jQuery('.flexslider').flexslider({
					animation: "slide",
					direction: "horizontal",
					slideshowSpeed: 6000,
					animationSpeed: 600,
				});
			});
		</script>
		
	<?php 
	}
		add_action( 'wp_head', 'wptuts_slider_initialize' );

//Create Slider
	function wptuts_slider_template() {
		
		//Query Arguments
		$args = array(
			'post_type' => 'slides',
			'posts_per_page' => 5,
		);
		
		//The Query
		$the_query = new WP_Query( $args );
		
		//Check if the Query returns any posts
		if( $the_query->have_posts() ) {
			//Start the Slider
			?>
			<div class='flexslider'>
				<ul class='slides'>
					
					<?php
						//The Loop
						while ( $the_query->have_posts() ) : $the_query->the_post(); 
					?>
							
							<li>
							
							<?php
								//check if there's a slide URL given and if so, allows a link to it
								if( get_post_meta( get_the_id(), 'wptuts_slideurl', true) != '' ) {
							?>
								<a href="<?php echo esc_url( get_post_meta( get_the_id(), 'wptuts_slideurl', true) ); ?>">
								<?php 
									}
									
									//The Slide's Image
									echo the_post_thumbnail();
									
									//Close off the Slide's link if there is one
									if( get_post_meta( get_the_id(), 'wptuts_sliderurl', true ) != '' ) { 
								?>
								</a>
								<?php } ?>
							</li>
						<?php endwhile; ?>
				</ul>
			</div>
		<?php 
		}
		wp_reset_postdata();
	}

?>