<?php
/**
Plugin Name: TS-Social Media Feed
Description: Add the most recent posts to your social media Feed
Version: 1.0
Author: Ike Mattice
*/


//I don't know what this does
ini_set('display_errors', 'On');
error_reporting(E_ALL | E_STRICT);

//Number of posts to pull from each social media site
define("POST_LIMIT", '10');

session_start();

//TWITTER
require_once('TwitterAPIExchange.php');

//retrieves tweets from Twitter.  Returns array of tweets or a default tweet if connection fails
function getTweets() {
$tweets = array();
$tweetCount = POST_LIMIT;
$screenName = "BeavtonChamber";

$settings = array(
  'oauth_access_token' => "715287762140659712-FMM5QPTlg745qRExjOWb3CI9HTSqw0e",
  'oauth_access_token_secret' => 'ZAyOFK1x3PWvVHTyIqcKADXpAQLjxDvaAMU0VwQCx3UGl',
  'consumer_key' => '5SY8UalWj8F8zrCHKkDu9RYQb',
  'consumer_secret' => 'ndpD91zzjgGmsWlcLTHAPAmVbHHM50QSv3WDz8UaeRnH0MUGZf',
);

//connect to twitter and get a response
$url = "https://api.twitter.com/1.1/statuses/user_timeline.json";
$requestMethod = "GET";
$getField = "?screen_name=" . $screenName . "&count=" . $tweetCount;
$twitter = new TwitterAPIExchange($settings);
$response =  json_decode($twitter ->setGetfield($getField)
              ->buildOauth($url, $requestMethod)
              ->performRequest(), $assoc = TRUE);

//ERROR: problem connecting with Twitter.  Echo to console and return a default tweet
  if(isset($response["errors"][0]["message"]) != "") {
    //echoing here sticks an unneccesary card in the carousel
    //echo("<script>console.error('Could not connect to Twitter.  Please contact your web developer for assistance.')</script>");

    $defaultTweet = array(
      'isDefault' => true,
      'source'    => "Twitter",
      'date_formatted'      => Date('D, F jS, Y'),
      'text'      => "Find us on Twitter!",
      'url'       => "https://twitter.com/BeavtonChamber"
    );

    array_push($tweets, $defaultTweet);

  }
//SUCCESS: Return all tweets in a standard associated array
  else {

    //Only return half of the post limit
    $count = 5;  //POST_LIMIT / 2
    foreach($response as $tweet) {
      $split_tweet = explode("https", $tweet['text']);
      $tweet_text = $split_tweet[0];

      if (strlen($tweet_text) == 0 ) {
      } else {

        if ($count > 0 ) {
          $newTweet = array(
            'isDefault' => 0,
            'source' => "Twitter",
            'date' => $tweet['created_at'],
            'text' => trim($tweet_text)
          );
            //Check if the tweet comes with a url.  If it doesn't, use a basic URL
            if (isset($tweet['entities']['urls'][0]['url'])) {
              $newTweet['url'] = $tweet['entities']['urls'][0]['url'];
            } else {
              $newTweet['url'] = $tweet['user']['url'];
            }

          array_push($tweets, $newTweet);
        }
        $count --;
      }
    }
  }

  return $tweets;
}




//FACEBOOK
define("APP_ID", '676811722494423');
define("APP_SECRET", '4f6e812a958428c25bf8e2187001b7a2');
define("PAGE_ID", "66865482805");
$facebook_post_limit = 10;

//I don't really know what this function does.  THe internet told me to use it.
function fetchUrl($url){

 $ch = curl_init();
 curl_setopt($ch, CURLOPT_URL, $url);
 curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
 curl_setopt($ch, CURLOPT_TIMEOUT, 20);
 // You may need to add the line below
 // curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,false);

 $feedData = curl_exec($ch);
 curl_close($ch);

 return $feedData;

}

//retrieves tweets from Facebook.  Returns array of posts or a default post if connection fails
function getPosts() {
  $posts = array();

//Retrieve auth token
  $authToken = fetchUrl("https://graph.facebook.com/oauth/access_token?grant_type=client_credentials&client_id=".APP_ID."&client_secret=".APP_SECRET);
  $json_object = fetchUrl("https://graph.facebook.com/".PAGE_ID."/feed?{$authToken}&limit=".POST_LIMIT);
  $feedarray = json_decode($json_object);

//ERROR: Did not recieve proper array of posts.  Note it in console and return a default post
  if ( $feedarray == NULL) {
    //echoing here sticks an unneccesary card in the carousel
    //echo("<script>console.error('Could not connect to Facebook.  Please contact your web developer for assistance.')</script>");

    $newPost = array(
      'isDefault'   => 1,
      'source'      => 'Facebook',
      'date_formatted'        => Date('D, F jS, Y'),
      'text'        => 'Find us on Facebook!',
      'url'         => 'https://www.facebook.com/BeavertonChamber'
    );

    array_push($posts, $newPost);
  }

  //SUCCESS: Return posts from facebook in the proper format
  else {

    foreach ( $feedarray->data as $feed_data ) {
      if(isset($feed_data->{'message'})) {
        $newPost = array(
          'isDefault' => 0,
          'source' => 'Facebook',
          'date' => $feed_data->{'created_time'}
        );

        //check if the post's text is more than a tweets.  If it is, then trim it down.
        if (strlen($feed_data->{'message'}) > 140) {
          $short_text = trim(implode(' ', array_slice(explode(' ', $feed_data->{'message'}), 0, 15 )));
           $newPost['text'] = $short_text . "...";
        } else {
          $newPost['text'] = trim($feed_data->{'message'});
        }

        //$newPost['url'] = "http://www.facebook.com/BeavertonChamber/posts/".$feed_data->{'id'};
        array_push($posts, $newPost);
      }
    }
  }

  return $posts;
}

function removeDuplicatePosts($posts) {
    $compare = [];
    $keep    = [];

    foreach($posts as $key => $post) {
        $short = substr($post['text'], 0, 50);
        if( !in_array($short, $compare) ) {
            $compare[] = $short;
            $keep[$key] = $post;
        }
    }
    return $keep;
}

//ALL POSTS
//gets all posts from social media sites and returns an array that is devoid of duplicates, empty posts (such as picture posts), and limited to the POST_LIMIT
function getSocialMediaPosts() {
  $tweets = getTweets();
  $posts = getPosts();
  $limit = POST_LIMIT;
  $output = [];

if ($posts[0]['isDefault'] !== 1) {
  //date format
  foreach($posts as $post) {
    $formatDate = strtotime($post['date']);
    $post['date_formatted'] = date('D, F jS, Y', $formatDate);
    $output[strtotime($post['date'])] = $post;
  }
} else {

  array_push($output, $posts[0]);
}
if ($tweets[0]['isDefault'] !== 1) {
foreach($tweets as $tweet) {
  $formatDate = strtotime($tweet['date']);
  $tweet['date_formatted'] = date('D, F jS, Y', $formatDate);
  $output[$formatDate] = $tweet;
}
} else {
  array_push($output, $tweets[0]);
}


  //sort by date
  krsort($output);

  $result = removeDuplicatePosts($output);
  $return = array_slice($result, 0, $limit);

  return $return;
}

//return the html objects that will be displayed on the page
function buildPost($post) {
  if ($post['source'] == 'Facebook') {
    $class = 'fb-post';
    $icon_class = 'facebook-icon';
    $icon_source = '/icons/official-facebook-icon.svg';
    $url = 'https://www.facebook.com/BeavertonChamber';
  } elseif ($post['source'] == 'Twitter') {
    $class = 'tweet';
    $icon_class = 'twitter-icon';
    $icon_source = '/icons/official-twitter-icon-blue.svg';
    $url = 'https://twitter.com/BeavtonChamber';
  }

  echo("<div class='".$class." social-media-post'>");
  echo("<a href=".$url." target='_blank'>");
    echo("<img class=".$icon_class." src='" . get_template_directory_uri() .$icon_source."' />");
    echo("<span class='date'>".$post['date_formatted']."</span>");
   echo("<p>".$post['text']."</p>");

      if ((substr($post['text'], -3) == '...')) {
          echo("<span class='read-more'>Click to read more</span>");
      }
    echo("</a>");
  echo("</div>");
}















//WORDPRESS ADMIN UI: NOT IMPLEMENTED
// add_action( 'admin_menu', 'create_admin_submenu_entry');
//
// function create_admin_submenu_entry() {
//   add_options_page('Social Media Settings', 'Social Media Settings', 'manage_options', 'ts-social-media-settings', 'create_ts_media_feed_admin_page');
// };
//
// function create_ts_media_feed_admin_page() {
  ?>

    <!-- <div class="ts-admin-settings-container">
      <h2>Social Media Feed Settings</h2>

      <form>
        <label>Twitter</label><br />
        <input type="text" name="twitter" placeholder="@username"/>
        <button>Save</button>

        <br />
        <br />

        <label>Facebook</label><br />
        <input type="text" name="facebook" placeholder="Profile URL"/>
        <button>Save</button>
      </form>
    </div> -->

  <?php
//};


//Enqueue the scripts needed for the plugin
define('TS_MEDIA_FEED_PATH', plugin_dir_path(__FILE__));

function ts_media_feed_scripts() {

    	wp_enqueue_style( 'owl-carousel-css', '/wp-content/plugins/ts-media-feed/owl-carousel/assets/owl.carousel.css');
      wp_enqueue_style( 'animate-css', '/wp-content/plugins/ts-media-feed/owl-carousel/assets/animate.css');

    	wp_enqueue_style( 'social-media-feed-css', '/wp-content/plugins/ts-media-feed/social-media-feed.css');

      wp_enqueue_script( 'owl-carousel-js', '/wp-content/plugins/ts-media-feed/owl-carousel/owl.carousel.js', array( 'jquery' ));
    	wp_enqueue_script( 'owl-carousel-init', '/wp-content/plugins/ts-media-feed/carousel-init.js');
      // echo("script init");
}

add_action( 'wp_enqueue_scripts', 'ts_media_feed_scripts');



//returns the social media container as a shortcode.  COULD NOT GET THIS TO WORK PROPERLY
function createSocialMediaFeed() {
	$html = '<div id="feed-wrapper">
			<div id="social-media-feed" class="owl-carousel">

			<?php
				$social_media_posts = getSocialMediaPosts();

				ksort($social_media_posts);

				foreach ( $social_media_posts as $post) {

					buildPost($post);
				}

			?>
		</div>
	</div>';

	return $html;
}

add_shortcode('create_social_media_feed', 'createSocialMediaFeed');
?>
