<?php
/*
Plugin Name: Chamber - Admin
Plugin URI: http://www.column-right.com
Description: Chamber site administration documentation.
Author: Chris Myers
Author URI: http://www.column-right.com
*/

add_action('admin_menu', 'cb_options_add_page');

// Add menu page
function cb_options_add_page() {
	add_options_page('Chamber Admin', 'Chamber Admin', 'read', 'chamber-admin', 'cb_options_do_page');
}

// Draw the menu page itself
function cb_options_do_page() {
	?>
	<div class="wrap">
		<h2>Reference Documents</h2>
		<ul>
            <li><a target="_blank" href="http://www.beaverton.org/wp-content/plugins/chamber-admin/01-Best_Practices.pdf">01 - Best Practices</a></li>
            <li><a target="_blank" href="http://www.beaverton.org/wp-content/plugins/chamber-admin/02-Dashboard_Items.pdf">02 - Basic Dashboard Items</a></li>
            <li><a target="_blank" href="http://www.beaverton.org/wp-content/plugins/chamber-admin/03-Toolbar.pdf">03 - The Tool Bar</a></li>
            <li><a target="_blank" href="http://www.beaverton.org/wp-content/plugins/chamber-admin/04-Image_Quick_Ref.pdf">04 - Image Size Quick Reference</a></li>
            <li><a target="_blank" href="http://www.beaverton.org/wp-content/plugins/chamber-admin/05-Uploading_Media.pdf">05 - Uploading Media</a></li>
            <li><a target="_blank" href="http://www.beaverton.org/wp-content/plugins/chamber-admin/06-Creating_Newsroom_Post.pdf">06 - Creating a Newroom Post</a></li>
            <li><a target="_blank" href="http://www.beaverton.org/wp-content/plugins/chamber-admin/07-Anatomy_Event_Post.pdf">07 - Anatomy of an Event Post</a></li>
            <li><a target="_blank" href="http://www.beaverton.org/wp-content/plugins/chamber-admin/08-Anatomy_Testimonial_Post.pdf">08 - Anatomy of a Testimonial Post</a></li>
            <li><a target="_blank" href="http://www.beaverton.org/wp-content/plugins/chamber-admin/09_Anatomy_Slider.pdf">09 - Anatomy of a Slider</a></li>
            <li><a target="_blank" href="http://www.beaverton.org/wp-content/plugins/chamber-admin/10_Creating_Slider.pdf">10 - Creating a Homepage Slider or Ad</a></li>
            <li><a target="_blank" href="http://www.beaverton.org/wp-content/plugins/chamber-admin/11-Anatomy_Store_Post.pdf">11 - Anatomy of a Store Post</a></li>
            <li><a target="_blank" href="http://www.beaverton.org/wp-content/plugins/chamber-admin/12-Anatomy_Diamond_Member.pdf">12 - Anatomy of a Diamond Member Post</a></li>
            <li><a target="_blank" href="http://www.beaverton.org/wp-content/plugins/chamber-admin/13-Altering_Existing_Page.pdf">13 - Altering an Existing Page</a></li>
            <li><a target="_blank" href="http://www.beaverton.org/wp-content/plugins/chamber-admin/14-Understanding_Sidebar.pdf">14 - Understanding a Page's Sidebar</a></li>
            <li><a target="_blank" href="http://www.beaverton.org/wp-content/plugins/chamber-admin/15-Icon_Quick_Ref.pdf">15 - Icon Quick Reference</a></li>
            <li><a target="_blank" href="http://www.beaverton.org/wp-content/plugins/chamber-admin/16-Placing_Video.pdf">16 - Placing a Video</a></li>
            <li><a target="_blank" href="http://www.beaverton.org/wp-content/plugins/chamber-admin/17-Creating_New_Page.pdf">17 - Creating a New Page</a></li>
            <li><a target="_blank" href="http://www.beaverton.org/wp-content/plugins/chamber-admin/18-Understanding_Menus.pdf">18 - Understanding The Menus</a></li>
            <li><a target="_blank" href="http://www.beaverton.org/wp-content/plugins/chamber-admin/19-Altering_Navigation_SiteMap.pdf">19 - Altering the Navigation/Site Map</a></li>
            <li><a target="_blank" href="http://www.beaverton.org/wp-content/plugins/chamber-admin/20-Meta_Data_SEO_Info.pdf">20 - Meta Data (SEO) Information</a></li>
        </ul>
	</div>
	<?php	
}

// remove footer
function admin_register_head() {
    echo('<style>#footer {display:none;}</style>');
}
add_action('admin_head', 'admin_register_head');
?>