(function() {

    tinymce.create('tinymce.plugins.tinyplugin', {

        init : function(ed, url){
        
            // adds command to be triggered by button
            ed.addCommand('tiny_plugin_func', function() {
                ed.windowManager.open({
                    file : url + '/tiny_form.htm',
                    width : 320,
                    height : 320,
                    inline : 1
                }, {
                    plugin_url : url, // Plugin absolute URL
                    some_custom_arg : 'custom arg' // Custom argument (can be pulled into dialog.htm)
                });
            });
        
            // adds button to the UI
            ed.addButton('tinyplugin', {
                title : 'Beaverton Chamber of Commerce',
                cmd : 'tiny_plugin_func',
                image: url + "/wand.png"
            });
        },

        getInfo : function() {
            return {
                longname : 'Beaverton Chamber of Commerce TinyMCE Plugin',
                author : 'Chris Myers',
                authorurl : 'http://www.column-right.com',
                infourl : '',
                version : '0.1.0'
            };
        }
    });

    tinymce.PluginManager.add('tinyplugin', tinymce.plugins.tinyplugin);
    
})();