<?php
/*
Plugin Name: Beaverton Chamber of Commerce TinyMCE Plugin
Plugin URI: http://www.column-right.com
Description: Adds custom functionality TinyMCE editor.
Author: Chris Myers
Version: 0.1.0
Author URI: http://www.column-right.com
*/



function tinyplugin_add_button($buttons) {
    array_push($buttons, "separator", "tinyplugin");
    return $buttons;
}
add_filter('mce_buttons', 'tinyplugin_add_button', 0);


function tinyplugin_register($plugin_array) {
    $url = trim(get_bloginfo('url'), "/")."/wp-content/plugins/bc_tiny_plugin/editor_plugin.js";

    $plugin_array['tinyplugin'] = $url;
    return $plugin_array;
}
add_filter('mce_external_plugins', "tinyplugin_register");


function myformatTinyMCE($in) {
    $in['extended_valid_elements'] = 'eventmarker';
    $in['custom_elements'] = 'eventmarker';
    return $in;
}
add_filter('tiny_mce_before_init', 'myformatTinyMCE' );

?>