<?php

/*
Template Name: Template Blog With Sidebar 
*/

 get_header(); 
 ?>	
		<div id="container"> <!-- start container -->	
				<?php
					$page_title_show = get_post_meta($post->ID,'show_page_title', true);
					$page_title_alternative = get_post_meta($post->ID,'page_title_alternative', true);
					$template_blog_sidebar = get_post_meta($post->ID,'template-blog-sidebar', true);
					
					$sidebar_main_class="main_inside_with_sidebar_right";
					$sidebar_id="sidebar_right";	
					if ($template_blog_sidebar  == 'left') {
						$sidebar_main_class = 'main_inside_with_sidebar_left';
						$sidebar_id = 'sidebar_left';
					}
					
					
					$page_title_text = get_post_meta($post->ID,'page_title_text', true);
					if ($page_title_show != 'No') {
					?>
						<div class="page-titles">
							<h1 class="page-title-h1"><?php if ($page_title_alternative != '') { echo $page_title_alternative; } else { the_title(); } ?></h1>
							<?php if ($page_title_text != '') { ?><h2 class="page-title-h2"><?php echo $page_title_text;  ?></h2> <?php } ?>
							<div class="page-title-border"></div>
						</div>	
					<?php
					}	
					?>			
			<div class="main"><!-- start main -->
				<div class="<?php echo $sidebar_main_class; ?>">	<!-- start main inside-->		
					<div class="blog-with-sidebar">						
						<?php
							$readmore = "&#151; Read more &#151;";
							if (get_option($pego_prefix.'read_more_title') != '') {
								$readmore = get_option($pego_prefix.'read_more_title');
							}
							$numberOfBlogPosts = '';
							$numberOfBlogPosts = get_post_meta($post->ID, 'post_number_pagination' , true);	
							$data = get_option(OPTIONS);
							$dateFormat = $data['date_format'];						
							if ($numberOfBlogPosts == '') { $numberOfBlogPosts = -1; }
							$args = array('order'=> 'DESC', 'orderby' => 'post_date'  );
							$port_query = new WP_Query( $args );
							$temp = $wp_query;
							$wp_query= null;
							$post_count = 0;
							$wp_query = new WP_Query();
							$wp_query->query('showposts='.$numberOfBlogPosts.''.'&paged='.$paged);
							while ($wp_query->have_posts()) : $wp_query->the_post();
								$post_count++;	
							
								$cats= get_the_category_list(', ','',$post->ID);
								?>
								<div class="post-wrapper">
								<?php								
								if ( has_post_format( 'image' )) {
									$image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'single-post-thumbnail' );
									?>
									<div class="post-image post-image-hover">
										<a title="<?php the_title(); ?>" href="<?php the_permalink(); ?>"><img src="<?php echo $image[0]; ?>" alt="" /></a>
									</div>
									<div class="clear"></div>
									<div class="post-type-icon"><span class="icon-picture"></span></div>
									<div class="post-title">
											<h1><a href="<?php 	 the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a></h1>
											<div class="post-details">
												<p><?php echo $cats; ?> - <?php echo get_the_date($dateFormat); ?> - <a href="<?php comments_link(); ?>"><?php echo get_comments_number( $post->ID ); ?> Comments</a> - by <?php the_author_posts_link(); ?></p>
											</div>
										</div>
										<div class="clear"></div>
										<div class="post-content">
											<p>
											<?php the_excerpt (); ?>
											</p>
										</div>
										<a href="<?php 	the_permalink();  ?>" class="read-more"><?php echo esc_html($readmore); ?></a>
										
								
								<?php
								} else
								if ( has_post_format( 'video' )) {
									$post_video_url = get_post_meta($post->ID , 'post_video_url' , true);
									?>
									<div class="post-image">
										<div class="video-wrapper"><div class="video-container"><?php echo $post_video_url; ?></div></div>
									</div>
									<div class="clear"></div>
									<div class="post-type-icon"><span class="icon-video"></span></div>
										<div class="post-title">
											<h1><a href="<?php 	 the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a></h1>
											<div class="post-details">
												<p><?php echo $cats; ?> - <?php echo get_the_date($dateFormat); ?> - <a href="<?php comments_link(); ?>"><?php echo get_comments_number( $post->ID ); ?> Comments</a> - by <?php the_author_posts_link(); ?></p>
											</div>
										</div>
										<div class="clear"></div>
										<div class="post-content">
											<p>
											<?php the_excerpt (); ?>
											</p>
										</div>
										<a href="<?php 	the_permalink();  ?>" class="read-more"><?php echo esc_html($readmore); ?></a>
								
								<?php
								} else
								if ( has_post_format( 'gallery' )) {
									?>
									<div class="post-image">
										<div class="flexsliderFolio">
											<ul class="slides">
											<?php 
												$attachments = get_children(array('post_parent' => $post->ID,
													'post_status' => 'inherit',
													'post_type' => 'attachment',
													'post_mime_type' => 'image',
													'order' => 'ASC',
													'orderby' => 'menu_order ID'));	
												foreach($attachments as $att_id => $attachment) {
													$full_img_url = wp_get_attachment_image_src($attachment->ID,'PostImg', true);
													?>
													<li><img src="<?php echo $full_img_url[0]; ?>" alt=""></li>
													<?php
												}
												?>
											</ul>
										</div>			
									</div>
									<div class="clear"></div>
									<div class="post-type-icon"><span class="icon-docs"></span></div>
									<div class="post-title">
										<h1><a href="<?php 	 the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a></h1>
										<div class="post-details">
											<p><?php echo $cats; ?> - <?php echo get_the_date($dateFormat); ?> - <a href="<?php comments_link(); ?>"><?php echo get_comments_number( $post->ID ); ?> Comments</a> - by <?php the_author_posts_link(); ?></p>
										</div>
									</div>
									<div class="clear"></div>
									<div class="post-content">
										<p>
										<?php the_excerpt (); ?>
										</p>
									</div>
									<a href="<?php 	the_permalink();  ?>" class="read-more"><?php echo esc_html($readmore); ?></a>
								
								<?php
								} else 
								if ( has_post_format( 'quote' )) {
									$post_quote = get_post_meta($post->ID , 'post_quote' , true);
								?>
									<div class="post-type-icon"><span class="icon-quote"></span></div>
									<div class="postQuote"><?php echo $post_quote; ?></div>
									<div class="clear"></div>
										<div class="post-title">
											<div class="post-details  post-details-quote">
												<p><?php echo $cats; ?> - <?php echo get_the_date($dateFormat); ?> - <a href="<?php comments_link(); ?>"><?php echo get_comments_number( $post->ID ); ?> Comments</a> - by <?php the_author_posts_link(); ?></p>
											</div>
										</div>
										<div class="clear"></div>
										<div class="post-content">
											<p>
											<?php the_excerpt (); ?>
											</p>
										</div>			
								
								<?php
								} else 
								if ( has_post_format( 'link' )) {
									$post_link = get_post_meta($post->ID , 'post_link' , true);
								?>
									<div class="post-type-icon"><span class="icon-link"></span></div>
									<div class="post-title">
											<h1><a href="<?php 	 echo $post_link; ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a></h1>
											<div class="post-details">
												<p><?php echo $cats; ?> - <?php echo get_the_date($dateFormat); ?> - <a href="<?php comments_link(); ?>"><?php echo get_comments_number( $post->ID ); ?> Comments</a> - by <?php the_author_posts_link(); ?></p>
											</div>
										</div>
										<div class="clear"></div>
										<div class="post-content">
											<p>
											<?php the_excerpt (); ?>
											</p>
										</div>	
								<?php
								} else 
								if ( has_post_format( 'audio' )) {
									$post_audio = get_post_meta($post->ID , 'post_audio' , true);									
									?>
									<div class="post-type-icon"><span class="icon-note"></span></div>
									<div class="post-title">
										<h1><a href="<?php 	 the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a></h1>
										<div class="post-details">
											<p><?php echo $cats; ?> - <?php echo get_the_date($dateFormat); ?> - <a href="<?php comments_link(); ?>"><?php echo get_comments_number( $post->ID ); ?> Comments</a> - by <?php the_author_posts_link(); ?></p>
										</div>
									</div>
									<div class="clear"></div>
									<div class="audio-post-wrapper">
										<?php echo do_shortcode($post_audio); ?>
									</div>
									<div class="post-content">
										<p>
										<?php the_excerpt (); ?>
										</p>
									</div>
									<a href="<?php 	the_permalink();  ?>" class="read-more"><?php echo esc_html($readmore); ?></a>
								<?php
								} else {
								?>
									<div class="clear"></div>
									<div class="post-type-icon"><span class="icon-pencil"></span></div>
									<div class="post-title">
										<h1><a href="<?php 	 the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a></h1>
										<div class="post-details">
											<p><?php echo $cats; ?> - <?php echo get_the_date($dateFormat); ?> - <a href="<?php comments_link(); ?>"><?php echo get_comments_number( $post->ID ); ?> Comments</a> - by <?php the_author_posts_link(); ?></p>
										</div>
									</div>
									<div class="clear"></div>
									<div class="post-content">
										<p>
										<?php the_excerpt (); ?>
										</p>
									</div>
									<!-- <a href="<?php 	the_permalink();  ?>" class="read-more"><?php echo esc_html($readmore); ?></a> -->
								
								<?php
								}
								?>
								<div class="title-stripes-post"></div>
								</div>
								
							<?php							
							endwhile;  
							?>
						<div class="clear"></div>
						<div class="blog-pagination">
							<span style="padding:0;">
							<?php pego_pagination();?>							
							</span>
						</div>
					</div>	
					
					</div><!-- end main inside -->	

					<div id="<?php echo $sidebar_id; ?>" class="sidebar">
						<?php			
							if (function_exists('dynamic_sidebar') && dynamic_sidebar('Blog sidebar')) : else :

							endif; 	
						?>	
					</div>	
					<div class="clear"></div>						
			</div><!-- end main -->		
<?php get_footer(); ?>