<?php global $themedir, $pego_prefix; ?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <title><?php wp_title('|', true, 'right'); ?><?php bloginfo('name'); ?></title>	
	
	<!-- for mobile devices -->
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1"/>	
	
	<!-- Favicon Icon -->
	<link rel="shortcut icon" href="<?php echo get_option($pego_prefix.'favicon'); ?>" type="image/vnd.microsoft.icon"/>
	<link rel="icon" href="<?php echo get_option($pego_prefix.'favicon'); ?>" type="image/x-ico"/>	
	
	<script type="text/javascript">
        var search_placeholder = '<?php echo get_option($pego_prefix.'header2_placeholder'); ?>';
    </script>	
	<!-- google analytics -->
	<?php
	if  (get_option($pego_prefix.'google_analytics')) {
		echo ' <script type="text/javascript"> '.get_option($pego_prefix.'google_analytics').' </script>';
	}
	
	//Google fonts 
	include("functions/fonts-links.php"); 	
	
	// icons for iPad and iPhone
	 pego_get_apple_icons(); 	
  	
    wp_enqueue_script('jquery-ui-accordion'); 
	wp_enqueue_script('jquery'); 
	wp_head(); 	
	//custom CSS 
	include("functions/custom-css.php"); 
	?>		
	<!-- css for IE lower than 9 -->
	  <!--[if lt IE 9]>	
		<script type="text/javascript" src="<?php  echo get_template_directory_uri(); ?>/js/html5.js"></script>	   
		<link rel="stylesheet" type="text/css" href="<?php echo get_stylesheet_directory_uri(); ?>/css/ie9low.css"/>			
	  <![endif]-->
</head>
<body <?php body_class(); ?>>
	<div id="menuMobile">
		<div class="menuMobileClose"><img src="<?php echo get_template_directory_uri(); ?>/images/icon-responsive-menu.png" alt=""/></div>
		<div class="clear"></div>
		<?php wp_nav_menu(array('menu' => 'Main Nav Menu', 'menu_class' => 'mobileMenu')); ?> 
		<div class="clear"></div>
	</div>
	<div class="stickyMenu">
		<div id="menusmall">
				<?php wp_nav_menu(array('menu' => 'Main Nav Menu', 'menu_class' => 'sf-menu')); ?>          
		</div>			
	</div>
	<?php
	$header_type = get_option($pego_prefix.'header_type');
	if ($header_type == 'Header#1') {
	?>	
		<!-- start upper header search -->
		<div id="headerArea">
			<div id="headerArea_content">
				<div id="headerArea_inside">
						<?php echo do_shortcode('[wpbsearch]'); ?>
					</div>
			</div>
		</div>	
		<div id="under_headerArea">
			<div id="inside_under_headerArea">
					<div id="headerArea_button"></div>
			</div>
			<div class="clear"></div>
		</div>	
		<!-- end upper header search -->
	<?php
	} else
	if ($header_type == 'Header#2') {
	?>
	<div id="headerArea-widgets" ><!-- start upper panel with widgets -->
		<div id="headerArea-widgets_content">
			<div class="fl">				
				<?php
					$icons_bg_color =  get_option($pego_prefix.'upper_header_left_icons_color');
					$icon1 =  get_option($pego_prefix.'upper_header_left_icon1');
					$icon1text =  get_option($pego_prefix.'upper_header_left_icon1_text');
					if (($icon1 != '')&&($icon1text != '')) {
						echo '<div class="info-details"><div style="color:'.$icons_bg_color.';" class="iconQuickInfoWidget icon-'.$icon1.'"></div><p class="fl quick-info">'.$icon1text.'</p></div>';
					}
					$icon2 =  get_option($pego_prefix.'upper_header_left_icon2');
					$icon2text =  get_option($pego_prefix.'upper_header_left_icon2_text');
					if (($icon2 != '')&&($icon2text != '')) {
						echo '<div class="info-details"><div style="color:'.$icons_bg_color.';" class="iconQuickInfoWidget icon-'.$icon2.'"></div><p class="fl quick-info">'.$icon2text.'</p></div>';
					}
					$icon3 =  get_option($pego_prefix.'upper_header_left_icon3');
					$icon3text =  get_option($pego_prefix.'upper_header_left_icon3_text');
					if (($icon3 != '')&&($icon3text != '')) {
						echo '<div class="info-details"><div style="color:'.$icons_bg_color.';" class="iconQuickInfoWidget icon-'.$icon3.'"></div><p class="fl quick-info">'.$icon3text.'</p></div>';
					}
				?>
			</div>
			<div class="fr">
				<?php
					$social_icons_bg_color =  get_option($pego_prefix.'upper_header_right_icons_color');
					$social_icons_type =  get_option($pego_prefix.'upper_header_right_icons_type');
					$social_icon1 =  get_option($pego_prefix.'upper_header_right_icon1');
					$social_icon1_url =  get_option($pego_prefix.'upper_header_right_icon1_url');
					$social_icon2 =  get_option($pego_prefix.'upper_header_right_icon2');
					$social_icon2_url =  get_option($pego_prefix.'upper_header_right_icon2_url');
					$social_icon3 =  get_option($pego_prefix.'upper_header_right_icon3');
					$social_icon3_url =  get_option($pego_prefix.'upper_header_right_icon3_url');
					$social_icon4 =  get_option($pego_prefix.'upper_header_right_icon4');
					$social_icon4_url =  get_option($pego_prefix.'upper_header_right_icon4_url');
					$social_icon5 =  get_option($pego_prefix.'upper_header_right_icon5');
					$social_icon5_url =  get_option($pego_prefix.'upper_header_right_icon5_url');
					$social_icon6 =  get_option($pego_prefix.'upper_header_right_icon6');
					$social_icon6_url =  get_option($pego_prefix.'upper_header_right_icon6_url');
					$social_icon7 =  get_option($pego_prefix.'upper_header_right_icon7');
					$social_icon7_url =  get_option($pego_prefix.'upper_header_right_icon7_url');
					$social_icon8 =  get_option($pego_prefix.'upper_header_right_icon8');
					$social_icon8_url =  get_option($pego_prefix.'upper_header_right_icon8_url');					
					$upper_socialsClass='social-bookmarks';
					if ($social_icons_type == 'light') {
						$upper_socialsClass="social-bookmarksLight";
					}
					?>
					<div class="<?php echo $upper_socialsClass; ?>">                    
						<ul>
							<?php
							$i = 0;
							for ($i = 1 ; $i <= 8 ; $i++)
							{
								$icon_url = "social_icon".$i."_url";
								$icon_path = "social_icon".$i;
								if ($$icon_url != "")
								{ 
									$icon_filename = $$icon_path;
									$icon_filename = substr($icon_filename, 0, -4); 
								?>
								<li style="background-color: <?php echo $social_icons_bg_color; ?>" class="<?php echo $$icon_path; ?>"><a target="_blank" href="<?php echo $$icon_url; ?>"></a></li>
								<?php
								}
							}
							?>                        
						</ul><!-- END UL-->
					</div><!--END SOCIAL BOOKMARKS-->
					<?php 
				?>
			</div>
		</div>
		<div class="clear"></div>
	</div><!-- end upper panel with widgets-->
	<?php
	} else {
	?>
		<div id="headerArea3"></div>	
	<?php
	}
	?>	
	
	<div id="header-wrapper"> <!-- start header-wrapper -->
		<div id="header"> <!-- start header -->
			<div id="header-inside"> <!-- start header-inside -->
				<div id="logo">
				<?php
					$logo = get_stylesheet_directory_uri()."/images/logo.png";
					if (get_option($pego_prefix.'logo') != '') {
						$logo = get_option($pego_prefix.'logo');
					}	
				?>
					<a href="<?php  echo home_url(); ?>" title="">
						<img id="logoImage" src="<?php echo $logo; ?>" alt="" title="" />
					</a>
				</div>	
				<div id="main-menu">
					<nav class="primary">
						<?php wp_nav_menu(array('menu' => 'Main Nav Menu', 'menu_class' => 'sf-menu')); ?>          
					</nav><!--.primary-->	
				</div>
				<div class="menuMobileShow"><img src="<?php echo get_template_directory_uri(); ?>/images/icon-responsive-menu-white.png" alt=""/></div>
				<div class="clear"></div>			
			</div> <!-- end header-inside -->
		</div> <!-- end header -->
	</div> <!-- end header-wrapper -->
	<div class="clear"></div>