<?php
//page editing
	add_action( 'admin_menu', 'hybrid_create_meta_box_page' );
   add_action( 'save_post', 'hybrid_save_meta_data_page' );



function hybrid_create_meta_box_page() {
	global $theme_name;

	add_meta_box( 'page-meta-boxes', __('Page settings', "furniot"), 'page_meta_boxes', 'page', 'normal', 'default' );
}


function hybrid_page_meta_boxes() {

	$rev_sliders=array();
	$layer_sliders = pego_get_slider_layer();
	$sidebars = pego_get_all_sidebars();
	/* Array of the meta box options. */
	$meta_boxes = array(
			'page-title-heading' => array( 
							'name' => 'page_title_heading', 
							'title' => __('Page Titles Options', 'furniot'), 
							'description' => __('Options for page titles.', 'furniot'), 
							'type' => "heading"),
			'show_page_title' => array( 
							'name' => 'show_page_title', 
							'title' => __('Show page title?', 'furniot'), 
							'description' => __('Select Yes to show page title.', 'furniot'), 
							'type' => "select", 
							'std' => __('Yes','furniot'),
							'options' => array(__('Yes','furniot'),__('No','furniot'))),
			'page_title_alternative' => array( 
							'name' => 'page_title_alternative', 
							'title' => __('Page title', 'furniot'), 
							'description' => __('Input page title if you want it to be differnet than the page name is [optional].', 'furniot'), 
							'type' => "text"),						
			'page_title_text' => array( 
							'name' => 'page_title_text', 
							'title' => __('Page title text', 'furniot'), 
							'description' => __('Input text which we be displayed under the page title [optional].', 'furniot'), 
							'type' => "text"),	
			'portfolio-heading' => array( 
							'name' => 'portfolio_heading', 
							'title' => __('Portfolio Template Options', 'furniot'), 
							'description' => __('Options for portfolio template.', 'furniot'), 
							'type' => "heading"),
			'show_filter' => array( 
							'name' => 'show_filter', 
							'title' => __('Show filter?', 'furniot'), 
							'description' => __('Select Yes to show the filter.', 'furniot'), 
							'type' => "select", 
							'std' => __('Yes','furniot'),
							'options' => array(__('Yes','furniot'),__('No','furniot'))),
			'include_category' => array( 
							'name' => 'include_category', 
							'title' => __(' Include category: ', 'furniot'), 
							'description' => __('Insert portfolio category SLUG(seperate categories with :: ). If empty all will be choosen.', 'furniot'), 
							'type' => 'text' ),
			'portfolio_ordering' => array( 
							'name' => 'portfolio_ordering', 
							'title' => __('Ordering:', 'furniot'), 
							'description' => __('Choose how portfolio items will be ordered.', 'furniot'), 
							'type' => "select", 
							'std' => __('Date','furniot'),
							'options' => array(__('Date','furniot'),__('Admin Ordering','furniot'))),
			'portfolio_ordering1' => array( 
							'name' => 'portfolio_ordering1', 
							'title' => __('Ordering direction:', 'furniot'), 
							'description' => __('Choose in which direction portfolio items will be ordered.', 'furniot'), 
							'type' => "select", 
							'std' => __('DESC','furniot'),
							'options' => array(__('DESC','furniot'),__('ASC','furniot'))),
			'blog-heading' => array( 
							'name' => 'blog-heading', 
							'title' => __('Blog Template Options', 'furniot'), 
							'description' => __('Options for blog template.', 'furniot'), 
							'type' => "heading"),
			'post_number' => array( 
							'name' => 'post_number_pagination', 
							'title' => __('Posts number', 'furniot'), 
							'description' => __('Number of posts to show before making pagination. For no pagination, leave empty.', 'furniot'), 
							'type' => "text"),
			'template-blog-sidebar' => array( 
							'name' => 'template-blog-sidebar', 
							'title' => __('Sidebar position', 'furniot'), 
							'description' => __('Choose sidebar position.', 'furniot'), 							
							'type' => "select", 
							'std' => __('left','furniot'),
							'options' => array(__('left','furniot'),__('right','furniot'))),
			'sidebar-heading' => array( 
							'name' => 'sidebar_heading', 
							'title' => __('Templates with Sidebar Options', 'furniot'), 
							'description' => __('Options for templates with sidebar.', 'furniot'), 
							'type' => "heading"),
			'sidebar-choose' => array( 
							'name' => 'sidebar-choose', 
							'title' => __('Choose sidebar', 'furniot'), 
							'description' => __('Select the sidebar.', 'furniot'), 
							'type' => "select", 
							'std' => '',
							'options' => $sidebars),
			'template-home-heading' => array( 
							'name' => 'template_home_heading', 
							'title' => __('Template Fullwidth Slider under Header Options', 'furniot'), 
							'description' => __('Options for template Fullwidth Slider under Header.', 'furniot'), 
							'type' => "heading"),
			'home-template-slider' => array( 
							'name' => 'home-template-slider', 
							'title' => __('Slider', 'furniot'), 
							'description' => __('Select slider.', 'furniot'), 
							'type' => "select", 
							'std' => '',
							'options' => $layer_sliders)
		
	);

	return apply_filters( 'hybrid_page_meta_boxes', $meta_boxes );
}

function page_meta_boxes() {
	global $post;
	$meta_boxes = hybrid_page_meta_boxes(); ?>

	<table class="form-table">
	<?php foreach ( $meta_boxes as $meta ) :

		$value = stripslashes( get_post_meta( $post->ID, $meta['name'], true ) );

		if ( $meta['type'] == 'text' )
			get_meta_text_input_page( $meta, $value );
		elseif ( $meta['type'] == 'heading' )
			get_meta_heading( $meta, $value );
		elseif ( $meta['type'] == 'textarea' )
			get_meta_textarea_page( $meta, $value );
		elseif ( $meta['type'] == 'select' )
			get_meta_select_page( $meta, $value );

	endforeach; ?>
	</table>
<?php
}

function get_meta_text_input_page( $args = array(), $value = false ) {

	extract( $args ); ?>

	<tr>
		<th style="width:30%;">
			<label for="<?php echo $name; ?>"><b><?php echo $title; ?></b><br/><span  style="color:#777777;"><?php echo $description; ?></span></label>
		</th>
		<td>
			<input type="text" name="<?php echo $name; ?>" id="<?php echo $name; ?>" value="<?php echo esc_html( $value );  ?>" size="30" tabindex="30" style="width: 97%;" />
			<input type="hidden" name="<?php echo $name; ?>_noncename" id="<?php echo $name; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
		</td>
	</tr>
	<?php
}


function get_meta_select_page( $args = array(), $value = false ) {

	extract( $args ); ?>

	<tr>
		<th style="width:30%;">
			<label for="<?php echo $name; ?>"><b><?php echo $title; ?></b><br/><span style="color:#777777;" ><?php echo $description; ?></span></label>
		</th>
		<td>
			<select style="width:90px;" name="<?php echo $name; ?>" id="<?php echo $name; ?>">
			<?php foreach ( $options as $option ) : ?>
				<option <?php if ( htmlentities( $value, ENT_QUOTES ) == $option ) echo ' selected="selected"'; ?>>
					<?php echo $option; ?>
				</option>
			<?php endforeach; ?>
			</select>
			<input type="hidden" name="<?php echo $name; ?>_noncename" id="<?php echo $name; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
		</td>
	</tr>
	<?php
}


function get_meta_color_page( $args = array(), $value = false ) {

	extract( $args ); ?>

	<tr>
		<th style="width:30%;">
			<label for="<?php echo $name; ?>"><b><?php echo $title; ?></b><br/><span style="color:#777777;" ><?php echo $description; ?></span></label>
		</th>
		<td>
			<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/functions/css/colorpicker.css" type="text/css" media="screen" />
			<script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/functions/js/jquery.js"></script>
			<script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/functions/js/colorpicker.js"></script>	
			<script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/functions/js/eye.js"></script>
			<script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/functions/js/layout.js?ver=1.0.2"></script>
		   #<input type="text" maxlength="6" size="6" name="<?php echo $name; ?>"  id="colorpickerField1" value="<?php echo esc_html( $value );  ?>"  />
			<input type="hidden" name="<?php echo $name; ?>_noncename" id="<?php echo $name; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
		</td>
	</tr>
	<?php
}



function get_meta_textarea_page( $args = array(), $value = false ) {

	extract( $args ); ?>

	<tr>
		<th style="width:30%;">
			<label for="<?php echo $name; ?>"><b><?php echo $title; ?></b><br/><span style="color:#777777;"><?php echo $description; ?></span></label>
		</th>
		<td>
			<textarea name="<?php echo $name; ?>" id="<?php echo $name; ?>" cols="60" rows="4" tabindex="30" style="width: 97%;"><?php echo esc_html( $value );  ?></textarea>
			<input type="hidden" name="<?php echo $name; ?>_noncename" id="<?php echo $name; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
		</td>
	</tr>
	<?php
}

function get_meta_heading( $args = array(), $value = false ) {

	extract( $args ); ?>

	<tr>
		<th style="width:30%;">
			<label for="<?php echo $name; ?>"><h1 style="font-size:14px;"><?php echo $title; ?></h1><span style="color:#777777;"><?php echo $description; ?></span></label>
		</th>		
	</tr>
	<?php
}


function hybrid_save_meta_data_page( $post_id ) {
	global $post;
	
	$meta_boxes = array_merge( hybrid_page_meta_boxes() );
	foreach ( $meta_boxes as $meta_box ) :
	if ( $meta_box['type'] != 'heading' ) {	
			
		if ((!isset($_POST[$meta_box['name'] . '_noncename']))  || ( !wp_verify_nonce( $_POST[$meta_box['name'] . '_noncename'], plugin_basename( __FILE__ ) ) ))
			return $post_id;
		

		if ( 'page' == $_POST['post_type'] && !current_user_can( 'edit_page', $post_id ) )
			return $post_id;

		elseif ( 'post' == $_POST['post_type'] && !current_user_can( 'edit_post', $post_id ) )
			return $post_id;

		$data = stripslashes( $_POST[$meta_box['name']] );

		if ( get_post_meta( $post_id, $meta_box['name'] ) == '' )
			add_post_meta( $post_id, $meta_box['name'], $data, true );

		elseif ( $data != get_post_meta( $post_id, $meta_box['name'], true ) )
			update_post_meta( $post_id, $meta_box['name'], $data );

		elseif ( $data == '' )
			delete_post_meta( $post_id, $meta_box['name'], get_post_meta( $post_id, $meta_box['name'], true ) );
	}
	endforeach;	
}
?>